/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.transaction.txn.journal;

import java.nio.ByteBuffer;
import org.apache.jena.atlas.lib.ByteBufferLib;
import org.apache.jena.atlas.lib.Bytes;
import org.apache.jena.dboe.transaction.txn.ComponentId;
import org.apache.jena.dboe.transaction.txn.ComponentIds;
import org.apache.jena.dboe.transaction.txn.journal.JournalEntryType;

public class JournalEntry {
    public static final JournalEntry COMMIT = new JournalEntry(JournalEntryType.COMMIT, ComponentIds.idSystem);
    public static final JournalEntry ABORT = new JournalEntry(JournalEntryType.ABORT, ComponentIds.idSystem);
    private long position = -1L;
    private long endPosition = -1L;
    private final JournalEntryType type;
    private final ComponentId componentId;
    private final ByteBuffer data;

    private JournalEntry(JournalEntryType type, ComponentId id) {
        this(type, id, null);
    }

    public JournalEntry(JournalEntryType type, ComponentId componentId, ByteBuffer bytes) {
        this.type = type;
        this.componentId = componentId;
        this.data = bytes;
    }

    void setPosition(long posn) {
        this.position = posn;
    }

    void setEndPosition(long endPosn) {
        this.endPosition = endPosn;
    }

    public long getPosition() {
        return this.position;
    }

    long getEndPosition() {
        return this.endPosition;
    }

    public JournalEntryType getType() {
        return this.type;
    }

    public ComponentId getComponentId() {
        return this.componentId;
    }

    public ByteBuffer getByteBuffer() {
        return this.data;
    }

    public String toString() {
        return "JournalEntry: " + String.valueOf((Object)this.type) + " " + String.valueOf(this.componentId);
    }

    public static String format(JournalEntry entry) {
        StringBuilder sbuff = new StringBuilder();
        sbuff.append("Entry: ");
        sbuff.append("  " + String.valueOf((Object)entry.type));
        if (entry.componentId != null) {
            String label = entry.componentId.label();
            if (label != null) {
                sbuff.append(label);
            }
            sbuff.append(" [..");
            int z = Bytes.getInt(entry.componentId.getBytes(), entry.componentId.getBytes().length - 4);
            sbuff.append(Integer.toHexString(z));
            sbuff.append("]");
        }
        if (entry.data != null) {
            sbuff.append("  " + ByteBufferLib.details(entry.data));
        }
        return sbuff.toString();
    }
}

