/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.build;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.FusekiConfigException;
import org.apache.jena.fuseki.build.FusekiPrefixes;
import org.apache.jena.fuseki.server.Operation;
import org.apache.jena.fuseki.servlets.ActionService;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.riot.out.NodeFmtLib;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.Prefixes;
import org.apache.jena.shared.JenaException;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.exec.QueryExec;
import org.apache.jena.sparql.exec.QueryExecBuilder;
import org.apache.jena.sparql.exec.RowSet;
import org.apache.jena.sparql.util.graph.GNode;
import org.apache.jena.sparql.util.graph.GraphList;
import org.apache.jena.system.G;
import org.apache.jena.vocabulary.RDFS;

class BuildLib {
    private BuildLib() {
    }

    static RowSet query(String string, Graph graph) {
        return BuildLib.query(string, graph, null, null);
    }

    static RowSet query(String string, Graph graph, String varName, Node value) {
        Query query2 = QueryFactory.create(FusekiPrefixes.PREFIXES + string);
        QueryExecBuilder qExec = QueryExec.graph(graph).query(query2);
        if (varName != null && value != null) {
            qExec.substitution(varName, value);
        }
        return qExec.build().select().materialize();
    }

    private static Binding querySubstitution(String varName, Node value) {
        Var var = Var.alloc(varName);
        return BindingFactory.binding(var, value);
    }

    static Node getOne(Graph graph, Node subject, Node property) {
        List<Node> x = G.listSP(graph, subject, property);
        if (x.isEmpty()) {
            throw new FusekiConfigException("No property '" + BuildLib.displayStr(graph, property) + "' for service " + BuildLib.displayStr(graph, subject));
        }
        if (x.size() > 1) {
            throw new FusekiConfigException("Multiple properties '" + BuildLib.displayStr(graph, property) + "' for service " + BuildLib.displayStr(graph, subject));
        }
        return x.get(0);
    }

    static Node getZeroOrOne(Graph graph, Node subject, Node property) {
        List<Node> x = G.listSP(graph, subject, property);
        if (x.isEmpty()) {
            return null;
        }
        if (x.size() > 1) {
            throw new FusekiConfigException("Multiple triples for " + BuildLib.displayStr(graph, subject) + " " + BuildLib.displayStr(graph, property));
        }
        return x.get(0);
    }

    static Collection<Node> getMultiple(Graph graph, Node resource, Node property) {
        List<Node> nodes = G.listSP(graph, resource, property);
        if (nodes.isEmpty()) {
            return null;
        }
        ArrayList<Node> results = new ArrayList<Node>();
        nodes.forEach(node -> {
            List<Node> members = BuildLib.listMembers(graph, node);
            if (members != null) {
                results.addAll(members);
            } else {
                results.add((Node)node);
            }
        });
        return results;
    }

    private static List<Node> listMembers(Graph graph, Node node) {
        GNode gnode = new GNode(graph, node);
        if (!GraphList.isListNode(gnode)) {
            return null;
        }
        List<Node> list = GraphList.members(gnode);
        return list;
    }

    static String displayStr(Graph graph, Node n) {
        if (n == null) {
            return "NULL";
        }
        if (graph == null) {
            return NodeFmtLib.str(n, null);
        }
        PrefixMap prefixMap = Prefixes.adapt(graph);
        return NodeFmtLib.str(n, null, prefixMap);
    }

    static String strForResource(Graph graph, Node node) {
        Node label;
        if (node == null) {
            return "NULL";
        }
        if (G.hasProperty(graph, node, RDFS.Nodes.label) && (label = G.getOneSP(graph, node, RDFS.Nodes.label)).isLiteral()) {
            return label.getLiteralLexicalForm();
        }
        if (node.isBlank()) {
            return "<<blank node>>";
        }
        if (node.isURI()) {
            return BuildLib.strForURI(graph, node.getURI());
        }
        throw BuildLib.notSupported(node);
    }

    private static RuntimeException notSupported(Node node) {
        return new JenaException("Not supported: " + String.valueOf(node));
    }

    static String strForURI(Graph graph, String uri) {
        if (graph != null) {
            PrefixMap prefixMap = Prefixes.adapt(graph);
            String x = graph.getPrefixMapping().qnameFor(uri);
            if (x != null) {
                return x;
            }
        }
        return "<" + uri + ">";
    }

    static Pair<Operation, ActionService> loadOperationActionService(Graph graph, Node implementation) {
        String classURI = implementation.isLiteral() ? implementation.getLiteralLexicalForm() : implementation.getURI();
        String javaScheme = "java:";
        String scheme = null;
        if (!classURI.startsWith(javaScheme)) {
            Fuseki.configLog.error("Class to load is not 'java:' " + classURI);
            throw new FusekiConfigException("Not a 'java:' class reference: " + classURI);
        }
        scheme = javaScheme;
        String className = classURI.substring(scheme.length());
        ActionService action = null;
        try {
            Class<?> cls = Class.forName(className);
            Constructor<?> x = cls.getConstructor(new Class[0]);
            action = (ActionService)x.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException ex) {
            throw new FusekiConfigException("Class not found: " + className);
        }
        catch (Exception ex) {
            throw new FusekiConfigException("Can't create object from " + className);
        }
        Operation op = Operation.alloc(NodeFactory.createBlankNode(), classURI, classURI);
        return Pair.create(op, action);
    }
}

