/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.jena.fuseki.Fuseki;

public abstract class ServletBase
extends HttpServlet {
    private static AtomicLong requestIdAlloc = new AtomicLong(0L);
    static final String varyHeaderSetting = String.join((CharSequence)",", "Accept", "Accept-Encoding", "Accept-Charset", "Origin", "Access-Control-Request-Method", "Access-Control-Request-Headers");
    public static boolean CORS_ENABLED = false;

    protected ServletBase() {
    }

    protected static long allocRequestId(HttpServletRequest request, HttpServletResponse response) {
        long id = requestIdAlloc.incrementAndGet();
        ServletBase.addRequestId(response, id);
        return id;
    }

    protected static void addRequestId(HttpServletResponse response, long id) {
        response.addHeader(Fuseki.FusekiRequestIdHeader, Long.toString(id));
    }

    public static void setVaryHeader(HttpServletResponse httpResponse) {
        httpResponse.setHeader("Vary", varyHeaderSetting);
    }

    public static void setCommonHeadersForOptions(HttpServletResponse httpResponse) {
        if (CORS_ENABLED) {
            httpResponse.setHeader("Access-Control-Allow-Headers", "X-Requested-With, Content-Type, Authorization");
        }
        httpResponse.setHeader("Content-Length", "0");
        ServletBase.setCommonHeaders(httpResponse);
    }

    public static void setCommonHeaders(HttpServletResponse httpResponse) {
        if (CORS_ENABLED) {
            httpResponse.setHeader("Access-Control-Allow-Origin", "*");
        }
        if (Fuseki.outputFusekiServerHeader) {
            httpResponse.setHeader("Server", Fuseki.serverHttpName);
        }
    }
}

