/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.kryo;

import com.esotericsoftware.kryo.kryo5.Kryo;
import com.esotericsoftware.kryo.kryo5.Serializer;
import com.esotericsoftware.kryo.kryo5.io.Input;
import com.esotericsoftware.kryo.kryo5.io.Output;
import org.locationtech.jts.geom.Envelope;

public class EnvelopeSerializer
extends Serializer<Envelope> {
    @Override
    public void write(Kryo kryo, Output output, Envelope envelope) {
        output.writeDouble(envelope.getMinX());
        output.writeDouble(envelope.getMaxX());
        output.writeDouble(envelope.getMinY());
        output.writeDouble(envelope.getMaxY());
    }

    @Override
    public Envelope read(Kryo kryo, Input input, Class<? extends Envelope> type) {
        double xMin = input.readDouble();
        double xMax = input.readDouble();
        double yMin = input.readDouble();
        double yMax = input.readDouble();
        if (xMin <= xMax) {
            return new Envelope(xMin, xMax, yMin, yMax);
        }
        return new Envelope();
    }
}

