/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.backward_codecs.lucene94;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.lucene.backward_codecs.lucene94.Lucene94HnswVectorsReader;
import org.apache.lucene.codecs.lucene90.IndexedDISI;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.VectorScorer;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.RandomAccessInput;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.packed.DirectMonotonicReader;

abstract class OffHeapByteVectorValues
extends ByteVectorValues {
    protected final int dimension;
    protected final int size;
    protected final IndexInput slice;
    protected int lastOrd = -1;
    protected final byte[] binaryValue;
    protected final ByteBuffer byteBuffer;
    protected final int byteSize;
    protected final VectorSimilarityFunction vectorSimilarityFunction;

    OffHeapByteVectorValues(int dimension, int size, IndexInput slice, VectorSimilarityFunction vectorSimilarityFunction, int byteSize) {
        this.dimension = dimension;
        this.size = size;
        this.slice = slice;
        this.byteSize = byteSize;
        this.vectorSimilarityFunction = vectorSimilarityFunction;
        this.byteBuffer = ByteBuffer.allocate(byteSize);
        this.binaryValue = this.byteBuffer.array();
    }

    @Override
    public int dimension() {
        return this.dimension;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public byte[] vectorValue(int targetOrd) throws IOException {
        if (this.lastOrd != targetOrd) {
            this.readValue(targetOrd);
            this.lastOrd = targetOrd;
        }
        return this.binaryValue;
    }

    private void readValue(int targetOrd) throws IOException {
        this.slice.seek((long)targetOrd * (long)this.byteSize);
        this.slice.readBytes(this.byteBuffer.array(), this.byteBuffer.arrayOffset(), this.byteSize);
    }

    static OffHeapByteVectorValues load(Lucene94HnswVectorsReader.FieldEntry fieldEntry, IndexInput vectorData) throws IOException {
        if (fieldEntry.docsWithFieldOffset() == -2L || fieldEntry.vectorEncoding() != VectorEncoding.BYTE) {
            return new EmptyOffHeapVectorValues(fieldEntry.dimension());
        }
        IndexInput bytesSlice = vectorData.slice("vector-data", fieldEntry.vectorDataOffset(), fieldEntry.vectorDataLength());
        int byteSize = fieldEntry.dimension();
        if (fieldEntry.docsWithFieldOffset() == -1L) {
            return new DenseOffHeapVectorValues(fieldEntry.dimension(), fieldEntry.size(), bytesSlice, fieldEntry.similarityFunction(), byteSize);
        }
        return new SparseOffHeapVectorValues(fieldEntry, vectorData, bytesSlice, fieldEntry.similarityFunction(), byteSize);
    }

    private static class EmptyOffHeapVectorValues
    extends OffHeapByteVectorValues {
        public EmptyOffHeapVectorValues(int dimension) {
            super(dimension, 0, null, VectorSimilarityFunction.COSINE, 0);
        }

        @Override
        public int dimension() {
            return super.dimension();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public OffHeapByteVectorValues copy() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] vectorValue(int targetOrd) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int ordToDoc(int ord) {
            throw new UnsupportedOperationException();
        }

        @Override
        public KnnVectorValues.DocIndexIterator iterator() {
            return this.createDenseIterator();
        }

        @Override
        public Bits getAcceptOrds(Bits acceptDocs) {
            return null;
        }

        @Override
        public VectorScorer scorer(byte[] query2) {
            return null;
        }
    }

    static class DenseOffHeapVectorValues
    extends OffHeapByteVectorValues {
        public DenseOffHeapVectorValues(int dimension, int size, IndexInput slice, VectorSimilarityFunction vectorSimilarityFunction, int byteSize) {
            super(dimension, size, slice, vectorSimilarityFunction, byteSize);
        }

        @Override
        public DenseOffHeapVectorValues copy() throws IOException {
            return new DenseOffHeapVectorValues(this.dimension, this.size, this.slice.clone(), this.vectorSimilarityFunction, this.byteSize);
        }

        @Override
        public KnnVectorValues.DocIndexIterator iterator() {
            return this.createDenseIterator();
        }

        @Override
        public Bits getAcceptOrds(Bits acceptDocs) {
            return acceptDocs;
        }

        @Override
        public VectorScorer scorer(final byte[] query2) throws IOException {
            final DenseOffHeapVectorValues copy = this.copy();
            final KnnVectorValues.DocIndexIterator iterator = copy.iterator();
            return new VectorScorer(){

                @Override
                public float score() throws IOException {
                    return vectorSimilarityFunction.compare(copy.vectorValue(iterator.index()), query2);
                }

                @Override
                public DocIdSetIterator iterator() {
                    return iterator;
                }
            };
        }
    }

    private static class SparseOffHeapVectorValues
    extends OffHeapByteVectorValues {
        private final DirectMonotonicReader ordToDoc;
        private final IndexedDISI disi;
        private final IndexInput dataIn;
        private final Lucene94HnswVectorsReader.FieldEntry fieldEntry;

        public SparseOffHeapVectorValues(Lucene94HnswVectorsReader.FieldEntry fieldEntry, IndexInput dataIn, IndexInput slice, VectorSimilarityFunction vectorSimilarityFunction, int byteSize) throws IOException {
            super(fieldEntry.dimension(), fieldEntry.size(), slice, vectorSimilarityFunction, byteSize);
            this.fieldEntry = fieldEntry;
            RandomAccessInput addressesData = dataIn.randomAccessSlice(fieldEntry.addressesOffset(), fieldEntry.addressesLength());
            this.dataIn = dataIn;
            this.ordToDoc = DirectMonotonicReader.getInstance(fieldEntry.meta(), addressesData);
            this.disi = new IndexedDISI(dataIn, fieldEntry.docsWithFieldOffset(), fieldEntry.docsWithFieldLength(), fieldEntry.jumpTableEntryCount(), fieldEntry.denseRankPower(), fieldEntry.size());
        }

        @Override
        public SparseOffHeapVectorValues copy() throws IOException {
            return new SparseOffHeapVectorValues(this.fieldEntry, this.dataIn, this.slice.clone(), this.vectorSimilarityFunction, this.byteSize);
        }

        @Override
        public int ordToDoc(int ord) {
            return (int)this.ordToDoc.get(ord);
        }

        @Override
        public KnnVectorValues.DocIndexIterator iterator() {
            return SparseOffHeapVectorValues.fromDISI(this.disi);
        }

        @Override
        public Bits getAcceptOrds(final Bits acceptDocs) {
            if (acceptDocs == null) {
                return null;
            }
            return new Bits(){

                @Override
                public boolean get(int index) {
                    return acceptDocs.get(this.ordToDoc(index));
                }

                @Override
                public int length() {
                    return size;
                }
            };
        }

        @Override
        public VectorScorer scorer(final byte[] query2) throws IOException {
            final SparseOffHeapVectorValues copy = this.copy();
            final IndexedDISI disi = copy.disi;
            return new VectorScorer(){

                @Override
                public float score() throws IOException {
                    return vectorSimilarityFunction.compare(copy.vectorValue(disi.index()), query2);
                }

                @Override
                public DocIdSetIterator iterator() {
                    return disi;
                }
            };
        }
    }
}

