/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.comparators;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.Pruning;
import org.apache.lucene.search.comparators.NumericComparator;
import org.apache.lucene.util.NumericUtils;

public class IntComparator
extends NumericComparator<Integer> {
    private final int[] values;
    protected int topValue;
    protected int bottom;

    public IntComparator(int numHits, String field, Integer missingValue, boolean reverse, Pruning pruning) {
        super(field, missingValue != null ? missingValue : 0, reverse, pruning, 4);
        this.values = new int[numHits];
    }

    @Override
    public int compare(int slot1, int slot2) {
        return Integer.compare(this.values[slot1], this.values[slot2]);
    }

    @Override
    public void setTopValue(Integer value) {
        super.setTopValue(value);
        this.topValue = value;
    }

    @Override
    public Integer value(int slot) {
        return this.values[slot];
    }

    @Override
    protected long missingValueAsComparableLong() {
        return ((Integer)this.missingValue).intValue();
    }

    @Override
    protected long sortableBytesToLong(byte[] bytes) {
        return NumericUtils.sortableBytesToInt(bytes, 0);
    }

    @Override
    public LeafFieldComparator getLeafComparator(LeafReaderContext context2) throws IOException {
        return new IntLeafComparator(context2);
    }

    public class IntLeafComparator
    extends NumericComparator.NumericLeafComparator {
        public IntLeafComparator(LeafReaderContext context2) throws IOException {
            super(IntComparator.this, context2);
        }

        private int getValueForDoc(int doc) throws IOException {
            if (this.docValues.advanceExact(doc)) {
                return (int)this.docValues.longValue();
            }
            return (Integer)IntComparator.this.missingValue;
        }

        @Override
        public void setBottom(int slot) throws IOException {
            IntComparator.this.bottom = IntComparator.this.values[slot];
            super.setBottom(slot);
        }

        @Override
        public int compareBottom(int doc) throws IOException {
            return Integer.compare(IntComparator.this.bottom, this.getValueForDoc(doc));
        }

        @Override
        public int compareTop(int doc) throws IOException {
            return Integer.compare(IntComparator.this.topValue, this.getValueForDoc(doc));
        }

        @Override
        public void copy(int slot, int doc) throws IOException {
            IntComparator.this.values[slot] = this.getValueForDoc(doc);
            super.copy(slot, doc);
        }

        @Override
        protected long bottomAsComparableLong() {
            return IntComparator.this.bottom;
        }

        @Override
        protected long topAsComparableLong() {
            return IntComparator.this.topValue;
        }
    }
}

