/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import org.apache.sis.metadata.TitleProperty;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.xml.bind.metadata.replace.RS_Identifier;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.InternationalString;

@TitleProperty(name="code")
@XmlType(name="MD_Identifier_Type", namespace="http://standards.iso.org/iso/19115/-3/mcc/1.0", propOrder={"authority", "code", "codeSpace", "version", "description"})
@XmlRootElement(name="MD_Identifier", namespace="http://standards.iso.org/iso/19115/-3/mcc/1.0")
@XmlSeeAlso(value={RS_Identifier.class})
public class DefaultIdentifier
extends ISOMetadata
implements Identifier {
    private static final long serialVersionUID = -23375776954553866L;
    private Citation authority;
    private String code;
    private String codeSpace;
    private String version;
    private InternationalString description;

    public DefaultIdentifier() {
    }

    public DefaultIdentifier(String code) {
        this.code = code;
    }

    public DefaultIdentifier(String codeSpace, String code, String version2) {
        this.code = code;
        this.codeSpace = codeSpace;
        this.version = version2;
    }

    public DefaultIdentifier(Citation authority, String code) {
        this.authority = authority;
        this.code = code;
        this.codeSpace = Citations.toCodeSpace(authority);
    }

    public DefaultIdentifier(Identifier object) {
        super(object);
        if (object != null) {
            this.code = object.getCode();
            this.authority = object.getAuthority();
            if (object instanceof DefaultIdentifier) {
                DefaultIdentifier c = (DefaultIdentifier)object;
                this.codeSpace = c.getCodeSpace();
                this.version = c.getVersion();
                this.description = c.getDescription();
            } else if (object instanceof ReferenceIdentifier) {
                ReferenceIdentifier c = (ReferenceIdentifier)object;
                this.codeSpace = c.getCodeSpace();
                this.version = c.getVersion();
            }
        }
    }

    public static DefaultIdentifier castOrCopy(Identifier object) {
        if (object == null || object instanceof DefaultIdentifier) {
            return (DefaultIdentifier)object;
        }
        return new DefaultIdentifier(object);
    }

    @Override
    @XmlElement(name="authority")
    public Citation getAuthority() {
        return this.authority;
    }

    public void setAuthority(Citation newValue) {
        this.checkWritePermission(this.authority);
        this.authority = newValue;
    }

    @Override
    @XmlElement(name="code", required=true)
    public String getCode() {
        return this.code;
    }

    public void setCode(String newValue) {
        this.checkWritePermission(this.code);
        this.code = newValue;
    }

    @XmlElement(name="codeSpace")
    @UML(identifier="codeSpace", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public String getCodeSpace() {
        return this.codeSpace;
    }

    public void setCodeSpace(String newValue) {
        this.checkWritePermission(this.codeSpace);
        this.codeSpace = newValue;
    }

    @XmlElement(name="version")
    @UML(identifier="version", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String newValue) {
        this.checkWritePermission(this.version);
        this.version = newValue;
    }

    @XmlElement(name="description")
    @UML(identifier="description", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public InternationalString getDescription() {
        return this.description;
    }

    public void setDescription(InternationalString newValue) {
        this.checkWritePermission(this.description);
        this.description = newValue;
    }
}

