/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.internal;

import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import org.apache.sis.math.Fraction;
import org.apache.sis.referencing.util.ExtendedPrecisionMatrix;
import org.apache.sis.util.internal.DoubleDouble;

public enum Arithmetic {
    ADD(DoubleDouble::add, Fraction::add, Math::addExact),
    SUBTRACT(DoubleDouble::subtract, Fraction::subtract, Math::subtractExact),
    MULTIPLY(DoubleDouble::multiply, Fraction::multiply, Math::multiplyExact),
    DIVIDE(DoubleDouble::divide, Fraction::divide, Fraction::valueOf),
    INVERSE((a, b) -> a.inverse(), (a, b) -> a.inverse(), (a, b) -> new Fraction(1, Math.toIntExact(a))),
    NEGATE((a, b) -> a.negate(), (a, b) -> a.negate(), (a, b) -> Math.negateExact(a)),
    SQRT((a, b) -> a.sqrt(), (a, b) -> DoubleDouble.of(a, false).sqrt(), (a, b) -> DoubleDouble.of(a).sqrt());

    public static final boolean DECIMAL = true;
    private final BinaryOperator<DoubleDouble> onDoubleDouble;
    private final BiFunction<Fraction, Fraction, Number> onFraction;
    private final BiFunction<Long, Long, Number> onLong;

    private Arithmetic(BinaryOperator<DoubleDouble> onDoubleDouble, BiFunction<Fraction, Fraction, Number> onFraction, BiFunction<Long, Long, Number> onLong) {
        this.onDoubleDouble = onDoubleDouble;
        this.onFraction = onFraction;
        this.onLong = onLong;
    }

    private static Long tryLongValue(Number element) {
        if (element == null || element instanceof Long) {
            return (Long)element;
        }
        long a = element.longValue();
        return (double)a == element.doubleValue() ? Long.valueOf(a) : null;
    }

    private Number apply(Number a, Number b) {
        Object result = null;
        try {
            Long aLong = Arithmetic.tryLongValue(a);
            Long bLong = Arithmetic.tryLongValue(b);
            if (aLong != null && (bLong != null || b == null)) {
                result = this.onLong.apply(aLong, bLong);
            } else {
                Fraction bFrac;
                Fraction aFrac = a instanceof Fraction ? (Fraction)a : null;
                Fraction fraction = bFrac = b instanceof Fraction ? (Fraction)b : null;
                if (aFrac != null || bFrac != null) {
                    if (aFrac == null && aLong != null) {
                        aFrac = new Fraction(Math.toIntExact(aLong), 1);
                    }
                    if (bFrac == null && bLong != null) {
                        bFrac = new Fraction(Math.toIntExact(bLong), 1);
                    }
                    if (aFrac != null && (bFrac != null || b == null)) {
                        result = this.onFraction.apply(aFrac, bFrac);
                    }
                }
            }
        }
        catch (ArithmeticException aLong) {
            // empty catch block
        }
        if (result == null) {
            result = (Number)this.onDoubleDouble.apply(DoubleDouble.of(a, true), DoubleDouble.of(b, true));
        }
        if (ExtendedPrecisionMatrix.isZero(result)) {
            return null;
        }
        if (result.equals(a)) {
            return a;
        }
        if (result.equals(b)) {
            return b;
        }
        Long simplified = Arithmetic.tryLongValue((Number)result);
        return simplified != null ? simplified : result;
    }

    public static Number add(Number a, Number b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return ADD.apply(a, b);
    }

    public static Number subtract(Number a, Number b) {
        if (b == null) {
            return a;
        }
        if (a == null) {
            return NEGATE.apply(b, null);
        }
        return SUBTRACT.apply(a, b);
    }

    public static Number multiply(Number a, Number b) {
        if (a == null || b == null) {
            return null;
        }
        if (Arithmetic.isOne(a)) {
            return b;
        }
        if (Arithmetic.isOne(b)) {
            return a;
        }
        return MULTIPLY.apply(a, b);
    }

    public static Number divide(Number a, Number b) {
        if (b != null) {
            if (a == null || Arithmetic.isOne(b)) {
                return a;
            }
            if (Arithmetic.isOne(a)) {
                return INVERSE.apply(b, null);
            }
        }
        return DIVIDE.apply(a, b);
    }

    public static Number inverse(Number a) {
        if (a == null) {
            return Double.POSITIVE_INFINITY;
        }
        if (Arithmetic.isOne(a)) {
            return a;
        }
        return INVERSE.apply(a, null);
    }

    public static Number negate(Number a) {
        if (a == null) {
            return null;
        }
        return NEGATE.apply(a, null);
    }

    public static Number square(Number a) {
        if (a == null || Arithmetic.isOne(a)) {
            return a;
        }
        return MULTIPLY.apply(a, a);
    }

    public static Number sqrt(Number a) {
        if (a == null || Arithmetic.isOne(a)) {
            return a;
        }
        return SQRT.apply(a, null);
    }

    public static boolean isOne(Number element) {
        return element != null && element.doubleValue() == 1.0;
    }
}

