/*
 * Decompiled with CFR 0.152.
 */
package tdb2.xloader;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.atlas.logging.LogCtl;
import org.apache.jena.cmd.ArgDecl;
import org.apache.jena.cmd.CmdException;
import org.apache.jena.cmd.CmdMain;
import org.apache.jena.sys.JenaSystem;
import org.apache.jena.tdb2.xloader.XLoaderFiles;

abstract class AbstractCmdxLoad
extends CmdMain {
    protected static ArgDecl argLocation;
    protected static ArgDecl argTmpdir;
    protected static ArgDecl argIndex;
    protected static ArgDecl argSortThreads;
    protected String location = null;
    protected String tmpdir = null;
    protected String indexName = null;
    protected int sortThreads = -1;
    protected String sortNodeTableArgs = null;
    protected String sortIndexArgs = null;
    protected List<String> filenames = null;
    protected XLoaderFiles loaderFiles = null;

    protected AbstractCmdxLoad(String stageName, String[] argv) {
        super(argv);
        this.setCmdArgs();
    }

    protected abstract void setCmdArgs();

    protected String getArgsSummary() {
        return "--loc=DIR --tmpdir=DIR";
    }

    @Override
    protected void processModulesAndArgs() {
        if (!super.hasArg(argLocation)) {
            throw new CmdException("Required: --loc=");
        }
        this.location = super.getValue(argLocation);
        this.tmpdir = super.getValue(argTmpdir);
        this.indexName = super.getValue(argIndex);
        if (this.location != null) {
            this.checkDirectory(this.location);
        }
        if (this.tmpdir != null) {
            this.checkDirectory(this.tmpdir);
        } else {
            this.tmpdir = this.location;
        }
        this.filenames = new ArrayList<String>(super.getPositional());
        if (super.contains(argSortThreads)) {
            String str2 = super.getValue(argSortThreads);
            try {
                this.sortThreads = Integer.parseInt(str2);
            }
            catch (NumberFormatException ex) {
                throw new CmdException("--threads :: Failed to parse '" + str2 + "' as an integer");
            }
        }
        this.subCheckArgs();
        this.loaderFiles = new XLoaderFiles(this.tmpdir);
    }

    private void checkDirectory(String dirname) {
        try {
            Path path = Paths.get(dirname, new String[0]);
            if (Files.exists(path, new LinkOption[0])) {
                path = path.toRealPath(new LinkOption[0]);
            }
            if (!(!Files.exists(path, new LinkOption[0]) || Files.isDirectory(path, new LinkOption[0]) && Files.isWritable(path))) {
                throw new CmdException("Path name '" + dirname + "' exists but is not a writable directory");
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    protected abstract void subCheckArgs();

    static {
        JenaSystem.init();
        LogCtl.setLog4j2();
        argLocation = new ArgDecl(true, "location", "loc");
        argTmpdir = new ArgDecl(true, "tmpdir", "tmp");
        argIndex = new ArgDecl(true, "index");
        argSortThreads = new ArgDecl(true, "threads", "thread", "sortThreads", "sortthreads");
    }
}

