/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util.iso;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.exec.RowSet;
import org.apache.jena.sparql.util.EqualityTest;
import org.apache.jena.sparql.util.NodeUtils;
import org.apache.jena.sparql.util.iso.BNodeIso;
import org.apache.jena.sparql.util.iso.IsoLib;
import org.apache.jena.sparql.util.iso.IsoMapping;

public class IsoAlgRows {
    private static final boolean DEBUG = false;
    private static final IndentedWriter out = IsoAlgRows.debugIndentedWriter();

    private static final IndentedWriter debugIndentedWriter() {
        IndentedWriter iout = null;
        return iout;
    }

    public static boolean isomorphic(RowSet rowset1, RowSet rowset2, BNodeIso.Match matching) {
        Objects.requireNonNull(rowset1);
        Objects.requireNonNull(rowset2);
        if (rowset1 == rowset2) {
            return true;
        }
        if (!IsoLib.compareHeader(rowset1, rowset2)) {
            return false;
        }
        List<Binding> rows1 = IsoAlgRows.toList(rowset1);
        List<Binding> rows2 = IsoAlgRows.toList(rowset2);
        if (rows1.size() != rows2.size()) {
            return false;
        }
        return IsoAlgRows.matcher(rows1, rows2, matching);
    }

    public static boolean isomorphic(List<Binding> list1, List<Binding> list2, BNodeIso.Match matching) {
        if (list1.size() != list2.size()) {
            return false;
        }
        return IsoAlgRows.matcher(list1, list2, matching);
    }

    private static boolean matcher(List<Binding> list1, List<Binding> list2, BNodeIso.Match matching) {
        return IsoAlgRows.matcherWorker(list1, 0, list2, IsoMapping.rootMapping, switch (matching) {
            case BNodeIso.Match.EXACT_TERM, BNodeIso.Match.EXACT_VALUE -> IsoLib.mappableNoMap;
            case BNodeIso.Match.BNODES_TERM, BNodeIso.Match.BNODES_VALUE -> IsoLib.mappableBlankNodes;
            default -> throw new InternalErrorException("Unknown matching policy");
        }, switch (matching) {
            case BNodeIso.Match.BNODES_TERM, BNodeIso.Match.EXACT_TERM -> NodeUtils.sameRdfTerm;
            case BNodeIso.Match.BNODES_VALUE, BNodeIso.Match.EXACT_VALUE -> NodeUtils.sameValue;
            default -> throw new InternalErrorException("Unknown equality policy");
        });
    }

    private static boolean matcherWorker(List<Binding> rows1, int idx1, List<Binding> rows2, IsoMapping mapping, IsoLib.Mappable mappable, EqualityTest equalityTest) {
        if (rows1.size() == 0) {
            return true;
        }
        for (int i = idx1; i < rows1.size(); ++i) {
            Binding row1 = rows1.get(i);
            if (row1 == null) continue;
            List<Possibility> possibilities = IsoAlgRows.matcherOneRow(row1, rows2, mapping, mappable, equalityTest);
            if (possibilities.isEmpty()) {
                return false;
            }
            for (Possibility poss : possibilities) {
                int iRest = i + 1;
                if (iRest >= rows1.size()) {
                    return true;
                }
                ArrayList<Binding> rows2x = new ArrayList<Binding>(rows2);
                rows2x.remove(poss.row);
                if (!IsoAlgRows.matcherWorker(rows1, iRest, rows2x, poss.mapping, mappable, equalityTest)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private static List<Possibility> matcherOneRow(Binding row1, List<Binding> rows2, IsoMapping mapping, IsoLib.Mappable mappable, EqualityTest equalityTest) {
        ArrayList<Possibility> possibilities = new ArrayList<Possibility>();
        for (int j = 0; j < rows2.size(); ++j) {
            IsoMapping step;
            Binding row2 = rows2.get(j);
            if (row2 == null || (step = IsoAlgRows.matchOne(row1, row2, mapping, mappable, equalityTest)) == null) continue;
            Possibility poss = new Possibility(row2, step);
            possibilities.add(poss);
        }
        return possibilities;
    }

    private static IsoMapping matchOne(Binding row1, Binding row2, IsoMapping mapping, IsoLib.Mappable mappable, EqualityTest equalityTest) {
        Iterator<Var> iter = row1.vars();
        IsoMapping mapping2 = mapping;
        while (iter.hasNext()) {
            Var v = iter.next();
            Node n1 = row1.get(v);
            Node n2 = row2.get(v);
            if (n2 == null) {
                return null;
            }
            if ((mapping2 = IsoAlgRows.matchTerms(n1, n2, mapping2, mappable, equalityTest)) != null) continue;
            return null;
        }
        return mapping2;
    }

    static IsoMapping matchTermsTest(Node n1, Node n2, EqualityTest nodeTest) {
        EqualityTest eqtest = BNodeIso.bnodeIsoByTerm();
        return IsoAlgRows.matchTerms(n1, n2, IsoMapping.rootMapping, IsoLib.mappableBlankNodes, eqtest);
    }

    static IsoMapping matchTerms(Node n1, Node n2, IsoMapping _mapping, IsoLib.Mappable mappable, EqualityTest nodeTest) {
        if (_mapping == null) {
            return null;
        }
        if (n1 == null || n2 == null) {
            return null;
        }
        IsoMapping mapping = _mapping;
        Node n1m = mapping.map(n1);
        if (n1m != null) {
            if (n1m.equals(n2)) {
                return mapping;
            }
            return null;
        }
        if (n1.isTripleTerm()) {
            if (n2.isTripleTerm()) {
                Triple t1 = n1.getTriple();
                Triple t2 = n2.getTriple();
                mapping = IsoAlgRows.matchTerms(t1.getSubject(), t2.getSubject(), mapping, mappable, nodeTest);
                if (mapping == null) {
                    return null;
                }
                mapping = IsoAlgRows.matchTerms(t1.getPredicate(), t2.getPredicate(), mapping, mappable, nodeTest);
                if (mapping == null) {
                    return null;
                }
                mapping = IsoAlgRows.matchTerms(t1.getObject(), t2.getObject(), mapping, mappable, nodeTest);
                if (mapping == null) {
                    return null;
                }
                return mapping;
            }
            return null;
        }
        if (n2.isTripleTerm()) {
            return null;
        }
        if (mappable.mappable(n1, n2)) {
            if (mapping.reverseMapped(n2)) {
                return null;
            }
            mapping = new IsoMapping(mapping, n1, n2);
            return mapping;
        }
        if (!nodeTest.equal(n1, n2)) {
            return null;
        }
        return mapping;
    }

    private static List<Binding> toList(RowSet rs) {
        return Iter.iter(rs).toList();
    }

    private record Possibility(Binding row, IsoMapping mapping) {
        @Override
        public String toString() {
            return String.format("Poss|%s %s|", IsoLib.str(this.row), this.mapping);
        }
    }
}

