/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.backward_codecs.lucene101;

import java.io.IOException;
import org.apache.lucene.backward_codecs.lucene101.ForUtil;
import org.apache.lucene.backward_codecs.lucene101.PostingDecodingUtil;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.packed.PackedInts;

public final class ForDeltaUtil {
    private static final int HALF_BLOCK_SIZE = 64;
    private static final int ONE_BLOCK_SIZE_FOURTH = 32;
    private static final int TWO_BLOCK_SIZE_FOURTHS = 64;
    private static final int THREE_BLOCK_SIZE_FOURTHS = 96;
    private final int[] tmp = new int[128];

    private static void prefixSum8(int[] arr, int base) {
        ForDeltaUtil.innerPrefixSum8(arr);
        ForUtil.expand8(arr);
        int l0 = base;
        int l1 = l0 + arr[31];
        int l2 = l1 + arr[63];
        int l3 = l2 + arr[95];
        for (int i = 0; i < 32; ++i) {
            int n = i;
            arr[n] = arr[n] + l0;
            int n2 = 32 + i;
            arr[n2] = arr[n2] + l1;
            int n3 = 64 + i;
            arr[n3] = arr[n3] + l2;
            int n4 = 96 + i;
            arr[n4] = arr[n4] + l3;
        }
    }

    private static void prefixSum16(int[] arr, int base) {
        ForDeltaUtil.innerPrefixSum16(arr);
        ForUtil.expand16(arr);
        int l0 = base;
        int l1 = base + arr[63];
        for (int i = 0; i < 64; ++i) {
            int n = i;
            arr[n] = arr[n] + l0;
            int n2 = 64 + i;
            arr[n2] = arr[n2] + l1;
        }
    }

    private static void prefixSum32(int[] arr, int base) {
        arr[0] = arr[0] + base;
        for (int i = 1; i < 128; ++i) {
            int n = i;
            arr[n] = arr[n] + arr[i - 1];
        }
    }

    private static void innerPrefixSum8(int[] arr) {
        arr[1] = arr[1] + arr[0];
        arr[2] = arr[2] + arr[1];
        arr[3] = arr[3] + arr[2];
        arr[4] = arr[4] + arr[3];
        arr[5] = arr[5] + arr[4];
        arr[6] = arr[6] + arr[5];
        arr[7] = arr[7] + arr[6];
        arr[8] = arr[8] + arr[7];
        arr[9] = arr[9] + arr[8];
        arr[10] = arr[10] + arr[9];
        arr[11] = arr[11] + arr[10];
        arr[12] = arr[12] + arr[11];
        arr[13] = arr[13] + arr[12];
        arr[14] = arr[14] + arr[13];
        arr[15] = arr[15] + arr[14];
        arr[16] = arr[16] + arr[15];
        arr[17] = arr[17] + arr[16];
        arr[18] = arr[18] + arr[17];
        arr[19] = arr[19] + arr[18];
        arr[20] = arr[20] + arr[19];
        arr[21] = arr[21] + arr[20];
        arr[22] = arr[22] + arr[21];
        arr[23] = arr[23] + arr[22];
        arr[24] = arr[24] + arr[23];
        arr[25] = arr[25] + arr[24];
        arr[26] = arr[26] + arr[25];
        arr[27] = arr[27] + arr[26];
        arr[28] = arr[28] + arr[27];
        arr[29] = arr[29] + arr[28];
        arr[30] = arr[30] + arr[29];
        arr[31] = arr[31] + arr[30];
    }

    private static void innerPrefixSum16(int[] arr) {
        arr[1] = arr[1] + arr[0];
        arr[2] = arr[2] + arr[1];
        arr[3] = arr[3] + arr[2];
        arr[4] = arr[4] + arr[3];
        arr[5] = arr[5] + arr[4];
        arr[6] = arr[6] + arr[5];
        arr[7] = arr[7] + arr[6];
        arr[8] = arr[8] + arr[7];
        arr[9] = arr[9] + arr[8];
        arr[10] = arr[10] + arr[9];
        arr[11] = arr[11] + arr[10];
        arr[12] = arr[12] + arr[11];
        arr[13] = arr[13] + arr[12];
        arr[14] = arr[14] + arr[13];
        arr[15] = arr[15] + arr[14];
        arr[16] = arr[16] + arr[15];
        arr[17] = arr[17] + arr[16];
        arr[18] = arr[18] + arr[17];
        arr[19] = arr[19] + arr[18];
        arr[20] = arr[20] + arr[19];
        arr[21] = arr[21] + arr[20];
        arr[22] = arr[22] + arr[21];
        arr[23] = arr[23] + arr[22];
        arr[24] = arr[24] + arr[23];
        arr[25] = arr[25] + arr[24];
        arr[26] = arr[26] + arr[25];
        arr[27] = arr[27] + arr[26];
        arr[28] = arr[28] + arr[27];
        arr[29] = arr[29] + arr[28];
        arr[30] = arr[30] + arr[29];
        arr[31] = arr[31] + arr[30];
        arr[32] = arr[32] + arr[31];
        arr[33] = arr[33] + arr[32];
        arr[34] = arr[34] + arr[33];
        arr[35] = arr[35] + arr[34];
        arr[36] = arr[36] + arr[35];
        arr[37] = arr[37] + arr[36];
        arr[38] = arr[38] + arr[37];
        arr[39] = arr[39] + arr[38];
        arr[40] = arr[40] + arr[39];
        arr[41] = arr[41] + arr[40];
        arr[42] = arr[42] + arr[41];
        arr[43] = arr[43] + arr[42];
        arr[44] = arr[44] + arr[43];
        arr[45] = arr[45] + arr[44];
        arr[46] = arr[46] + arr[45];
        arr[47] = arr[47] + arr[46];
        arr[48] = arr[48] + arr[47];
        arr[49] = arr[49] + arr[48];
        arr[50] = arr[50] + arr[49];
        arr[51] = arr[51] + arr[50];
        arr[52] = arr[52] + arr[51];
        arr[53] = arr[53] + arr[52];
        arr[54] = arr[54] + arr[53];
        arr[55] = arr[55] + arr[54];
        arr[56] = arr[56] + arr[55];
        arr[57] = arr[57] + arr[56];
        arr[58] = arr[58] + arr[57];
        arr[59] = arr[59] + arr[58];
        arr[60] = arr[60] + arr[59];
        arr[61] = arr[61] + arr[60];
        arr[62] = arr[62] + arr[61];
        arr[63] = arr[63] + arr[62];
    }

    int bitsRequired(int[] ints) {
        int or = 0;
        for (int l : ints) {
            or |= l;
        }
        assert (or != 0);
        return PackedInts.bitsRequired(or);
    }

    void encodeDeltas(int bitsPerValue, int[] ints, DataOutput out) throws IOException {
        int primitiveSize;
        if (bitsPerValue <= 3) {
            primitiveSize = 8;
            ForUtil.collapse8(ints);
        } else if (bitsPerValue <= 10) {
            primitiveSize = 16;
            ForUtil.collapse16(ints);
        } else {
            primitiveSize = 32;
        }
        ForUtil.encode(ints, bitsPerValue, primitiveSize, out, this.tmp);
    }

    void decodeAndPrefixSum(int bitsPerValue, PostingDecodingUtil pdu, int base, int[] ints) throws IOException {
        switch (bitsPerValue) {
            case 1: {
                ForUtil.decode1(pdu, ints);
                ForDeltaUtil.prefixSum8(ints, base);
                break;
            }
            case 2: {
                ForUtil.decode2(pdu, ints);
                ForDeltaUtil.prefixSum8(ints, base);
                break;
            }
            case 3: {
                ForUtil.decode3(pdu, this.tmp, ints);
                ForDeltaUtil.prefixSum8(ints, base);
                break;
            }
            case 4: {
                ForDeltaUtil.decode4To16(pdu, ints);
                ForDeltaUtil.prefixSum16(ints, base);
                break;
            }
            case 5: {
                ForDeltaUtil.decode5To16(pdu, this.tmp, ints);
                ForDeltaUtil.prefixSum16(ints, base);
                break;
            }
            case 6: {
                ForDeltaUtil.decode6To16(pdu, this.tmp, ints);
                ForDeltaUtil.prefixSum16(ints, base);
                break;
            }
            case 7: {
                ForDeltaUtil.decode7To16(pdu, this.tmp, ints);
                ForDeltaUtil.prefixSum16(ints, base);
                break;
            }
            case 8: {
                ForDeltaUtil.decode8To16(pdu, ints);
                ForDeltaUtil.prefixSum16(ints, base);
                break;
            }
            case 9: {
                ForUtil.decode9(pdu, this.tmp, ints);
                ForDeltaUtil.prefixSum16(ints, base);
                break;
            }
            case 10: {
                ForUtil.decode10(pdu, this.tmp, ints);
                ForDeltaUtil.prefixSum16(ints, base);
                break;
            }
            case 11: {
                ForDeltaUtil.decode11To32(pdu, this.tmp, ints);
                ForDeltaUtil.prefixSum32(ints, base);
                break;
            }
            case 12: {
                ForDeltaUtil.decode12To32(pdu, this.tmp, ints);
                ForDeltaUtil.prefixSum32(ints, base);
                break;
            }
            case 13: {
                ForDeltaUtil.decode13To32(pdu, this.tmp, ints);
                ForDeltaUtil.prefixSum32(ints, base);
                break;
            }
            case 14: {
                ForDeltaUtil.decode14To32(pdu, this.tmp, ints);
                ForDeltaUtil.prefixSum32(ints, base);
                break;
            }
            case 15: {
                ForDeltaUtil.decode15To32(pdu, this.tmp, ints);
                ForDeltaUtil.prefixSum32(ints, base);
                break;
            }
            case 16: {
                ForDeltaUtil.decode16To32(pdu, ints);
                ForDeltaUtil.prefixSum32(ints, base);
                break;
            }
            default: {
                if (bitsPerValue < 1 || bitsPerValue > 32) {
                    throw new IllegalStateException("Illegal number of bits per value: " + bitsPerValue);
                }
                ForUtil.decodeSlow(bitsPerValue, pdu, this.tmp, ints);
                ForDeltaUtil.prefixSum32(ints, base);
            }
        }
    }

    private static void decode4To16(PostingDecodingUtil pdu, int[] ints) throws IOException {
        pdu.splitInts(16, ints, 12, 4, ForUtil.MASK16_4, ints, 48, ForUtil.MASK16_4);
    }

    private static void decode5To16(PostingDecodingUtil pdu, int[] tmp, int[] ints) throws IOException {
        pdu.splitInts(20, ints, 11, 5, ForUtil.MASK16_5, tmp, 0, ForUtil.MASK16_1);
        int iter = 0;
        int tmpIdx = 0;
        int intsIdx = 60;
        while (iter < 4) {
            int l0 = tmp[tmpIdx + 0] << 4;
            l0 |= tmp[tmpIdx + 1] << 3;
            l0 |= tmp[tmpIdx + 2] << 2;
            l0 |= tmp[tmpIdx + 3] << 1;
            ints[intsIdx + 0] = l0 |= tmp[tmpIdx + 4] << 0;
            ++iter;
            tmpIdx += 5;
            ++intsIdx;
        }
    }

    private static void decode6To16(PostingDecodingUtil pdu, int[] tmp, int[] ints) throws IOException {
        pdu.splitInts(24, ints, 10, 6, ForUtil.MASK16_6, tmp, 0, ForUtil.MASK16_4);
        int iter = 0;
        int tmpIdx = 0;
        int intsIdx = 48;
        while (iter < 8) {
            int l0 = tmp[tmpIdx + 0] << 2;
            ints[intsIdx + 0] = l0 |= tmp[tmpIdx + 1] >>> 2 & ForUtil.MASK16_2;
            int l1 = (tmp[tmpIdx + 1] & ForUtil.MASK16_2) << 4;
            ints[intsIdx + 1] = l1 |= tmp[tmpIdx + 2] << 0;
            ++iter;
            tmpIdx += 3;
            intsIdx += 2;
        }
    }

    private static void decode7To16(PostingDecodingUtil pdu, int[] tmp, int[] ints) throws IOException {
        pdu.splitInts(28, ints, 9, 7, ForUtil.MASK16_7, tmp, 0, ForUtil.MASK16_2);
        int iter = 0;
        int tmpIdx = 0;
        int intsIdx = 56;
        while (iter < 4) {
            int l0 = tmp[tmpIdx + 0] << 5;
            l0 |= tmp[tmpIdx + 1] << 3;
            l0 |= tmp[tmpIdx + 2] << 1;
            ints[intsIdx + 0] = l0 |= tmp[tmpIdx + 3] >>> 1 & ForUtil.MASK16_1;
            int l1 = (tmp[tmpIdx + 3] & ForUtil.MASK16_1) << 6;
            l1 |= tmp[tmpIdx + 4] << 4;
            l1 |= tmp[tmpIdx + 5] << 2;
            ints[intsIdx + 1] = l1 |= tmp[tmpIdx + 6] << 0;
            ++iter;
            tmpIdx += 7;
            intsIdx += 2;
        }
    }

    private static void decode8To16(PostingDecodingUtil pdu, int[] ints) throws IOException {
        pdu.splitInts(32, ints, 8, 8, ForUtil.MASK16_8, ints, 32, ForUtil.MASK16_8);
    }

    private static void decode11To32(PostingDecodingUtil pdu, int[] tmp, int[] ints) throws IOException {
        pdu.splitInts(44, ints, 21, 11, ForUtil.MASK32_11, tmp, 0, ForUtil.MASK32_10);
        int iter = 0;
        int tmpIdx = 0;
        int intsIdx = 88;
        while (iter < 4) {
            int l0 = tmp[tmpIdx + 0] << 1;
            ints[intsIdx + 0] = l0 |= tmp[tmpIdx + 1] >>> 9 & ForUtil.MASK32_1;
            int l1 = (tmp[tmpIdx + 1] & ForUtil.MASK32_9) << 2;
            ints[intsIdx + 1] = l1 |= tmp[tmpIdx + 2] >>> 8 & ForUtil.MASK32_2;
            int l2 = (tmp[tmpIdx + 2] & ForUtil.MASK32_8) << 3;
            ints[intsIdx + 2] = l2 |= tmp[tmpIdx + 3] >>> 7 & ForUtil.MASK32_3;
            int l3 = (tmp[tmpIdx + 3] & ForUtil.MASK32_7) << 4;
            ints[intsIdx + 3] = l3 |= tmp[tmpIdx + 4] >>> 6 & ForUtil.MASK32_4;
            int l4 = (tmp[tmpIdx + 4] & ForUtil.MASK32_6) << 5;
            ints[intsIdx + 4] = l4 |= tmp[tmpIdx + 5] >>> 5 & ForUtil.MASK32_5;
            int l5 = (tmp[tmpIdx + 5] & ForUtil.MASK32_5) << 6;
            ints[intsIdx + 5] = l5 |= tmp[tmpIdx + 6] >>> 4 & ForUtil.MASK32_6;
            int l6 = (tmp[tmpIdx + 6] & ForUtil.MASK32_4) << 7;
            ints[intsIdx + 6] = l6 |= tmp[tmpIdx + 7] >>> 3 & ForUtil.MASK32_7;
            int l7 = (tmp[tmpIdx + 7] & ForUtil.MASK32_3) << 8;
            ints[intsIdx + 7] = l7 |= tmp[tmpIdx + 8] >>> 2 & ForUtil.MASK32_8;
            int l8 = (tmp[tmpIdx + 8] & ForUtil.MASK32_2) << 9;
            ints[intsIdx + 8] = l8 |= tmp[tmpIdx + 9] >>> 1 & ForUtil.MASK32_9;
            int l9 = (tmp[tmpIdx + 9] & ForUtil.MASK32_1) << 10;
            ints[intsIdx + 9] = l9 |= tmp[tmpIdx + 10] << 0;
            ++iter;
            tmpIdx += 11;
            intsIdx += 10;
        }
    }

    private static void decode12To32(PostingDecodingUtil pdu, int[] tmp, int[] ints) throws IOException {
        pdu.splitInts(48, ints, 20, 12, ForUtil.MASK32_12, tmp, 0, ForUtil.MASK32_8);
        int iter = 0;
        int tmpIdx = 0;
        int intsIdx = 96;
        while (iter < 16) {
            int l0 = tmp[tmpIdx + 0] << 4;
            ints[intsIdx + 0] = l0 |= tmp[tmpIdx + 1] >>> 4 & ForUtil.MASK32_4;
            int l1 = (tmp[tmpIdx + 1] & ForUtil.MASK32_4) << 8;
            ints[intsIdx + 1] = l1 |= tmp[tmpIdx + 2] << 0;
            ++iter;
            tmpIdx += 3;
            intsIdx += 2;
        }
    }

    private static void decode13To32(PostingDecodingUtil pdu, int[] tmp, int[] ints) throws IOException {
        pdu.splitInts(52, ints, 19, 13, ForUtil.MASK32_13, tmp, 0, ForUtil.MASK32_6);
        int iter = 0;
        int tmpIdx = 0;
        int intsIdx = 104;
        while (iter < 4) {
            int l0 = tmp[tmpIdx + 0] << 7;
            l0 |= tmp[tmpIdx + 1] << 1;
            ints[intsIdx + 0] = l0 |= tmp[tmpIdx + 2] >>> 5 & ForUtil.MASK32_1;
            int l1 = (tmp[tmpIdx + 2] & ForUtil.MASK32_5) << 8;
            l1 |= tmp[tmpIdx + 3] << 2;
            ints[intsIdx + 1] = l1 |= tmp[tmpIdx + 4] >>> 4 & ForUtil.MASK32_2;
            int l2 = (tmp[tmpIdx + 4] & ForUtil.MASK32_4) << 9;
            l2 |= tmp[tmpIdx + 5] << 3;
            ints[intsIdx + 2] = l2 |= tmp[tmpIdx + 6] >>> 3 & ForUtil.MASK32_3;
            int l3 = (tmp[tmpIdx + 6] & ForUtil.MASK32_3) << 10;
            l3 |= tmp[tmpIdx + 7] << 4;
            ints[intsIdx + 3] = l3 |= tmp[tmpIdx + 8] >>> 2 & ForUtil.MASK32_4;
            int l4 = (tmp[tmpIdx + 8] & ForUtil.MASK32_2) << 11;
            l4 |= tmp[tmpIdx + 9] << 5;
            ints[intsIdx + 4] = l4 |= tmp[tmpIdx + 10] >>> 1 & ForUtil.MASK32_5;
            int l5 = (tmp[tmpIdx + 10] & ForUtil.MASK32_1) << 12;
            l5 |= tmp[tmpIdx + 11] << 6;
            ints[intsIdx + 5] = l5 |= tmp[tmpIdx + 12] << 0;
            ++iter;
            tmpIdx += 13;
            intsIdx += 6;
        }
    }

    private static void decode14To32(PostingDecodingUtil pdu, int[] tmp, int[] ints) throws IOException {
        pdu.splitInts(56, ints, 18, 14, ForUtil.MASK32_14, tmp, 0, ForUtil.MASK32_4);
        int iter = 0;
        int tmpIdx = 0;
        int intsIdx = 112;
        while (iter < 8) {
            int l0 = tmp[tmpIdx + 0] << 10;
            l0 |= tmp[tmpIdx + 1] << 6;
            l0 |= tmp[tmpIdx + 2] << 2;
            ints[intsIdx + 0] = l0 |= tmp[tmpIdx + 3] >>> 2 & ForUtil.MASK32_2;
            int l1 = (tmp[tmpIdx + 3] & ForUtil.MASK32_2) << 12;
            l1 |= tmp[tmpIdx + 4] << 8;
            l1 |= tmp[tmpIdx + 5] << 4;
            ints[intsIdx + 1] = l1 |= tmp[tmpIdx + 6] << 0;
            ++iter;
            tmpIdx += 7;
            intsIdx += 2;
        }
    }

    private static void decode15To32(PostingDecodingUtil pdu, int[] tmp, int[] ints) throws IOException {
        pdu.splitInts(60, ints, 17, 15, ForUtil.MASK32_15, tmp, 0, ForUtil.MASK32_2);
        int iter = 0;
        int tmpIdx = 0;
        int intsIdx = 120;
        while (iter < 4) {
            int l0 = tmp[tmpIdx + 0] << 13;
            l0 |= tmp[tmpIdx + 1] << 11;
            l0 |= tmp[tmpIdx + 2] << 9;
            l0 |= tmp[tmpIdx + 3] << 7;
            l0 |= tmp[tmpIdx + 4] << 5;
            l0 |= tmp[tmpIdx + 5] << 3;
            l0 |= tmp[tmpIdx + 6] << 1;
            ints[intsIdx + 0] = l0 |= tmp[tmpIdx + 7] >>> 1 & ForUtil.MASK32_1;
            int l1 = (tmp[tmpIdx + 7] & ForUtil.MASK32_1) << 14;
            l1 |= tmp[tmpIdx + 8] << 12;
            l1 |= tmp[tmpIdx + 9] << 10;
            l1 |= tmp[tmpIdx + 10] << 8;
            l1 |= tmp[tmpIdx + 11] << 6;
            l1 |= tmp[tmpIdx + 12] << 4;
            l1 |= tmp[tmpIdx + 13] << 2;
            ints[intsIdx + 1] = l1 |= tmp[tmpIdx + 14] << 0;
            ++iter;
            tmpIdx += 15;
            intsIdx += 2;
        }
    }

    private static void decode16To32(PostingDecodingUtil pdu, int[] ints) throws IOException {
        pdu.splitInts(64, ints, 16, 16, ForUtil.MASK32_16, ints, 64, ForUtil.MASK32_16);
    }
}

