/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.backward_codecs.lucene912;

import java.io.IOException;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;
import org.apache.lucene.backward_codecs.lucene912.ForDeltaUtil;
import org.apache.lucene.backward_codecs.lucene912.Lucene912PostingsFormat;
import org.apache.lucene.backward_codecs.lucene912.PForUtil;
import org.apache.lucene.backward_codecs.lucene912.PostingsUtil;
import org.apache.lucene.codecs.BlockTermState;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.PostingsReaderBase;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.Impact;
import org.apache.lucene.index.Impacts;
import org.apache.lucene.index.ImpactsEnum;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SlowImpactsEnum;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.FileDataHint;
import org.apache.lucene.store.FileTypeHint;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;

public final class Lucene912PostingsReader
extends PostingsReaderBase {
    private static final List<Impact> DUMMY_IMPACTS = Collections.singletonList(new Impact(Integer.MAX_VALUE, 1L));
    private final IndexInput docIn;
    private final IndexInput posIn;
    private final IndexInput payIn;
    private final int maxNumImpactsAtLevel0;
    private final int maxImpactNumBytesAtLevel0;
    private final int maxNumImpactsAtLevel1;
    private final int maxImpactNumBytesAtLevel1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Lucene912PostingsReader(SegmentReadState state) throws IOException {
        long expectedPayFileLength;
        long expectedPosFileLength;
        long expectedDocFileLength;
        int version2;
        boolean success;
        block13: {
            ChecksumIndexInput metaIn;
            block12: {
                String metaName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "psm");
                metaIn = null;
                success = false;
                try {
                    metaIn = state.directory.openChecksumInput(metaName);
                    version2 = CodecUtil.checkIndexHeader(metaIn, "Lucene912PostingsWriterMeta", 0, 0, state.segmentInfo.getId(), state.segmentSuffix);
                    this.maxNumImpactsAtLevel0 = metaIn.readInt();
                    this.maxImpactNumBytesAtLevel0 = metaIn.readInt();
                    this.maxNumImpactsAtLevel1 = metaIn.readInt();
                    this.maxImpactNumBytesAtLevel1 = metaIn.readInt();
                    expectedDocFileLength = metaIn.readLong();
                    if (state.fieldInfos.hasProx()) {
                        expectedPosFileLength = metaIn.readLong();
                        expectedPayFileLength = state.fieldInfos.hasPayloads() || state.fieldInfos.hasOffsets() ? metaIn.readLong() : -1L;
                    } else {
                        expectedPosFileLength = -1L;
                        expectedPayFileLength = -1L;
                    }
                    CodecUtil.checkFooter(metaIn, null);
                    success = true;
                    if (!success) break block12;
                }
                catch (Throwable t) {
                    try {
                        if (metaIn == null) throw t;
                        CodecUtil.checkFooter(metaIn, t);
                        throw new AssertionError((Object)"unreachable");
                    }
                    catch (Throwable throwable) {
                        if (success) {
                            metaIn.close();
                            throw throwable;
                        } else {
                            IOUtils.closeWhileHandlingException(metaIn);
                        }
                        throw throwable;
                    }
                }
                metaIn.close();
                break block13;
            }
            IOUtils.closeWhileHandlingException(metaIn);
        }
        success = false;
        IndexInput docIn = null;
        IndexInput posIn = null;
        IndexInput payIn = null;
        String docName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "doc");
        try {
            docIn = state.directory.openInput(docName, state.context.withHints(FileTypeHint.DATA, FileDataHint.POSTINGS));
            CodecUtil.checkIndexHeader(docIn, "Lucene912PostingsWriterDoc", version2, version2, state.segmentInfo.getId(), state.segmentSuffix);
            CodecUtil.retrieveChecksum(docIn, expectedDocFileLength);
            if (state.fieldInfos.hasProx()) {
                String proxName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "pos");
                posIn = state.directory.openInput(proxName, state.context);
                CodecUtil.checkIndexHeader(posIn, "Lucene912PostingsWriterPos", version2, version2, state.segmentInfo.getId(), state.segmentSuffix);
                CodecUtil.retrieveChecksum(posIn, expectedPosFileLength);
                if (state.fieldInfos.hasPayloads() || state.fieldInfos.hasOffsets()) {
                    String payName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "pay");
                    payIn = state.directory.openInput(payName, state.context);
                    CodecUtil.checkIndexHeader(payIn, "Lucene912PostingsWriterPay", version2, version2, state.segmentInfo.getId(), state.segmentSuffix);
                    CodecUtil.retrieveChecksum(payIn, expectedPayFileLength);
                }
            }
            this.docIn = docIn;
            this.posIn = posIn;
            this.payIn = payIn;
            success = true;
            if (success) return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(docIn, posIn, payIn);
            throw throwable;
        }
        IOUtils.closeWhileHandlingException(docIn, posIn, payIn);
    }

    @Override
    public void init(IndexInput termsIn, SegmentReadState state) throws IOException {
        CodecUtil.checkIndexHeader(termsIn, "Lucene90PostingsWriterTerms", 0, 0, state.segmentInfo.getId(), state.segmentSuffix);
        int indexBlockSize = termsIn.readVInt();
        if (indexBlockSize != 128) {
            throw new IllegalStateException("index-time BLOCK_SIZE (" + indexBlockSize + ") != read-time BLOCK_SIZE (128)");
        }
    }

    static void prefixSum(long[] buffer, int count, long base) {
        buffer[0] = buffer[0] + base;
        for (int i = 1; i < count; ++i) {
            int n = i;
            buffer[n] = buffer[n] + buffer[i - 1];
        }
    }

    @Override
    public BlockTermState newTermState() {
        return new Lucene912PostingsFormat.IntBlockTermState();
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(this.docIn, this.posIn, this.payIn);
    }

    @Override
    public void decodeTerm(DataInput in, FieldInfo fieldInfo, BlockTermState _termState, boolean absolute) throws IOException {
        long l;
        Lucene912PostingsFormat.IntBlockTermState termState = (Lucene912PostingsFormat.IntBlockTermState)_termState;
        if (absolute) {
            termState.docStartFP = 0L;
            termState.posStartFP = 0L;
            termState.payStartFP = 0L;
        }
        if (((l = in.readVLong()) & 1L) == 0L) {
            termState.docStartFP += l >>> 1;
            termState.singletonDocID = termState.docFreq == 1 ? in.readVInt() : -1;
        } else {
            assert (!absolute);
            assert (termState.singletonDocID != -1);
            termState.singletonDocID = (int)((long)termState.singletonDocID + BitUtil.zigZagDecode(l >>> 1));
        }
        if (fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0) {
            termState.posStartFP += in.readVLong();
            if (fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0 || fieldInfo.hasPayloads()) {
                termState.payStartFP += in.readVLong();
            }
            termState.lastPosBlockOffset = termState.totalTermFreq > 128L ? in.readVLong() : -1L;
        }
    }

    @Override
    public PostingsEnum postings(FieldInfo fieldInfo, BlockTermState termState, PostingsEnum reuse, int flags) throws IOException {
        EverythingEnum everythingEnum;
        if (fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) < 0 || !PostingsEnum.featureRequested(flags, (short)24)) {
            BlockDocsEnum blockDocsEnum;
            return (reuse instanceof BlockDocsEnum && (blockDocsEnum = (BlockDocsEnum)reuse).canReuse(this.docIn, fieldInfo) ? blockDocsEnum : new BlockDocsEnum(fieldInfo)).reset((Lucene912PostingsFormat.IntBlockTermState)termState, flags);
        }
        return (reuse instanceof EverythingEnum && (everythingEnum = (EverythingEnum)reuse).canReuse(this.docIn, fieldInfo) ? everythingEnum : new EverythingEnum(fieldInfo)).reset((Lucene912PostingsFormat.IntBlockTermState)termState, flags);
    }

    @Override
    public ImpactsEnum impacts(FieldInfo fieldInfo, BlockTermState state, int flags) throws IOException {
        boolean indexHasPositions;
        IndexOptions options = fieldInfo.getIndexOptions();
        boolean bl = indexHasPositions = options.compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
        if (state.docFreq >= 128) {
            if (!(options.compareTo(IndexOptions.DOCS_AND_FREQS) < 0 || indexHasPositions && PostingsEnum.featureRequested(flags, (short)24))) {
                return new BlockImpactsDocsEnum(this, indexHasPositions, (Lucene912PostingsFormat.IntBlockTermState)state);
            }
            if (!(!indexHasPositions || options.compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0 && PostingsEnum.featureRequested(flags, (short)56) || fieldInfo.hasPayloads() && PostingsEnum.featureRequested(flags, (short)88))) {
                return new BlockImpactsPostingsEnum(this, fieldInfo, (Lucene912PostingsFormat.IntBlockTermState)state);
            }
        }
        return new SlowImpactsEnum(this.postings(fieldInfo, state, null, flags));
    }

    private static long sumOverRange(long[] arr, int start, int end) {
        long res = 0L;
        for (int i = start; i < end; ++i) {
            res += arr[i];
        }
        return res;
    }

    static int readVInt15(DataInput in) throws IOException {
        short s = in.readShort();
        if (s >= 0) {
            return s;
        }
        return s & Short.MAX_VALUE | in.readVInt() << 15;
    }

    static long readVLong15(DataInput in) throws IOException {
        short s = in.readShort();
        if (s >= 0) {
            return s;
        }
        return (long)s & 0x7FFFL | in.readVLong() << 15;
    }

    private static int findNextGEQ(long[] buffer, long target, int from, int to) {
        for (int i = from; i < to; ++i) {
            if (buffer[i] < target) continue;
            return i;
        }
        return to;
    }

    private static void prefetchPostings(IndexInput docIn, Lucene912PostingsFormat.IntBlockTermState state) throws IOException {
        assert (state.docFreq > 1);
        if (docIn.getFilePointer() != state.docStartFP) {
            docIn.prefetch(state.docStartFP, 1L);
        }
    }

    static MutableImpactList readImpacts(ByteArrayDataInput in, MutableImpactList reuse) {
        int freq = 0;
        long norm = 0L;
        int length = 0;
        while (in.getPosition() < in.length()) {
            int freqDelta = in.readVInt();
            if ((freqDelta & 1) != 0) {
                freq += 1 + (freqDelta >>> 1);
                try {
                    norm += 1L + in.readZLong();
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            } else {
                freq += 1 + (freqDelta >>> 1);
            }
            Impact impact = reuse.impacts[length];
            impact.freq = freq;
            impact.norm = ++norm;
            ++length;
        }
        reuse.length = length;
        return reuse;
    }

    @Override
    public void checkIntegrity() throws IOException {
        if (this.docIn != null) {
            CodecUtil.checksumEntireFile(this.docIn);
        }
        if (this.posIn != null) {
            CodecUtil.checksumEntireFile(this.posIn);
        }
        if (this.payIn != null) {
            CodecUtil.checksumEntireFile(this.payIn);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(positions=" + (this.posIn != null) + ",payloads=" + (this.payIn != null) + ")";
    }

    final class BlockDocsEnum
    extends AbstractPostingsEnum {
        private final long[] freqBuffer;
        private boolean needsFreq;
        private long freqFP;

        public BlockDocsEnum(FieldInfo fieldInfo) {
            super(fieldInfo);
            this.freqBuffer = new long[128];
        }

        public boolean canReuse(IndexInput docIn, FieldInfo fieldInfo) {
            IndexOptions options = fieldInfo.getIndexOptions();
            return docIn == Lucene912PostingsReader.this.docIn && this.indexHasFreq == options.compareTo(IndexOptions.DOCS_AND_FREQS) >= 0;
        }

        public PostingsEnum reset(Lucene912PostingsFormat.IntBlockTermState termState, int flags) throws IOException {
            this.resetIndexInput(termState);
            if (this.pforUtil == null && this.docFreq >= 128) {
                this.pforUtil = new PForUtil();
                this.forDeltaUtil = new ForDeltaUtil();
            }
            this.totalTermFreq = this.indexHasFreq ? termState.totalTermFreq : (long)this.docFreq;
            this.needsFreq = PostingsEnum.featureRequested(flags, (short)8);
            if (!this.indexHasFreq || !this.needsFreq) {
                Arrays.fill(this.freqBuffer, 0, Math.min(128, this.docFreq), 1L);
            }
            this.freqFP = -1L;
            return this.resetIdsAndLevelParams(termState);
        }

        @Override
        public int freq() throws IOException {
            if (this.freqFP != -1L) {
                this.docIn.seek(this.freqFP);
                this.pforUtil.decode(this.docIn, this.freqBuffer);
                this.freqFP = -1L;
            }
            return (int)this.freqBuffer[this.docBufferUpto - 1];
        }

        @Override
        public int nextPosition() {
            return -1;
        }

        @Override
        public int startOffset() {
            return -1;
        }

        @Override
        public int endOffset() {
            return -1;
        }

        @Override
        public BytesRef getPayload() {
            return null;
        }

        private void refillFullBlock() throws IOException {
            assert (this.docFreq - this.docCountUpto >= 128);
            this.forDeltaUtil.decodeAndPrefixSum(this.docIn, this.prevDocID, this.docBuffer);
            if (this.indexHasFreq) {
                if (this.needsFreq) {
                    this.freqFP = this.docIn.getFilePointer();
                }
                PForUtil.skip(this.docIn);
            }
            this.docCountUpto += 128;
            this.prevDocID = this.docBuffer[127];
            this.docBufferUpto = 0;
            assert (this.docBuffer[this.docBufferSize] == Integer.MAX_VALUE);
        }

        private void refillRemainder() throws IOException {
            int left = this.docFreq - this.docCountUpto;
            assert (left >= 0);
            assert (left < 128);
            if (this.docFreq == 1) {
                this.docBuffer[0] = this.singletonDocID;
                this.freqBuffer[0] = this.totalTermFreq;
                this.docBuffer[1] = Integer.MAX_VALUE;
                ++this.docCountUpto;
            } else {
                PostingsUtil.readVIntBlock(this.docIn, this.docBuffer, this.freqBuffer, left, this.indexHasFreq, this.needsFreq);
                Lucene912PostingsReader.prefixSum(this.docBuffer, left, this.prevDocID);
                this.docBuffer[left] = Integer.MAX_VALUE;
                this.docCountUpto += left;
            }
            this.docBufferUpto = 0;
            this.docBufferSize = left;
            this.freqFP = -1L;
        }

        private void skipLevel1To(int target) throws IOException {
            block2: {
                do {
                    this.prevDocID = this.level1LastDocID;
                    this.level0LastDocID = this.level1LastDocID;
                    this.docIn.seek(this.level1DocEndFP);
                    this.docCountUpto = this.level1DocCountUpto;
                    this.level1DocCountUpto += 4096;
                    if (this.docFreq - this.docCountUpto < 4096) {
                        this.level1LastDocID = Integer.MAX_VALUE;
                        break block2;
                    }
                    this.level1LastDocID += this.docIn.readVInt();
                    this.level1DocEndFP = this.docIn.readVLong() + this.docIn.getFilePointer();
                } while (this.level1LastDocID < target);
                if (!this.indexHasFreq) break block2;
                this.docIn.skipBytes(this.docIn.readShort());
            }
        }

        private void skipLevel0To(int target) throws IOException {
            block2: {
                while (true) {
                    this.prevDocID = this.level0LastDocID;
                    if (this.docFreq - this.docCountUpto < 128) break;
                    long skip0NumBytes = this.docIn.readVLong();
                    long skip0EndFP = this.docIn.getFilePointer() + skip0NumBytes;
                    int docDelta = Lucene912PostingsReader.readVInt15(this.docIn);
                    this.level0LastDocID += docDelta;
                    if (target <= this.level0LastDocID) {
                        this.docIn.seek(skip0EndFP);
                        break block2;
                    }
                    this.docIn.skipBytes(Lucene912PostingsReader.readVLong15(this.docIn));
                    this.docCountUpto += 128;
                }
                this.level0LastDocID = Integer.MAX_VALUE;
            }
        }

        private void moveToNextLevel0Block() throws IOException {
            if (this.doc == this.level1LastDocID) {
                this.skipLevel1To(this.doc + 1);
            }
            this.prevDocID = this.level0LastDocID;
            if (this.docFreq - this.docCountUpto >= 128) {
                this.docIn.skipBytes(this.docIn.readVLong());
                this.refillFullBlock();
                this.level0LastDocID = (int)this.docBuffer[127];
            } else {
                this.level0LastDocID = Integer.MAX_VALUE;
                this.refillRemainder();
            }
        }

        @Override
        public int nextDoc() throws IOException {
            if (this.docBufferUpto == 128) {
                this.moveToNextLevel0Block();
            }
            this.doc = (int)this.docBuffer[this.docBufferUpto++];
            return this.doc;
        }

        @Override
        public int advance(int target) throws IOException {
            if (target > this.level0LastDocID) {
                if (target > this.level1LastDocID) {
                    this.skipLevel1To(target);
                }
                this.skipLevel0To(target);
                if (this.docFreq - this.docCountUpto >= 128) {
                    this.refillFullBlock();
                } else {
                    this.refillRemainder();
                }
            }
            int next = Lucene912PostingsReader.findNextGEQ(this.docBuffer, target, this.docBufferUpto, this.docBufferSize);
            this.doc = (int)this.docBuffer[next];
            this.docBufferUpto = next + 1;
            return this.doc;
        }

        @Override
        public long cost() {
            return this.docFreq;
        }
    }

    final class EverythingEnum
    extends AbstractPostingsEnum {
        private final long[] freqBuffer;
        private final long[] posDeltaBuffer;
        private final long[] payloadLengthBuffer;
        private final long[] offsetStartDeltaBuffer;
        private final long[] offsetLengthBuffer;
        private byte[] payloadBytes;
        private int payloadByteUpto;
        private int payloadLength;
        private int lastStartOffset;
        private int startOffset;
        private int endOffset;
        private int posBufferUpto;
        final IndexInput posIn;
        final IndexInput payIn;
        final BytesRef payload;
        final boolean indexHasOffsets;
        final boolean indexHasPayloads;
        final boolean indexHasOffsetsOrPayloads;
        private int freq;
        private int position;
        private long posPendingCount;
        private long lastPosBlockFP;
        private long level0PosEndFP;
        private int level0BlockPosUpto;
        private long level0PayEndFP;
        private int level0BlockPayUpto;
        private long level1PosEndFP;
        private int level1BlockPosUpto;
        private long level1PayEndFP;
        private int level1BlockPayUpto;
        private boolean needsOffsets;
        private boolean needsPayloads;

        public EverythingEnum(FieldInfo fieldInfo) throws IOException {
            super(fieldInfo);
            this.freqBuffer = new long[129];
            this.posDeltaBuffer = new long[128];
            this.indexHasOffsets = fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
            this.indexHasPayloads = fieldInfo.hasPayloads();
            this.indexHasOffsetsOrPayloads = this.indexHasOffsets || this.indexHasPayloads;
            this.posIn = Lucene912PostingsReader.this.posIn.clone();
            this.payIn = this.indexHasOffsetsOrPayloads ? Lucene912PostingsReader.this.payIn.clone() : null;
            if (this.indexHasOffsets) {
                this.offsetStartDeltaBuffer = new long[128];
                this.offsetLengthBuffer = new long[128];
            } else {
                this.offsetStartDeltaBuffer = null;
                this.offsetLengthBuffer = null;
                this.startOffset = -1;
                this.endOffset = -1;
            }
            if (this.indexHasPayloads) {
                this.payloadLengthBuffer = new long[128];
                this.payloadBytes = new byte[128];
                this.payload = new BytesRef();
            } else {
                this.payloadLengthBuffer = null;
                this.payloadBytes = null;
                this.payload = null;
            }
        }

        public boolean canReuse(IndexInput docIn, FieldInfo fieldInfo) {
            return docIn == Lucene912PostingsReader.this.docIn && this.indexHasOffsets == fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0 && this.indexHasPayloads == fieldInfo.hasPayloads();
        }

        public PostingsEnum reset(Lucene912PostingsFormat.IntBlockTermState termState, int flags) throws IOException {
            this.resetIndexInput(termState);
            if (this.forDeltaUtil == null && this.docFreq >= 128) {
                this.forDeltaUtil = new ForDeltaUtil();
            }
            this.totalTermFreq = termState.totalTermFreq;
            if (this.pforUtil == null && this.totalTermFreq >= 128L) {
                this.pforUtil = new PForUtil();
            }
            long posTermStartFP = termState.posStartFP;
            long payTermStartFP = termState.payStartFP;
            this.posIn.seek(posTermStartFP);
            if (this.indexHasOffsetsOrPayloads) {
                this.payIn.seek(payTermStartFP);
            }
            this.level1PosEndFP = posTermStartFP;
            this.level1PayEndFP = payTermStartFP;
            this.level0PosEndFP = posTermStartFP;
            this.level0PayEndFP = payTermStartFP;
            this.posPendingCount = 0L;
            this.payloadByteUpto = 0;
            this.lastPosBlockFP = termState.totalTermFreq < 128L ? posTermStartFP : (termState.totalTermFreq == 128L ? -1L : posTermStartFP + termState.lastPosBlockOffset);
            this.needsOffsets = PostingsEnum.featureRequested(flags, (short)56);
            this.needsPayloads = PostingsEnum.featureRequested(flags, (short)88);
            this.level1BlockPosUpto = 0;
            this.level1BlockPayUpto = 0;
            this.level0BlockPosUpto = 0;
            this.level0BlockPayUpto = 0;
            this.posBufferUpto = 128;
            return this.resetIdsAndLevelParams(termState);
        }

        @Override
        public int freq() {
            return this.freq;
        }

        private void refillDocs() throws IOException {
            int left = this.docFreq - this.docCountUpto;
            assert (left >= 0);
            if (left >= 128) {
                this.forDeltaUtil.decodeAndPrefixSum(this.docIn, this.prevDocID, this.docBuffer);
                this.pforUtil.decode(this.docIn, this.freqBuffer);
                this.docCountUpto += 128;
            } else if (this.docFreq == 1) {
                this.docBuffer[0] = this.singletonDocID;
                this.freqBuffer[0] = this.totalTermFreq;
                this.docBuffer[1] = Integer.MAX_VALUE;
                ++this.docCountUpto;
                this.docBufferSize = 1;
            } else {
                PostingsUtil.readVIntBlock(this.docIn, this.docBuffer, this.freqBuffer, left, this.indexHasFreq, true);
                Lucene912PostingsReader.prefixSum(this.docBuffer, left, this.prevDocID);
                this.docBuffer[left] = Integer.MAX_VALUE;
                this.docCountUpto += left;
                this.docBufferSize = left;
            }
            this.prevDocID = this.docBuffer[127];
            this.docBufferUpto = 0;
            assert (this.docBuffer[this.docBufferSize] == Integer.MAX_VALUE);
        }

        private void skipLevel1To(int target) throws IOException {
            do {
                this.prevDocID = this.level1LastDocID;
                this.level0LastDocID = this.level1LastDocID;
                this.docIn.seek(this.level1DocEndFP);
                this.level0PosEndFP = this.level1PosEndFP;
                this.level0BlockPosUpto = this.level1BlockPosUpto;
                if (this.indexHasOffsetsOrPayloads) {
                    this.level0PayEndFP = this.level1PayEndFP;
                    this.level0BlockPayUpto = this.level1BlockPayUpto;
                }
                this.docCountUpto = this.level1DocCountUpto;
                this.level1DocCountUpto += 4096;
                if (this.docFreq - this.docCountUpto < 4096) {
                    this.level1LastDocID = Integer.MAX_VALUE;
                    break;
                }
                this.level1LastDocID += this.docIn.readVInt();
                long delta = this.docIn.readVLong();
                this.level1DocEndFP = delta + this.docIn.getFilePointer();
                long skip1EndFP = (long)this.docIn.readShort() + this.docIn.getFilePointer();
                this.docIn.skipBytes(this.docIn.readShort());
                this.level1PosEndFP += this.docIn.readVLong();
                this.level1BlockPosUpto = this.docIn.readByte();
                if (this.indexHasOffsetsOrPayloads) {
                    this.level1PayEndFP += this.docIn.readVLong();
                    this.level1BlockPayUpto = this.docIn.readVInt();
                }
                assert (this.docIn.getFilePointer() == skip1EndFP);
            } while (this.level1LastDocID < target);
        }

        private void moveToNextLevel0Block() throws IOException {
            if (this.doc == this.level1LastDocID) {
                this.skipLevel1To(this.doc + 1);
            }
            this.prevDocID = this.level0LastDocID;
            assert (this.docBufferUpto == 128);
            if (this.level0PosEndFP >= this.posIn.getFilePointer()) {
                this.posIn.seek(this.level0PosEndFP);
                this.posPendingCount = this.level0BlockPosUpto;
                if (this.indexHasOffsetsOrPayloads) {
                    assert (this.level0PayEndFP >= this.payIn.getFilePointer());
                    this.payIn.seek(this.level0PayEndFP);
                    this.payloadByteUpto = this.level0BlockPayUpto;
                }
                this.posBufferUpto = 128;
            }
            if (this.docFreq - this.docCountUpto >= 128) {
                this.docIn.readVLong();
                int docDelta = Lucene912PostingsReader.readVInt15(this.docIn);
                this.level0LastDocID += docDelta;
                Lucene912PostingsReader.readVLong15(this.docIn);
                this.docIn.skipBytes(this.docIn.readVLong());
                this.level0PosEndFP += this.docIn.readVLong();
                this.level0BlockPosUpto = this.docIn.readByte();
                if (this.indexHasOffsetsOrPayloads) {
                    this.level0PayEndFP += this.docIn.readVLong();
                    this.level0BlockPayUpto = this.docIn.readVInt();
                }
            } else {
                this.level0LastDocID = Integer.MAX_VALUE;
            }
            this.refillDocs();
        }

        @Override
        public int nextDoc() throws IOException {
            if (this.docBufferUpto == 128) {
                this.moveToNextLevel0Block();
            }
            this.doc = (int)this.docBuffer[this.docBufferUpto];
            this.freq = (int)this.freqBuffer[this.docBufferUpto];
            ++this.docBufferUpto;
            this.posPendingCount += (long)this.freq;
            this.position = 0;
            this.lastStartOffset = 0;
            return this.doc;
        }

        private void skipLevel0To(int target) throws IOException {
            block7: {
                while (true) {
                    this.prevDocID = this.level0LastDocID;
                    if (this.level0PosEndFP >= this.posIn.getFilePointer()) {
                        this.posIn.seek(this.level0PosEndFP);
                        this.posPendingCount = this.level0BlockPosUpto;
                        if (this.indexHasOffsetsOrPayloads) {
                            assert (this.level0PayEndFP >= this.payIn.getFilePointer());
                            this.payIn.seek(this.level0PayEndFP);
                            this.payloadByteUpto = this.level0BlockPayUpto;
                        }
                        this.posBufferUpto = 128;
                    } else {
                        this.posPendingCount += Lucene912PostingsReader.sumOverRange(this.freqBuffer, this.docBufferUpto, 128);
                    }
                    if (this.docFreq - this.docCountUpto < 128) break;
                    this.docIn.readVLong();
                    int docDelta = Lucene912PostingsReader.readVInt15(this.docIn);
                    this.level0LastDocID += docDelta;
                    long blockLength = Lucene912PostingsReader.readVLong15(this.docIn);
                    long blockEndFP = this.docIn.getFilePointer() + blockLength;
                    this.docIn.skipBytes(this.docIn.readVLong());
                    this.level0PosEndFP += this.docIn.readVLong();
                    this.level0BlockPosUpto = this.docIn.readByte();
                    if (this.indexHasOffsetsOrPayloads) {
                        this.level0PayEndFP += this.docIn.readVLong();
                        this.level0BlockPayUpto = this.docIn.readVInt();
                    }
                    if (target > this.level0LastDocID) {
                        this.docIn.seek(blockEndFP);
                        this.docCountUpto += 128;
                        continue;
                    }
                    break block7;
                    break;
                }
                this.level0LastDocID = Integer.MAX_VALUE;
            }
        }

        @Override
        public int advance(int target) throws IOException {
            if (target > this.level0LastDocID) {
                if (target > this.level1LastDocID) {
                    this.skipLevel1To(target);
                }
                this.skipLevel0To(target);
                this.refillDocs();
            }
            int next = Lucene912PostingsReader.findNextGEQ(this.docBuffer, target, this.docBufferUpto, this.docBufferSize);
            this.posPendingCount += Lucene912PostingsReader.sumOverRange(this.freqBuffer, this.docBufferUpto, next + 1);
            this.freq = (int)this.freqBuffer[next];
            this.docBufferUpto = next + 1;
            this.position = 0;
            this.lastStartOffset = 0;
            this.doc = (int)this.docBuffer[next];
            return this.doc;
        }

        private void skipPositions() throws IOException {
            long toSkip = this.posPendingCount - (long)this.freq;
            int leftInBlock = 128 - this.posBufferUpto;
            if (toSkip < (long)leftInBlock) {
                int end = (int)((long)this.posBufferUpto + toSkip);
                if (this.indexHasPayloads) {
                    this.payloadByteUpto = (int)((long)this.payloadByteUpto + Lucene912PostingsReader.sumOverRange(this.payloadLengthBuffer, this.posBufferUpto, end));
                }
                this.posBufferUpto = end;
            } else {
                toSkip -= (long)leftInBlock;
                while (toSkip >= 128L) {
                    assert (this.posIn.getFilePointer() != this.lastPosBlockFP);
                    PForUtil.skip(this.posIn);
                    if (this.indexHasPayloads) {
                        PForUtil.skip(this.payIn);
                        int numBytes = this.payIn.readVInt();
                        this.payIn.seek(this.payIn.getFilePointer() + (long)numBytes);
                    }
                    if (this.indexHasOffsets) {
                        PForUtil.skip(this.payIn);
                        PForUtil.skip(this.payIn);
                    }
                    toSkip -= 128L;
                }
                this.refillPositions();
                this.payloadByteUpto = 0;
                int toSkipInt = (int)toSkip;
                if (this.indexHasPayloads) {
                    this.payloadByteUpto = (int)((long)this.payloadByteUpto + Lucene912PostingsReader.sumOverRange(this.payloadLengthBuffer, 0, toSkipInt));
                }
                this.posBufferUpto = toSkipInt;
            }
            this.position = 0;
            this.lastStartOffset = 0;
        }

        private void refillPositions() throws IOException {
            if (this.posIn.getFilePointer() == this.lastPosBlockFP) {
                int count = (int)(this.totalTermFreq % 128L);
                int payloadLength = 0;
                int offsetLength = 0;
                this.payloadByteUpto = 0;
                for (int i = 0; i < count; ++i) {
                    int code = this.posIn.readVInt();
                    if (this.indexHasPayloads) {
                        if ((code & 1) != 0) {
                            payloadLength = this.posIn.readVInt();
                        }
                        this.payloadLengthBuffer[i] = payloadLength;
                        this.posDeltaBuffer[i] = code >>> 1;
                        if (payloadLength != 0) {
                            if (this.payloadByteUpto + payloadLength > this.payloadBytes.length) {
                                this.payloadBytes = ArrayUtil.grow(this.payloadBytes, this.payloadByteUpto + payloadLength);
                            }
                            this.posIn.readBytes(this.payloadBytes, this.payloadByteUpto, payloadLength);
                            this.payloadByteUpto += payloadLength;
                        }
                    } else {
                        this.posDeltaBuffer[i] = code;
                    }
                    if (!this.indexHasOffsets) continue;
                    int deltaCode = this.posIn.readVInt();
                    if ((deltaCode & 1) != 0) {
                        offsetLength = this.posIn.readVInt();
                    }
                    this.offsetStartDeltaBuffer[i] = deltaCode >>> 1;
                    this.offsetLengthBuffer[i] = offsetLength;
                }
                this.payloadByteUpto = 0;
            } else {
                this.pforUtil.decode(this.posIn, this.posDeltaBuffer);
                if (this.indexHasPayloads) {
                    if (this.needsPayloads) {
                        this.pforUtil.decode(this.payIn, this.payloadLengthBuffer);
                        int numBytes = this.payIn.readVInt();
                        if (numBytes > this.payloadBytes.length) {
                            this.payloadBytes = ArrayUtil.growNoCopy(this.payloadBytes, numBytes);
                        }
                        this.payIn.readBytes(this.payloadBytes, 0, numBytes);
                    } else {
                        PForUtil.skip(this.payIn);
                        int numBytes = this.payIn.readVInt();
                        this.payIn.seek(this.payIn.getFilePointer() + (long)numBytes);
                    }
                    this.payloadByteUpto = 0;
                }
                if (this.indexHasOffsets) {
                    if (this.needsOffsets) {
                        this.pforUtil.decode(this.payIn, this.offsetStartDeltaBuffer);
                        this.pforUtil.decode(this.payIn, this.offsetLengthBuffer);
                    } else {
                        PForUtil.skip(this.payIn);
                        PForUtil.skip(this.payIn);
                    }
                }
            }
        }

        @Override
        public int nextPosition() throws IOException {
            assert (this.posPendingCount > 0L);
            if (this.posPendingCount > (long)this.freq) {
                this.skipPositions();
                this.posPendingCount = this.freq;
            }
            if (this.posBufferUpto == 128) {
                this.refillPositions();
                this.posBufferUpto = 0;
            }
            this.position = (int)((long)this.position + this.posDeltaBuffer[this.posBufferUpto]);
            if (this.indexHasPayloads) {
                this.payloadLength = (int)this.payloadLengthBuffer[this.posBufferUpto];
                this.payload.bytes = this.payloadBytes;
                this.payload.offset = this.payloadByteUpto;
                this.payload.length = this.payloadLength;
                this.payloadByteUpto += this.payloadLength;
            }
            if (this.indexHasOffsets) {
                this.startOffset = this.lastStartOffset + (int)this.offsetStartDeltaBuffer[this.posBufferUpto];
                this.endOffset = this.startOffset + (int)this.offsetLengthBuffer[this.posBufferUpto];
                this.lastStartOffset = this.startOffset;
            }
            ++this.posBufferUpto;
            --this.posPendingCount;
            return this.position;
        }

        @Override
        public int startOffset() {
            return this.startOffset;
        }

        @Override
        public int endOffset() {
            return this.endOffset;
        }

        @Override
        public BytesRef getPayload() {
            if (this.payloadLength == 0) {
                return null;
            }
            return this.payload;
        }

        @Override
        public long cost() {
            return this.docFreq;
        }
    }

    final class BlockImpactsDocsEnum
    extends BlockImpactsEnum {
        final boolean indexHasPos;
        private long freqFP;

        public BlockImpactsDocsEnum(Lucene912PostingsReader this$0, boolean indexHasPos, Lucene912PostingsFormat.IntBlockTermState termState) throws IOException {
            super(this$0, termState);
            this.indexHasPos = indexHasPos;
            this.freqFP = -1L;
        }

        @Override
        public int freq() throws IOException {
            if (this.freqFP != -1L) {
                this.docIn.seek(this.freqFP);
                this.pforUtil.decode(this.docIn, this.freqBuffer);
                this.freqFP = -1L;
            }
            return (int)this.freqBuffer[this.docBufferUpto - 1];
        }

        @Override
        public int nextPosition() {
            return -1;
        }

        private void refillDocs() throws IOException {
            int left = this.docFreq - this.docCountUpto;
            assert (left >= 0);
            if (left >= 128) {
                this.forDeltaUtil.decodeAndPrefixSum(this.docIn, this.prevDocID, this.docBuffer);
                this.freqFP = this.docIn.getFilePointer();
                PForUtil.skip(this.docIn);
                this.docCountUpto += 128;
            } else {
                PostingsUtil.readVIntBlock(this.docIn, this.docBuffer, this.freqBuffer, left, true, true);
                Lucene912PostingsReader.prefixSum(this.docBuffer, left, this.prevDocID);
                this.docBuffer[left] = Integer.MAX_VALUE;
                this.freqFP = -1L;
                this.docCountUpto += left;
                this.docBufferSize = left;
            }
            this.prevDocID = this.docBuffer[127];
            this.docBufferUpto = 0;
            assert (this.docBuffer[this.docBufferSize] == Integer.MAX_VALUE);
        }

        private void skipLevel1To(int target) throws IOException {
            block3: {
                do {
                    this.prevDocID = this.level1LastDocID;
                    this.level0LastDocID = this.level1LastDocID;
                    this.docIn.seek(this.level1DocEndFP);
                    this.docCountUpto = this.level1DocCountUpto;
                    this.level1DocCountUpto += 4096;
                    if (this.docFreq - this.docCountUpto < 4096) {
                        this.level1LastDocID = Integer.MAX_VALUE;
                        break block3;
                    }
                    this.level1LastDocID += this.docIn.readVInt();
                    this.level1DocEndFP = this.docIn.readVLong() + this.docIn.getFilePointer();
                } while (this.level1LastDocID < target);
                long skip1EndFP = (long)this.docIn.readShort() + this.docIn.getFilePointer();
                short numImpactBytes = this.docIn.readShort();
                this.docIn.readBytes(this.level1SerializedImpacts.bytes, 0, numImpactBytes);
                this.level1SerializedImpacts.length = numImpactBytes;
                assert (this.indexHasPos || this.docIn.getFilePointer() == skip1EndFP);
                this.docIn.seek(skip1EndFP);
            }
        }

        private void skipLevel0To(int target) throws IOException {
            block2: {
                while (true) {
                    this.prevDocID = this.level0LastDocID;
                    if (this.docFreq - this.docCountUpto < 128) break;
                    long skip0NumBytes = this.docIn.readVLong();
                    long skip0End = this.docIn.getFilePointer() + skip0NumBytes;
                    int docDelta = Lucene912PostingsReader.readVInt15(this.docIn);
                    long blockLength = Lucene912PostingsReader.readVLong15(this.docIn);
                    this.level0LastDocID += docDelta;
                    if (target <= this.level0LastDocID) {
                        this.level0DocEndFP = this.docIn.getFilePointer() + blockLength;
                        int numImpactBytes = this.docIn.readVInt();
                        this.docIn.readBytes(this.level0SerializedImpacts.bytes, 0, numImpactBytes);
                        this.level0SerializedImpacts.length = numImpactBytes;
                        this.docIn.seek(skip0End);
                        break block2;
                    }
                    this.docIn.skipBytes(blockLength);
                    this.docCountUpto += 128;
                }
                this.level0LastDocID = Integer.MAX_VALUE;
            }
        }

        @Override
        public void advanceShallow(int target) throws IOException {
            if (target > this.level0LastDocID) {
                if (target > this.level1LastDocID) {
                    this.skipLevel1To(target);
                } else if (this.needsRefilling) {
                    this.docIn.seek(this.level0DocEndFP);
                    this.docCountUpto += 128;
                }
                this.skipLevel0To(target);
                this.needsRefilling = true;
            }
        }

        private void moveToNextLevel0Block() throws IOException {
            if (this.doc == this.level1LastDocID) {
                this.skipLevel1To(this.doc + 1);
            } else if (this.needsRefilling) {
                this.docIn.seek(this.level0DocEndFP);
                this.docCountUpto += 128;
            }
            this.prevDocID = this.level0LastDocID;
            if (this.docFreq - this.docCountUpto >= 128) {
                long skip0Len = this.docIn.readVLong();
                long skip0End = this.docIn.getFilePointer() + skip0Len;
                int docDelta = Lucene912PostingsReader.readVInt15(this.docIn);
                long blockLength = Lucene912PostingsReader.readVLong15(this.docIn);
                this.level0LastDocID += docDelta;
                this.level0DocEndFP = this.docIn.getFilePointer() + blockLength;
                int numImpactBytes = this.docIn.readVInt();
                this.docIn.readBytes(this.level0SerializedImpacts.bytes, 0, numImpactBytes);
                this.level0SerializedImpacts.length = numImpactBytes;
                this.docIn.seek(skip0End);
            } else {
                this.level0LastDocID = Integer.MAX_VALUE;
            }
            this.refillDocs();
            this.needsRefilling = false;
        }

        @Override
        public int nextDoc() throws IOException {
            if (this.docBufferUpto == 128) {
                if (this.needsRefilling) {
                    this.refillDocs();
                    this.needsRefilling = false;
                } else {
                    this.moveToNextLevel0Block();
                }
            }
            this.doc = (int)this.docBuffer[this.docBufferUpto++];
            return this.doc;
        }

        @Override
        public int advance(int target) throws IOException {
            if (target > this.level0LastDocID || this.needsRefilling) {
                this.advanceShallow(target);
                this.refillDocs();
                this.needsRefilling = false;
            }
            int next = Lucene912PostingsReader.findNextGEQ(this.docBuffer, target, this.docBufferUpto, this.docBufferSize);
            this.doc = (int)this.docBuffer[next];
            this.docBufferUpto = next + 1;
            return this.doc;
        }
    }

    final class BlockImpactsPostingsEnum
    extends BlockImpactsEnum {
        private final long[] posDeltaBuffer = new long[128];
        private int posBufferUpto;
        final IndexInput posIn;
        final boolean indexHasFreq;
        final boolean indexHasOffsets;
        final boolean indexHasPayloads;
        final boolean indexHasOffsetsOrPayloads;
        private final long totalTermFreq;
        private int freq;
        private int position;
        private long posPendingCount;
        private final long lastPosBlockFP;
        private long level0PosEndFP;
        private int level0BlockPosUpto;
        private long level1PosEndFP;
        private int level1BlockPosUpto;
        private final int singletonDocID;

        public BlockImpactsPostingsEnum(Lucene912PostingsReader this$0, FieldInfo fieldInfo, Lucene912PostingsFormat.IntBlockTermState termState) throws IOException {
            super(this$0, termState);
            IndexOptions options = fieldInfo.getIndexOptions();
            this.indexHasFreq = options.compareTo(IndexOptions.DOCS_AND_FREQS) >= 0;
            this.indexHasOffsets = options.compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
            this.indexHasPayloads = fieldInfo.hasPayloads();
            this.indexHasOffsetsOrPayloads = this.indexHasOffsets || this.indexHasPayloads;
            this.posIn = this$0.posIn.clone();
            long posTermStartFP = termState.posStartFP;
            this.totalTermFreq = termState.totalTermFreq;
            this.singletonDocID = termState.singletonDocID;
            this.posIn.seek(posTermStartFP);
            this.level1PosEndFP = posTermStartFP;
            this.level0PosEndFP = posTermStartFP;
            this.posPendingCount = 0L;
            this.lastPosBlockFP = termState.totalTermFreq < 128L ? posTermStartFP : (termState.totalTermFreq == 128L ? -1L : posTermStartFP + termState.lastPosBlockOffset);
            this.level1BlockPosUpto = 0;
            this.posBufferUpto = 128;
        }

        @Override
        public int freq() {
            return this.freq;
        }

        private void refillDocs() throws IOException {
            int left = this.docFreq - this.docCountUpto;
            assert (left >= 0);
            if (left >= 128) {
                this.forDeltaUtil.decodeAndPrefixSum(this.docIn, this.prevDocID, this.docBuffer);
                this.pforUtil.decode(this.docIn, this.freqBuffer);
                this.docCountUpto += 128;
            } else if (this.docFreq == 1) {
                this.docBuffer[0] = this.singletonDocID;
                this.freqBuffer[0] = this.totalTermFreq;
                this.docBuffer[1] = Integer.MAX_VALUE;
                ++this.docCountUpto;
            } else {
                PostingsUtil.readVIntBlock(this.docIn, this.docBuffer, this.freqBuffer, left, this.indexHasFreq, true);
                Lucene912PostingsReader.prefixSum(this.docBuffer, left, this.prevDocID);
                this.docBuffer[left] = Integer.MAX_VALUE;
                this.docCountUpto += left;
                this.docBufferSize = left;
            }
            this.prevDocID = this.docBuffer[127];
            this.docBufferUpto = 0;
            assert (this.docBuffer[this.docBufferSize] == Integer.MAX_VALUE);
        }

        private void skipLevel1To(int target) throws IOException {
            block5: {
                long skip1EndFP;
                do {
                    this.prevDocID = this.level1LastDocID;
                    this.level0LastDocID = this.level1LastDocID;
                    this.docIn.seek(this.level1DocEndFP);
                    this.level0PosEndFP = this.level1PosEndFP;
                    this.level0BlockPosUpto = this.level1BlockPosUpto;
                    this.docCountUpto = this.level1DocCountUpto;
                    this.level1DocCountUpto += 4096;
                    if (this.docFreq - this.docCountUpto < 4096) {
                        this.level1LastDocID = Integer.MAX_VALUE;
                        break block5;
                    }
                    this.level1LastDocID += this.docIn.readVInt();
                    this.level1DocEndFP = this.docIn.readVLong() + this.docIn.getFilePointer();
                    skip1EndFP = (long)this.docIn.readShort() + this.docIn.getFilePointer();
                    short numImpactBytes = this.docIn.readShort();
                    if (this.level1LastDocID >= target) {
                        this.docIn.readBytes(this.level1SerializedImpacts.bytes, 0, numImpactBytes);
                        this.level1SerializedImpacts.length = numImpactBytes;
                    } else {
                        this.docIn.skipBytes(numImpactBytes);
                    }
                    this.level1PosEndFP += this.docIn.readVLong();
                    this.level1BlockPosUpto = this.docIn.readByte();
                    assert (this.indexHasOffsetsOrPayloads || this.docIn.getFilePointer() == skip1EndFP);
                } while (this.level1LastDocID < target);
                this.docIn.seek(skip1EndFP);
            }
        }

        private void skipLevel0To(int target) throws IOException {
            block4: {
                while (true) {
                    this.prevDocID = this.level0LastDocID;
                    if (this.level0PosEndFP >= this.posIn.getFilePointer()) {
                        this.posIn.seek(this.level0PosEndFP);
                        this.posPendingCount = this.level0BlockPosUpto;
                        this.posBufferUpto = 128;
                    } else {
                        this.posPendingCount += Lucene912PostingsReader.sumOverRange(this.freqBuffer, this.docBufferUpto, 128);
                    }
                    if (this.docFreq - this.docCountUpto < 128) break;
                    this.docIn.readVLong();
                    int docDelta = Lucene912PostingsReader.readVInt15(this.docIn);
                    long blockLength = Lucene912PostingsReader.readVLong15(this.docIn);
                    this.level0DocEndFP = this.docIn.getFilePointer() + blockLength;
                    this.level0LastDocID += docDelta;
                    if (target <= this.level0LastDocID) {
                        int numImpactBytes = this.docIn.readVInt();
                        this.docIn.readBytes(this.level0SerializedImpacts.bytes, 0, numImpactBytes);
                        this.level0SerializedImpacts.length = numImpactBytes;
                        this.level0PosEndFP += this.docIn.readVLong();
                        this.level0BlockPosUpto = this.docIn.readByte();
                        if (!this.indexHasOffsetsOrPayloads) break block4;
                        this.docIn.readVLong();
                        this.docIn.readVInt();
                        break block4;
                    }
                    this.docIn.skipBytes(this.docIn.readVLong());
                    this.level0PosEndFP += this.docIn.readVLong();
                    this.level0BlockPosUpto = this.docIn.readVInt();
                    this.docIn.seek(this.level0DocEndFP);
                    this.docCountUpto += 128;
                }
                this.level0LastDocID = Integer.MAX_VALUE;
            }
        }

        @Override
        public void advanceShallow(int target) throws IOException {
            if (target > this.level0LastDocID) {
                if (target > this.level1LastDocID) {
                    this.skipLevel1To(target);
                } else if (this.needsRefilling) {
                    this.docIn.seek(this.level0DocEndFP);
                    this.docCountUpto += 128;
                }
                this.skipLevel0To(target);
                this.needsRefilling = true;
            }
        }

        @Override
        public int nextDoc() throws IOException {
            if (this.docBufferUpto == 128) {
                this.advanceShallow(this.doc + 1);
                assert (this.needsRefilling);
                this.refillDocs();
                this.needsRefilling = false;
            }
            this.doc = (int)this.docBuffer[this.docBufferUpto];
            this.freq = (int)this.freqBuffer[this.docBufferUpto];
            this.posPendingCount += (long)this.freq;
            ++this.docBufferUpto;
            this.position = 0;
            return this.doc;
        }

        @Override
        public int advance(int target) throws IOException {
            this.advanceShallow(target);
            if (this.needsRefilling) {
                this.refillDocs();
                this.needsRefilling = false;
            }
            int next = Lucene912PostingsReader.findNextGEQ(this.docBuffer, target, this.docBufferUpto, this.docBufferSize);
            this.posPendingCount += Lucene912PostingsReader.sumOverRange(this.freqBuffer, this.docBufferUpto, next + 1);
            this.freq = (int)this.freqBuffer[next];
            this.docBufferUpto = next + 1;
            this.position = 0;
            this.doc = (int)this.docBuffer[next];
            return this.doc;
        }

        private void skipPositions() throws IOException {
            long toSkip = this.posPendingCount - (long)this.freq;
            int leftInBlock = 128 - this.posBufferUpto;
            if (toSkip < (long)leftInBlock) {
                this.posBufferUpto = (int)((long)this.posBufferUpto + toSkip);
            } else {
                toSkip -= (long)leftInBlock;
                while (toSkip >= 128L) {
                    assert (this.posIn.getFilePointer() != this.lastPosBlockFP);
                    PForUtil.skip(this.posIn);
                    toSkip -= 128L;
                }
                this.refillPositions();
                this.posBufferUpto = (int)toSkip;
            }
            this.position = 0;
        }

        private void refillPositions() throws IOException {
            if (this.posIn.getFilePointer() == this.lastPosBlockFP) {
                int count = (int)(this.totalTermFreq % 128L);
                int payloadLength = 0;
                for (int i = 0; i < count; ++i) {
                    int deltaCode;
                    int code = this.posIn.readVInt();
                    if (this.indexHasPayloads) {
                        if ((code & 1) != 0) {
                            payloadLength = this.posIn.readVInt();
                        }
                        this.posDeltaBuffer[i] = code >>> 1;
                        if (payloadLength != 0) {
                            this.posIn.skipBytes(payloadLength);
                        }
                    } else {
                        this.posDeltaBuffer[i] = code;
                    }
                    if (!this.indexHasOffsets || ((deltaCode = this.posIn.readVInt()) & 1) == 0) continue;
                    this.posIn.readVInt();
                }
            } else {
                this.pforUtil.decode(this.posIn, this.posDeltaBuffer);
            }
        }

        @Override
        public int nextPosition() throws IOException {
            assert (this.posPendingCount > 0L);
            if (this.posPendingCount > (long)this.freq) {
                this.skipPositions();
                this.posPendingCount = this.freq;
            }
            if (this.posBufferUpto == 128) {
                this.refillPositions();
                this.posBufferUpto = 0;
            }
            this.position = (int)((long)this.position + this.posDeltaBuffer[this.posBufferUpto]);
            ++this.posBufferUpto;
            --this.posPendingCount;
            return this.position;
        }
    }

    static class MutableImpactList
    extends AbstractList<Impact>
    implements RandomAccess {
        int length;
        final Impact[] impacts;

        MutableImpactList(int capacity) {
            this.impacts = new Impact[capacity];
            for (int i = 0; i < capacity; ++i) {
                this.impacts[i] = new Impact(Integer.MAX_VALUE, 1L);
            }
        }

        @Override
        public Impact get(int index) {
            return this.impacts[index];
        }

        @Override
        public int size() {
            return this.length;
        }
    }

    private abstract class BlockImpactsEnum
    extends ImpactsEnum {
        protected final ForDeltaUtil forDeltaUtil = new ForDeltaUtil();
        protected final PForUtil pforUtil = new PForUtil();
        protected final long[] docBuffer = new long[129];
        protected final long[] freqBuffer = new long[128];
        protected final int docFreq;
        protected final IndexInput docIn;
        protected int docCountUpto;
        protected int doc = -1;
        protected long prevDocID = -1L;
        protected int docBufferSize = 128;
        protected int docBufferUpto = 128;
        protected boolean needsRefilling;
        protected int level0LastDocID = -1;
        protected long level0DocEndFP;
        protected final BytesRef level0SerializedImpacts;
        protected final MutableImpactList level0Impacts;
        protected int level1LastDocID;
        protected long level1DocEndFP;
        protected int level1DocCountUpto = 0;
        protected final BytesRef level1SerializedImpacts;
        protected final MutableImpactList level1Impacts;
        private final Impacts impacts = new Impacts(){
            private final ByteArrayDataInput scratch = new ByteArrayDataInput();

            @Override
            public int numLevels() {
                return BlockImpactsEnum.this.level1LastDocID == Integer.MAX_VALUE ? 1 : 2;
            }

            @Override
            public int getDocIdUpTo(int level) {
                if (level == 0) {
                    return BlockImpactsEnum.this.level0LastDocID;
                }
                return level == 1 ? BlockImpactsEnum.this.level1LastDocID : Integer.MAX_VALUE;
            }

            @Override
            public List<Impact> getImpacts(int level) {
                if (level == 0 && BlockImpactsEnum.this.level0LastDocID != Integer.MAX_VALUE) {
                    return this.readImpacts(BlockImpactsEnum.this.level0SerializedImpacts, BlockImpactsEnum.this.level0Impacts);
                }
                if (level == 1) {
                    return this.readImpacts(BlockImpactsEnum.this.level1SerializedImpacts, BlockImpactsEnum.this.level1Impacts);
                }
                return DUMMY_IMPACTS;
            }

            private List<Impact> readImpacts(BytesRef serialized, MutableImpactList impactsList) {
                ByteArrayDataInput scratch = this.scratch;
                scratch.reset(serialized.bytes, 0, serialized.length);
                Lucene912PostingsReader.readImpacts(scratch, impactsList);
                return impactsList;
            }
        };

        private BlockImpactsEnum(Lucene912PostingsReader lucene912PostingsReader, Lucene912PostingsFormat.IntBlockTermState termState) throws IOException {
            this.docFreq = termState.docFreq;
            this.docIn = lucene912PostingsReader.docIn.clone();
            Lucene912PostingsReader.prefetchPostings(this.docIn, termState);
            this.level0SerializedImpacts = new BytesRef(lucene912PostingsReader.maxImpactNumBytesAtLevel0);
            this.level1SerializedImpacts = new BytesRef(lucene912PostingsReader.maxImpactNumBytesAtLevel1);
            this.level0Impacts = new MutableImpactList(lucene912PostingsReader.maxNumImpactsAtLevel0);
            this.level1Impacts = new MutableImpactList(lucene912PostingsReader.maxNumImpactsAtLevel1);
            if (this.docFreq < 4096) {
                this.level1LastDocID = Integer.MAX_VALUE;
                if (this.docFreq > 1) {
                    this.docIn.seek(termState.docStartFP);
                }
            } else {
                this.level1LastDocID = -1;
                this.level1DocEndFP = termState.docStartFP;
            }
            this.docBuffer[128] = Integer.MAX_VALUE;
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public int startOffset() {
            return -1;
        }

        @Override
        public int endOffset() {
            return -1;
        }

        @Override
        public BytesRef getPayload() {
            return null;
        }

        @Override
        public long cost() {
            return this.docFreq;
        }

        @Override
        public Impacts getImpacts() {
            return this.impacts;
        }
    }

    private abstract class AbstractPostingsEnum
    extends PostingsEnum {
        protected ForDeltaUtil forDeltaUtil;
        protected PForUtil pforUtil;
        protected final long[] docBuffer = new long[129];
        protected final boolean indexHasFreq;
        protected int doc;
        protected int level0LastDocID;
        protected int level1LastDocID;
        protected long level1DocEndFP;
        protected int level1DocCountUpto;
        protected int docFreq;
        protected long totalTermFreq;
        protected int singletonDocID;
        protected int docCountUpto;
        protected long prevDocID;
        protected int docBufferSize;
        protected int docBufferUpto;
        protected IndexInput docIn;

        protected AbstractPostingsEnum(FieldInfo fieldInfo) {
            this.indexHasFreq = fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS) >= 0;
            this.docBuffer[128] = Integer.MAX_VALUE;
        }

        @Override
        public int docID() {
            return this.doc;
        }

        protected void resetIndexInput(Lucene912PostingsFormat.IntBlockTermState termState) throws IOException {
            this.docFreq = termState.docFreq;
            this.singletonDocID = termState.singletonDocID;
            if (this.docFreq > 1) {
                if (this.docIn == null) {
                    this.docIn = Lucene912PostingsReader.this.docIn.clone();
                }
                Lucene912PostingsReader.prefetchPostings(this.docIn, termState);
            }
        }

        protected PostingsEnum resetIdsAndLevelParams(Lucene912PostingsFormat.IntBlockTermState termState) throws IOException {
            this.doc = -1;
            this.prevDocID = -1L;
            this.docCountUpto = 0;
            this.level0LastDocID = -1;
            if (this.docFreq < 4096) {
                this.level1LastDocID = Integer.MAX_VALUE;
                if (this.docFreq > 1) {
                    this.docIn.seek(termState.docStartFP);
                }
            } else {
                this.level1LastDocID = -1;
                this.level1DocEndFP = termState.docStartFP;
            }
            this.level1DocCountUpto = 0;
            this.docBufferSize = 128;
            this.docBufferUpto = 128;
            return this;
        }
    }
}

