/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml.bind.gml;

import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.util.Date;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.sis.xml.bind.Context;
import org.apache.sis.xml.util.XmlUtilities;

public final class DateAdapter
extends XmlAdapter<XMLGregorianCalendar, Date> {
    @Override
    public Date unmarshal(XMLGregorianCalendar value) {
        return value != null ? XmlUtilities.toDate(Context.current(), value) : null;
    }

    @Override
    public XMLGregorianCalendar marshal(Date value) {
        if (value != null) {
            Context context2 = Context.current();
            try {
                XMLGregorianCalendar gc = XmlUtilities.toXML(context2, value);
                XmlUtilities.trimTime(gc, true);
                return gc;
            }
            catch (DatatypeConfigurationException e2) {
                Context.warningOccured(context2, XmlAdapter.class, "marshal", e2, true);
            }
        }
        return null;
    }
}

