/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.settings;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.juneau.commons.function.ResettableSupplier;
import org.apache.juneau.commons.settings.Settings;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.Utils;

public class Setting<T>
extends ResettableSupplier<T> {
    private final Settings settings;

    public Setting(Settings settings, Supplier<T> supplier) {
        super(AssertionUtils.assertArgNotNull("supplier", supplier));
        this.settings = AssertionUtils.assertArgNotNull("settings", settings);
    }

    public Settings getSettings() {
        return this.settings;
    }

    public Optional<T> asOptional() {
        return Utils.opt(this.get());
    }

    @Override
    public <U> Setting<U> map(Function<? super T, ? extends U> mapper) {
        AssertionUtils.assertArgNotNull("mapper", mapper);
        return new Setting<Object>(this.settings, () -> {
            Object value = this.get();
            return Utils.nn(value) ? mapper.apply((T)value) : null;
        });
    }

    @Override
    public Setting<T> filter(Predicate<? super T> predicate) {
        AssertionUtils.assertArgNotNull("predicate", predicate);
        return new Setting<Object>(this.settings, () -> {
            Object value = this.get();
            return Utils.nn(value) && predicate.test((T)value) ? value : null;
        });
    }
}

