/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.swaps;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.commons.utils.DateUtils;
import org.apache.juneau.swap.StringSwap;
import org.apache.juneau.swaps.DefaultingTemporalAccessor;

public class TemporalCalendarSwap
extends StringSwap<Calendar> {
    private final DateTimeFormatter formatter;

    public TemporalCalendarSwap(String pattern) {
        super(Calendar.class);
        this.formatter = DateUtils.getDateTimeFormatter(pattern);
    }

    @Override
    public String swap(BeanSession session, Calendar o) throws Exception {
        if (o == null) {
            return null;
        }
        ZonedDateTime t = o instanceof GregorianCalendar ? ((GregorianCalendar)o).toZonedDateTime() : o.toInstant().atZone(session.getTimeZoneId());
        return this.formatter.format(t);
    }

    @Override
    public Calendar unswap(BeanSession session, String f, ClassMeta<?> hint) throws Exception {
        if (f == null) {
            return null;
        }
        ZoneId offset = session.getTimeZoneId();
        DefaultingTemporalAccessor ta = new DefaultingTemporalAccessor(this.formatter.parse(f), offset);
        return GregorianCalendar.from(ZonedDateTime.from(ta));
    }

    public static class Rfc1123DateTime
    extends TemporalCalendarSwap {
        public static final TemporalCalendarSwap DEFAULT = new Rfc1123DateTime();

        public Rfc1123DateTime() {
            super("RFC_1123_DATE_TIME");
        }
    }

    public static class IsoZonedDateTime
    extends TemporalCalendarSwap {
        public static final TemporalCalendarSwap DEFAULT = new IsoZonedDateTime();

        public IsoZonedDateTime() {
            super("ISO_ZONED_DATE_TIME");
        }
    }

    public static class IsoWeekDate
    extends TemporalCalendarSwap {
        public static final TemporalCalendarSwap DEFAULT = new IsoWeekDate();

        public IsoWeekDate() {
            super("ISO_WEEK_DATE");
        }
    }

    public static class IsoTime
    extends TemporalCalendarSwap {
        public static final TemporalCalendarSwap DEFAULT = new IsoTime();

        public IsoTime() {
            super("ISO_TIME");
        }
    }

    public static class IsoOrdinalDate
    extends TemporalCalendarSwap {
        public static final TemporalCalendarSwap DEFAULT = new IsoOrdinalDate();

        public IsoOrdinalDate() {
            super("ISO_ORDINAL_DATE");
        }
    }

    public static class IsoOffsetTime
    extends TemporalCalendarSwap {
        public static final TemporalCalendarSwap DEFAULT = new IsoOffsetTime();

        public IsoOffsetTime() {
            super("ISO_OFFSET_TIME");
        }
    }

    public static class IsoOffsetDateTime
    extends TemporalCalendarSwap {
        public static final TemporalCalendarSwap DEFAULT = new IsoOffsetDateTime();

        public IsoOffsetDateTime() {
            super("ISO_OFFSET_DATE_TIME");
        }
    }

    public static class IsoOffsetDate
    extends TemporalCalendarSwap {
        public static final TemporalCalendarSwap DEFAULT = new IsoOffsetDate();

        public IsoOffsetDate() {
            super("ISO_OFFSET_DATE");
        }
    }

    public static class IsoLocalTime
    extends TemporalCalendarSwap {
        public static final TemporalCalendarSwap DEFAULT = new IsoLocalTime();

        public IsoLocalTime() {
            super("ISO_LOCAL_TIME");
        }
    }

    public static class IsoLocalDateTime
    extends TemporalCalendarSwap {
        public static final TemporalCalendarSwap DEFAULT = new IsoLocalDateTime();

        public IsoLocalDateTime() {
            super("ISO_LOCAL_DATE_TIME");
        }
    }

    public static class IsoLocalDate
    extends TemporalCalendarSwap {
        public static final TemporalCalendarSwap DEFAULT = new IsoLocalDate();

        public IsoLocalDate() {
            super("ISO_LOCAL_DATE");
        }
    }

    public static class IsoInstant
    extends TemporalCalendarSwap {
        public static final TemporalCalendarSwap DEFAULT = new IsoInstant();

        public IsoInstant() {
            super("ISO_INSTANT");
        }
    }

    public static class IsoDateTime
    extends TemporalCalendarSwap {
        public static final TemporalCalendarSwap DEFAULT = new IsoDateTime();

        public IsoDateTime() {
            super("ISO_DATE_TIME");
        }
    }

    public static class IsoDate
    extends TemporalCalendarSwap {
        public static final TemporalCalendarSwap DEFAULT = new IsoDate();

        public IsoDate() {
            super("ISO_DATE");
        }
    }

    public static class BasicIsoDate
    extends TemporalCalendarSwap {
        public static final TemporalCalendarSwap DEFAULT = new BasicIsoDate();

        public BasicIsoDate() {
            super("BASIC_ISO_DATE");
        }
    }
}

