/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.arg;

import java.lang.reflect.Type;
import org.apache.juneau.AnnotationWorkList;
import org.apache.juneau.commons.reflect.AnnotationProvider;
import org.apache.juneau.commons.reflect.AnnotationTraversal;
import org.apache.juneau.commons.reflect.ParameterInfo;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.http.annotation.PathRemainder;
import org.apache.juneau.http.annotation.PathRemainderAnnotation;
import org.apache.juneau.httppart.HttpPartParser;
import org.apache.juneau.httppart.HttpPartParserSession;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.rest.RestOpSession;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.arg.RestOpArg;
import org.apache.juneau.rest.util.UrlPathMatcher;

public class PathRemainderArg
implements RestOpArg {
    private static final AnnotationProvider AP = AnnotationProvider.INSTANCE;
    private final HttpPartParser partParser;
    private final HttpPartSchema schema;
    private final String def;
    private final Type type;

    public static PathRemainderArg create(ParameterInfo paramInfo, AnnotationWorkList annotations, UrlPathMatcher pathMatcher) {
        if (AP.has(PathRemainder.class, paramInfo, new AnnotationTraversal[0])) {
            return new PathRemainderArg(paramInfo, annotations);
        }
        return null;
    }

    protected PathRemainderArg(ParameterInfo paramInfo, AnnotationWorkList annotations) {
        this.def = PathRemainderAnnotation.findDef(paramInfo).orElse(null);
        this.type = paramInfo.getParameterType().innerType();
        this.schema = HttpPartSchema.create(PathRemainder.class, paramInfo);
        Class<? extends HttpPartParser> pp = this.schema.getParser();
        this.partParser = Utils.nn(pp) ? (HttpPartParser)HttpPartParser.creator().type((Class)pp).apply(annotations).create() : null;
    }

    @Override
    public Object resolve(RestOpSession opSession) throws Exception {
        RestRequest req = opSession.getRequest();
        HttpPartParserSession ps = this.partParser == null ? req.getPartParserSession() : this.partParser.getPartSession();
        return req.getPathParams().get("/*").parser(ps).schema(this.schema).def(this.def).as(this.type, new Type[0]).orElse(null);
    }
}

