/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.lang;

import org.apache.juneau.commons.lang.Value;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.Utils;

public class ShortValue
extends Value<Short> {
    public static ShortValue create() {
        return ShortValue.of((short)0);
    }

    public static ShortValue of(Short value) {
        return new ShortValue(value);
    }

    public ShortValue(Short value) {
        super(value);
    }

    public ShortValue add(Short x) {
        Short v = (Short)this.get();
        this.set((short)((v == null ? (short)0 : v) + (x == null ? (short)0 : x)));
        return this;
    }

    public Short addAndGet(Short x) {
        Short v = (Short)this.get();
        short result = (short)((v == null ? (short)0 : v) + (x == null ? (short)0 : x));
        this.set(result);
        return result;
    }

    public ShortValue decrement() {
        Short v = (Short)this.get();
        this.set((short)((v == null ? (short)0 : v) - 1));
        return this;
    }

    public Short decrementAndGet() {
        Short v = (Short)this.get();
        short result = (short)((v == null ? (short)0 : v) - 1);
        this.set(result);
        return result;
    }

    public short getAndIncrement() {
        Short v = (Short)this.get();
        this.set(v == null ? (short)1 : (short)(v + 1));
        return v == null ? (short)0 : v;
    }

    public ShortValue increment() {
        Short v = (Short)this.get();
        this.set((short)((v == null ? (short)0 : v) + 1));
        return this;
    }

    public Short incrementAndGet() {
        Short v = (Short)this.get();
        short result = (short)((v == null ? (short)0 : v) + 1);
        this.set(result);
        return result;
    }

    @Override
    public boolean is(Short value) {
        return Utils.eq((Short)this.get(), value);
    }

    public boolean isAny(Short ... values) {
        AssertionUtils.assertArgNotNull("values", values);
        Short current = (Short)this.get();
        for (Short value : values) {
            if (!Utils.eq(current, value)) continue;
            return true;
        }
        return false;
    }
}

