/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.kafka.streams.errors.internals;

import org.apache.kafka.streams.errors.StreamsException;

/**
 * {@link FailedProcessingException} is the top-level exception type generated by Kafka Streams, and indicates errors have
 * occurred during a {@link org.apache.kafka.streams.processor.internals.ProcessorNode ProcessorNode's} processing.
 */
public class FailedProcessingException extends StreamsException {
    private static final long serialVersionUID = 1L;

    public FailedProcessingException(final String errorMessage, final Exception exception) {
        super(errorMessage, exception);
    }

    public FailedProcessingException(final Exception exception) {
        // we need to explicitly set `message` to `null` here
        super(null, exception);
    }
}
