/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.util.Date;
import kafka.common.LogCleaningAbortedException;
import kafka.log.CleanedTransactionMetadata;
import kafka.log.Cleaner$;
import kafka.log.CleanerStats;
import kafka.log.LocalLog$;
import kafka.log.LogCleaner;
import kafka.log.LogToClean;
import kafka.log.UnifiedLog;
import kafka.utils.Logging;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.CloseableIterator;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.storage.internals.log.AbortedTxn;
import org.apache.kafka.storage.internals.log.LastRecord;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogSegment;
import org.apache.kafka.storage.internals.log.LogSegmentOffsetOverflowException;
import org.apache.kafka.storage.internals.log.OffsetMap;
import org.apache.kafka.storage.internals.log.TransactionIndex;
import org.apache.kafka.storage.internals.utils.Throttler;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\tue!\u0002\u0012$\u0001\r:\u0003\u0002\u0003\u001b\u0001\u0005\u000b\u0007I\u0011\u0001\u001c\t\u0011i\u0002!\u0011!Q\u0001\n]B\u0001b\u000f\u0001\u0003\u0006\u0004%\t\u0001\u0010\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005{!AA\n\u0001B\u0001B\u0003%q\u0007\u0003\u0005N\u0001\t\u0005\t\u0015!\u00038\u0011!q\u0005A!A!\u0002\u0013y\u0005\u0002\u0003*\u0001\u0005\u0003\u0005\u000b\u0011B*\t\u0011a\u0003!\u0011!Q\u0001\neC\u0001\u0002\u0019\u0001\u0003\u0002\u0003\u0006I!\u0019\u0005\u0006W\u0002!\t\u0001\u001c\u0005\u0006o\u0002!\t\u0006\u001f\u0005\n\u0003\u0013\u0001\u0001\u0019!C\u0005\u0003\u0017A\u0011\"!\b\u0001\u0001\u0004%I!a\b\t\u0011\u0005\u0015\u0002\u0001)Q\u0005\u0003\u001bA\u0011\"a\n\u0001\u0001\u0004%I!a\u0003\t\u0013\u0005%\u0002\u00011A\u0005\n\u0005-\u0002\u0002CA\u0018\u0001\u0001\u0006K!!\u0004\t\u0013\u0005E\u0002A1A\u0005\n\u0005M\u0002\u0002CA\u001e\u0001\u0001\u0006I!!\u000e\t\u0011\u0005u\u0002\u0001\"\u0001$\u0003\u007fA\u0001\"!\u0018\u0001\t\u0003\u0019\u0013q\f\u0005\t\u0003O\u0002A\u0011A\u0012\u0002j!A\u0011Q\u0015\u0001\u0005\u0002\r\n9\u000bC\u0004\u0002t\u0002!I!!>\t\u000f\t%\u0001\u0001\"\u0003\u0003\f!9!\u0011\u0004\u0001\u0005\n\tm\u0001b\u0002B\u0019\u0001\u0011%!1\u0007\u0005\b\u0005o\u0001A\u0011\u0002B\u001d\u0011!\u0011Y\u0004\u0001C\u0001G\tu\u0002b\u0002B3\u0001\u0011%!q\r\u0005\t\u0005c\u0002A\u0011A\u0012\u0003t!9!1\u0011\u0001\u0005\n\t\u0015%aB\"mK\u0006tWM\u001d\u0006\u0003I\u0015\n1\u0001\\8h\u0015\u00051\u0013!B6bM.\f7c\u0001\u0001)]A\u0011\u0011\u0006L\u0007\u0002U)\t1&A\u0003tG\u0006d\u0017-\u0003\u0002.U\t1\u0011I\\=SK\u001a\u0004\"a\f\u001a\u000e\u0003AR!!M\u0013\u0002\u000bU$\u0018\u000e\\:\n\u0005M\u0002$a\u0002'pO\u001eLgnZ\u0001\u0003S\u0012\u001c\u0001!F\u00018!\tI\u0003(\u0003\u0002:U\t\u0019\u0011J\u001c;\u0002\u0007%$\u0007%A\u0005pM\u001a\u001cX\r^'baV\tQ\b\u0005\u0002?\u00136\tqH\u0003\u0002%\u0001*\u0011\u0011IQ\u0001\nS:$XM\u001d8bYNT!a\u0011#\u0002\u000fM$xN]1hK*\u0011a%\u0012\u0006\u0003\r\u001e\u000ba!\u00199bG\",'\"\u0001%\u0002\u0007=\u0014x-\u0003\u0002K\u007f\tIqJ\u001a4tKRl\u0015\r]\u0001\u000b_\u001a47/\u001a;NCB\u0004\u0013\u0001D5p\u0005V4g-\u001a:TSj,\u0017aD7bq&{')\u001e4gKJ\u001c\u0016N_3\u0002'\u0011,\bOQ;gM\u0016\u0014Hj\\1e\r\u0006\u001cGo\u001c:\u0011\u0005%\u0002\u0016BA)+\u0005\u0019!u.\u001e2mK\u0006IA\u000f\u001b:piRdWM\u001d\t\u0003)Zk\u0011!\u0016\u0006\u0003c\u0001K!aV+\u0003\u0013QC'o\u001c;uY\u0016\u0014\u0018\u0001\u0002;j[\u0016\u0004\"A\u00170\u000e\u0003mS!!\r/\u000b\u0005u#\u0015AB2p[6|g.\u0003\u0002`7\n!A+[7f\u0003%\u0019\u0007.Z2l\t>tW\r\u0005\u0003*E\u0012D\u0017BA2+\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0002fM6\tA,\u0003\u0002h9\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007CA\u0015j\u0013\tQ'F\u0001\u0003V]&$\u0018A\u0002\u001fj]&$h\bF\u0005n_B\f(o\u001d;vmB\u0011a\u000eA\u0007\u0002G!)Ag\u0003a\u0001o!)1h\u0003a\u0001{!)Aj\u0003a\u0001o!)Qj\u0003a\u0001o!)aj\u0003a\u0001\u001f\")!k\u0003a\u0001'\")\u0001l\u0003a\u00013\")\u0001m\u0003a\u0001C\u0006QAn\\4hKJt\u0015-\\3\u0016\u0003e\u00042A_A\u0002\u001d\tYx\u0010\u0005\u0002}U5\tQP\u0003\u0002\u007fk\u00051AH]8pizJ1!!\u0001+\u0003\u0019\u0001&/\u001a3fM&!\u0011QAA\u0004\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011\u0001\u0016\u0002\u0015I,\u0017\r\u001a\"vM\u001a,'/\u0006\u0002\u0002\u000eA!\u0011qBA\r\u001b\t\t\tB\u0003\u0003\u0002\u0014\u0005U\u0011a\u00018j_*\u0011\u0011qC\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u001c\u0005E!A\u0003\"zi\u0016\u0014UO\u001a4fe\u0006q!/Z1e\u0005V4g-\u001a:`I\u0015\fHc\u00015\u0002\"!I\u00111\u0005\b\u0002\u0002\u0003\u0007\u0011QB\u0001\u0004q\u0012\n\u0014a\u0003:fC\u0012\u0014UO\u001a4fe\u0002\n1b\u001e:ji\u0016\u0014UO\u001a4fe\u0006yqO]5uK\n+hMZ3s?\u0012*\u0017\u000fF\u0002i\u0003[A\u0011\"a\t\u0012\u0003\u0003\u0005\r!!\u0004\u0002\u0019]\u0014\u0018\u000e^3Ck\u001a4WM\u001d\u0011\u00027\u0011,7m\\7qe\u0016\u001c8/[8o\u0005V4g-\u001a:TkB\u0004H.[3s+\t\t)\u0004E\u0002[\u0003oI1!!\u000f\\\u00059\u0011UO\u001a4feN+\b\u000f\u001d7jKJ\fA\u0004Z3d_6\u0004(/Z:tS>t')\u001e4gKJ\u001cV\u000f\u001d9mS\u0016\u0014\b%A\u0003dY\u0016\fg\u000e\u0006\u0003\u0002B\u0005M\u0003cB\u0015\u0002D\u0005\u001d\u0013QJ\u0005\u0004\u0003\u000bR#A\u0002+va2,'\u0007E\u0002*\u0003\u0013J1!a\u0013+\u0005\u0011auN\\4\u0011\u00079\fy%C\u0002\u0002R\r\u0012Ab\u00117fC:,'o\u0015;biNDq!!\u0016\u0016\u0001\u0004\t9&A\u0005dY\u0016\fg.\u00192mKB\u0019a.!\u0017\n\u0007\u0005m3E\u0001\u0006M_\u001e$vn\u00117fC:\fq\u0001Z8DY\u0016\fg\u000e\u0006\u0004\u0002B\u0005\u0005\u00141\r\u0005\b\u0003+2\u0002\u0019AA,\u0011\u001d\t)G\u0006a\u0001\u0003\u000f\n1bY;se\u0016tG\u000fV5nK\u0006i1\r\\3b]N+w-\\3oiN$\u0012\u0003[A6\u0003g\nI)!$\u0002\u0010\u0006M\u0015QTAQ\u0011\u0019!s\u00031\u0001\u0002nA\u0019a.a\u001c\n\u0007\u0005E4E\u0001\u0006V]&4\u0017.\u001a3M_\u001eDq!!\u001e\u0018\u0001\u0004\t9(\u0001\u0005tK\u001elWM\u001c;t!\u0019\tI(a \u0002\u00046\u0011\u00111\u0010\u0006\u0004\u0003{R\u0013AC2pY2,7\r^5p]&!\u0011\u0011QA>\u0005\r\u0019V-\u001d\t\u0004}\u0005\u0015\u0015bAAD\u007f\tQAj\\4TK\u001elWM\u001c;\t\r\u0005-u\u00031\u0001>\u0003\ri\u0017\r\u001d\u0005\b\u0003K:\u0002\u0019AA$\u0011\u001d\t\tj\u0006a\u0001\u0003\u001b\nQa\u001d;biNDq!!&\u0018\u0001\u0004\t9*A\nue\u0006t7/Y2uS>tW*\u001a;bI\u0006$\u0018\rE\u0002o\u00033K1!a'$\u0005i\u0019E.Z1oK\u0012$&/\u00198tC\u000e$\u0018n\u001c8NKR\fG-\u0019;b\u0011\u001d\tyj\u0006a\u0001\u0003\u000f\nQ\u0003\\3hC\u000eLH)\u001a7fi\u0016DuN]5{_:l5\u000fC\u0004\u0002$^\u0001\r!a\u0012\u0002?U\u0004\b/\u001a:C_VtGm\u00144gg\u0016$xJZ\"mK\u0006t\u0017N\\4S_VtG-A\u0005dY\u0016\fg.\u00138u_RI\u0002.!+\u0002.\u0006u\u0016\u0011YAb\u0003\u001b\f\t.!6\u0002X\u00065\u0018q^Ay\u0011\u0019\tY\u000b\u0007a\u0001I\u0006qAo\u001c9jGB\u000b'\u000f^5uS>t\u0007bBAX1\u0001\u0007\u0011\u0011W\u0001\u000eg>,(oY3SK\u000e|'\u000fZ:\u0011\t\u0005M\u0016\u0011X\u0007\u0003\u0003kS1!a.]\u0003\u0019\u0011XmY8sI&!\u00111XA[\u0005-1\u0015\u000e\\3SK\u000e|'\u000fZ:\t\u000f\u0005}\u0006\u00041\u0001\u0002\u0004\u0006!A-Z:u\u0011\u0019\tY\t\u0007a\u0001{!9\u0011Q\u0019\rA\u0002\u0005\u001d\u0017\u0001\t:fi\u0006Lg\u000eT3hC\u000eLH)\u001a7fi\u0016\u001c\u0018I\u001c3Uq:l\u0015M]6feN\u00042!KAe\u0013\r\tYM\u000b\u0002\b\u0005>|G.Z1o\u0011\u001d\ty\r\u0007a\u0001\u0003\u000f\n\u0011\u0003Z3mKR,'+\u001a;f]RLwN\\'t\u0011\u0019\t\u0019\u000e\u0007a\u0001o\u0005\tR.\u0019=M_\u001elUm]:bO\u0016\u001c\u0016N_3\t\u000f\u0005U\u0005\u00041\u0001\u0002\u0018\"9\u0011\u0011\u001c\rA\u0002\u0005m\u0017\u0001\b7bgR\u0014VmY8sIN|e-Q2uSZ,\u0007K]8ek\u000e,'o\u001d\t\t\u0003;\f\u0019/a\u0012\u0002h6\u0011\u0011q\u001c\u0006\u0005\u0003C\fY(A\u0004nkR\f'\r\\3\n\t\u0005\u0015\u0018q\u001c\u0002\u0004\u001b\u0006\u0004\bc\u0001 \u0002j&\u0019\u00111^ \u0003\u00151\u000b7\u000f\u001e*fG>\u0014H\rC\u0004\u0002$b\u0001\r!a\u0012\t\u000f\u0005E\u0005\u00041\u0001\u0002N!9\u0011Q\r\rA\u0002\u0005\u001d\u0013!E4s_^\u0014UO\u001a4feN|%OR1jYRI\u0001.a>\u0002z\u0006u\u0018q \u0005\b\u0003_K\u0002\u0019AAY\u0011\u0019\tY0\u0007a\u0001o\u0005A\u0001o\\:ji&|g\u000e\u0003\u0004\u0002Tf\u0001\ra\u000e\u0005\b\u0005\u0003I\u0002\u0019\u0001B\u0002\u00035iW-\\8ssJ+7m\u001c:egB!\u00111\u0017B\u0003\u0013\u0011\u00119!!.\u0003\u001b5+Wn\u001c:z%\u0016\u001cwN\u001d3t\u0003I\u0019\bn\\;mI\u0012K7oY1sI\n\u000bGo\u00195\u0015\r\u0005\u001d'Q\u0002B\f\u0011\u001d\u0011yA\u0007a\u0001\u0005#\tQAY1uG\"\u0004B!a-\u0003\u0014%!!QCA[\u0005-\u0011VmY8sI\n\u000bGo\u00195\t\u000f\u0005U%\u00041\u0001\u0002\u0018\u0006\u00112\u000f[8vY\u0012\u0014V\r^1j]J+7m\u001c:e)9\t9M!\b\u0003 \t\r\"Q\u0005B\u0017\u0005_Aa!a#\u001c\u0001\u0004i\u0004b\u0002B\u00117\u0001\u0007\u0011qY\u0001\u001ee\u0016$\u0018-\u001b8EK2,G/Z:G_JdUmZ1dsJ+7m\u001c:eg\"9!qB\u000eA\u0002\tE\u0001bBA\\7\u0001\u0007!q\u0005\t\u0005\u0003g\u0013I#\u0003\u0003\u0003,\u0005U&A\u0002*fG>\u0014H\rC\u0004\u0002\u0012n\u0001\r!!\u0014\t\u000f\u0005\u00154\u00041\u0001\u0002H\u0005YqM]8x\u0005V4g-\u001a:t)\rA'Q\u0007\u0005\u0007\u0003'd\u0002\u0019A\u001c\u0002\u001dI,7\u000f^8sK\n+hMZ3sgR\t\u0001.A\nhe>,\boU3h[\u0016tGo\u001d\"z'&TX\r\u0006\u0006\u0003@\tE#\u0011\fB/\u0005C\u0002bA!\u0011\u0003L\u0005]d\u0002\u0002B\"\u0005\u000fr1\u0001 B#\u0013\u0005Y\u0013b\u0001B%U\u00059\u0001/Y2lC\u001e,\u0017\u0002\u0002B'\u0005\u001f\u0012A\u0001T5ti*\u0019!\u0011\n\u0016\t\u000f\u0005Ud\u00041\u0001\u0003TA1\u0011\u0011\u0010B+\u0003\u0007KAAa\u0016\u0002|\tA\u0011\n^3sC\ndW\r\u0003\u0004\u0003\\y\u0001\raN\u0001\b[\u0006D8+\u001b>f\u0011\u0019\u0011yF\ba\u0001o\u0005aQ.\u0019=J]\u0012,\u0007pU5{K\"9!1\r\u0010A\u0002\u0005\u001d\u0013A\u00064jeN$XK\\2mK\u0006t\u0017M\u00197f\u001f\u001a47/\u001a;\u000231\f7\u000f^(gMN,GOR8s\r&\u00148\u000f^*fO6,g\u000e\u001e\u000b\u0007\u0003\u000f\u0012IGa\u001c\t\u000f\t-t\u00041\u0001\u0003n\u0005!1/Z4t!\u0019\u0011\tEa\u0013\u0002\u0004\"9!1M\u0010A\u0002\u0005\u001d\u0013A\u00042vS2$wJ\u001a4tKRl\u0015\r\u001d\u000b\fQ\nU$q\u000fB>\u0005\u007f\u0012\t\t\u0003\u0004%A\u0001\u0007\u0011Q\u000e\u0005\b\u0005s\u0002\u0003\u0019AA$\u0003\u0015\u0019H/\u0019:u\u0011\u001d\u0011i\b\ta\u0001\u0003\u000f\n1!\u001a8e\u0011\u0019\tY\t\ta\u0001{!9\u0011\u0011\u0013\u0011A\u0002\u00055\u0013\u0001\u00072vS2$wJ\u001a4tKRl\u0015\r\u001d$peN+w-\\3oiR\u0011\u0012q\u0019BD\u0005\u0013\u0013iIa$\u0003\u0014\n]%\u0011\u0014BN\u0011\u0019\tY+\ta\u0001I\"9!1R\u0011A\u0002\u0005\r\u0015aB:fO6,g\u000e\u001e\u0005\u0007\u0003\u0017\u000b\u0003\u0019A\u001f\t\u000f\tE\u0015\u00051\u0001\u0002H\u0005Y1\u000f^1si>3gm]3u\u0011\u001d\u0011)*\ta\u0001\u0003\u000f\naC\\3yiN+w-\\3oiN#\u0018M\u001d;PM\u001a\u001cX\r\u001e\u0005\u0007\u0003'\f\u0003\u0019A\u001c\t\u000f\u0005U\u0015\u00051\u0001\u0002\u0018\"9\u0011\u0011S\u0011A\u0002\u00055\u0003")
public class Cleaner
implements Logging {
    private final int id;
    private final OffsetMap offsetMap;
    private final int ioBufferSize;
    private final int maxIoBufferSize;
    private final double dupBufferLoadFactor;
    private final Throttler throttler;
    private final Time time;
    private final Function1<TopicPartition, BoxedUnit> checkDone;
    private ByteBuffer readBuffer;
    private ByteBuffer writeBuffer;
    private final BufferSupplier decompressionBufferSupplier;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int id() {
        return this.id;
    }

    public OffsetMap offsetMap() {
        return this.offsetMap;
    }

    @Override
    public String loggerName() {
        return LogCleaner.class.getName();
    }

    private ByteBuffer readBuffer() {
        return this.readBuffer;
    }

    private void readBuffer_$eq(ByteBuffer x$1) {
        this.readBuffer = x$1;
    }

    private ByteBuffer writeBuffer() {
        return this.writeBuffer;
    }

    private void writeBuffer_$eq(ByteBuffer x$1) {
        this.writeBuffer = x$1;
    }

    private BufferSupplier decompressionBufferSupplier() {
        return this.decompressionBufferSupplier;
    }

    public Tuple2<Object, CleanerStats> clean(LogToClean cleanable) {
        return this.doClean(cleanable, this.time.milliseconds());
    }

    public Tuple2<Object, CleanerStats> doClean(LogToClean cleanable, long currentTime) {
        long l;
        this.info((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Beginning cleaning of log %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{cleanable.log().name()})));
        Option option = cleanable.log().logSegments(0L, cleanable.firstDirtyOffset()).lastOption();
        if (None$.MODULE$.equals(option)) {
            l = 0L;
        } else if (option instanceof Some) {
            l = ((LogSegment)((Some)option).value()).lastModified() - cleanable.log().config().deleteRetentionMs;
        } else {
            throw new MatchError((Object)option);
        }
        long legacyDeleteHorizonMs = l;
        UnifiedLog log = cleanable.log();
        CleanerStats stats = new CleanerStats(Time.SYSTEM);
        this.info((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Building offset map for %s..."), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{cleanable.log().name()})));
        long upperBoundOffset = cleanable.firstUncleanableOffset();
        this.buildOffsetMap(log, cleanable.firstDirtyOffset(), upperBoundOffset, this.offsetMap(), stats);
        long endOffset = this.offsetMap().latestOffset() + 1L;
        stats.indexDone();
        long cleanableHorizonMs = BoxesRunTime.unboxToLong((Object)log.logSegments(0L, cleanable.firstUncleanableOffset()).lastOption().map((Function1 & Serializable)x$12 -> BoxesRunTime.boxToLong((long)x$12.lastModified())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
        this.info((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Cleaning log %s (cleaning prior to %s, discarding tombstones prior to upper bound deletion horizon %s)..."), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{log.name(), new Date(cleanableHorizonMs), new Date(legacyDeleteHorizonMs)})));
        CleanedTransactionMetadata transactionMetadata = new CleanedTransactionMetadata();
        this.groupSegmentsBySize(log.logSegments(0L, endOffset), log.config().segmentSize, log.config().maxIndexSize, cleanable.firstUncleanableOffset()).foreach((Function1 & Serializable)group -> {
            this.cleanSegments(log, (Seq<LogSegment>)group, this.offsetMap(), currentTime, stats, transactionMetadata, legacyDeleteHorizonMs, upperBoundOffset);
            return BoxedUnit.UNIT;
        });
        stats.bufferUtilization_$eq(this.offsetMap().utilization());
        stats.allDone();
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)endOffset), (Object)stats);
    }

    /*
     * WARNING - void declaration
     */
    public void cleanSegments(UnifiedLog log, Seq<LogSegment> segments, OffsetMap map, long currentTime, CleanerStats stats, CleanedTransactionMetadata transactionMetadata, long legacyDeleteHorizonMs, long upperBoundOffsetOfCleaningRound) {
        void createNewCleanedSegment_baseOffset;
        void createNewCleanedSegment_logConfig;
        long l = ((LogSegment)segments.head()).baseOffset();
        LogConfig logConfig = log.config();
        File createNewCleanedSegment_dir = log.dir();
        Object var29_11 = null;
        logConfig = null;
        LogSegment cleaned = LocalLog$.MODULE$.createNewCleanedSegment(createNewCleanedSegment_dir, (LogConfig)createNewCleanedSegment_logConfig, (long)createNewCleanedSegment_baseOffset);
        transactionMetadata.cleanedIndex_$eq((Option<TransactionIndex>)new Some((Object)cleaned.txnIndex()));
        try {
            Iterator iter = segments.iterator();
            Some currentSegmentOpt = new Some(iter.next());
            Map<Object, LastRecord> lastOffsetOfActiveProducers = log.lastRecordsOfActiveProducers();
            while (currentSegmentOpt.isDefined()) {
                LogSegment currentSegment = (LogSegment)currentSegmentOpt.get();
                None$ nextSegmentOpt = iter.hasNext() ? new Some(iter.next()) : None$.MODULE$;
                long startOffset = currentSegment.baseOffset();
                long upperBoundOffset = BoxesRunTime.unboxToLong((Object)nextSegmentOpt.map((Function1 & Serializable)x$13 -> BoxesRunTime.boxToLong((long)x$13.baseOffset())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> currentSegment.readNextOffset()));
                List<AbortedTxn> abortedTransactions = log.collectAbortedTransactions(startOffset, upperBoundOffset);
                transactionMetadata.addAbortedTransactions(abortedTransactions);
                boolean retainLegacyDeletesAndTxnMarkers = currentSegment.lastModified() > legacyDeleteHorizonMs;
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(120).append("Cleaning ").append(currentSegment).append(" in log ").append(log.name()).append(" into ").append(cleaned.baseOffset()).append(" ").append("with an upper bound deletion horizon ").append(legacyDeleteHorizonMs).append(" computed from ").append("the segment last modified time of ").append(currentSegment.lastModified()).append(",").append((Object)(retainLegacyDeletesAndTxnMarkers ? "retaining" : "discarding")).append(" deletes.").toString());
                try {
                    this.cleanInto(log.topicPartition(), currentSegment.log(), cleaned, map, retainLegacyDeletesAndTxnMarkers, log.config().deleteRetentionMs, log.config().maxMessageSize(), transactionMetadata, lastOffsetOfActiveProducers, upperBoundOffsetOfCleaningRound, stats, currentTime);
                }
                catch (LogSegmentOffsetOverflowException e) {
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(47).append("Caught segment overflow error during cleaning: ").append(e.getMessage()).toString());
                    log.splitOverflowedSegment(currentSegment);
                    throw new LogCleaningAbortedException();
                }
                currentSegmentOpt = nextSegmentOpt;
            }
            cleaned.onBecomeInactiveSegment();
            cleaned.flush();
            long modified = ((LogSegment)segments.last()).lastModified();
            cleaned.setLastModified(modified);
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(52).append("Swapping in cleaned segment ").append(cleaned).append(" for segment(s) ").append(segments).append(" in log ").append(log).toString());
            log.replaceSegments((Seq<LogSegment>)new .colon.colon((Object)cleaned, (List)Nil$.MODULE$), segments);
            return;
        }
        catch (LogCleaningAbortedException e) {
            try {
                try {
                    cleaned.deleteIfExists();
                }
                catch (Exception deleteException) {
                    e.addSuppressed(deleteException);
                }
            }
            catch (Throwable throwable) {
                throw e;
            }
            throw e;
        }
    }

    public void cleanInto(TopicPartition topicPartition, FileRecords sourceRecords, LogSegment dest, OffsetMap map, boolean retainLegacyDeletesAndTxnMarkers, long deleteRetentionMs, int maxLogMessageSize, CleanedTransactionMetadata transactionMetadata, Map<Object, LastRecord> lastRecordsOfActiveProducers, long upperBoundOffsetOfCleaningRound, CleanerStats stats, long currentTime) {
        MemoryRecords.RecordFilter logCleanerFilter = new MemoryRecords.RecordFilter(this, currentTime, deleteRetentionMs, transactionMetadata, lastRecordsOfActiveProducers, upperBoundOffsetOfCleaningRound, map, retainLegacyDeletesAndTxnMarkers, stats){
            private boolean discardBatchRecords;
            private final /* synthetic */ Cleaner $outer;
            private final CleanedTransactionMetadata transactionMetadata$2;
            private final Map lastRecordsOfActiveProducers$1;
            private final long upperBoundOffsetOfCleaningRound$1;
            private final OffsetMap map$1;
            private final boolean retainLegacyDeletesAndTxnMarkers$2;
            private final CleanerStats stats$3;

            private boolean discardBatchRecords() {
                return this.discardBatchRecords;
            }

            private void discardBatchRecords_$eq(boolean x$1) {
                this.discardBatchRecords = x$1;
            }

            public MemoryRecords.RecordFilter.BatchRetentionResult checkBatchRetention(RecordBatch batch) {
                boolean canDiscardBatch = this.$outer.kafka$log$Cleaner$$shouldDiscardBatch(batch, this.transactionMetadata$2);
                if (batch.isControlBatch()) {
                    this.discardBatchRecords_$eq(canDiscardBatch && batch.deleteHorizonMs().isPresent() && batch.deleteHorizonMs().getAsLong() <= this.currentTime);
                } else {
                    this.discardBatchRecords_$eq(canDiscardBatch);
                }
                MemoryRecords.RecordFilter.BatchRetention batchRetention = batch.hasProducerId() && this.isBatchLastRecordOfProducer$1(batch) ? MemoryRecords.RecordFilter.BatchRetention.RETAIN_EMPTY : (batch.nextOffset() == this.upperBoundOffsetOfCleaningRound$1 ? MemoryRecords.RecordFilter.BatchRetention.RETAIN_EMPTY : (this.discardBatchRecords() ? MemoryRecords.RecordFilter.BatchRetention.DELETE : MemoryRecords.RecordFilter.BatchRetention.DELETE_EMPTY));
                return new MemoryRecords.RecordFilter.BatchRetentionResult(batchRetention, canDiscardBatch && batch.isControlBatch());
            }

            public boolean shouldRetainRecord(RecordBatch batch, Record record) {
                if (this.discardBatchRecords()) {
                    return false;
                }
                if (batch.isControlBatch()) {
                    return true;
                }
                return this.$outer.kafka$log$Cleaner$$shouldRetainRecord(this.map$1, this.retainLegacyDeletesAndTxnMarkers$2, batch, record, this.stats$3, this.currentTime);
            }

            public static final /* synthetic */ boolean $anonfun$checkBatchRetention$1(RecordBatch batch$1, LastRecord lastRecord) {
                if (lastRecord.lastDataOffset.isPresent()) {
                    return batch$1.lastOffset() == lastRecord.lastDataOffset.getAsLong();
                }
                return batch$1.isControlBatch() && batch$1.producerEpoch() == lastRecord.producerEpoch;
            }

            private final boolean isBatchLastRecordOfProducer$1(RecordBatch batch$1) {
                return this.lastRecordsOfActiveProducers$1.get((Object)BoxesRunTime.boxToLong((long)batch$1.producerId())).exists((Function1 & Serializable)lastRecord -> BoxesRunTime.boxToBoolean((boolean)$anon$1.$anonfun$checkBatchRetention$1(batch$1, lastRecord)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.transactionMetadata$2 = transactionMetadata$2;
                this.lastRecordsOfActiveProducers$1 = lastRecordsOfActiveProducers$1;
                this.upperBoundOffsetOfCleaningRound$1 = upperBoundOffsetOfCleaningRound$1;
                this.map$1 = map$1;
                this.retainLegacyDeletesAndTxnMarkers$2 = retainLegacyDeletesAndTxnMarkers$2;
                this.stats$3 = stats$3;
                super(currentTime$2, deleteRetentionMs$1);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$checkBatchRetention$1$adapted(org.apache.kafka.common.record.RecordBatch org.apache.kafka.storage.internals.log.LastRecord )}, serializedLambda);
            }
        };
        int position = 0;
        while (position < sourceRecords.sizeInBytes()) {
            this.checkDone.apply((Object)topicPartition);
            this.readBuffer().clear();
            this.writeBuffer().clear();
            sourceRecords.readInto(this.readBuffer(), position);
            MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)this.readBuffer());
            this.throttler.maybeThrottle((double)records.sizeInBytes());
            MemoryRecords.FilterResult result = records.filterTo(topicPartition, logCleanerFilter, this.writeBuffer(), maxLogMessageSize, this.decompressionBufferSupplier());
            stats.readMessages(result.messagesRead(), result.bytesRead());
            stats.recopyMessages(result.messagesRetained(), result.bytesRetained());
            position += result.bytesRead();
            ByteBuffer outputBuffer = result.outputBuffer();
            if (outputBuffer.position() > 0) {
                outputBuffer.flip();
                MemoryRecords retained = MemoryRecords.readableRecords((ByteBuffer)outputBuffer);
                dest.append(result.maxOffset(), retained);
                this.throttler.maybeThrottle((double)outputBuffer.limit());
            }
            if (this.readBuffer().limit() <= 0 || result.bytesRead() != 0) continue;
            this.growBuffersOrFail(sourceRecords, position, maxLogMessageSize, records);
        }
        this.restoreBuffers();
    }

    private void growBuffersOrFail(FileRecords sourceRecords, int position, int maxLogMessageSize, MemoryRecords memoryRecords) {
        int n;
        if (this.readBuffer().capacity() >= maxLogMessageSize) {
            Integer nextBatchSize = memoryRecords.firstBatchSize();
            String logDesc = new StringBuilder(25).append("log segment ").append(sourceRecords.file()).append(" at position ").append(position).toString();
            if (nextBatchSize == null) {
                throw new IllegalStateException(new StringBuilder(40).append("Could not determine next batch size for ").append(logDesc).toString());
            }
            if (Predef$.MODULE$.Integer2int(nextBatchSize) <= 0) {
                throw new IllegalStateException(new StringBuilder(24).append("Invalid batch size ").append(nextBatchSize).append(" for ").append(logDesc).toString());
            }
            if (Predef$.MODULE$.Integer2int(nextBatchSize) <= this.readBuffer().capacity()) {
                throw new IllegalStateException(new StringBuilder(50).append("Batch size ").append(nextBatchSize).append(" < buffer size ").append(this.readBuffer().capacity()).append(", but not processed for ").append(logDesc).toString());
            }
            long bytesLeft = sourceRecords.channel().size() - (long)position;
            if ((long)Predef$.MODULE$.Integer2int(nextBatchSize) > bytesLeft) {
                throw new CorruptRecordException(new StringBuilder(69).append("Log segment may be corrupt, batch size ").append(nextBatchSize).append(" > ").append(bytesLeft).append(" bytes left in segment for ").append(logDesc).toString());
            }
            n = nextBatchSize;
        } else {
            n = maxLogMessageSize;
        }
        int maxSize = n;
        this.growBuffers(maxSize);
    }

    public boolean kafka$log$Cleaner$$shouldDiscardBatch(RecordBatch batch, CleanedTransactionMetadata transactionMetadata) {
        if (batch.isControlBatch()) {
            return transactionMetadata.onControlBatchRead(batch);
        }
        return transactionMetadata.onBatchRead(batch);
    }

    public boolean kafka$log$Cleaner$$shouldRetainRecord(OffsetMap map, boolean retainDeletesForLegacyRecords, RecordBatch batch, Record record, CleanerStats stats, long currentTime) {
        if (record.offset() > map.latestOffset()) {
            return true;
        }
        if (record.hasKey()) {
            boolean isRetainedValue;
            ByteBuffer key = record.key();
            long foundOffset = map.get(key);
            boolean latestOffsetForKey = record.offset() >= foundOffset;
            boolean legacyRecord = batch.magic() < 2;
            boolean bl = isRetainedValue = record.hasValue() || Cleaner.shouldRetainDeletes$1(legacyRecord, batch, currentTime, retainDeletesForLegacyRecords);
            return latestOffsetForKey && isRetainedValue;
        }
        stats.invalidMessage();
        return false;
    }

    private void growBuffers(int maxLogMessageSize) {
        int maxBufferSize = package$.MODULE$.max(maxLogMessageSize, this.maxIoBufferSize);
        if (this.readBuffer().capacity() >= maxBufferSize || this.writeBuffer().capacity() >= maxBufferSize) {
            throw new IllegalStateException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("This log contains a message larger than maximum allowable size of %s."), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)maxBufferSize)})));
        }
        int newSize = package$.MODULE$.min(this.readBuffer().capacity() * 2, maxBufferSize);
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(50).append("Growing cleaner I/O buffers from ").append(this.readBuffer().capacity()).append(" bytes to ").append(newSize).append(" bytes.").toString());
        this.readBuffer_$eq(ByteBuffer.allocate(newSize));
        this.writeBuffer_$eq(ByteBuffer.allocate(newSize));
    }

    private void restoreBuffers() {
        if (this.readBuffer().capacity() > this.ioBufferSize) {
            this.readBuffer_$eq(ByteBuffer.allocate(this.ioBufferSize));
        }
        if (this.writeBuffer().capacity() > this.ioBufferSize) {
            this.writeBuffer_$eq(ByteBuffer.allocate(this.ioBufferSize));
            return;
        }
    }

    public List<Seq<LogSegment>> groupSegmentsBySize(Iterable<LogSegment> segments, int maxSize, int maxIndexSize, long firstUncleanableOffset) {
        Nil$ grouped = Nil$.MODULE$;
        List segs = segments.toList();
        while (segs.nonEmpty()) {
            .colon.colon group = new .colon.colon((Object)((LogSegment)segs.head()), (List)Nil$.MODULE$);
            long logSize = ((LogSegment)segs.head()).size();
            long indexSize = ((LogSegment)segs.head()).offsetIndex().sizeInBytes();
            long timeIndexSize = ((LogSegment)segs.head()).timeIndex().sizeInBytes();
            segs = (List)segs.tail();
            while (segs.nonEmpty() && logSize + (long)((LogSegment)segs.head()).size() <= (long)maxSize && indexSize + (long)((LogSegment)segs.head()).offsetIndex().sizeInBytes() <= (long)maxIndexSize && timeIndexSize + (long)((LogSegment)segs.head()).timeIndex().sizeInBytes() <= (long)maxIndexSize && (((LogSegment)segs.head()).size() == 0 || this.lastOffsetForFirstSegment((List<LogSegment>)segs, firstUncleanableOffset) - ((LogSegment)group.last()).baseOffset() <= Integer.MAX_VALUE)) {
                LogSegment logSegment = (LogSegment)segs.head();
                group = group.$colon$colon((Object)logSegment);
                logSize += (long)((LogSegment)segs.head()).size();
                indexSize += (long)((LogSegment)segs.head()).offsetIndex().sizeInBytes();
                timeIndexSize += (long)((LogSegment)segs.head()).timeIndex().sizeInBytes();
                segs = (List)segs.tail();
            }
            grouped = grouped.$colon$colon((Object)group.reverse());
        }
        return grouped.reverse();
    }

    private long lastOffsetForFirstSegment(List<LogSegment> segs, long firstUncleanableOffset) {
        if (segs.size() > 1) {
            return ((LogSegment)segs.apply(1)).baseOffset() - 1L;
        }
        return firstUncleanableOffset - 1L;
    }

    public void buildOffsetMap(UnifiedLog log, long start, long end, OffsetMap map, CleanerStats stats) {
        map.clear();
        Buffer dirty = log.logSegments(start, end).toBuffer();
        ListBuffer nextSegmentStartOffsets = new ListBuffer();
        if (dirty.nonEmpty()) {
            ((IterableOnceOps)dirty.tail()).foreach((Function1 & Serializable)nextSegment -> (ListBuffer)nextSegmentStartOffsets.append((Object)BoxesRunTime.boxToLong((long)nextSegment.baseOffset())));
            nextSegmentStartOffsets.append((Object)BoxesRunTime.boxToLong((long)end));
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Building offset map for log %s for %d segments in offset range [%d, %d)."), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{log.name(), BoxesRunTime.boxToInteger((int)dirty.size()), BoxesRunTime.boxToLong((long)start), BoxesRunTime.boxToLong((long)end)})));
        CleanedTransactionMetadata transactionMetadata = new CleanedTransactionMetadata();
        List<AbortedTxn> abortedTransactions = log.collectAbortedTransactions(start, end);
        transactionMetadata.addAbortedTransactions(abortedTransactions);
        BooleanRef full = BooleanRef.create((boolean)false);
        ((IterableOps)dirty.zip((IterableOnce)nextSegmentStartOffsets)).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)Cleaner.$anonfun$buildOffsetMap$3(check$ifrefutable$1))).withFilter((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)Cleaner.$anonfun$buildOffsetMap$4(full, x$15))).foreach((Function1 & Serializable)x$16 -> {
            Cleaner.$anonfun$buildOffsetMap$5(this, log, full, map, start, transactionMetadata, stats, dirty, x$16);
            return BoxedUnit.UNIT;
        });
        this.info((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Offset map for log %s complete."), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{log.name()})));
    }

    private boolean buildOffsetMapForSegment(TopicPartition topicPartition, LogSegment segment, OffsetMap map, long startOffset, long nextSegmentStartOffset, int maxLogMessageSize, CleanedTransactionMetadata transactionMetadata, CleanerStats stats) {
        Object object = new Object();
        try {
            int position = segment.offsetIndex().lookup((long)startOffset).position;
            int maxDesiredMapSize = (int)((double)map.slots() * this.dupBufferLoadFactor);
            while (position < segment.log().sizeInBytes()) {
                this.checkDone.apply((Object)topicPartition);
                this.readBuffer().clear();
                try {
                    segment.log().readInto(this.readBuffer(), position);
                }
                catch (Exception e) {
                    throw new KafkaException(new StringBuilder(67).append("Failed to read from segment ").append(segment).append(" of partition ").append(topicPartition).append(" ").append("while loading offset map").toString(), (Throwable)e);
                }
                MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)this.readBuffer());
                this.throttler.maybeThrottle((double)records.sizeInBytes());
                int startPosition = position;
                CollectionConverters$.MODULE$.IterableHasAsScala(records.batches()).asScala().foreach((Function1 & Serializable)batch -> {
                    Cleaner.$anonfun$buildOffsetMapForSegment$1(this, transactionMetadata, stats, startOffset, map, maxDesiredMapSize, object, batch);
                    return BoxedUnit.UNIT;
                });
                int bytesRead = records.validBytes();
                stats.indexBytesRead(bytesRead);
                if ((position += bytesRead) != startPosition) continue;
                this.growBuffersOrFail(segment.log(), position, maxLogMessageSize, records);
            }
            map.updateLatestOffset(nextSegmentStartOffset - 1L);
            this.restoreBuffers();
            return false;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
    }

    private static final boolean shouldRetainDeletes$1(boolean legacyRecord$1, RecordBatch batch$2, long currentTime$3, boolean retainDeletesForLegacyRecords$1) {
        if (!legacyRecord$1) {
            return !batch$2.deleteHorizonMs().isPresent() || currentTime$3 < batch$2.deleteHorizonMs().getAsLong();
        }
        return retainDeletesForLegacyRecords$1;
    }

    public static final /* synthetic */ boolean $anonfun$buildOffsetMap$3(Tuple2 check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ boolean $anonfun$buildOffsetMap$4(BooleanRef full$1, Tuple2 x$15) {
        if (x$15 != null) {
            return !full$1.elem;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$buildOffsetMap$5(Cleaner $this, UnifiedLog log$3, BooleanRef full$1, OffsetMap map$2, long start$1, CleanedTransactionMetadata transactionMetadata$3, CleanerStats stats$4, Buffer dirty$1, Tuple2 x$16) {
        if (x$16 != null) {
            LogSegment segment = (LogSegment)x$16._1();
            long nextSegmentStartOffset = x$16._2$mcJ$sp();
            $this.checkDone.apply((Object)log$3.topicPartition());
            full$1.elem = $this.buildOffsetMapForSegment(log$3.topicPartition(), segment, map$2, start$1, nextSegmentStartOffset, log$3.config().maxMessageSize(), transactionMetadata$3, stats$4);
            if (full$1.elem) {
                $this.debug((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Offset map is full, %d segments fully mapped, segment with base offset %d is partially mapped"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)dirty$1.indexOf((Object)segment)), BoxesRunTime.boxToLong((long)segment.baseOffset())})));
                return;
            }
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$buildOffsetMapForSegment$2(long startOffset$1, OffsetMap map$3, int maxDesiredMapSize$1, Object nonLocalReturnKey1$1, CleanerStats stats$5, Record record) {
        if (record.hasKey() && record.offset() >= startOffset$1) {
            if (map$3.size() < maxDesiredMapSize$1) {
                map$3.put(record.key(), record.offset());
            } else {
                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
            }
        }
        stats$5.indexMessagesRead(1);
    }

    public static final /* synthetic */ void $anonfun$buildOffsetMapForSegment$1(Cleaner $this, CleanedTransactionMetadata transactionMetadata$4, CleanerStats stats$5, long startOffset$1, OffsetMap map$3, int maxDesiredMapSize$1, Object nonLocalReturnKey1$1, MutableRecordBatch batch) {
        if (batch.isControlBatch()) {
            transactionMetadata$4.onControlBatchRead((RecordBatch)batch);
            stats$5.indexMessagesRead(1);
        } else if (transactionMetadata$4.onBatchRead((RecordBatch)batch)) {
            stats$5.indexMessagesRead(Predef$.MODULE$.Integer2int(batch.countOrNull()));
        } else {
            try (CloseableIterator recordsIterator = batch.streamingIterator($this.decompressionBufferSupplier());){
                CollectionConverters$.MODULE$.IteratorHasAsScala((java.util.Iterator)recordsIterator).asScala().foreach((Function1 & Serializable)record -> {
                    Cleaner.$anonfun$buildOffsetMapForSegment$2(startOffset$1, map$3, maxDesiredMapSize$1, nonLocalReturnKey1$1, stats$5, record);
                    return BoxedUnit.UNIT;
                });
            }
        }
        if (batch.lastOffset() >= startOffset$1) {
            map$3.updateLatestOffset(batch.lastOffset());
            return;
        }
    }

    public Cleaner(int id, OffsetMap offsetMap, int ioBufferSize, int maxIoBufferSize, double dupBufferLoadFactor, Throttler throttler, Time time, Function1<TopicPartition, BoxedUnit> checkDone) {
        this.id = id;
        this.offsetMap = offsetMap;
        this.ioBufferSize = ioBufferSize;
        this.maxIoBufferSize = maxIoBufferSize;
        this.dupBufferLoadFactor = dupBufferLoadFactor;
        this.throttler = throttler;
        this.time = time;
        this.checkDone = checkDone;
        this.logIdent_$eq(new StringBuilder(10).append("Cleaner ").append(id).append(": ").toString());
        this.readBuffer = ByteBuffer.allocate(ioBufferSize);
        this.writeBuffer = ByteBuffer.allocate(ioBufferSize);
        this.decompressionBufferSupplier = BufferSupplier.create();
        Predef$.MODULE$.require((double)offsetMap.slots() * dupBufferLoadFactor > 1.0, (Function0 & Serializable)() -> "offset map is too small to fit in even a single message, so log cleaning will never make progress. You can increase log.cleaner.dedupe.buffer.size or decrease log.cleaner.threads");
    }
}

