/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.filter.rewrite.impl;

import java.net.URISyntaxException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteRuleDescriptor;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteStepDescriptor;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriter;
import org.apache.knox.gateway.filter.rewrite.spi.UrlRewriteFlowDescriptorBase;
import org.apache.knox.gateway.util.urltemplate.Parser;
import org.apache.knox.gateway.util.urltemplate.Template;

public class UrlRewriteRuleDescriptorImpl
extends UrlRewriteFlowDescriptorBase<UrlRewriteRuleDescriptor>
implements UrlRewriteRuleDescriptor {
    private String name;
    private String scope;
    private String pattern;
    private Template template;
    private EnumSet<UrlRewriter.Direction> directions;
    private static Map<String, UrlRewriter.Direction> directionNameMap = new HashMap<String, UrlRewriter.Direction>();

    public UrlRewriteRuleDescriptorImpl() {
        super("rule");
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public UrlRewriteRuleDescriptor name(String name) {
        this.name = name;
        return this;
    }

    public void setName(String name) {
        this.name(name);
    }

    public String getName() {
        return this.name;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope(scope);
    }

    @Override
    public String scope() {
        return this.scope;
    }

    @Override
    public UrlRewriteStepDescriptor scope(String scope) {
        this.scope = scope;
        return this;
    }

    @Override
    public EnumSet<UrlRewriter.Direction> directions() {
        return this.directions;
    }

    @Override
    public UrlRewriteRuleDescriptor directions(String directions) {
        this.directions = UrlRewriteRuleDescriptorImpl.parseDirections(directions);
        return this;
    }

    public void setDirections(String directions) {
        this.directions(directions);
    }

    public void setDirection(String directions) {
        this.directions(directions);
    }

    public void setDir(String directions) {
        this.directions(directions);
    }

    public String getDir() {
        String s = null;
        if (this.directions != null) {
            StringBuilder sb = new StringBuilder();
            for (UrlRewriter.Direction direction : this.directions) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(direction.toString());
            }
            s = sb.toString();
        }
        return s;
    }

    @Override
    public UrlRewriteRuleDescriptor directions(UrlRewriter.Direction ... directions) {
        return this;
    }

    @Override
    public String pattern() {
        return this.pattern;
    }

    @Override
    public UrlRewriteRuleDescriptor pattern(String pattern) throws URISyntaxException {
        this.pattern = pattern;
        this.template = Parser.parseTemplate((String)pattern);
        return this;
    }

    public void setPattern(String pattern) throws URISyntaxException {
        this.pattern(pattern);
    }

    public void setUrl(String pattern) throws URISyntaxException {
        this.pattern(pattern);
    }

    public String getPattern() {
        return this.pattern();
    }

    @Override
    public Template template() {
        return this.template;
    }

    @Override
    public UrlRewriteRuleDescriptor template(Template template) {
        this.template = template;
        this.pattern = template.toString();
        return this;
    }

    private static EnumSet<UrlRewriter.Direction> parseDirections(String directions) {
        EnumSet<UrlRewriter.Direction> set = EnumSet.noneOf(UrlRewriter.Direction.class);
        StringTokenizer parser = new StringTokenizer(directions, " ,;:/|+");
        while (parser.hasMoreTokens()) {
            UrlRewriter.Direction direction = UrlRewriteRuleDescriptorImpl.parseDirection(parser.nextToken());
            if (direction == null) continue;
            set.add(direction);
        }
        return set;
    }

    private static UrlRewriter.Direction parseDirection(String direction) {
        direction = direction.trim().toLowerCase(Locale.ROOT);
        return directionNameMap.get(direction);
    }

    static {
        directionNameMap.put("inbound", UrlRewriter.Direction.IN);
        directionNameMap.put("in", UrlRewriter.Direction.IN);
        directionNameMap.put("i", UrlRewriter.Direction.IN);
        directionNameMap.put("request", UrlRewriter.Direction.IN);
        directionNameMap.put("req", UrlRewriter.Direction.IN);
        directionNameMap.put("outbound", UrlRewriter.Direction.OUT);
        directionNameMap.put("out", UrlRewriter.Direction.OUT);
        directionNameMap.put("o", UrlRewriter.Direction.OUT);
        directionNameMap.put("response", UrlRewriter.Direction.OUT);
        directionNameMap.put("res", UrlRewriter.Direction.OUT);
    }
}

