/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.ldif;

import org.apache.directory.api.i18n.I18n;

public enum ChangeType {
    Add(0),
    Modify(1),
    ModDn(2),
    ModRdn(3),
    Delete(4),
    None(-1);

    public static final int ADD_ORDINAL = 0;
    public static final int MODIFY_ORDINAL = 1;
    public static final int MODDN_ORDINAL = 2;
    public static final int MODRDN_ORDINAL = 3;
    public static final int DELETE_ORDINAL = 4;
    public static final int NONE_ORDINAL = -1;
    private final int changeType;

    private ChangeType(int changeType) {
        this.changeType = changeType;
    }

    public int getChangeType() {
        return this.changeType;
    }

    public static ChangeType getChangeType(int val) {
        switch (val) {
            case -1: {
                return None;
            }
            case 0: {
                return Add;
            }
            case 1: {
                return Modify;
            }
            case 2: {
                return ModDn;
            }
            case 3: {
                return ModRdn;
            }
            case 4: {
                return Delete;
            }
        }
        throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_13438_UNKNOWN_CHANGE_TYPE, (Object[])new Object[]{val}));
    }
}

