/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.server.api.v1;

import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.Serializable;
import java.util.Collections;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.client.api.v1.dto.Count;
import org.apache.kyuubi.client.api.v1.dto.Engine;
import org.apache.kyuubi.client.api.v1.dto.OperationData;
import org.apache.kyuubi.client.api.v1.dto.ServerData;
import org.apache.kyuubi.client.api.v1.dto.SessionData;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.engine.ApplicationManagerInfo;
import org.apache.kyuubi.engine.ApplicationManagerInfo$;
import org.apache.kyuubi.engine.KyuubiApplicationManager;
import org.apache.kyuubi.ha.HighAvailabilityConf$;
import org.apache.kyuubi.ha.client.DiscoveryClient;
import org.apache.kyuubi.ha.client.DiscoveryClientProvider$;
import org.apache.kyuubi.ha.client.DiscoveryPaths$;
import org.apache.kyuubi.ha.client.ServiceNodeInfo;
import org.apache.kyuubi.operation.KyuubiOperation;
import org.apache.kyuubi.operation.Operation;
import org.apache.kyuubi.operation.OperationHandle;
import org.apache.kyuubi.operation.OperationHandle$;
import org.apache.kyuubi.package$;
import org.apache.kyuubi.server.KyuubiRestFrontendService;
import org.apache.kyuubi.server.KyuubiServer$;
import org.apache.kyuubi.server.api.ApiRequestContext;
import org.apache.kyuubi.server.api.ApiUtils$;
import org.apache.kyuubi.session.KyuubiSession;
import org.apache.kyuubi.session.KyuubiSessionManager;
import org.apache.kyuubi.session.SessionHandle$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@Tag(name="Admin")
@Produces(value={"application/json"})
@ScalaSignature(bytes="\u0006\u0001\r=c!\u0002\n\u0014\u0001My\u0002\"\u0002\u0018\u0001\t\u0003\u0001\u0004\"B\u001a\u0001\t\u0003!\u0004\"\u00029\u0001\t\u0003!\u0004\"B=\u0001\t\u0003!\u0004BBA\u0003\u0001\u0011\u0005A\u0007\u0003\u0004\u0002\u0018\u0001!\t\u0001\u000e\u0005\u0007\u0003S\u0001A\u0011\u0001\u001b\t\u000f\u0005m\u0002\u0001\"\u0001\u0002>!9\u0011q\u0018\u0001\u0005\u0002\u0005\u0005\u0007bBAu\u0001\u0011\u0005\u00111\u001e\u0005\b\u00053\u0001A\u0011\u0001B\u000e\u0011\u001d\u00119\u0004\u0001C\u0001\u0005sAqA!&\u0001\t\u0003\u00119\nC\u0004\u0003B\u0002!\tAa1\t\u000f\tm\u0007\u0001\"\u0003\u0003^\"9!Q\u001e\u0001\u0005\n\t=\bb\u0002Bz\u0001\u0011\u0005!Q\u001f\u0002\u000e\u0003\u0012l\u0017N\u001c*fg>,(oY3\u000b\u0005Q)\u0012A\u0001<2\u0015\t1r#A\u0002ba&T!\u0001G\r\u0002\rM,'O^3s\u0015\tQ2$\u0001\u0004lsV,(-\u001b\u0006\u00039u\ta!\u00199bG\",'\"\u0001\u0010\u0002\u0007=\u0014xm\u0005\u0003\u0001A\u0019R\u0003CA\u0011%\u001b\u0005\u0011#\"A\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0012#AB!osJ+g\r\u0005\u0002(Q5\tQ#\u0003\u0002*+\t\t\u0012\t]5SKF,Xm\u001d;D_:$X\r\u001f;\u0011\u0005-bS\"A\r\n\u00055J\"a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\t\u0011\u0007\u0005\u00023\u00015\t1#A\rsK\u001a\u0014Xm\u001d5Ge>tG/\u001a8e\u0011\u0006$wn\u001c9D_:4G#A\u001b\u0011\u0005YzT\"A\u001c\u000b\u0005aJ\u0014\u0001B2pe\u0016T!AO\u001e\u0002\u0005I\u001c(B\u0001\u001f>\u0003\t98OC\u0001?\u0003\u0015Q\u0017M^1y\u0013\t\u0001uG\u0001\u0005SKN\u0004xN\\:fQ\u0011\u0011!IR$\u0011\u0005\r#U\"A\u001d\n\u0005\u0015K$\u0001\u0002)bi\"\fQA^1mk\u0016\f\u0013\u0001S\u0001\u0014e\u00164'/Z:i_!\fGm\\8q?\u000e|gN\u001a\u0015\u0003\u0005)\u0003\"aQ&\n\u00051K$\u0001\u0002)P'RC\u0003B\u0001(_?\u0006\u0014WN\u001c\t\u0003\u001frk\u0011\u0001\u0015\u0006\u0003#J\u000b\u0011B]3ta>t7/Z:\u000b\u0005M#\u0016aC1o]>$\u0018\r^5p]NT!!\u0016,\u0002\u0007=\f7O\u0003\u0002X1\u0006\u0011ao\r\u0006\u00033j\u000bqa]<bO\u001e,'OC\u0001\\\u0003\tIw.\u0003\u0002^!\nY\u0011\t]5SKN\u0004xN\\:f\u00031\u0011Xm\u001d9p]N,7i\u001c3fC\u0005\u0001\u0017a\u0001\u001a1a\u000591m\u001c8uK:$H&A2,\u0007\u0011T7\u000e\u0005\u0002fQ6\taM\u0003\u0002h%\u0006)Q.\u001a3jC&\u0011\u0011N\u001a\u0002\b\u0007>tG/\u001a8u\u0003%iW\rZ5b)f\u0004X-I\u0001m\u0003A\t\u0007\u000f\u001d7jG\u0006$\u0018n\u001c80UN|g.A\u0006eKN\u001c'/\u001b9uS>t\u0017%A8\u0002AJ,gM]3tQ\u0002\"\b.\u001a\u0011LsV,(-\u001b\u0011tKJ4XM\u001d\u0011iC\u0012|w\u000e\u001d\u0011d_:4G\u0006\t8pi\u0016\u0004C\u000f[1uY\u0001JG\u000fI8oYf\u0004C/Y6fg\u0002\ngMZ3di\u00022wN\u001d\u0011ge>tG/\u001a8eAM,'O^5dKN\u0004cn\\<\u0002/I,gM]3tQV\u001bXM\u001d#fM\u0006,H\u000e^:D_:4\u0007\u0006B\u0002C\rJ\f\u0013a]\u0001\u001be\u00164'/Z:i_U\u001cXM]0eK\u001a\fW\u000f\u001c;t?\u000e|gN\u001a\u0015\u0003\u0007)C\u0003b\u0001(_?\u00064Xn\u001e\u0017\u0002G\u0006\n\u00010A\u0011sK\u001a\u0014Xm\u001d5!i\",\u0007%^:fe\u0002\"WMZ1vYR\u001c\beY8oM&<7/A\u000bsK\u001a\u0014Xm\u001d5Lk\n,'O\\3uKN\u001cuN\u001c4)\t\u0011\u0011ei_\u0011\u0002y\u00069\"/\u001a4sKNDwf[;cKJtW\r^3t?\u000e|gN\u001a\u0015\u0003\t)C\u0013\u0002\u0002(_?\u0006|X.!\u0001-\u0003\r\f#!a\u0001\u0002=I,gM]3tQ\u0002\"\b.\u001a\u0011lk\n,'O\\3uKN\u00043m\u001c8gS\u001e\u001c\u0018\u0001\u0006:fMJ,7\u000f[+oY&l\u0017\u000e^3e+N,'\u000fK\u0003\u0006\u0005\u001a\u000bI!\t\u0002\u0002\f\u00059\"/\u001a4sKNDw&\u001e8mS6LG/\u001a3`kN,'o\u001d\u0015\u0003\u000b)C#\"\u0002(_?\u0006\f\t\"\\A\nY\u0005\u0019\u0017EAA\u000b\u0003m\u0011XM\u001a:fg\"\u0004C\u000f[3!k:d\u0017.\\5uK\u0012\u0004So]3sg\u0006y!/\u001a4sKNDG)\u001a8z+N,'\u000fK\u0003\u0007\u0005\u001a\u000bY\"\t\u0002\u0002\u001e\u0005\u0011\"/\u001a4sKNDw\u0006Z3os~+8/\u001a:tQ\t1!\n\u000b\u0006\u0007\u001dz{\u0016-a\tn\u0003Ka\u0013aY\u0011\u0003\u0003O\taC]3ge\u0016\u001c\b\u000e\t;iK\u0002\"WM\\=!kN,'o]\u0001\u000ee\u00164'/Z:i\t\u0016t\u00170\u00139)\u000b\u001d\u0011e)!\f\"\u0005\u0005=\u0012\u0001\u0005:fMJ,7\u000f[\u0018eK:Lx,\u001b9tQ\t9!\n\u000b\u0006\b\u001dz{\u0016-!\u000en\u0003oa\u0013aY\u0011\u0003\u0003s\tAC]3ge\u0016\u001c\b\u000e\t;iK\u0002\"WM\\=!SB\u001c\u0018\u0001C:fgNLwN\\:\u0015\r\u0005}\u00121NAE!\u0019\t\t%!\u0015\u0002X9!\u00111IA'\u001d\u0011\t)%a\u0013\u000e\u0005\u0005\u001d#bAA%_\u00051AH]8pizJ\u0011aI\u0005\u0004\u0003\u001f\u0012\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003'\n)FA\u0002TKFT1!a\u0014#!\u0011\tI&a\u001a\u000e\u0005\u0005m#\u0002BA/\u0003?\n1\u0001\u001a;p\u0015\r!\u0012\u0011\r\u0006\u0004-\u0005\r$bAA33\u000511\r\\5f]RLA!!\u001b\u0002\\\tY1+Z:tS>tG)\u0019;b\u0011\u001d\ti\u0007\u0003a\u0001\u0003_\nQ!^:feN\u0004B!!\u001d\u0002z9!\u00111OA;!\r\t)EI\u0005\u0004\u0003o\u0012\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002|\u0005u$AB*ue&twMC\u0002\u0002x\tBs!a\u001b\u0002\u0002\u001a\u000b9\tE\u0002D\u0003\u0007K1!!\":\u0005)\tV/\u001a:z!\u0006\u0014\u0018-\\\u0011\u0003\u0003[Bq!a#\t\u0001\u0004\ty'A\u0006tKN\u001c\u0018n\u001c8UsB,\u0007fBAE\u0003\u00033\u0015qR\u0011\u0003\u0003\u0017CS\u0001\u0003\"G\u0003'\u000b#!a\u000f)\u0007!\t9\nE\u0002D\u00033K1!a':\u0005\r9U\t\u0016\u0015\u000b\u00119sv,YAP[\u0006mFFAAQW\u001d!'n[AR\u0003K\u000bQ!\u0019:sCf\\c!a*\u0002.\u0006=\u0006cA3\u0002*&\u0019\u00111\u00164\u0003\u0017\u0005\u0013(/Y=TG\",W.Y\u0001\u0007g\u000eDW-\\1,\r\u0005E\u0016qWA]!\r)\u00171W\u0005\u0004\u0003k3'AB*dQ\u0016l\u0017-\u0001\bj[BdW-\\3oi\u0006$\u0018n\u001c8$\u0005\u0005]\u0013EAA_\u0003\u0005:W\r\u001e\u0011uQ\u0016\u0004C.[:uA=4\u0007%\u00197mA1Lg/\u001a\u0011tKN\u001c\u0018n\u001c8t\u00031\u0019Gn\\:f'\u0016\u001c8/[8o)\r)\u00141\u0019\u0005\b\u0003\u000bL\u0001\u0019AA8\u0003A\u0019Xm]:j_:D\u0015M\u001c3mKN#(\u000fK\u0004\u0002D\u0006%g)a4\u0011\u0007\r\u000bY-C\u0002\u0002Nf\u0012\u0011\u0002U1uQB\u000b'/Y7\"\u0005\u0005E\u0017!D:fgNLwN\u001c%b]\u0012dW\rK\u0003\n\u0005\u001a\u000b).\t\u0002\u0002X\u0006A2/Z:tS>t7oL>tKN\u001c\u0018n\u001c8IC:$G.Z?)\u0007%\tY\u000eE\u0002D\u0003;L1!a8:\u0005\u0019!U\tT#U\u000b\"R\u0011B\u00140`C\u0006\rX.!:-\u0003\r\f#!a:\u0002\u001f\rcwn]3!C\u0002\u001aXm]:j_:\fa\u0002\\5ti>\u0003XM]1uS>t7\u000f\u0006\u0005\u0002n\u0006U\u0018\u0011`A\u007f!\u0019\t\t%!\u0015\u0002pB!\u0011\u0011LAy\u0013\u0011\t\u00190a\u0017\u0003\u001b=\u0003XM]1uS>tG)\u0019;b\u0011\u001d\tiG\u0003a\u0001\u0003_Bs!!>\u0002\u0002\u001a\u000b9\tC\u0004\u0002R*\u0001\r!a\u001c)\u000f\u0005e\u0018\u0011\u0011$\u0002P\"9\u00111\u0012\u0006A\u0002\u0005=\u0004fBA\u007f\u0003\u00033\u0015q\u0012\u0015\u0006\u0015\t3%1A\u0011\u0003\u0005\u000b\t!b\u001c9fe\u0006$\u0018n\u001c8tQ\rQ\u0011q\u0013\u0015\u000b\u00159sv,\u0019B\u0006[\nUAF\u0001B\u0007W\u001d!'n[AR\u0005\u001fYc!a*\u0002.\nE1FBAY\u0003o\u0013\u0019b\t\u0002\u0002p\u0006\u0012!qC\u0001&O\u0016$\b\u0005\u001e5fA1L7\u000f\u001e\u0011pM\u0002\nG\u000e\u001c\u0011bGRLg/\u001a\u0011pa\u0016\u0014\u0018\r^5p]N\fab\u00197pg\u0016|\u0005/\u001a:bi&|g\u000eF\u00026\u0005;AqAa\b\f\u0001\u0004\ty'\u0001\npa\u0016\u0014\u0018\r^5p]\"\u000bg\u000e\u001a7f'R\u0014\bf\u0002B\u000f\u0003\u00134%1E\u0011\u0003\u0005K\tqb\u001c9fe\u0006$\u0018n\u001c8IC:$G.\u001a\u0015\u0006\u0017\t3%\u0011F\u0011\u0003\u0005W\tAd\u001c9fe\u0006$\u0018n\u001c8t_m|\u0007/\u001a:bi&|g\u000eS1oI2,W\u0010K\u0002\f\u00037D#b\u0003(_?\u0006\u0014\t$\u001cB\u001aY\u0005\u0019\u0017E\u0001B\u001b\u0003I\u0019Gn\\:fA\u0005t\u0007e\u001c9fe\u0006$\u0018n\u001c8\u0002\u0019\u0011,G.\u001a;f\u000b:<\u0017N\\3\u0015\u001bU\u0012YD!\u0012\u0003P\t]#\u0011\rB6\u0011\u001d\u0011i\u0004\u0004a\u0001\u0003_\n!\"\u001a8hS:,G+\u001f9fQ\u001d\u0011Y$!!G\u0005\u0003\n#Aa\u0011\u0002\tQL\b/\u001a\u0005\b\u0005\u000fb\u0001\u0019AA8\u0003)\u0019\b.\u0019:f\u0019\u00164X\r\u001c\u0015\b\u0005\u000b\n\tI\u0012B&C\t\u0011i%\u0001\u0006tQ\u0006\u0014X\r\\3wK2DqA!\u0015\r\u0001\u0004\ty'A\u0005tk\n$w.\\1j]\":!qJAA\r\nU\u0013E\u0001B)\u0011\u001d\u0011I\u0006\u0004a\u0001\u0003_\nqb[=vk\nL\u0007K]8ysV\u001bXM\u001d\u0015\b\u0005/\n\tI\u0012B/C\t\u0011y&A\u0005qe>D\u00180V:fe\"9!1\r\u0007A\u0002\u0005=\u0014\u0001\u00045teA\u0013x\u000e_=Vg\u0016\u0014\bf\u0002B1\u0003\u00033%qM\u0011\u0003\u0005S\nq\u0003[5wK:\u001aXM\u001d<feJr\u0003O]8ys:*8/\u001a:\t\u000f\t5D\u00021\u0001\u0003p\u0005!1.\u001b7m!\r\t#\u0011O\u0005\u0004\u0005g\u0012#a\u0002\"p_2,\u0017M\u001c\u0015\b\u0005W\u00129H\u0012B?!\r\u0019%\u0011P\u0005\u0004\u0005wJ$\u0001\u0004#fM\u0006,H\u000e\u001e,bYV,\u0017E\u0001B@\u0003\u00151\u0017\r\\:fQ\u001d\u0011Y'!!G\u0005\u0007\u000b#A!\u001c)\u000b1\u0011eIa\"\"\u0005\t%\u0015AB3oO&tW\rK\u0002\r\u00037D#\u0002\u0004(_?\u0006\u0014y)\u001cBIY\u0005\u0019\u0017E\u0001BJ\u0003Q!W\r\\3uK\u0002Z\u00170^;cS\u0002*gnZ5oK\u0006YA.[:u\u000b:<\u0017N\\3t)1\u0011IJ!)\u0003&\n%&Q\u0016BY!\u0019\t\t%!\u0015\u0003\u001cB!\u0011\u0011\fBO\u0013\u0011\u0011y*a\u0017\u0003\r\u0015sw-\u001b8f\u0011\u001d\u0011i$\u0004a\u0001\u0003_BsA!)\u0002\u0002\u001a\u0013\t\u0005C\u0004\u0003H5\u0001\r!a\u001c)\u000f\t\u0015\u0016\u0011\u0011$\u0003L!9!\u0011K\u0007A\u0002\u0005=\u0004f\u0002BU\u0003\u00033%Q\u000b\u0005\b\u00053j\u0001\u0019AA8Q\u001d\u0011i+!!G\u0005;BqAa\u0019\u000e\u0001\u0004\ty\u0007K\u0004\u00032\u0006\u0005eIa\u001a)\u000b5\u0011eIa\")\u00075\t9\n\u000b\u0006\u000e\u001dz{\u0016Ma/n\u0005{c\u0013aY\u0011\u0003\u0005\u007f\u000b1\u0003\\5ti\u0002Z\u00170^;cS\u0002*gnZ5oKN\f1\u0002\\5tiN+'O^3sgR\u0011!Q\u0019\t\u0007\u0003\u0003\n\tFa2\u0011\t\u0005e#\u0011Z\u0005\u0005\u0005\u0017\fYF\u0001\u0006TKJ4XM\u001d#bi\u0006DSA\u0004\"G\u0005\u001f\f\u0013\u0001\u0007\u0015\u0004\u001d\u0005]\u0005F\u0003\bO=~\u000b'Q[7\u0003X2\u0012!QB\u0011\u0003\u00053\fA\u0004\\5ti\u0002\nG\u000e\u001c\u0011mSZ,\u0007e[=vk\nL\u0007e]3sm\u0016\u00148/A\no_Jl\u0017\r\\5{K\u0016sw-\u001b8f\u0013:4w\u000e\u0006\u0007\u0003\u001c\n}'1\u001dBs\u0005O\u0014I\u000fC\u0004\u0003b>\u0001\r!a\u001c\u0002\u0011U\u001cXM\u001d(b[\u0016DqA!\u0010\u0010\u0001\u0004\ty\u0007C\u0004\u0003H=\u0001\r!a\u001c\t\u000f\tEs\u00021\u0001\u0002p!9!1^\bA\u0002\u0005=\u0014\u0001E:vE\u0012|W.Y5o\t\u00164\u0017-\u001e7u\u0003Q\u0019\u0017\r\\2vY\u0006$X-\u00128hS:,7\u000b]1dKR!\u0011q\u000eBy\u0011\u001d\u0011I\t\u0005a\u0001\u00057\u000b!bY8v]R\u0014\u0015\r^2i)!\u00119P!@\u0004\f\rM\u0001\u0003BA-\u0005sLAAa?\u0002\\\t)1i\\;oi\"9!q`\tA\u0002\u0005=\u0014!\u00032bi\u000eDG+\u001f9fQ\u001d\u0011iPa\u001eG\u0007\u0007\t#a!\u0002\u0002\u000bM\u0003\u0016IU&)\u000f\tu\u0018\u0011\u0011$\u0004\n\u0005\u0012!q \u0005\b\u0007\u001b\t\u0002\u0019AA8\u0003%\u0011\u0017\r^2i+N,'\u000fK\u0004\u0004\f\u0005\u0005ei!\u0005\"\u0005\r5\u0001bBB\u000b#\u0001\u0007\u0011qN\u0001\u000bE\u0006$8\r[*uCR,\u0007fBB\n\u0003\u000335\u0011D\u0011\u0003\u0007+AS!\u0005\"G\u0007;\t#aa\b\u0002\u0017\t\fGo\u001950G>,h\u000e\u001e\u0015\u0004#\u0005]\u0005FC\tO=~\u000b7QE7\u0004.1\u00121qE\u0016\bI*\\\u0017QVB\u0015W\u0019\t\t,a.\u0004,\r\u0012!q_\u0011\u0003\u0007_\t1cZ3uAQDW\r\t2bi\u000eD\u0007eY8v]RDc\u0001AB\u001a\r\u000ee\u0002cA\"\u00046%\u00191qG\u001d\u0003\u0011A\u0013x\u000eZ;dKNd\u0013a\u001b\u0015\b\u0001\ru2\u0011JB&!\u0011\u0019yd!\u0012\u000e\u0005\r\u0005#bAB\"%\u0006!A/Y4t\u0013\u0011\u00199e!\u0011\u0003\u0007Q\u000bw-\u0001\u0003oC6,\u0017EAB'\u0003\u0015\tE-\\5o\u0001")
public class AdminResource
implements ApiRequestContext,
Logging {
    private transient Logger org$apache$kyuubi$Logging$$log_;
    @Context
    private ServletContext servletContext;
    @Context
    private HttpServletRequest httpRequest;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$((Logging)this, message, (Throwable)t);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<Object> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    @Override
    public final KyuubiRestFrontendService fe() {
        return ApiRequestContext.fe$(this);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    @Override
    public ServletContext servletContext() {
        return this.servletContext;
    }

    @Override
    public void servletContext_$eq(ServletContext x$1) {
        this.servletContext = x$1;
    }

    @Override
    public HttpServletRequest httpRequest() {
        return this.httpRequest;
    }

    @Override
    public void httpRequest_$eq(HttpServletRequest x$1) {
        this.httpRequest = x$1;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="refresh the Kyuubi server hadoop conf, note that, it only takes affect for frontend services now")
    @POST
    @Path(value="refresh/hadoop_conf")
    public Response refreshFrontendHadoopConf() {
        String userName = this.fe().getSessionUser((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
        String ipAddress = this.fe().getIpAddress();
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(56).append("Receive refresh Kyuubi server hadoop conf request from ").append(userName).append("/").append(ipAddress).toString());
        if (!this.fe().isAdministrator(userName)) {
            throw new ForbiddenException(new java.lang.StringBuilder(56).append(userName).append(" is not allowed to refresh the Kyuubi server hadoop conf").toString());
        }
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Reloading the Kyuubi server hadoop conf");
        KyuubiServer$.MODULE$.reloadHadoopConf();
        return Response.ok((Object)new java.lang.StringBuilder(42).append("Refresh the hadoop conf for ").append(this.fe().connectionUrl()).append(" successfully.").toString()).build();
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="refresh the user defaults configs")
    @POST
    @Path(value="refresh/user_defaults_conf")
    public Response refreshUserDefaultsConf() {
        String userName = this.fe().getSessionUser((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
        String ipAddress = this.fe().getIpAddress();
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(49).append("Receive refresh user defaults conf request from ").append(userName).append("/").append(ipAddress).toString());
        if (!this.fe().isAdministrator(userName)) {
            throw new ForbiddenException(new java.lang.StringBuilder(49).append(userName).append(" is not allowed to refresh the user defaults conf").toString());
        }
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Reloading user defaults conf");
        KyuubiServer$.MODULE$.refreshUserDefaultsConf();
        return Response.ok((Object)"Refresh the user defaults conf successfully.").build();
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="refresh the kubernetes configs")
    @POST
    @Path(value="refresh/kubernetes_conf")
    public Response refreshKubernetesConf() {
        String userName = this.fe().getSessionUser((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
        String ipAddress = this.fe().getIpAddress();
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(46).append("Receive refresh kubernetes conf request from ").append(userName).append("/").append(ipAddress).toString());
        if (!this.fe().isAdministrator(userName)) {
            throw new ForbiddenException(new java.lang.StringBuilder(46).append(userName).append(" is not allowed to refresh the kubernetes conf").toString());
        }
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Reloading kubernetes conf");
        KyuubiServer$.MODULE$.refreshKubernetesConf();
        return Response.ok((Object)"Refresh the kubernetes conf successfully.").build();
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="refresh the unlimited users")
    @POST
    @Path(value="refresh/unlimited_users")
    public Response refreshUnlimitedUser() {
        String userName = this.fe().getSessionUser((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
        String ipAddress = this.fe().getIpAddress();
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(46).append("Receive refresh unlimited users request from ").append(userName).append("/").append(ipAddress).toString());
        if (!this.fe().isAdministrator(userName)) {
            throw new ForbiddenException(new java.lang.StringBuilder(46).append(userName).append(" is not allowed to refresh the unlimited users").toString());
        }
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Reloading unlimited users");
        KyuubiServer$.MODULE$.refreshUnlimitedUsers();
        return Response.ok((Object)"Refresh the unlimited users successfully.").build();
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="refresh the deny users")
    @POST
    @Path(value="refresh/deny_users")
    public Response refreshDenyUser() {
        String userName = this.fe().getSessionUser((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
        String ipAddress = this.fe().getIpAddress();
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(41).append("Receive refresh deny users request from ").append(userName).append("/").append(ipAddress).toString());
        if (!this.fe().isAdministrator(userName)) {
            throw new ForbiddenException(new java.lang.StringBuilder(41).append(userName).append(" is not allowed to refresh the deny users").toString());
        }
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Reloading deny users");
        KyuubiServer$.MODULE$.refreshDenyUsers();
        return Response.ok((Object)"Refresh the deny users successfully.").build();
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="refresh the deny ips")
    @POST
    @Path(value="refresh/deny_ips")
    public Response refreshDenyIp() {
        String userName = this.fe().getSessionUser((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
        String ipAddress = this.fe().getIpAddress();
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(39).append("Receive refresh deny ips request from ").append(userName).append("/").append(ipAddress).toString());
        if (!this.fe().isAdministrator(userName)) {
            throw new ForbiddenException(new java.lang.StringBuilder(39).append(userName).append(" is not allowed to refresh the deny ips").toString());
        }
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Reloading deny ips");
        KyuubiServer$.MODULE$.refreshDenyIps();
        return Response.ok((Object)"Refresh the deny ips successfully.").build();
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=SessionData.class)))}, description="get the list of all live sessions")
    @GET
    @Path(value="sessions")
    public Seq<SessionData> sessions(@QueryParam(value="users") String users, @QueryParam(value="sessionType") String sessionType) {
        Iterable sessions;
        block2: {
            String userName = this.fe().getSessionUser((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
            String ipAddress = this.fe().getIpAddress();
            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(49).append("Received listing all live sessions request from ").append(userName).append("/").append(ipAddress).toString());
            if (!this.fe().isAdministrator(userName)) {
                throw new ForbiddenException(new java.lang.StringBuilder(41).append(userName).append(" is not allowed to list all live sessions").toString());
            }
            sessions = this.fe().be().sessionManager().allSessions();
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{sessionType})) {
                sessions = (Iterable)sessions.filter((Function1 & Serializable & scala.Serializable)session -> BoxesRunTime.boxToBoolean((boolean)sessionType.equals(((KyuubiSession)session).sessionType().toString())));
            }
            if (!StringUtils.isNotBlank((CharSequence)users)) break block2;
            Set usersSet = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])users.split(","))).toSet();
            sessions = (Iterable)sessions.filter((Function1 & Serializable & scala.Serializable)session -> BoxesRunTime.boxToBoolean((boolean)usersSet.contains((Object)session.user())));
        }
        return ((TraversableOnce)sessions.map((Function1 & Serializable & scala.Serializable)session -> ApiUtils$.MODULE$.sessionData((KyuubiSession)((Object)session)), Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="Close a session")
    @DELETE
    @Path(value="sessions/{sessionHandle}")
    public Response closeSession(@PathParam(value="sessionHandle") String sessionHandleStr) {
        String userName = this.fe().getSessionUser((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
        String ipAddress = this.fe().getIpAddress();
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(41).append("Received closing a session request from ").append(userName).append("/").append(ipAddress).toString());
        if (!this.fe().isAdministrator(userName)) {
            throw new ForbiddenException(new java.lang.StringBuilder(37).append(userName).append(" is not allowed to close the session ").append(sessionHandleStr).toString());
        }
        this.fe().be().closeSession(SessionHandle$.MODULE$.fromUUID(sessionHandleStr));
        return Response.ok((Object)new java.lang.StringBuilder(32).append("Session ").append(sessionHandleStr).append(" is closed successfully.").toString()).build();
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=OperationData.class)))}, description="get the list of all active operations")
    @GET
    @Path(value="operations")
    public Seq<OperationData> listOperations(@QueryParam(value="users") String users, @QueryParam(value="sessionHandle") String sessionHandle, @QueryParam(value="sessionType") String sessionType) {
        Iterable operations;
        block3: {
            String userName = this.fe().getSessionUser((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
            String ipAddress = this.fe().getIpAddress();
            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(60).append("Received listing all of the active operations request from ").append(userName).append("/").append(ipAddress).toString());
            if (!this.fe().isAdministrator(userName)) {
                throw new ForbiddenException(new java.lang.StringBuilder(42).append(userName).append(" is not allowed to list all the operations").toString());
            }
            operations = this.fe().be().sessionManager().operationManager().allOperations();
            if (StringUtils.isNotBlank((CharSequence)users)) {
                Set usersSet = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])users.split(","))).toSet();
                operations = (Iterable)operations.filter((Function1 & Serializable & scala.Serializable)operation -> BoxesRunTime.boxToBoolean((boolean)usersSet.contains((Object)operation.getSession().user())));
            }
            if (StringUtils.isNotBlank((CharSequence)sessionHandle)) {
                operations = (Iterable)operations.filter((Function1 & Serializable & scala.Serializable)operation -> BoxesRunTime.boxToBoolean((boolean)AdminResource.$anonfun$listOperations$3(sessionHandle, operation)));
            }
            if (!StringUtils.isNotBlank((CharSequence)sessionType)) break block3;
            operations = (Iterable)operations.filter((Function1 & Serializable & scala.Serializable)operation -> BoxesRunTime.boxToBoolean((boolean)sessionType.equalsIgnoreCase(((KyuubiSession)operation.getSession()).sessionType().toString())));
        }
        return ((TraversableOnce)operations.map((Function1 & Serializable & scala.Serializable)operation -> ApiUtils$.MODULE$.operationData((KyuubiOperation)((Object)operation)), Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="close an operation")
    @DELETE
    @Path(value="operations/{operationHandle}")
    public Response closeOperation(@PathParam(value="operationHandle") String operationHandleStr) {
        String userName = this.fe().getSessionUser((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
        String ipAddress = this.fe().getIpAddress();
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(42).append("Received close an operation request from ").append(userName).append("/").append(ipAddress).toString());
        if (!this.fe().isAdministrator(userName)) {
            throw new ForbiddenException(new java.lang.StringBuilder(39).append(userName).append(" is not allowed to close the operation ").append(operationHandleStr).toString());
        }
        OperationHandle operationHandle = OperationHandle$.MODULE$.apply(operationHandleStr);
        this.fe().be().closeOperation(operationHandle);
        return Response.ok((Object)new java.lang.StringBuilder(34).append("Operation ").append(operationHandleStr).append(" is closed successfully.").toString()).build();
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="delete kyuubi engine")
    @DELETE
    @Path(value="engine")
    public Response deleteEngine(@QueryParam(value="type") String engineType, @QueryParam(value="sharelevel") String shareLevel, @QueryParam(value="subdomain") String subdomain, @QueryParam(value="proxyUser") String kyuubiProxyUser, @QueryParam(value="hive.server2.proxy.user") String hs2ProxyUser, @QueryParam(value="kill") @DefaultValue(value="false") boolean kill) {
        String activeProxyUser = (String)Option$.MODULE$.apply((Object)kyuubiProxyUser).getOrElse((Function0 & Serializable & scala.Serializable)() -> hs2ProxyUser);
        String userName = this.fe().isAdministrator(this.fe().getRealUser()) ? (String)Option$.MODULE$.apply((Object)activeProxyUser).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.fe().getRealUser()) : this.fe().getSessionUser(activeProxyUser);
        Engine engine = this.normalizeEngineInfo(userName, engineType, shareLevel, subdomain, "default");
        String engineSpace = this.calculateEngineSpace(engine);
        StringBuilder responseMsgBuilder = new StringBuilder();
        DiscoveryClientProvider$.MODULE$.withDiscoveryClient(this.fe().getConf(), (Function1 & Serializable & scala.Serializable)discoveryClient -> {
            AdminResource.$anonfun$deleteEngine$3(this, engineSpace, responseMsgBuilder, kill, discoveryClient);
            return BoxedUnit.UNIT;
        });
        return Response.ok((Object)responseMsgBuilder.toString()).build();
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="list kyuubi engines")
    @GET
    @Path(value="engine")
    public Seq<Engine> listEngines(@QueryParam(value="type") String engineType, @QueryParam(value="sharelevel") String shareLevel, @QueryParam(value="subdomain") String subdomain, @QueryParam(value="proxyUser") String kyuubiProxyUser, @QueryParam(value="hive.server2.proxy.user") String hs2ProxyUser) {
        String activeProxyUser = (String)Option$.MODULE$.apply((Object)kyuubiProxyUser).getOrElse((Function0 & Serializable & scala.Serializable)() -> hs2ProxyUser);
        String userName = this.fe().isAdministrator(this.fe().getRealUser()) ? (String)Option$.MODULE$.apply((Object)activeProxyUser).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.fe().getRealUser()) : this.fe().getSessionUser(activeProxyUser);
        Engine engine = this.normalizeEngineInfo(userName, engineType, shareLevel, subdomain, "");
        String engineSpace = this.calculateEngineSpace(engine);
        ListBuffer engineNodes = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        DiscoveryClientProvider$.MODULE$.withDiscoveryClient(this.fe().getConf(), (Function1 & Serializable & scala.Serializable)discoveryClient -> {
            boolean bl = false;
            Option option = null;
            Option option2 = Option$.MODULE$.apply((Object)subdomain).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AdminResource.$anonfun$listEngines$4(x$1)));
            if (option2 instanceof Some) {
                this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(27).append("Listing engine nodes under ").append(engineSpace).toString());
                return engineNodes.$plus$plus$eq((TraversableOnce)discoveryClient.getServiceNodesInfo(engineSpace, discoveryClient.getServiceNodesInfo$default$2(), discoveryClient.getServiceNodesInfo$default$3()));
            }
            if (None$.MODULE$.equals(option2)) {
                bl = true;
                option = option2;
                if (discoveryClient.pathNonExists(engineSpace, discoveryClient.pathNonExists$default$2())) {
                    this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(71).append("Path ").append(engineSpace).append(" does not exist. user: ").append(userName).append(", engine type: ").append(engineType).append(", ").append("share level: ").append(shareLevel).append(", subdomain: ").append(subdomain).toString());
                    return BoxedUnit.UNIT;
                }
            }
            if (bl) {
                return discoveryClient.getChildren(engineSpace).map((Function1 & Serializable & scala.Serializable)child -> {
                    this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(28).append("Listing engine nodes under ").append(engineSpace).append("/").append((String)child).toString());
                    return engineNodes.$plus$plus$eq((TraversableOnce)discoveryClient.getServiceNodesInfo(new java.lang.StringBuilder(1).append(engineSpace).append("/").append((String)child).toString(), discoveryClient.getServiceNodesInfo$default$2(), discoveryClient.getServiceNodesInfo$default$3()));
                }, List$.MODULE$.canBuildFrom());
            }
            throw new MatchError((Object)option2);
        });
        return ((ListBuffer)engineNodes.map((Function1 & Serializable & scala.Serializable)node -> new Engine(engine.getVersion(), engine.getUser(), engine.getEngineType(), engine.getSharelevel(), (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])node.namespace().split("/"))).last(), node.instance(), node.namespace(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)node.attributes()).asJava()), ListBuffer$.MODULE$.canBuildFrom())).toSeq();
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=OperationData.class)))}, description="list all live kyuubi servers")
    @GET
    @Path(value="server")
    public Seq<ServerData> listServers() {
        String userName = this.fe().getSessionUser((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
        String ipAddress = this.fe().getIpAddress();
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(52).append("Received list all live kyuubi servers request from ").append(userName).append("/").append(ipAddress).toString());
        if (!this.fe().isAdministrator(userName)) {
            throw new ForbiddenException(new java.lang.StringBuilder(47).append(userName).append(" is not allowed to list all live kyuubi servers").toString());
        }
        KyuubiConf kyuubiConf = this.fe().getConf();
        ListBuffer servers = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        String serverSpec = DiscoveryPaths$.MODULE$.makePath(null, (String)kyuubiConf.get(HighAvailabilityConf$.MODULE$.HA_NAMESPACE()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        DiscoveryClientProvider$.MODULE$.withDiscoveryClient(kyuubiConf, (Function1 & Serializable & scala.Serializable)discoveryClient -> (Seq)discoveryClient.getServiceNodesInfo(serverSpec, discoveryClient.getServiceNodesInfo$default$2(), discoveryClient.getServiceNodesInfo$default$3()).map((Function1 & Serializable & scala.Serializable)nodeInfo -> servers.$plus$eq((Object)ApiUtils$.MODULE$.serverData((ServiceNodeInfo)nodeInfo)), Seq$.MODULE$.canBuildFrom()));
        return servers.toSeq();
    }

    private Engine normalizeEngineInfo(String userName, String engineType, String shareLevel, String subdomain, String subdomainDefault) {
        KyuubiConf clonedConf = this.fe().getConf().clone();
        Option$.MODULE$.apply((Object)engineType).foreach((Function1 & Serializable & scala.Serializable)x$2 -> clonedConf.set(KyuubiConf$.MODULE$.ENGINE_TYPE(), x$2));
        Option$.MODULE$.apply((Object)subdomain).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AdminResource.$anonfun$normalizeEngineInfo$2(x$3))).foreach((Function1 & Serializable & scala.Serializable)x$4 -> clonedConf.set(KyuubiConf$.MODULE$.ENGINE_SHARE_LEVEL_SUBDOMAIN(), (Object)Option$.MODULE$.apply((Object)subdomain)));
        Option$.MODULE$.apply((Object)shareLevel).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)AdminResource.$anonfun$normalizeEngineInfo$4(x$5))).foreach((Function1 & Serializable & scala.Serializable)x$6 -> clonedConf.set(KyuubiConf$.MODULE$.ENGINE_SHARE_LEVEL(), x$6));
        String serverSpace = (String)clonedConf.get(HighAvailabilityConf$.MODULE$.HA_NAMESPACE());
        String normalizedEngineType = (String)clonedConf.get(KyuubiConf$.MODULE$.ENGINE_TYPE());
        String engineSubdomain = (String)((Option)clonedConf.get(KyuubiConf$.MODULE$.ENGINE_SHARE_LEVEL_SUBDOMAIN())).getOrElse((Function0 & Serializable & scala.Serializable)() -> subdomainDefault);
        String engineShareLevel = (String)clonedConf.get(KyuubiConf$.MODULE$.ENGINE_SHARE_LEVEL());
        return new Engine(package$.MODULE$.KYUUBI_VERSION(), userName, normalizedEngineType, engineShareLevel, engineSubdomain, null, serverSpace, Collections.emptyMap());
    }

    private String calculateEngineSpace(Engine engine) {
        String string = engine.getSharelevel();
        String userOrGroup = "GROUP".equals(string) ? this.fe().sessionManager().groupProvider().primaryGroup(engine.getUser(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)this.fe().getConf().getAll()).asJava()) : engine.getUser();
        String engineSpace = new java.lang.StringBuilder(3).append(engine.getNamespace()).append("_").append(engine.getVersion()).append("_").append(engine.getSharelevel()).append("_").append(engine.getEngineType()).toString();
        return DiscoveryPaths$.MODULE$.makePath(engineSpace, userOrGroup, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{engine.getSubdomain()}));
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=Count.class))}, description="get the batch count")
    @GET
    @Path(value="batch/count")
    public Count countBatch(@QueryParam(value="batchType") @DefaultValue(value="SPARK") String batchType, @QueryParam(value="batchUser") String batchUser, @QueryParam(value="batchState") String batchState) {
        String userName = this.fe().getSessionUser((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
        String ipAddress = this.fe().getIpAddress();
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(40).append("Received counting batches request from ").append(userName).append("/").append(ipAddress).toString());
        if (!this.fe().isAdministrator(userName)) {
            throw new ForbiddenException(new java.lang.StringBuilder(36).append(userName).append(" is not allowed to count the batches").toString());
        }
        int batchCount = BoxesRunTime.unboxToInt((Object)this.fe().batchService().map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.countBatch(batchType, (Option<String>)Option$.MODULE$.apply((Object)batchUser), (Option<String>)Option$.MODULE$.apply((Object)batchState), x$7.countBatch$default$4()))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        return new Count(Predef$.MODULE$.int2Integer(batchCount));
    }

    public static final /* synthetic */ boolean $anonfun$listOperations$3(String sessionHandle$1, Operation operation) {
        return operation.getSession().handle().equals((Object)SessionHandle$.MODULE$.fromUUID(sessionHandle$1));
    }

    public static final /* synthetic */ void $anonfun$deleteEngine$3(AdminResource $this, String engineSpace$1, StringBuilder responseMsgBuilder$1, boolean kill$1, DiscoveryClient discoveryClient) {
        String x$1 = engineSpace$1;
        boolean x$2 = true;
        Option x$3 = discoveryClient.getServiceNodesInfo$default$2();
        Seq engineNodes = discoveryClient.getServiceNodesInfo(x$1, x$3, x$2);
        engineNodes.foreach((Function1 & Serializable & scala.Serializable)engineNode -> {
            String nodePath = new java.lang.StringBuilder(1).append(engineSpace$1).append("/").append(engineNode.nodeName()).toString();
            String engineRefId = (String)engineNode.engineRefId().orNull(Predef$.MODULE$.$conforms());
            $this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(21).append("Deleting engine node:").append(nodePath).toString());
            try {
                discoveryClient.delete(nodePath, discoveryClient.delete$default$2());
                responseMsgBuilder$1.append(new java.lang.StringBuilder(39).append("Engine ").append(engineSpace$1).append(" refId=").append(engineRefId).append(" is deleted successfully.").toString());
            }
            catch (Exception e) {
                $this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(29).append("Failed to delete engine node:").append(nodePath).toString(), e);
                throw new NotFoundException(new java.lang.StringBuilder(30).append("Failed to delete engine node:").append(nodePath).append(",").append(e.getMessage()).toString());
            }
            if (kill$1 && engineRefId != null) {
                ApplicationManagerInfo appMgrInfo = (ApplicationManagerInfo)engineNode.attributes().get((Object)"kyuubi.engine.appMgrInfo").map((Function1 & Serializable & scala.Serializable)encodedStr -> ApplicationManagerInfo$.MODULE$.deserialize((String)encodedStr)).getOrElse((Function0 & Serializable & scala.Serializable)() -> new ApplicationManagerInfo((Option<String>)None$.MODULE$, ApplicationManagerInfo$.MODULE$.apply$default$2()));
                KyuubiApplicationManager qual$1 = ((KyuubiSessionManager)$this.fe().be().sessionManager()).applicationManager();
                ApplicationManagerInfo x$4 = appMgrInfo;
                String x$5 = engineRefId;
                Option<String> x$6 = qual$1.killApplication$default$3();
                Tuple2<Object, String> killResponse = qual$1.killApplication(x$4, x$5, x$6);
                return responseMsgBuilder$1.append(new java.lang.StringBuilder(23).append("\nKilled engine with ").append(appMgrInfo).append("/").append(engineRefId).append(": ").append(killResponse).toString());
            }
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$listEngines$4(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$normalizeEngineInfo$2(String x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$normalizeEngineInfo$4(String x$5) {
        return new StringOps(Predef$.MODULE$.augmentString(x$5)).nonEmpty();
    }

    public AdminResource() {
        ApiRequestContext.$init$(this);
        Logging.$init$((Logging)this);
    }
}

