/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shaded.hive.metastore.conf;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.kyuubi.shaded.hive.common.ZooKeeperHiveHelper;
import org.apache.kyuubi.shaded.hive.metastore.conf.SizeValidator;
import org.apache.kyuubi.shaded.hive.metastore.conf.StringSetValidator;
import org.apache.kyuubi.shaded.hive.metastore.conf.TimeValidator;
import org.apache.kyuubi.shaded.hive.metastore.conf.Validator;
import org.apache.kyuubi.shaded.hive.metastore.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetastoreConf {
    private static final Logger LOG = LoggerFactory.getLogger(MetastoreConf.class);
    private static final Pattern TIME_UNIT_SUFFIX = Pattern.compile("([0-9]+)([a-zA-Z]+)");
    private static final Map<String, ConfVars> metaConfs = new HashMap<String, ConfVars>();
    private static volatile URL hiveSiteURL = null;
    private static URL hiveDefaultURL = null;
    private static URL hiveMetastoreSiteURL = null;
    private static URL metastoreSiteURL = null;
    private static AtomicBoolean beenDumped = new AtomicBoolean();
    private static Map<String, ConfVars> keyToVars = new HashMap<String, ConfVars>(ConfVars.values().length * 2);
    static final String TEST_ENV_WORKAROUND = "metastore.testing.env.workaround.dont.ever.set.this.";
    public static final ConfVars[] metaVars;
    private static final ConfVars[] metaConfVars;
    private static final Set<String> unprintables;

    public static ConfVars getMetaConf(String name) {
        return metaConfs.get(name);
    }

    private MetastoreConf() {
        throw new RuntimeException("You should never be creating one of these!");
    }

    public static Configuration newMetastoreConf() {
        return MetastoreConf.newMetastoreConf(new Configuration());
    }

    public static Configuration newMetastoreConf(Configuration conf) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = MetastoreConf.class.getClassLoader();
        }
        hiveDefaultURL = classLoader.getResource("hive-default.xml");
        if (hiveSiteURL == null) {
            hiveSiteURL = MetastoreConf.findConfigFile(classLoader, "hive-site.xml");
        }
        if (hiveSiteURL != null) {
            conf.addResource(hiveSiteURL);
        }
        if ((hiveMetastoreSiteURL = MetastoreConf.findConfigFile(classLoader, "hivemetastore-site.xml")) != null) {
            conf.addResource(hiveMetastoreSiteURL);
        }
        if ((metastoreSiteURL = MetastoreConf.findConfigFile(classLoader, "metastore-site.xml")) != null) {
            conf.addResource(metastoreSiteURL);
        }
        for (ConfVars var : ConfVars.values()) {
            if (System.getProperty(var.varname) == null) continue;
            LOG.debug("Setting conf value " + var.varname + " using value " + System.getProperty(var.varname));
            conf.set(var.varname, System.getProperty(var.varname));
        }
        System.getProperties().stringPropertyNames().stream().filter(s -> s.startsWith("hive.")).forEach(s -> {
            String v = System.getProperty(s);
            LOG.debug("Picking up system property " + s + " with value " + v);
            conf.set(s, v);
        });
        if (!beenDumped.getAndSet(true) && MetastoreConf.getBoolVar(conf, ConfVars.DUMP_CONFIG_ON_CREATION) && LOG.isDebugEnabled()) {
            LOG.debug(MetastoreConf.dumpConfig(conf));
        }
        for (ConfVars var : ConfVars.values()) {
            if (var.deprecatedName != null) {
                Configuration.addDeprecation((String)var.getVarname(), (String)var.deprecatedName);
            }
            if (var.hiveDeprecatedName == null) continue;
            Configuration.addDeprecation((String)var.getHiveName(), (String)var.hiveDeprecatedName);
        }
        return conf;
    }

    private static URL findConfigFile(ClassLoader classLoader, String name) {
        URL result = classLoader.getResource(name);
        if (result == null) {
            result = MetastoreConf.seeIfConfAtThisLocation("METASTORE_CONF_DIR", name, false);
        }
        if (result == null) {
            result = MetastoreConf.seeIfConfAtThisLocation("METASTORE_HOME", name, true);
        }
        if (result == null) {
            result = MetastoreConf.seeIfConfAtThisLocation("HIVE_CONF_DIR", name, false);
        }
        if (result == null) {
            result = MetastoreConf.seeIfConfAtThisLocation("HIVE_HOME", name, true);
        }
        if (result == null) {
            URI jarUri = null;
            try {
                jarUri = MetastoreConf.class.getProtectionDomain().getCodeSource().getLocation().toURI();
            }
            catch (Throwable e) {
                LOG.warn("Cannot get jar URI", e);
            }
            if (jarUri != null) {
                result = MetastoreConf.seeIfConfAtThisLocation(new File(jarUri).getParent(), name, true);
            }
        }
        if (result == null) {
            LOG.info("Unable to find config file: " + name);
        } else {
            LOG.info("Found configuration file: " + result);
        }
        return result;
    }

    private static URL seeIfConfAtThisLocation(String envVar, String name, boolean inConfDir) {
        String path = System.getenv(envVar);
        if (path == null) {
            path = System.getProperty(TEST_ENV_WORKAROUND + envVar);
        }
        if (path != null) {
            String suffix = inConfDir ? "conf" + File.separatorChar + name : name;
            return MetastoreConf.checkConfigFile(new File(path, suffix));
        }
        return null;
    }

    private static URL checkConfigFile(File f) {
        try {
            return f.exists() && f.isFile() ? f.toURI().toURL() : null;
        }
        catch (Throwable e) {
            LOG.warn("Error looking for config " + f, e);
            return null;
        }
    }

    public static String getVar(Configuration conf, ConfVars var) {
        assert (var.defaultVal.getClass() == String.class);
        String val = conf.get(var.varname);
        return val == null ? conf.get(var.hiveName, (String)var.defaultVal) : val;
    }

    public static String getVar(Configuration conf, ConfVars var, String defaultVal) {
        assert (var.defaultVal.getClass() == String.class);
        String val = conf.get(var.varname);
        return val == null ? conf.get(var.hiveName, defaultVal) : val;
    }

    public static Collection<String> getStringCollection(Configuration conf, ConfVars var) {
        assert (var.defaultVal.getClass() == String.class);
        String val = conf.get(var.varname);
        if (val == null) {
            val = conf.get(var.hiveName, (String)var.defaultVal);
        }
        if (val == null) {
            return Collections.emptySet();
        }
        return StringUtils.asSet(val.split(","));
    }

    public static void setVar(Configuration conf, ConfVars var, String val) {
        assert (var.defaultVal.getClass() == String.class);
        conf.set(var.varname, val);
    }

    public static int getIntVar(Configuration conf, ConfVars var) {
        long val = MetastoreConf.getLongVar(conf, var);
        assert (val <= Integer.MAX_VALUE);
        return (int)val;
    }

    public static long getLongVar(Configuration conf, ConfVars var) {
        assert (var.defaultVal.getClass() == Long.class);
        String val = conf.get(var.varname);
        return val == null ? conf.getLong(var.hiveName, ((Long)var.defaultVal).longValue()) : Long.parseLong(val);
    }

    public static void setLongVar(Configuration conf, ConfVars var, long val) {
        assert (var.defaultVal.getClass() == Long.class);
        conf.setLong(var.varname, val);
    }

    public static boolean getBoolVar(Configuration conf, ConfVars var) {
        assert (var.defaultVal.getClass() == Boolean.class);
        String val = conf.get(var.varname);
        return val == null ? conf.getBoolean(var.hiveName, ((Boolean)var.defaultVal).booleanValue()) : Boolean.valueOf(val).booleanValue();
    }

    public static String[] getTrimmedStringsVar(Configuration conf, ConfVars var) {
        assert (var.defaultVal.getClass() == String.class);
        String[] result = conf.getTrimmedStrings(var.varname, (String[])null);
        if (result != null) {
            return result;
        }
        if (var.hiveName != null && (result = conf.getTrimmedStrings(var.hiveName, (String[])null)) != null) {
            return result;
        }
        return org.apache.hadoop.util.StringUtils.getTrimmedStrings((String)((String)var.getDefaultVal()));
    }

    public static void setBoolVar(Configuration conf, ConfVars var, boolean val) {
        assert (var.defaultVal.getClass() == Boolean.class);
        conf.setBoolean(var.varname, val);
    }

    public static double getDoubleVar(Configuration conf, ConfVars var) {
        assert (var.defaultVal.getClass() == Double.class);
        String val = conf.get(var.varname);
        return val == null ? conf.getDouble(var.hiveName, ((Double)var.defaultVal).doubleValue()) : Double.valueOf(val).doubleValue();
    }

    public static void setDoubleVar(Configuration conf, ConfVars var, double val) {
        assert (var.defaultVal.getClass() == Double.class);
        conf.setDouble(var.varname, val);
    }

    public static long getSizeVar(Configuration conf, ConfVars var) {
        return SizeValidator.toSizeBytes(MetastoreConf.getVar(conf, var));
    }

    public static <I> Class<? extends I> getClass(Configuration conf, ConfVars var, Class<? extends I> defaultValue, Class<I> xface) {
        assert (var.defaultVal.getClass() == String.class);
        String val = conf.get(var.varname);
        return val == null ? conf.getClass(var.hiveName, defaultValue, xface) : conf.getClass(var.varname, defaultValue, xface);
    }

    public static <I> void setClass(Configuration conf, ConfVars var, Class<? extends I> theClass, Class<I> xface) {
        assert (var.defaultVal.getClass() == String.class);
        conf.setClass(var.varname, theClass, xface);
    }

    public static long getTimeVar(Configuration conf, ConfVars var, TimeUnit outUnit) {
        assert (var.defaultVal.getClass() == TimeValue.class);
        String val = conf.get(var.varname);
        if (val == null) {
            val = conf.get(var.hiveName);
        }
        if (val != null) {
            return MetastoreConf.convertTimeStr(val, ((TimeValue)((ConfVars)var).defaultVal).unit, outUnit);
        }
        return outUnit.convert(((TimeValue)((ConfVars)var).defaultVal).val, ((TimeValue)((ConfVars)var).defaultVal).unit);
    }

    public static void setTimeVar(Configuration conf, ConfVars var, long duration, TimeUnit unit) {
        assert (var.defaultVal.getClass() == TimeValue.class);
        conf.setTimeDuration(var.varname, duration, unit);
    }

    public static long convertTimeStr(String val, TimeUnit defaultUnit, TimeUnit outUnit) {
        if (val.charAt(val.length() - 1) >= 'A') {
            Matcher m = TIME_UNIT_SUFFIX.matcher(val);
            if (m.matches()) {
                long duration = Long.parseLong(m.group(1));
                String unit = m.group(2).toLowerCase();
                if (unit.equals("s") || unit.startsWith("sec")) {
                    return outUnit.convert(duration, TimeUnit.SECONDS);
                }
                if (unit.equals("ms") || unit.startsWith("msec")) {
                    return outUnit.convert(duration, TimeUnit.MILLISECONDS);
                }
                if (unit.equals("m") || unit.startsWith("min")) {
                    return outUnit.convert(duration, TimeUnit.MINUTES);
                }
                if (unit.equals("us") || unit.startsWith("usec")) {
                    return outUnit.convert(duration, TimeUnit.MICROSECONDS);
                }
                if (unit.equals("ns") || unit.startsWith("nsec")) {
                    return outUnit.convert(duration, TimeUnit.NANOSECONDS);
                }
                if (unit.equals("h") || unit.startsWith("hour")) {
                    return outUnit.convert(duration, TimeUnit.HOURS);
                }
                if (unit.equals("d") || unit.startsWith("day")) {
                    return outUnit.convert(duration, TimeUnit.DAYS);
                }
                throw new IllegalArgumentException("Invalid time unit " + unit);
            }
            throw new IllegalArgumentException("Invalid time unit " + val);
        }
        return outUnit.convert(Long.parseLong(val), defaultUnit);
    }

    static String timeAbbreviationFor(TimeUnit timeunit) {
        switch (timeunit) {
            case DAYS: {
                return "d";
            }
            case HOURS: {
                return "h";
            }
            case MINUTES: {
                return "m";
            }
            case SECONDS: {
                return "s";
            }
            case MILLISECONDS: {
                return "ms";
            }
            case MICROSECONDS: {
                return "us";
            }
            case NANOSECONDS: {
                return "ns";
            }
        }
        throw new IllegalArgumentException("Invalid timeunit " + (Object)((Object)timeunit));
    }

    public static String getPassword(Configuration conf, ConfVars var) throws IOException {
        assert (var.defaultVal.getClass() == String.class);
        char[] pw = conf.getPassword(var.varname);
        if (pw == null) {
            pw = conf.getPassword(var.hiveName);
        }
        return pw == null ? var.defaultVal.toString() : new String(pw);
    }

    public static String get(Configuration conf, String key) {
        ConfVars var = keyToVars.get(key);
        if (var == null) {
            return conf.get(key);
        }
        String val = conf.get(var.varname);
        return val == null ? conf.get(var.hiveName, var.defaultVal.toString()) : val;
    }

    public static boolean isPrintable(String key) {
        return !unprintables.contains(key);
    }

    public static String getAsString(Configuration conf, ConfVars var) {
        if (var.defaultVal.getClass() == String.class) {
            return MetastoreConf.getVar(conf, var);
        }
        if (var.defaultVal.getClass() == Boolean.class) {
            return Boolean.toString(MetastoreConf.getBoolVar(conf, var));
        }
        if (var.defaultVal.getClass() == Long.class) {
            return Long.toString(MetastoreConf.getLongVar(conf, var));
        }
        if (var.defaultVal.getClass() == Double.class) {
            return Double.toString(MetastoreConf.getDoubleVar(conf, var));
        }
        if (var.defaultVal.getClass() == TimeValue.class) {
            TimeUnit timeUnit = ((TimeValue)((ConfVars)var).defaultVal).unit;
            return MetastoreConf.getTimeVar(conf, var, timeUnit) + MetastoreConf.timeAbbreviationFor(timeUnit);
        }
        throw new RuntimeException("Unknown type for getObject " + var.defaultVal.getClass().getName());
    }

    public static URL getHiveDefaultLocation() {
        return hiveDefaultURL;
    }

    public static URL getHiveSiteLocation() {
        return hiveSiteURL;
    }

    public static URL getHiveMetastoreSiteURL() {
        return hiveMetastoreSiteURL;
    }

    public static URL getMetastoreSiteURL() {
        return metastoreSiteURL;
    }

    public List<URL> getResourceFileLocations() {
        return Arrays.asList(hiveSiteURL, hiveMetastoreSiteURL, metastoreSiteURL);
    }

    public static boolean isEmbeddedMetaStore(String msUri) {
        return msUri == null || msUri.trim().isEmpty();
    }

    public static ZooKeeperHiveHelper getZKConfig(Configuration conf) {
        return ZooKeeperHiveHelper.builder().quorum(MetastoreConf.getVar(conf, ConfVars.THRIFT_URIS)).clientPort(MetastoreConf.getVar(conf, ConfVars.THRIFT_ZOOKEEPER_CLIENT_PORT)).serverRegistryNameSpace(MetastoreConf.getVar(conf, ConfVars.THRIFT_ZOOKEEPER_NAMESPACE)).connectionTimeout((int)MetastoreConf.getTimeVar(conf, ConfVars.THRIFT_ZOOKEEPER_CONNECTION_TIMEOUT, TimeUnit.MILLISECONDS)).sessionTimeout((int)MetastoreConf.getTimeVar(conf, ConfVars.THRIFT_ZOOKEEPER_SESSION_TIMEOUT, TimeUnit.MILLISECONDS)).baseSleepTime((int)MetastoreConf.getTimeVar(conf, ConfVars.THRIFT_ZOOKEEPER_CONNECTION_BASESLEEPTIME, TimeUnit.MILLISECONDS)).maxRetries(MetastoreConf.getIntVar(conf, ConfVars.THRIFT_ZOOKEEPER_CONNECTION_MAX_RETRIES)).build();
    }

    static String dumpConfig(Configuration conf) {
        StringBuilder buf = new StringBuilder("MetastoreConf object:\n");
        if (hiveSiteURL != null) {
            buf.append("Used hive-site file: ").append(hiveSiteURL).append('\n');
        }
        if (hiveMetastoreSiteURL != null) {
            buf.append("Used hivemetastore-site file: ").append(hiveMetastoreSiteURL).append('\n');
        }
        if (metastoreSiteURL != null) {
            buf.append("Used metastore-site file: ").append(metastoreSiteURL).append('\n');
        }
        for (ConfVars var : ConfVars.values()) {
            if (unprintables.contains(var.varname)) continue;
            buf.append("Key: <").append(var.varname).append("> old hive key: <").append(var.hiveName).append(">  value: <").append(MetastoreConf.getAsString(conf, var)).append(">\n");
        }
        buf.append("Finished MetastoreConf object.\n");
        return buf.toString();
    }

    public static char[] getValueFromKeystore(String keystorePath, String key) throws IOException {
        char[] valueCharArray = null;
        if (keystorePath != null && key != null) {
            Configuration conf = new Configuration();
            conf.set("hadoop.security.credential.provider.path", keystorePath);
            valueCharArray = conf.getPassword(key);
        }
        return valueCharArray;
    }

    static {
        for (ConfVars var : ConfVars.values()) {
            keyToVars.put(var.varname, var);
            keyToVars.put(var.hiveName, var);
        }
        metaVars = new ConfVars[]{ConfVars.THRIFT_URIS, ConfVars.THRIFT_ZOOKEEPER_CLIENT_PORT, ConfVars.THRIFT_ZOOKEEPER_NAMESPACE, ConfVars.THRIFT_CONNECTION_RETRIES, ConfVars.THRIFT_FAILURE_RETRIES, ConfVars.CLIENT_CONNECT_RETRY_DELAY, ConfVars.CLIENT_SOCKET_TIMEOUT, ConfVars.CLIENT_SOCKET_LIFETIME, ConfVars.KERBEROS_PRINCIPAL, ConfVars.USE_THRIFT_SASL, ConfVars.METASTORE_CLIENT_AUTH_MODE, ConfVars.METASTORE_CLIENT_PLAIN_USERNAME};
        metaConfVars = new ConfVars[]{ConfVars.CLIENT_SOCKET_TIMEOUT};
        for (ConfVars confVar : metaConfVars) {
            metaConfs.put(confVar.varname, confVar);
            metaConfs.put(confVar.hiveName, confVar);
        }
        unprintables = StringUtils.asSet(ConfVars.SSL_KEYSTORE_PASSWORD.varname, ConfVars.SSL_KEYSTORE_PASSWORD.hiveName, ConfVars.SSL_TRUSTSTORE_PASSWORD.varname, ConfVars.SSL_TRUSTSTORE_PASSWORD.hiveName);
    }

    public static enum ConfVars {
        CLIENT_CONNECT_RETRY_DELAY("metastore.client.connect.retry.delay", "hive.metastore.client.connect.retry.delay", 1L, TimeUnit.SECONDS, "Number of seconds for the client to wait between consecutive connection attempts"),
        CLIENT_KERBEROS_PRINCIPAL("metastore.client.kerberos.principal", "hive.metastore.client.kerberos.principal", "", "The Kerberos principal associated with the HA cluster of hcat_servers."),
        CLIENT_SOCKET_LIFETIME("metastore.client.socket.lifetime", "hive.metastore.client.socket.lifetime", 0L, TimeUnit.SECONDS, "MetaStore Client socket lifetime in seconds. After this time is exceeded, client\nreconnects on the next MetaStore operation. A value of 0s means the connection\nhas an infinite lifetime."),
        CLIENT_SOCKET_TIMEOUT("metastore.client.socket.timeout", "hive.metastore.client.socket.timeout", 600L, TimeUnit.SECONDS, "MetaStore Client socket timeout in seconds"),
        CLIENT_CONNECTION_TIMEOUT("metastore.client.connection.timeout", "hive.metastore.client.connection.timeout", 600L, TimeUnit.SECONDS, "MetaStore Client connection timeout in seconds"),
        DUMP_CONFIG_ON_CREATION("metastore.dump.config.on.creation", "metastore.dump.config.on.creation", true, "If true, a printout of the config file (minus sensitive values) will be dumped to the log whenever newMetastoreConf() is called.  Can produce a lot of logs"),
        KERBEROS_PRINCIPAL("metastore.kerberos.principal", "hive.metastore.kerberos.principal", "hive-metastore/_HOST@EXAMPLE.COM", "The service principal for the metastore Thrift server. \nThe special string _HOST will be replaced automatically with the correct host name."),
        SSL_KEYSTORE_PASSWORD("metastore.keystore.password", "hive.metastore.keystore.password", "", "Metastore SSL certificate keystore password."),
        SSL_TRUSTSTORE_PATH("metastore.truststore.path", "hive.metastore.truststore.path", "", "Metastore SSL certificate truststore location."),
        SSL_TRUSTSTORE_PASSWORD("metastore.truststore.password", "hive.metastore.truststore.password", "", "Metastore SSL certificate truststore password."),
        SSL_TRUSTSTORE_TYPE("metastore.truststore.type", "hive.metastore.truststore.type", "", "Metastore SSL certificate truststore type."),
        SSL_TRUSTMANAGERFACTORY_ALGORITHM("metastore.trustmanagerfactory.algorithm", "hive.metastore.trustmanagerfactory.algorithm", "", "Metastore SSL certificate truststore algorithm."),
        THRIFT_TRANSPORT_MODE("metastore.server.thrift.transport.mode", "hive.metastore.server.thrift.transport.mode", "binary", "Transport mode for thrift server in Metastore. Can be binary or http"),
        THRIFT_HTTP_PATH("metastore.server.thrift.http.path", "hive.metastore.server.thrift.http.path", "metastore", "Path component of URL endpoint when in HTTP mode"),
        THRIFT_CONNECTION_RETRIES("metastore.connect.retries", "hive.metastore.connect.retries", 3L, "Number of retries while opening a connection to metastore"),
        THRIFT_FAILURE_RETRIES("metastore.failure.retries", "hive.metastore.failure.retries", 1L, "Number of retries upon failure of Thrift metastore calls"),
        THRIFT_URIS("metastore.thrift.uris", "hive.metastore.uris", "", "URIs Used by metastore client to connect to remotemetastore\n.If dynamic service discovery mode is set, the URIs are used to connect to the corresponding service discovery servers e.g. a zookeeper. Otherwise they are used as URIs for remote metastore."),
        THRIFT_METASTORE_CLIENT_MAX_MESSAGE_SIZE("metastore.thrift.client.max.message.size", "hive.thrift.client.max.message.size", "1gb", (Validator)new SizeValidator(-1L, true, Integer.MAX_VALUE, true), "Thrift client configuration for max message size. 0 or -1 will use the default defined in the Thrift library. The upper limit is 2147483648 bytes (or 2gb)."),
        THRIFT_SERVICE_DISCOVERY_MODE("metastore.service.discovery.mode", "hive.metastore.service.discovery.mode", "", "Specifies which dynamic service discovery method to use. Currently we support only \"zookeeper\" to specify ZooKeeper based service discovery."),
        THRIFT_ZOOKEEPER_CLIENT_PORT("metastore.zookeeper.client.port", "hive.zookeeper.client.port", "2181", "The port of ZooKeeper servers to talk to.\nIf the list of Zookeeper servers specified in hive.metastore.thrift.uris does not contain port numbers, this value is used."),
        THRIFT_ZOOKEEPER_SESSION_TIMEOUT("metastore.zookeeper.session.timeout", "hive.zookeeper.session.timeout", 120000L, TimeUnit.MILLISECONDS, new TimeValidator(TimeUnit.MILLISECONDS), "ZooKeeper client's session timeout (in milliseconds). The client is disconnected\nif a heartbeat is not sent in the timeout."),
        THRIFT_ZOOKEEPER_CONNECTION_TIMEOUT("metastore.zookeeper.connection.timeout", "hive.zookeeper.connection.timeout", 15L, TimeUnit.SECONDS, new TimeValidator(TimeUnit.SECONDS), "ZooKeeper client's connection timeout in seconds. Connection timeout * hive.metastore.zookeeper.connection.max.retries\nwith exponential backoff is when curator client deems connection is lost to zookeeper."),
        THRIFT_ZOOKEEPER_NAMESPACE("metastore.zookeeper.namespace", "hive.zookeeper.namespace", "hive_metastore", "The parent node under which all ZooKeeper nodes for metastores are created."),
        THRIFT_ZOOKEEPER_CONNECTION_MAX_RETRIES("metastore.zookeeper.connection.max.retries", "hive.zookeeper.connection.max.retries", 3L, "Max number of times to retry when connecting to the ZooKeeper server."),
        THRIFT_ZOOKEEPER_CONNECTION_BASESLEEPTIME("metastore.zookeeper.connection.basesleeptime", "hive.zookeeper.connection.basesleeptime", 1000L, TimeUnit.MILLISECONDS, new TimeValidator(TimeUnit.MILLISECONDS), "Initial amount of time (in milliseconds) to wait between retries\nwhen connecting to the ZooKeeper server when using ExponentialBackoffRetry policy."),
        THRIFT_URI_SELECTION("metastore.thrift.uri.selection", "hive.metastore.uri.selection", "RANDOM", (Validator)new StringSetValidator("RANDOM", "SEQUENTIAL"), "Determines the selection mechanism used by metastore client to connect to remote metastore.  SEQUENTIAL implies that the first valid metastore from the URIs specified through hive.metastore.uris will be picked.  RANDOM implies that the metastore will be picked randomly"),
        TOKEN_SIGNATURE("metastore.token.signature", "hive.metastore.token.signature", "", "The delegation token service name to match when selecting a token from the current user's tokens."),
        URI_RESOLVER("metastore.uri.resolver", "hive.metastore.uri.resolver", "", "If set, fully qualified class name of resolver for hive metastore uri's"),
        METASTORE_CLIENT_THRIFT_TRANSPORT_MODE("metastore.client.thrift.transport.mode", "hive.metastore.client.thrift.transport.mode", "binary", "Transport mode to be used by the metastore client. It should be the same as " + (Object)((Object)THRIFT_TRANSPORT_MODE)),
        USE_SSL("metastore.use.SSL", "hive.metastore.use.SSL", false, "Set this to true for using SSL encryption in HMS server."),
        USE_THRIFT_SASL("metastore.sasl.enabled", "hive.metastore.sasl.enabled", false, "If true, the metastore Thrift interface will be secured with SASL. Clients must authenticate with Kerberos."),
        METASTORE_CLIENT_AUTH_MODE("metastore.client.auth.mode", "hive.metastore.client.auth.mode", "NOSASL", (Validator)new StringSetValidator("NOSASL", "PLAIN", "KERBEROS", "JWT"), "If PLAIN, clients will authenticate using plain authentication, by providing username and password. Any other value is ignored right now but may be used later.If JWT- Supported only in HTTP transport mode. If set, HMS Client will pick the value of JWT from environment variable HMS_JWT and set it in Authorization header in http request"),
        METASTORE_CLIENT_ADDITIONAL_HEADERS("metastore.client.http.additional.headers", "hive.metastore.client.http.additional.headers", "", "Comma separated list of headers which are passed to the metastore service in the http headers"),
        METASTORE_CLIENT_PLAIN_USERNAME("metastore.client.plain.username", "hive.metastore.client.plain.username", "", "The username used by the metastore client when " + (Object)((Object)METASTORE_CLIENT_AUTH_MODE) + " is true. The password is obtained from " + "hadoop.security.credential.provider.path" + " using username as the alias."),
        USE_THRIFT_FRAMED_TRANSPORT("metastore.thrift.framed.transport.enabled", "hive.metastore.thrift.framed.transport.enabled", false, "If true, the metastore Thrift interface will use TFramedTransport. When false (default) a standard TTransport is used."),
        USE_THRIFT_COMPACT_PROTOCOL("metastore.thrift.compact.protocol.enabled", "hive.metastore.thrift.compact.protocol.enabled", false, "If true, the metastore Thrift interface will use TCompactProtocol. When false (default) TBinaryProtocol will be used.\nSetting it to true will break compatibility with older clients running TBinaryProtocol.");

        private final String varname;
        private final String hiveName;
        private final Object defaultVal;
        private final Validator validator;
        private final boolean caseSensitive;
        private final String description;
        private String deprecatedName = null;
        private String hiveDeprecatedName = null;

        private ConfVars(String varname, String hiveName, String defaultVal, String description) {
            this.varname = varname;
            this.hiveName = hiveName;
            this.defaultVal = defaultVal;
            this.validator = null;
            this.caseSensitive = false;
            this.description = description;
        }

        private ConfVars(String varname, String hiveName, String defaultVal, Validator validator, String description) {
            this.varname = varname;
            this.hiveName = hiveName;
            this.defaultVal = defaultVal;
            this.validator = validator;
            this.caseSensitive = false;
            this.description = description;
        }

        private ConfVars(String varname, String hiveName, String defaultVal, boolean caseSensitive, String description) {
            this.varname = varname;
            this.hiveName = hiveName;
            this.defaultVal = defaultVal;
            this.validator = null;
            this.caseSensitive = caseSensitive;
            this.description = description;
        }

        private ConfVars(String varname, String hiveName, long defaultVal, String description) {
            this.varname = varname;
            this.hiveName = hiveName;
            this.defaultVal = defaultVal;
            this.validator = null;
            this.caseSensitive = false;
            this.description = description;
        }

        private ConfVars(String varname, String hiveName, long defaultVal, Validator validator, String description) {
            this.varname = varname;
            this.hiveName = hiveName;
            this.defaultVal = defaultVal;
            this.validator = validator;
            this.caseSensitive = false;
            this.description = description;
        }

        private ConfVars(String varname, String hiveName, long defaultVal, Validator validator, String description, String deprecatedName, String hiveDeprecatedName) {
            this.varname = varname;
            this.hiveName = hiveName;
            this.defaultVal = defaultVal;
            this.validator = validator;
            this.caseSensitive = false;
            this.description = description;
            this.deprecatedName = deprecatedName;
            this.hiveDeprecatedName = hiveDeprecatedName;
        }

        private ConfVars(String varname, String hiveName, boolean defaultVal, String description) {
            this.varname = varname;
            this.hiveName = hiveName;
            this.defaultVal = defaultVal;
            this.validator = null;
            this.caseSensitive = false;
            this.description = description;
        }

        private ConfVars(String varname, String hiveName, double defaultVal, String description) {
            this.varname = varname;
            this.hiveName = hiveName;
            this.defaultVal = defaultVal;
            this.validator = null;
            this.caseSensitive = false;
            this.description = description;
        }

        private ConfVars(String varname, String hiveName, long defaultVal, TimeUnit unit, String description) {
            this.varname = varname;
            this.hiveName = hiveName;
            this.defaultVal = new TimeValue(defaultVal, unit);
            this.validator = new TimeValidator(unit);
            this.caseSensitive = false;
            this.description = description;
        }

        private ConfVars(String varname, String hiveName, long defaultVal, TimeUnit unit, Validator validator, String description) {
            this.varname = varname;
            this.hiveName = hiveName;
            this.defaultVal = new TimeValue(defaultVal, unit);
            this.validator = validator;
            this.caseSensitive = false;
            this.description = description;
        }

        public void validate(String value) throws IllegalArgumentException {
            if (this.validator != null) {
                this.validator.validate(value);
            }
        }

        public boolean isCaseSensitive() {
            return this.caseSensitive;
        }

        public String getVarname() {
            return this.varname;
        }

        public String getHiveName() {
            return this.hiveName;
        }

        public Object getDefaultVal() {
            return this.defaultVal;
        }

        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return this.varname;
        }
    }

    private static class TimeValue {
        final long val;
        final TimeUnit unit;

        private TimeValue(long val, TimeUnit unit) {
            this.val = val;
            this.unit = unit;
        }

        public String toString() {
            switch (this.unit) {
                case NANOSECONDS: {
                    return Long.toString(this.val) + "ns";
                }
                case MICROSECONDS: {
                    return Long.toString(this.val) + "us";
                }
                case MILLISECONDS: {
                    return Long.toString(this.val) + "ms";
                }
                case SECONDS: {
                    return Long.toString(this.val) + "s";
                }
                case MINUTES: {
                    return Long.toString(this.val) + "m";
                }
                case HOURS: {
                    return Long.toString(this.val) + "h";
                }
                case DAYS: {
                    return Long.toString(this.val) + "d";
                }
            }
            throw new RuntimeException("Unknown time unit " + (Object)((Object)this.unit));
        }
    }
}

