/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.server.metadata;

import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kyuubi.KyuubiException;
import org.apache.kyuubi.KyuubiException$;
import org.apache.kyuubi.client.api.v1.dto.Batch;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.engine.ApplicationInfo;
import org.apache.kyuubi.metrics.MetricsSystem;
import org.apache.kyuubi.metrics.MetricsSystem$;
import org.apache.kyuubi.server.metadata.InsertMetadata;
import org.apache.kyuubi.server.metadata.MetadataManager$;
import org.apache.kyuubi.server.metadata.MetadataManager$$anon$1$;
import org.apache.kyuubi.server.metadata.MetadataRequest;
import org.apache.kyuubi.server.metadata.MetadataRequestsRetryRef;
import org.apache.kyuubi.server.metadata.MetadataStore;
import org.apache.kyuubi.server.metadata.UpdateMetadata;
import org.apache.kyuubi.server.metadata.api.KubernetesEngineInfo;
import org.apache.kyuubi.server.metadata.api.Metadata;
import org.apache.kyuubi.server.metadata.api.MetadataFilter;
import org.apache.kyuubi.server.metadata.api.MetadataFilter$;
import org.apache.kyuubi.service.AbstractService;
import org.apache.kyuubi.session.SessionType$;
import org.apache.kyuubi.util.JdbcUtils$;
import org.apache.kyuubi.util.ThreadUtils$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t-h\u0001B\u00193\u0001uBQ\u0001\u0012\u0001\u0005\u0002\u0015C\u0011\u0002\u0013\u0001A\u0002\u0003\u0007I\u0011B%\t\u00135\u0003\u0001\u0019!a\u0001\n\u0013q\u0005\"C,\u0001\u0001\u0004\u0005\t\u0015)\u0003K\u0011!A\u0006A1A\u0005\u0002IJ\u0006B\u0002:\u0001A\u0003%!\f\u0003\u0005t\u0001\t\u0007I\u0011\u0001\u001au\u0011\u0019a\b\u0001)A\u0005k\"AQ\u0010\u0001EC\u0002\u0013%a\u0010\u0003\u0006\u0002\u0006\u0001A)\u0019!C\u0005\u0003\u000fA!\"a\u0004\u0001\u0011\u000b\u0007I\u0011BA\t\u0011)\tI\u0002\u0001EC\u0002\u0013%\u00111\u0004\u0005\u000b\u0003G\u0001\u0001R1A\u0005\n\u0005\u001d\u0001BCA\u0013\u0001!\u0015\r\u0011\"\u0003\u0002\u0012!9\u0011q\u0005\u0001\u0005B\u0005%\u0002bBA\u001e\u0001\u0011\u0005\u0013Q\b\u0005\b\u0003\u007f\u0001A\u0011IA\u001f\u0011\u001d\t\t\u0005\u0001C\u0005\u0003\u0007Bq!a\u001a\u0001\t#\tI\u0007C\u0004\u0002\u0002\u0002!\t!a!\t\u0013\u0005]\u0005!%A\u0005\u0002\u0005e\u0005bBAX\u0001\u0011\u0005\u0011\u0011\u0017\u0005\b\u0003'\u0004A\u0011AAk\u0011\u001d\tY\u000e\u0001C\u0001\u0003;Dq!!=\u0001\t\u0003\t\u0019\u0010C\u0005\u0003\u0018\u0001\t\n\u0011\"\u0001\u0002\u001a\"9!\u0011\u0004\u0001\u0005\u0002\tm\u0001b\u0002B\u0017\u0001\u0011\u0005!q\u0006\u0005\b\u0005g\u0001A\u0011\u0001B\u001b\u0011\u001d\u0011I\u0004\u0001C\u0001\u0005wAqA!\u0013\u0001\t\u0003\u0011Y\u0005C\u0004\u0003V\u0001!\tAa\u0016\t\u0013\tu\u0003!%A\u0005\u0002\u0005e\u0005b\u0002B0\u0001\u0011\u0005!\u0011\r\u0005\b\u0005[\u0002A\u0011\u0001B8\u0011\u001d\u0011\u0019\b\u0001C\u0001\u0005kBqA!\u001f\u0001\t\u0013\ti\u0004\u0003\u0005\u0003|\u0001!\tA\rB?\u0011\u001d\u0011)\u000b\u0001C\u0001\u0005OCqAa-\u0001\t\u0003\u0011)\fC\u0004\u0003:\u0002!\tAa/\t\u000f\t}\u0006\u0001\"\u0003\u0002>\u001d9!\u0011\u0019\u001a\t\u0002\t\rgAB\u00193\u0011\u0003\u0011)\r\u0003\u0004EY\u0011\u0005!Q\u001b\u0005\b\u0005/dC\u0011\u0001Bm\u0011\u001d\u0011i\u000e\fC\u0001\u0005?DqA!:-\t\u0003\u00119OA\bNKR\fG-\u0019;b\u001b\u0006t\u0017mZ3s\u0015\t\u0019D'\u0001\u0005nKR\fG-\u0019;b\u0015\t)d'\u0001\u0004tKJ4XM\u001d\u0006\u0003oa\naa[=vk\nL'BA\u001d;\u0003\u0019\t\u0007/Y2iK*\t1(A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001}A\u0011qHQ\u0007\u0002\u0001*\u0011\u0011IN\u0001\bg\u0016\u0014h/[2f\u0013\t\u0019\u0005IA\bBEN$(/Y2u'\u0016\u0014h/[2f\u0003\u0019a\u0014N\\5u}Q\ta\t\u0005\u0002H\u00015\t!'\u0001\b`[\u0016$\u0018\rZ1uCN#xN]3\u0016\u0003)\u0003\"aR&\n\u00051\u0013$!D'fi\u0006$\u0017\r^1Ti>\u0014X-\u0001\n`[\u0016$\u0018\rZ1uCN#xN]3`I\u0015\fHCA(V!\t\u00016+D\u0001R\u0015\u0005\u0011\u0016!B:dC2\f\u0017B\u0001+R\u0005\u0011)f.\u001b;\t\u000fY\u001b\u0011\u0011!a\u0001\u0015\u0006\u0019\u0001\u0010J\u0019\u0002\u001f}kW\r^1eCR\f7\u000b^8sK\u0002\n\u0001%\u001b3f]RLg-[3s%\u0016\fX/Z:ug\u0006\u001b\u0018P\\2SKR\u0014\u0018PU3ggV\t!\f\u0005\u0003\\E\u0012|W\"\u0001/\u000b\u0005us\u0016AC2p]\u000e,(O]3oi*\u0011q\fY\u0001\u0005kRLGNC\u0001b\u0003\u0011Q\u0017M^1\n\u0005\rd&!E\"p]\u000e,(O]3oi\"\u000b7\u000f['baB\u0011Q\r\u001c\b\u0003M*\u0004\"aZ)\u000e\u0003!T!!\u001b\u001f\u0002\rq\u0012xn\u001c;?\u0013\tY\u0017+\u0001\u0004Qe\u0016$WMZ\u0005\u0003[:\u0014aa\u0015;sS:<'BA6R!\t9\u0005/\u0003\u0002re\tAR*\u001a;bI\u0006$\u0018MU3rk\u0016\u001cHo\u001d*fiJL(+\u001a4\u0002C%$WM\u001c;jM&,'OU3rk\u0016\u001cHo]!ts:\u001c'+\u001a;ssJ+gm\u001d\u0011\u0002K%$WM\u001c;jM&,'OU3rk\u0016\u001cHo]!ts:\u001c'+\u001a;ss&twmQ8v]R\u001cX#A;\u0011\tm\u0013GM\u001e\t\u0003ojl\u0011\u0001\u001f\u0006\u0003sr\u000ba!\u0019;p[&\u001c\u0017BA>y\u00055\tEo\\7jG&sG/Z4fe\u00061\u0013\u000eZ3oi&4\u0017.\u001a:SKF,Xm\u001d;t\u0003NLhn\u0019*fiJL\u0018N\\4D_VtGo\u001d\u0011\u0002+I,\u0017/^3tiN\u0014V\r\u001e:z\u0013:$XM\u001d<bYV\tq\u0010E\u0002Q\u0003\u0003I1!a\u0001R\u0005\u0011auN\\4\u00023I,\u0017/^3tiN\f5/\u001f8d%\u0016$(/_#oC\ndW\rZ\u000b\u0003\u0003\u0013\u00012\u0001UA\u0006\u0013\r\ti!\u0015\u0002\b\u0005>|G.Z1o\u0003e\u0011X-];fgR\u001c\u0018i]=oGJ+GO]=Ue&<w-\u001a:\u0016\u0005\u0005M\u0001cA.\u0002\u0016%\u0019\u0011q\u0003/\u00031M\u001b\u0007.\u001a3vY\u0016$W\t_3dkR|'oU3sm&\u001cW-\u0001\u000esKF,Xm\u001d;t\u0003NLhn\u0019*fiJLX\t_3dkR|'/\u0006\u0002\u0002\u001eA\u00191,a\b\n\u0007\u0005\u0005BL\u0001\nUQJ,\u0017\r\u001a)p_2,\u00050Z2vi>\u0014\u0018AD2mK\u0006tWM]#oC\ndW\rZ\u0001\u0010[\u0016$\u0018\rZ1uC\u000ecW-\u00198fe\u0006Q\u0011N\\5uS\u0006d\u0017N_3\u0015\u0007=\u000bY\u0003C\u0004\u0002.=\u0001\r!a\f\u0002\t\r|gN\u001a\t\u0005\u0003c\t9$\u0004\u0002\u00024)\u0019\u0011Q\u0007\u001c\u0002\r\r|gNZ5h\u0013\u0011\tI$a\r\u0003\u0015-KX/\u001e2j\u0007>tg-A\u0003ti\u0006\u0014H\u000fF\u0001P\u0003\u0011\u0019Ho\u001c9\u00025]LG\u000f['fi\u0006$\u0017\r^1SKF,Xm\u001d;NKR\u0014\u0018nY:\u0016\t\u0005\u0015\u00131\n\u000b\u0005\u0003\u000f\ni\u0006\u0005\u0003\u0002J\u0005-C\u0002\u0001\u0003\b\u0003\u001b\u0012\"\u0019AA(\u0005\u0005!\u0016\u0003BA)\u0003/\u00022\u0001UA*\u0013\r\t)&\u0015\u0002\b\u001d>$\b.\u001b8h!\r\u0001\u0016\u0011L\u0005\u0004\u00037\n&aA!os\"A\u0011q\f\n\u0005\u0002\u0004\t\t'A\u0003cY>\u001c7\u000eE\u0003Q\u0003G\n9%C\u0002\u0002fE\u0013\u0001\u0002\u00102z]\u0006lWMP\u0001\u0013k:\u0014XmY8wKJ\f'\r\\3E\u0005\u0016\u0013(\u000f\u0006\u0003\u0002\n\u0005-\u0004bBA7'\u0001\u0007\u0011qN\u0001\u0006G\u0006,8/\u001a\t\u0005\u0003c\nYH\u0004\u0003\u0002t\u0005]dbA4\u0002v%\t!+C\u0002\u0002zE\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002~\u0005}$!\u0003+ie><\u0018M\u00197f\u0015\r\tI(U\u0001\u000fS:\u001cXM\u001d;NKR\fG-\u0019;b)\u0015y\u0015QQAJ\u0011\u0019\u0019D\u00031\u0001\u0002\bB!\u0011\u0011RAH\u001b\t\tYIC\u0002\u0002\u000eJ\n1!\u00199j\u0013\u0011\t\t*a#\u0003\u00115+G/\u00193bi\u0006D\u0011\"!&\u0015!\u0003\u0005\r!!\u0003\u0002#\u0005\u001c\u0018P\\2SKR\u0014\u0018p\u00148FeJ|'/\u0001\rj]N,'\u000f^'fi\u0006$\u0017\r^1%I\u00164\u0017-\u001e7uII*\"!a'+\t\u0005%\u0011QT\u0016\u0003\u0003?\u0003B!!)\u0002,6\u0011\u00111\u0015\u0006\u0005\u0003K\u000b9+A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011V)\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002.\u0006\r&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006Aq-\u001a;CCR\u001c\u0007\u000e\u0006\u0003\u00024\u0006=\u0007#\u0002)\u00026\u0006e\u0016bAA\\#\n1q\n\u001d;j_:\u0004B!a/\u0002L6\u0011\u0011Q\u0018\u0006\u0005\u0003\u007f\u000b\t-A\u0002ei>TA!a1\u0002F\u0006\u0011a/\r\u0006\u0005\u0003\u001b\u000b9MC\u0002\u0002JZ\naa\u00197jK:$\u0018\u0002BAg\u0003{\u0013QAQ1uG\"Da!!5\u0017\u0001\u0004!\u0017a\u00022bi\u000eD\u0017\nZ\u0001\u0018O\u0016$()\u0019;dQN+7o]5p]6+G/\u00193bi\u0006$B!a6\u0002ZB)\u0001+!.\u0002\b\"1\u0011\u0011[\fA\u0002\u0011\fAdZ3u\u0017V\u0014WM\u001d8fi\u0016\u001c\u0018\t\u001d9mS\u000e\fG/[8o\u0013:4w\u000e\u0006\u0003\u0002`\u00065\b#\u0002)\u00026\u0006\u0005\b\u0003BAr\u0003Sl!!!:\u000b\u0007\u0005\u001dh'\u0001\u0004f]\u001eLg.Z\u0005\u0005\u0003W\f)OA\bBaBd\u0017nY1uS>t\u0017J\u001c4p\u0011\u0019\ty\u000f\u0007a\u0001I\u0006Q\u0011\u000eZ3oi&4\u0017.\u001a:\u0002\u0015\u001d,GOQ1uG\",7\u000f\u0006\u0006\u0002v\u0006m(Q\u0001B\b\u0005'\u0001b!!\u001d\u0002x\u0006e\u0016\u0002BA}\u0003\u007f\u00121aU3r\u0011\u001d\ti0\u0007a\u0001\u0003\u007f\faAZ5mi\u0016\u0014\b\u0003BAE\u0005\u0003IAAa\u0001\u0002\f\nqQ*\u001a;bI\u0006$\u0018MR5mi\u0016\u0014\bb\u0002B\u00043\u0001\u0007!\u0011B\u0001\u0005MJ|W\u000eE\u0002Q\u0005\u0017I1A!\u0004R\u0005\rIe\u000e\u001e\u0005\b\u0005#I\u0002\u0019\u0001B\u0005\u0003\u0011\u0019\u0018N_3\t\u0013\tU\u0011\u0004%AA\u0002\u0005%\u0011\u0001\u00023fg\u000e\fAcZ3u\u0005\u0006$8\r[3tI\u0011,g-Y;mi\u0012\"\u0014AC2pk:$()\u0019;dQRQ!\u0011\u0002B\u000f\u0005C\u0011)C!\u000b\t\r\t}1\u00041\u0001e\u0003%\u0011\u0017\r^2i)f\u0004X\r\u0003\u0004\u0003$m\u0001\r\u0001Z\u0001\nE\u0006$8\r[+tKJDaAa\n\u001c\u0001\u0004!\u0017A\u00032bi\u000eD7\u000b^1uK\"1!1F\u000eA\u0002\u0011\fab[=vk\nL\u0017J\\:uC:\u001cW-\u0001\fqS\u000e\\')\u0019;dQ\u001a{'oU;c[&$H/\u001b8h)\u0011\t9N!\r\t\r\t-B\u00041\u0001e\u0003Y\u0019\u0017M\\2fYVs7o\u00195fIVdW\r\u001a\"bi\u000eDG\u0003BA\u0005\u0005oAa!!5\u001e\u0001\u0004!\u0017AG4fi\n\u000bGo\u00195fgJ+7m\u001c<feflU\r^1eCR\fGC\u0003B\u001f\u0005\u007f\u0011\u0019E!\u0012\u0003HA1\u0011\u0011OA|\u0003\u000fCaA!\u0011\u001f\u0001\u0004!\u0017!B:uCR,\u0007B\u0002B\u0016=\u0001\u0007A\rC\u0004\u0003\by\u0001\rA!\u0003\t\u000f\tEa\u00041\u0001\u0003\n\u0005!s-\u001a;QK\u0016\u0014\u0018J\\:uC:\u001cWm\u00117pg\u0016$')\u0019;dQ\u0016\u001cX*\u001a;bI\u0006$\u0018\r\u0006\u0006\u0003>\t5#q\nB)\u0005'BaA!\u0011 \u0001\u0004!\u0007B\u0002B\u0016?\u0001\u0007A\rC\u0004\u0003\b}\u0001\rA!\u0003\t\u000f\tEq\u00041\u0001\u0003\n\u0005qQ\u000f\u001d3bi\u0016lU\r^1eCR\fG#B(\u0003Z\tm\u0003BB\u001a!\u0001\u0004\t9\tC\u0005\u0002\u0016\u0002\u0002\n\u00111\u0001\u0002\n\u0005AR\u000f\u001d3bi\u0016lU\r^1eCR\fG\u0005Z3gCVdG\u000f\n\u001a\u00021U\u00048/\u001a:u\u0017V\u0014WM\u001d8fi\u0016\u001cX*\u001a;bI\u0006$\u0018\rF\u0002P\u0005GBqA!\u001a#\u0001\u0004\u00119'\u0001\u000blk\n,'O\\3uKN,enZ5oK&sgm\u001c\t\u0005\u0003\u0013\u0013I'\u0003\u0003\u0003l\u0005-%\u0001F&vE\u0016\u0014h.\u001a;fg\u0016sw-\u001b8f\u0013:4w.A\ndY\u0016\fg.\u001e9NKR\fG-\u0019;b\u0005fLE\rF\u0002P\u0005cBa!!5$\u0001\u0004!\u0017!H2mK\u0006tW\u000f]&vE\u0016\u0014h.\u001a;fg6+G/\u00193bi\u0006\u0014\u00150\u00133\u0015\u0007=\u00139\b\u0003\u0004\u0002p\u0012\u0002\r\u0001Z\u0001\u0015gR\f'\u000f^'fi\u0006$\u0017\r^1DY\u0016\fg.\u001a:\u0002\u001f\rdW-\u00198va6+G/\u00193bi\u0006$ra\u0014B@\u0005\u0007\u00139\t\u0003\u0004\u0003\u0002\u001a\u0002\ra`\u0001\u0007[\u0006D\u0018iZ3\t\u000f\t\u0015e\u00051\u0001\u0003\n\u0005I!-\u0019;dQNK'0\u001a\u0005\u0007\u0005\u00133\u0003\u0019A@\u0002\u001b\t\fGo\u00195J]R,'O^1mQ\r1#Q\u0012\t\u0005\u0005\u001f\u0013\t+\u0004\u0002\u0003\u0012*!!1\u0013BK\u0003-\tgN\\8uCRLwN\\:\u000b\t\t]%\u0011T\u0001\u0007G>lWn\u001c8\u000b\t\tm%QT\u0001\u0007O>|w\r\\3\u000b\u0005\t}\u0015aA2p[&!!1\u0015BI\u0005E1\u0016n]5cY\u00164uN\u001d+fgRLgnZ\u0001\u0018C\u0012$W*\u001a;bI\u0006$\u0018MU3uef\u0014V-];fgR$2a\u0014BU\u0011\u001d\u0011Yk\na\u0001\u0005[\u000bqA]3rk\u0016\u001cH\u000fE\u0002H\u0005_K1A!-3\u0005=iU\r^1eCR\f'+Z9vKN$\u0018aG4fi6+G/\u00193bi\u0006\u0014V-];fgR\u001c(+\u001a;ssJ+g\rF\u0002p\u0005oCa!a<)\u0001\u0004!\u0017A\u00073f%\u0016<\u0017n\u001d;feJ+\u0017/^3tiN\u0014V\r\u001e:z%\u00164GcA(\u0003>\"1\u0011q^\u0015A\u0002\u0011\fae\u001d;beRlU\r^1eCR\f'+Z9vKN$8/Q:z]\u000e\u0014V\r\u001e:z)JLwmZ3s\u0003=iU\r^1eCR\fW*\u00198bO\u0016\u0014\bCA$-'\u0015a#q\u0019Bg!\r\u0001&\u0011Z\u0005\u0004\u0005\u0017\f&AB!osJ+g\r\u0005\u0003\u0003P\nEW\"\u0001\u001c\n\u0007\tMgGA\u0004M_\u001e<\u0017N\\4\u0015\u0005\t\r\u0017aE2sK\u0006$X-T3uC\u0012\fG/Y*u_J,Gc\u0001&\u0003\\\"9\u0011Q\u0006\u0018A\u0002\u0005=\u0012A\u00032vS2$')\u0019;dQR!\u0011\u0011\u0018Bq\u0011\u001d\u0011\u0019o\fa\u0001\u0003\u000f\u000bQBY1uG\"lU\r^1eCR\f\u0017\u0001\u00062vS2$\u0017\t\u001d9mS\u000e\fG/[8o\u0013:4w\u000e\u0006\u0003\u0002b\n%\bBB\u001a1\u0001\u0004\u00119\u0007")
public class MetadataManager
extends AbstractService {
    private long requestsRetryInterval;
    private boolean requestsAsyncRetryEnabled;
    private ScheduledExecutorService requestsAsyncRetryTrigger;
    private ThreadPoolExecutor org$apache$kyuubi$server$metadata$MetadataManager$$requestsAsyncRetryExecutor;
    private boolean cleanerEnabled;
    private ScheduledExecutorService metadataCleaner;
    private MetadataStore _metadataStore;
    private final ConcurrentHashMap<String, MetadataRequestsRetryRef> identifierRequestsAsyncRetryRefs = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, AtomicInteger> identifierRequestsAsyncRetryingCounts = new ConcurrentHashMap();
    private volatile byte bitmap$0;

    public static ApplicationInfo buildApplicationInfo(KubernetesEngineInfo kubernetesEngineInfo) {
        return MetadataManager$.MODULE$.buildApplicationInfo(kubernetesEngineInfo);
    }

    public static Batch buildBatch(Metadata metadata) {
        return MetadataManager$.MODULE$.buildBatch(metadata);
    }

    public static MetadataStore createMetadataStore(KyuubiConf kyuubiConf) {
        return MetadataManager$.MODULE$.createMetadataStore(kyuubiConf);
    }

    private MetadataStore _metadataStore() {
        return this._metadataStore;
    }

    private void _metadataStore_$eq(MetadataStore x$1) {
        this._metadataStore = x$1;
    }

    public ConcurrentHashMap<String, MetadataRequestsRetryRef> identifierRequestsAsyncRetryRefs() {
        return this.identifierRequestsAsyncRetryRefs;
    }

    public ConcurrentHashMap<String, AtomicInteger> identifierRequestsAsyncRetryingCounts() {
        return this.identifierRequestsAsyncRetryingCounts;
    }

    private long requestsRetryInterval$lzycompute() {
        MetadataManager metadataManager = this;
        synchronized (metadataManager) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.requestsRetryInterval = BoxesRunTime.unboxToLong((Object)this.conf().get(KyuubiConf$.MODULE$.METADATA_REQUEST_RETRY_INTERVAL()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.requestsRetryInterval;
    }

    private long requestsRetryInterval() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.requestsRetryInterval$lzycompute();
        }
        return this.requestsRetryInterval;
    }

    private boolean requestsAsyncRetryEnabled$lzycompute() {
        MetadataManager metadataManager = this;
        synchronized (metadataManager) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.requestsAsyncRetryEnabled = BoxesRunTime.unboxToBoolean((Object)this.conf().get(KyuubiConf$.MODULE$.METADATA_REQUEST_ASYNC_RETRY_ENABLED()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.requestsAsyncRetryEnabled;
    }

    private boolean requestsAsyncRetryEnabled() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.requestsAsyncRetryEnabled$lzycompute();
        }
        return this.requestsAsyncRetryEnabled;
    }

    private ScheduledExecutorService requestsAsyncRetryTrigger$lzycompute() {
        MetadataManager metadataManager = this;
        synchronized (metadataManager) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.requestsAsyncRetryTrigger = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("metadata-requests-async-retry-trigger", ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor$default$2());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.requestsAsyncRetryTrigger;
    }

    private ScheduledExecutorService requestsAsyncRetryTrigger() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.requestsAsyncRetryTrigger$lzycompute();
        }
        return this.requestsAsyncRetryTrigger;
    }

    private ThreadPoolExecutor requestsAsyncRetryExecutor$lzycompute() {
        MetadataManager metadataManager = this;
        synchronized (metadataManager) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.org$apache$kyuubi$server$metadata$MetadataManager$$requestsAsyncRetryExecutor = ThreadUtils$.MODULE$.newDaemonFixedThreadPool(BoxesRunTime.unboxToInt((Object)this.conf().get(KyuubiConf$.MODULE$.METADATA_REQUEST_ASYNC_RETRY_THREADS())), "metadata-requests-async-retry");
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.org$apache$kyuubi$server$metadata$MetadataManager$$requestsAsyncRetryExecutor;
    }

    public ThreadPoolExecutor org$apache$kyuubi$server$metadata$MetadataManager$$requestsAsyncRetryExecutor() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.requestsAsyncRetryExecutor$lzycompute();
        }
        return this.org$apache$kyuubi$server$metadata$MetadataManager$$requestsAsyncRetryExecutor;
    }

    private boolean cleanerEnabled$lzycompute() {
        MetadataManager metadataManager = this;
        synchronized (metadataManager) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.cleanerEnabled = BoxesRunTime.unboxToBoolean((Object)this.conf().get(KyuubiConf$.MODULE$.METADATA_CLEANER_ENABLED()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.cleanerEnabled;
    }

    private boolean cleanerEnabled() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this.cleanerEnabled$lzycompute();
        }
        return this.cleanerEnabled;
    }

    private ScheduledExecutorService metadataCleaner$lzycompute() {
        MetadataManager metadataManager = this;
        synchronized (metadataManager) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.metadataCleaner = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("metadata-cleaner", ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor$default$2());
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
        }
        return this.metadataCleaner;
    }

    private ScheduledExecutorService metadataCleaner() {
        if ((byte)(this.bitmap$0 & 0x20) == 0) {
            return this.metadataCleaner$lzycompute();
        }
        return this.metadataCleaner;
    }

    public void initialize(KyuubiConf conf) {
        this._metadataStore_$eq(MetadataManager$.MODULE$.createMetadataStore(conf));
        super.initialize(conf);
    }

    public void start() {
        super.start();
        if (this.requestsAsyncRetryEnabled()) {
            this.startMetadataRequestsAsyncRetryTrigger();
        }
        if (this.cleanerEnabled()) {
            this.startMetadataCleaner();
            return;
        }
    }

    public void stop() {
        if (this.requestsAsyncRetryEnabled()) {
            ThreadUtils$.MODULE$.shutdown((ExecutorService)this.requestsAsyncRetryTrigger(), ThreadUtils$.MODULE$.shutdown$default$2());
            ThreadUtils$.MODULE$.shutdown((ExecutorService)this.org$apache$kyuubi$server$metadata$MetadataManager$$requestsAsyncRetryExecutor(), ThreadUtils$.MODULE$.shutdown$default$2());
        }
        if (this.cleanerEnabled()) {
            ThreadUtils$.MODULE$.shutdown((ExecutorService)this.metadataCleaner(), ThreadUtils$.MODULE$.shutdown$default$2());
        }
        this._metadataStore().close();
        super.stop();
    }

    private <T> T withMetadataRequestMetrics(Function0<T> block) {
        Object object;
        MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.incCount("kyuubi.metadata.request.opened");
            return BoxedUnit.UNIT;
        });
        try {
            try {
                object = block.apply();
            }
            catch (Throwable e) {
                MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)x$2 -> {
                    x$2.markMeter("kyuubi.metadata.request.failed", x$2.markMeter$default$2());
                    return BoxedUnit.UNIT;
                });
                throw e;
            }
        }
        finally {
            MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)x$3 -> {
                x$3.decCount("kyuubi.metadata.request.opened");
                return BoxedUnit.UNIT;
            });
            MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)x$4 -> {
                x$4.markMeter("kyuubi.metadata.request.total", x$4.markMeter$default$2());
                return BoxedUnit.UNIT;
            });
        }
        return (T)object;
    }

    public boolean unrecoverableDBErr(Throwable cause) {
        return JdbcUtils$.MODULE$.isDuplicatedKeyDBErr(cause);
    }

    public void insertMetadata(Metadata metadata, boolean asyncRetryOnError) {
        try {
            this.withMetadataRequestMetrics((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this._metadataStore().insertMetadata(metadata));
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && this.unrecoverableDBErr(throwable2 = throwable3)) {
                throw throwable2;
            }
            if (throwable3 != null) {
                Throwable throwable4 = throwable3;
                if (this.requestsAsyncRetryEnabled() && asyncRetryOnError) {
                    this.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Error inserting metadata for session ").append(metadata.identifier()).toString(), throwable4);
                    this.addMetadataRetryRequest(new InsertMetadata(metadata));
                }
            }
            throw throwable;
        }
    }

    public boolean insertMetadata$default$2() {
        return true;
    }

    public Option<Batch> getBatch(String batchId) {
        return this.getBatchSessionMetadata(batchId).map((Function1 & Serializable & scala.Serializable)batchMetadata -> MetadataManager$.MODULE$.buildBatch((Metadata)batchMetadata));
    }

    public Option<Metadata> getBatchSessionMetadata(String batchId) {
        return Option$.MODULE$.apply(this.withMetadataRequestMetrics((Function0 & Serializable & scala.Serializable)() -> this._metadataStore().getMetadata(batchId))).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)MetadataManager.$anonfun$getBatchSessionMetadata$2(x$5)));
    }

    public Option<ApplicationInfo> getKubernetesApplicationInfo(String identifier) {
        return Option$.MODULE$.apply(this.withMetadataRequestMetrics((Function0 & Serializable & scala.Serializable)() -> this._metadataStore().getKubernetesMetaEngineInfo(identifier))).map((Function1 & Serializable & scala.Serializable)metadata -> {
            ApplicationInfo appInfo = MetadataManager$.MODULE$.buildApplicationInfo((KubernetesEngineInfo)metadata);
            this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Retrieve ").append(appInfo).append(" from kubernetes engine info store: ").append(metadata).toString());
            return appInfo;
        });
    }

    public Seq<Batch> getBatches(MetadataFilter filter, int from, int size, boolean desc) {
        return (Seq)((TraversableLike)this.withMetadataRequestMetrics((Function0 & Serializable & scala.Serializable)() -> this._metadataStore().getMetadataList(filter, from, size, (Option<String>)(filter.createTime() > 0L ? new Some((Object)"create_time") : new Some((Object)"key_id")), desc ? "DESC" : "ASC"))).map((Function1 & Serializable & scala.Serializable)batchMetadata -> MetadataManager$.MODULE$.buildBatch((Metadata)batchMetadata), Seq$.MODULE$.canBuildFrom());
    }

    public boolean getBatches$default$4() {
        return false;
    }

    public int countBatch(String batchType, String batchUser, String batchState, String kyuubiInstance) {
        Enumeration.Value x$1 = SessionType$.MODULE$.BATCH();
        String x$2 = batchType;
        String x$3 = batchUser;
        String x$4 = batchState;
        String x$5 = kyuubiInstance;
        String x$6 = MetadataFilter$.MODULE$.apply$default$5();
        long x$7 = MetadataFilter$.MODULE$.apply$default$7();
        long x$8 = MetadataFilter$.MODULE$.apply$default$8();
        boolean x$9 = MetadataFilter$.MODULE$.apply$default$9();
        MetadataFilter filter = new MetadataFilter(x$1, x$2, x$3, x$4, x$6, x$5, x$7, x$8, x$9);
        return BoxesRunTime.unboxToInt(this.withMetadataRequestMetrics((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this._metadataStore().countMetadata(filter)));
    }

    public Option<Metadata> pickBatchForSubmitting(String kyuubiInstance) {
        return (Option)this.withMetadataRequestMetrics((Function0 & Serializable & scala.Serializable)() -> this._metadataStore().pickMetadata(kyuubiInstance));
    }

    public boolean cancelUnscheduledBatch(String batchId) {
        return this._metadataStore().transformMetadataState(batchId, "INITIALIZED", "CANCELED");
    }

    public Seq<Metadata> getBatchesRecoveryMetadata(String state, String kyuubiInstance, int from, int size) {
        Enumeration.Value x$1 = SessionType$.MODULE$.BATCH();
        String x$2 = state;
        String x$3 = kyuubiInstance;
        String x$4 = MetadataFilter$.MODULE$.apply$default$2();
        String x$5 = MetadataFilter$.MODULE$.apply$default$3();
        String x$6 = MetadataFilter$.MODULE$.apply$default$5();
        long x$7 = MetadataFilter$.MODULE$.apply$default$7();
        long x$8 = MetadataFilter$.MODULE$.apply$default$8();
        boolean x$9 = MetadataFilter$.MODULE$.apply$default$9();
        MetadataFilter filter = new MetadataFilter(x$1, x$4, x$5, x$2, x$6, x$3, x$7, x$8, x$9);
        return (Seq)this.withMetadataRequestMetrics((Function0 & Serializable & scala.Serializable)() -> {
            MetadataStore qual$1 = this._metadataStore();
            MetadataFilter x$10 = filter;
            int x$11 = from;
            int x$12 = size;
            Option<String> x$13 = qual$1.getMetadataList$default$4();
            String x$14 = qual$1.getMetadataList$default$5();
            return qual$1.getMetadataList(x$10, x$11, x$12, x$13, x$14);
        });
    }

    public Seq<Metadata> getPeerInstanceClosedBatchesMetadata(String state, String kyuubiInstance, int from, int size) {
        Enumeration.Value x$1 = SessionType$.MODULE$.BATCH();
        String x$2 = state;
        String x$3 = kyuubiInstance;
        boolean x$4 = true;
        String x$5 = MetadataFilter$.MODULE$.apply$default$2();
        String x$6 = MetadataFilter$.MODULE$.apply$default$3();
        String x$7 = MetadataFilter$.MODULE$.apply$default$5();
        long x$8 = MetadataFilter$.MODULE$.apply$default$7();
        long x$9 = MetadataFilter$.MODULE$.apply$default$8();
        MetadataFilter filter = new MetadataFilter(x$1, x$5, x$6, x$2, x$7, x$3, x$8, x$9, x$4);
        return (Seq)this.withMetadataRequestMetrics((Function0 & Serializable & scala.Serializable)() -> {
            MetadataStore qual$1 = this._metadataStore();
            MetadataFilter x$10 = filter;
            int x$11 = from;
            int x$12 = size;
            Option<String> x$13 = qual$1.getMetadataList$default$4();
            String x$14 = qual$1.getMetadataList$default$5();
            return qual$1.getMetadataList(x$10, x$11, x$12, x$13, x$14);
        });
    }

    public void updateMetadata(Metadata metadata, boolean asyncRetryOnError) {
        try {
            this.withMetadataRequestMetrics((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this._metadataStore().updateMetadata(metadata));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 != null) {
                Throwable throwable3 = throwable2;
                if (this.requestsAsyncRetryEnabled() && asyncRetryOnError) {
                    this.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Error updating metadata for session ").append(metadata.identifier()).toString(), throwable3);
                    this.addMetadataRetryRequest(new UpdateMetadata(metadata));
                }
            }
            throw throwable;
        }
    }

    public boolean updateMetadata$default$2() {
        return true;
    }

    public void upsertKubernetesMetadata(KubernetesEngineInfo kubernetesEngineInfo) {
        try {
            this.withMetadataRequestMetrics((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this._metadataStore().upsertKubernetesEngineInfo(kubernetesEngineInfo));
        }
        catch (Throwable e) {
            this.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Error updating kubernetes engine info for session ").append(kubernetesEngineInfo.identifier()).toString(), e);
        }
    }

    public void cleanupMetadataById(String batchId) {
        this.withMetadataRequestMetrics((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this._metadataStore().cleanupMetadataByIdentifier(batchId));
    }

    public void cleanupKubernetesMetadataById(String identifier) {
        this.withMetadataRequestMetrics((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this._metadataStore().cleanupKubernetesEngineInfoByIdentifier(identifier));
    }

    private void startMetadataCleaner() {
        long stateMaxAge = BoxesRunTime.unboxToLong((Object)this.conf().get(KyuubiConf$.MODULE$.METADATA_MAX_AGE()));
        long interval = BoxesRunTime.unboxToLong((Object)this.conf().get(KyuubiConf$.MODULE$.METADATA_CLEANER_INTERVAL()));
        int batchSize = BoxesRunTime.unboxToInt((Object)this.conf().get(KyuubiConf$.MODULE$.METADATA_CLEANER_BATCH_SIZE()));
        long batchInterval = BoxesRunTime.unboxToLong((Object)this.conf().get(KyuubiConf$.MODULE$.METADATA_CLEANER_BATCH_INTERVAL()));
        Runnable cleanerTask = () -> {
            try {
                this.cleanupMetadata(stateMaxAge, batchSize, batchInterval);
            }
            catch (Throwable e) {
                this.error((Function0 & Serializable & scala.Serializable)() -> "Error cleaning up the metadata by age", e);
            }
        };
        ThreadUtils$.MODULE$.scheduleTolerableRunnableWithFixedDelay(this.metadataCleaner(), cleanerTask, interval, interval, TimeUnit.MILLISECONDS);
    }

    @VisibleForTesting
    public void cleanupMetadata(long maxAge, int batchSize, long batchInterval) {
        boolean needToCleanMetadata = true;
        boolean needToCleanKubernetesInfo = true;
        int cleanupLoop = 0;
        int MAX_CLEANUP_LOOPS = 100;
        while ((needToCleanMetadata || needToCleanKubernetesInfo) && cleanupLoop < MAX_CLEANUP_LOOPS) {
            ++cleanupLoop;
            if (needToCleanMetadata) {
                boolean bl = needToCleanMetadata = BoxesRunTime.unboxToInt(this.withMetadataRequestMetrics((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this._metadataStore().cleanupMetadataByAge(maxAge, batchSize))) >= batchSize;
            }
            if (needToCleanKubernetesInfo) {
                boolean bl = needToCleanKubernetesInfo = BoxesRunTime.unboxToInt(this.withMetadataRequestMetrics((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this._metadataStore().cleanupKubernetesEngineInfoByAge(maxAge, batchSize))) >= batchSize;
            }
            if (!needToCleanMetadata && !needToCleanKubernetesInfo) continue;
            if (cleanupLoop < MAX_CLEANUP_LOOPS) {
                this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Sleep ").append(batchInterval).append(" ms before next batch of metadata cleaning.").toString());
                Thread.sleep(batchInterval);
                continue;
            }
            this.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(77).append("Metadata cleaning reaches the maximum loop ").append(MAX_CLEANUP_LOOPS).append(", ").append("will continue in the next round.").toString());
        }
    }

    public void addMetadataRetryRequest(MetadataRequest request) {
        int maxRequestsAsyncRetryRefs = BoxesRunTime.unboxToInt((Object)this.conf().get(KyuubiConf$.MODULE$.METADATA_REQUEST_ASYNC_RETRY_QUEUE_SIZE()));
        if (this.identifierRequestsAsyncRetryRefs().size() > maxRequestsAsyncRetryRefs) {
            throw new KyuubiException(new StringBuilder(71).append("The number of metadata requests retry instances exceeds the limitation:").append(maxRequestsAsyncRetryRefs).toString(), KyuubiException$.MODULE$.$lessinit$greater$default$2());
        }
        String identifier2 = request.metadata().identifier();
        MetadataRequestsRetryRef ref = this.identifierRequestsAsyncRetryRefs().computeIfAbsent(identifier2, identifier -> {
            MetadataRequestsRetryRef ref = new MetadataRequestsRetryRef();
            this.debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Created MetadataRequestsRetryRef for session ").append((String)identifier).append(".").toString());
            return ref;
        });
        ref.addRetryingMetadataRequest(request);
        this.identifierRequestsAsyncRetryRefs().putIfAbsent(identifier2, ref);
        MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)x$6 -> {
            x$6.markMeter("kyuubi.metadata.request.retrying", x$6.markMeter$default$2());
            return BoxedUnit.UNIT;
        });
    }

    public MetadataRequestsRetryRef getMetadataRequestsRetryRef(String identifier) {
        return this.identifierRequestsAsyncRetryRefs().get(identifier);
    }

    public void deRegisterRequestsRetryRef(String identifier) {
        this.identifierRequestsAsyncRetryRefs().remove(identifier);
        this.identifierRequestsAsyncRetryingCounts().remove(identifier);
    }

    private void startMetadataRequestsAsyncRetryTrigger() {
        Runnable triggerTask = new Runnable(this){
            private final /* synthetic */ MetadataManager $outer;

            public void run() {
                this.$outer.identifierRequestsAsyncRetryRefs().forEach((id, ref) -> {
                    if (!ref.hasRemainingRequests()) {
                        $this.$outer.identifierRequestsAsyncRetryRefs().remove(id);
                        $this.$outer.identifierRequestsAsyncRetryingCounts().remove(id);
                        return;
                    }
                    AtomicInteger retryingCount = $this.$outer.identifierRequestsAsyncRetryingCounts().computeIfAbsent((String)id, x$7 -> new AtomicInteger(0));
                    if (retryingCount.get() == 0) {
                        Runnable retryTask = new Runnable(this, (String)id, (MetadataRequestsRetryRef)ref, retryingCount){
                            private final /* synthetic */ $anon$1 $outer;
                            private final String id$1;
                            private final MetadataRequestsRetryRef ref$1;
                            private final AtomicInteger retryingCount$1;

                            public void run() {
                                try {
                                    try {
                                        this.$outer.org$apache$kyuubi$server$metadata$MetadataManager$$anon$$$outer().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Retrying metadata requests for ").append($this.id$1).toString());
                                        MetadataRequest request = this.ref$1.metadataRequests().peek();
                                        while (request != null) {
                                            MetadataRequest metadataRequest = request;
                                            if (metadataRequest instanceof InsertMetadata) {
                                                InsertMetadata insertMetadata = (InsertMetadata)metadataRequest;
                                                this.$outer.org$apache$kyuubi$server$metadata$MetadataManager$$anon$$$outer().insertMetadata(insertMetadata.metadata(), false);
                                            } else if (metadataRequest instanceof UpdateMetadata) {
                                                UpdateMetadata updateMetadata = (UpdateMetadata)metadataRequest;
                                                this.$outer.org$apache$kyuubi$server$metadata$MetadataManager$$anon$$$outer().updateMetadata(updateMetadata.metadata(), false);
                                            } else {
                                                throw new MatchError((Object)metadataRequest);
                                            }
                                            this.ref$1.metadataRequests().remove(request);
                                            MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)x$8 -> {
                                                $anon$1$$anon$2.$anonfun$run$4(x$8);
                                                return BoxedUnit.UNIT;
                                            });
                                            request = this.ref$1.metadataRequests().peek();
                                        }
                                    }
                                    catch (Throwable e) {
                                        this.$outer.org$apache$kyuubi$server$metadata$MetadataManager$$anon$$$outer().error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Error retrying metadata requests for ").append($this.id$1).toString(), e);
                                    }
                                }
                                finally {
                                    this.retryingCount$1.decrementAndGet();
                                }
                            }

                            public static final /* synthetic */ void $anonfun$run$4(MetricsSystem x$8) {
                                x$8.markMeter("kyuubi.metadata.request.retrying", -1L);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.id$1 = id$1;
                                this.ref$1 = ref$1;
                                this.retryingCount$1 = retryingCount$1;
                            }

                            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$3(org.apache.kyuubi.server.metadata.MetadataManager$$anon$1$$anon$2 ), $anonfun$run$4$adapted(org.apache.kyuubi.metrics.MetricsSystem ), $anonfun$run$5(org.apache.kyuubi.server.metadata.MetadataManager$$anon$1$$anon$2 )}, serializedLambda);
                            }
                        };
                        try {
                            retryingCount.incrementAndGet();
                            $this.$outer.org$apache$kyuubi$server$metadata$MetadataManager$$requestsAsyncRetryExecutor().submit(retryTask);
                        }
                        catch (Throwable e) {
                            $this.$outer.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Error submitting metadata retry requests for ").append((String)id).toString(), e);
                            retryingCount.decrementAndGet();
                        }
                        return;
                    }
                });
            }

            public /* synthetic */ MetadataManager org$apache$kyuubi$server$metadata$MetadataManager$$anon$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$6(java.lang.String )}, serializedLambda);
            }
        };
        ThreadUtils$.MODULE$.scheduleTolerableRunnableWithFixedDelay(this.requestsAsyncRetryTrigger(), triggerTask, this.requestsRetryInterval(), this.requestsRetryInterval(), TimeUnit.MILLISECONDS);
    }

    public static final /* synthetic */ boolean $anonfun$getBatchSessionMetadata$2(Metadata x$5) {
        Enumeration.Value value = x$5.sessionType();
        Enumeration.Value value2 = SessionType$.MODULE$.BATCH();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    public MetadataManager() {
        super("MetadataManager");
    }
}

