/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.PointsFormat;
import org.apache.lucene.codecs.PointsReader;
import org.apache.lucene.codecs.PointsWriter;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.blocktreeords.BlockTreeOrdsPostingsFormat;
import org.apache.lucene.codecs.lucene90.Lucene90DocValuesFormat;
import org.apache.lucene.codecs.lucene90.Lucene90PointsReader;
import org.apache.lucene.codecs.lucene90.Lucene90PointsWriter;
import org.apache.lucene.codecs.memory.DirectPostingsFormat;
import org.apache.lucene.codecs.memory.FSTPostingsFormat;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.Directory;
import org.apache.lucene.tests.codecs.asserting.AssertingCodec;
import org.apache.lucene.tests.codecs.asserting.AssertingDocValuesFormat;
import org.apache.lucene.tests.codecs.asserting.AssertingPointsFormat;
import org.apache.lucene.tests.codecs.asserting.AssertingPostingsFormat;
import org.apache.lucene.tests.codecs.blockterms.LuceneFixedGap;
import org.apache.lucene.tests.codecs.blockterms.LuceneVarGapDocFreqInterval;
import org.apache.lucene.tests.codecs.blockterms.LuceneVarGapFixedInterval;
import org.apache.lucene.tests.codecs.bloom.TestBloomFilteredLucenePostings;
import org.apache.lucene.tests.codecs.mockrandom.MockRandomPostingsFormat;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.apache.lucene.tests.util.TestUtil;
import org.apache.lucene.util.IORunnable;
import org.apache.lucene.util.bkd.BKDConfig;
import org.apache.lucene.util.bkd.BKDWriter;

public class RandomCodec
extends AssertingCodec {
    private List<PostingsFormat> formats = new ArrayList<PostingsFormat>();
    private List<DocValuesFormat> dvFormats = new ArrayList<DocValuesFormat>();
    public Set<String> formatNames = new HashSet<String>();
    public Set<String> dvFormatNames = new HashSet<String>();
    public final Set<String> avoidCodecs;
    private Map<String, PostingsFormat> previousMappings = Collections.synchronizedMap(new HashMap());
    private Map<String, DocValuesFormat> previousDVMappings = Collections.synchronizedMap(new HashMap());
    private final int perFieldSeed;
    private final int maxPointsInLeafNode;
    private final double maxMBSortInHeap;
    private final int bkdSplitRandomSeed;

    @Override
    public PointsFormat pointsFormat() {
        return new AssertingPointsFormat(new PointsFormat(){

            public PointsWriter fieldsWriter(final SegmentWriteState writeState) throws IOException {
                return new Lucene90PointsWriter(writeState, RandomCodec.this.maxPointsInLeafNode, RandomCodec.this.maxMBSortInHeap){

                    public void writeField(FieldInfo fieldInfo, PointsReader reader) throws IOException {
                        PointValues.PointTree values = reader.getValues(fieldInfo.name).getPointTree();
                        BKDConfig config = new BKDConfig(fieldInfo.getPointDimensionCount(), fieldInfo.getPointIndexDimensionCount(), fieldInfo.getPointNumBytes(), RandomCodec.this.maxPointsInLeafNode);
                        try (final RandomlySplittingBKDWriter writer = new RandomlySplittingBKDWriter(writeState.segmentInfo.maxDoc(), writeState.directory, writeState.segmentInfo.name, config, RandomCodec.this.maxMBSortInHeap, values.size(), RandomCodec.this.bkdSplitRandomSeed ^ fieldInfo.name.hashCode());){
                            values.visitDocValues(new PointValues.IntersectVisitor(){

                                public void visit(int docID) {
                                    throw new IllegalStateException();
                                }

                                public void visit(int docID, byte[] packedValue) throws IOException {
                                    writer.add(packedValue, docID);
                                }

                                public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                                    return PointValues.Relation.CELL_CROSSES_QUERY;
                                }
                            });
                            IORunnable finalizer = writer.finish(this.metaOut, this.indexOut, this.dataOut);
                            if (finalizer != null) {
                                this.metaOut.writeInt(fieldInfo.number);
                                finalizer.run();
                            }
                        }
                    }
                };
            }

            public PointsReader fieldsReader(SegmentReadState readState) throws IOException {
                return new Lucene90PointsReader(readState);
            }
        });
    }

    @Override
    public PostingsFormat getPostingsFormatForField(String name) {
        PostingsFormat codec = this.previousMappings.get(name);
        if (codec == null) {
            codec = this.formats.get(Math.abs(this.perFieldSeed ^ name.hashCode()) % this.formats.size());
            this.previousMappings.put(name, codec);
            assert (this.previousMappings.size() < 10000) : "test went insane";
        }
        return codec;
    }

    @Override
    public DocValuesFormat getDocValuesFormatForField(String name) {
        DocValuesFormat codec = this.previousDVMappings.get(name);
        if (codec == null) {
            codec = this.dvFormats.get(Math.abs(this.perFieldSeed ^ name.hashCode()) % this.dvFormats.size());
            this.previousDVMappings.put(name, codec);
            assert (this.previousDVMappings.size() < 10000) : "test went insane";
        }
        return codec;
    }

    public RandomCodec(Random random, Set<String> avoidCodecs) {
        this.perFieldSeed = random.nextInt();
        this.avoidCodecs = avoidCodecs;
        int minItemsPerBlock = TestUtil.nextInt(random, 2, 100);
        int maxItemsPerBlock = 2 * Math.max(2, minItemsPerBlock - 1) + random.nextInt(100);
        int lowFreqCutoff = TestUtil.nextInt(random, 2, 100);
        this.maxPointsInLeafNode = TestUtil.nextInt(random, 16, 2048);
        this.maxMBSortInHeap = 5.0 + 3.0 * random.nextDouble();
        this.bkdSplitRandomSeed = random.nextInt();
        this.add(avoidCodecs, new PostingsFormat[]{TestUtil.getDefaultPostingsFormat(minItemsPerBlock, maxItemsPerBlock), new FSTPostingsFormat(), new DirectPostingsFormat(LuceneTestCase.rarely(random) ? 1 : (LuceneTestCase.rarely(random) ? Integer.MAX_VALUE : maxItemsPerBlock), LuceneTestCase.rarely(random) ? 1 : (LuceneTestCase.rarely(random) ? Integer.MAX_VALUE : lowFreqCutoff)), new TestBloomFilteredLucenePostings(), new MockRandomPostingsFormat(random), new BlockTreeOrdsPostingsFormat(minItemsPerBlock, maxItemsPerBlock), new LuceneFixedGap(TestUtil.nextInt(random, 1, 1000)), new LuceneVarGapFixedInterval(TestUtil.nextInt(random, 1, 1000)), new LuceneVarGapDocFreqInterval(TestUtil.nextInt(random, 1, 100), TestUtil.nextInt(random, 1, 1000)), TestUtil.getDefaultPostingsFormat(), new AssertingPostingsFormat()});
        this.addDocValues(avoidCodecs, new DocValuesFormat[]{TestUtil.getDefaultDocValuesFormat(), new Lucene90DocValuesFormat(), new AssertingDocValuesFormat()});
        Collections.shuffle(this.formats, random);
        Collections.shuffle(this.dvFormats, random);
        if (this.formats.size() > 4) {
            this.formats = this.formats.subList(0, 4);
        }
        if (this.dvFormats.size() > 4) {
            this.dvFormats = this.dvFormats.subList(0, 4);
        }
    }

    public RandomCodec(Random random) {
        this(random, Collections.emptySet());
    }

    private final void add(Set<String> avoidCodecs, PostingsFormat ... postings) {
        for (PostingsFormat p : postings) {
            if (avoidCodecs.contains(p.getName())) continue;
            this.formats.add(p);
            this.formatNames.add(p.getName());
        }
    }

    private final void addDocValues(Set<String> avoidCodecs, DocValuesFormat ... docvalues) {
        for (DocValuesFormat d : docvalues) {
            if (avoidCodecs.contains(d.getName())) continue;
            this.dvFormats.add(d);
            this.dvFormatNames.add(d.getName());
        }
    }

    @Override
    public String toString() {
        return super.toString() + ": " + this.previousMappings.toString() + ", docValues:" + this.previousDVMappings.toString() + ", maxPointsInLeafNode=" + this.maxPointsInLeafNode + ", maxMBSortInHeap=" + this.maxMBSortInHeap;
    }

    private static class RandomlySplittingBKDWriter
    extends BKDWriter {
        final Random random;

        public RandomlySplittingBKDWriter(int maxDoc, Directory tempDir, String tempFileNamePrefix, BKDConfig config, double maxMBSortInHeap, long totalPointCount, int randomSeed) throws IOException {
            super(maxDoc, tempDir, tempFileNamePrefix, config, maxMBSortInHeap, totalPointCount);
            this.random = new Random(randomSeed);
        }

        protected int split(byte[] minPackedValue, byte[] maxPackedValue, int[] parentDims) {
            return this.random.nextInt(this.config.numIndexDims());
        }
    }
}

