/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.math.BigInteger;
import java.util.Arrays;
import org.apache.lucene.util.BitUtil;

public final class NumericUtils {
    private NumericUtils() {
    }

    public static long doubleToSortableLong(double value) {
        return NumericUtils.sortableDoubleBits(Double.doubleToLongBits(value));
    }

    public static double sortableLongToDouble(long encoded) {
        return Double.longBitsToDouble(NumericUtils.sortableDoubleBits(encoded));
    }

    public static int floatToSortableInt(float value) {
        return NumericUtils.sortableFloatBits(Float.floatToIntBits(value));
    }

    public static float sortableIntToFloat(int encoded) {
        return Float.intBitsToFloat(NumericUtils.sortableFloatBits(encoded));
    }

    public static long sortableDoubleBits(long bits) {
        return bits ^ bits >> 63 & Long.MAX_VALUE;
    }

    public static int sortableFloatBits(int bits) {
        return bits ^ bits >> 31 & Integer.MAX_VALUE;
    }

    public static void subtract(int bytesPerDim, int dim, byte[] a, byte[] b, byte[] result) {
        int i;
        int start = dim * bytesPerDim;
        int end = start + bytesPerDim;
        int borrow = 0;
        int limit = start + (bytesPerDim & 0xFFFFFFFC);
        for (i = end - 1; i >= limit; --i) {
            int diff = Byte.toUnsignedInt(a[i]) - Byte.toUnsignedInt(b[i]) - borrow;
            borrow = diff < 0 ? 1 : 0;
            result[i - start] = (byte)diff;
        }
        i -= 3;
        while (i >= start) {
            int aInt = BitUtil.VH_BE_INT.get(a, i);
            int bInt = BitUtil.VH_BE_INT.get(b, i);
            long diff = Integer.toUnsignedLong(aInt) - Integer.toUnsignedLong(bInt) - (long)borrow;
            borrow = diff < 0L ? 1 : 0;
            BitUtil.VH_BE_INT.set(result, i - start, (int)diff);
            i -= 4;
        }
        if (borrow != 0) {
            throw new IllegalArgumentException("a < b");
        }
    }

    public static void add(int bytesPerDim, int dim, byte[] a, byte[] b, byte[] result) {
        int i;
        int start = dim * bytesPerDim;
        int end = start + bytesPerDim;
        int carry = 0;
        int limit = start + (bytesPerDim & 0xFFFFFFFC);
        for (i = end - 1; i >= limit; --i) {
            int digitSum = Byte.toUnsignedInt(a[i]) + Byte.toUnsignedInt(b[i]) + carry;
            carry = digitSum >= 256 ? 1 : 0;
            result[i - start] = (byte)digitSum;
        }
        i -= 3;
        while (i >= start) {
            int aInt = BitUtil.VH_BE_INT.get(a, i);
            int bInt = BitUtil.VH_BE_INT.get(b, i);
            long digitSum = Integer.toUnsignedLong(aInt) + Integer.toUnsignedLong(bInt) + (long)carry;
            carry = digitSum >= 0x100000000L ? 1 : 0;
            BitUtil.VH_BE_INT.set(result, i - start, (int)digitSum);
            i -= 4;
        }
        if (carry != 0) {
            throw new IllegalArgumentException("a + b overflows bytesPerDim=" + bytesPerDim);
        }
    }

    public static void intToSortableBytes(int value, byte[] result, int offset) {
        BitUtil.VH_BE_INT.set(result, offset, value ^= Integer.MIN_VALUE);
    }

    public static int sortableBytesToInt(byte[] encoded, int offset) {
        int x = BitUtil.VH_BE_INT.get(encoded, offset);
        return x ^ Integer.MIN_VALUE;
    }

    public static void longToSortableBytes(long value, byte[] result, int offset) {
        BitUtil.VH_BE_LONG.set(result, offset, value ^= Long.MIN_VALUE);
    }

    public static long sortableBytesToLong(byte[] encoded, int offset) {
        long v = BitUtil.VH_BE_LONG.get(encoded, offset);
        return v ^= Long.MIN_VALUE;
    }

    public static void bigIntToSortableBytes(BigInteger bigInt, int bigIntSize, byte[] result, int offset) {
        byte[] fullBigIntBytes;
        byte[] bigIntBytes = bigInt.toByteArray();
        if (bigIntBytes.length < bigIntSize) {
            fullBigIntBytes = new byte[bigIntSize];
            System.arraycopy(bigIntBytes, 0, fullBigIntBytes, bigIntSize - bigIntBytes.length, bigIntBytes.length);
            if ((bigIntBytes[0] & 0x80) != 0) {
                Arrays.fill(fullBigIntBytes, 0, bigIntSize - bigIntBytes.length, (byte)-1);
            }
        } else if (bigIntBytes.length == bigIntSize) {
            fullBigIntBytes = bigIntBytes;
        } else {
            throw new IllegalArgumentException("BigInteger: " + String.valueOf(bigInt) + " requires more than " + bigIntSize + " bytes storage");
        }
        fullBigIntBytes[0] = (byte)(fullBigIntBytes[0] ^ 0x80);
        System.arraycopy(fullBigIntBytes, 0, result, offset, bigIntSize);
        assert (NumericUtils.sortableBytesToBigInt(result, offset, bigIntSize).equals(bigInt)) : "bigInt=" + String.valueOf(bigInt) + " converted=" + String.valueOf(NumericUtils.sortableBytesToBigInt(result, offset, bigIntSize));
    }

    public static BigInteger sortableBytesToBigInt(byte[] encoded, int offset, int length) {
        byte[] bigIntBytes = new byte[length];
        System.arraycopy(encoded, offset, bigIntBytes, 0, length);
        bigIntBytes[0] = (byte)(bigIntBytes[0] ^ 0x80);
        return new BigInteger(bigIntBytes);
    }
}

