/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.helpers;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.sshd.agent.SshAgentFactory;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.ServiceFactory;
import org.apache.sshd.common.SyspropsMapWrapper;
import org.apache.sshd.common.channel.ChannelFactory;
import org.apache.sshd.common.channel.ChannelListener;
import org.apache.sshd.common.channel.RequestHandler;
import org.apache.sshd.common.channel.throttle.ChannelStreamWriterResolver;
import org.apache.sshd.common.config.VersionProperties;
import org.apache.sshd.common.file.FileSystemFactory;
import org.apache.sshd.common.forward.ForwarderFactory;
import org.apache.sshd.common.forward.PortForwardingEventListener;
import org.apache.sshd.common.io.DefaultIoServiceFactoryFactory;
import org.apache.sshd.common.io.IoServiceEventListener;
import org.apache.sshd.common.io.IoServiceFactory;
import org.apache.sshd.common.io.IoServiceFactoryFactory;
import org.apache.sshd.common.kex.AbstractKexFactoryManager;
import org.apache.sshd.common.random.Random;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.session.ReservedSessionMessagesHandler;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.SessionDisconnectHandler;
import org.apache.sshd.common.session.SessionListener;
import org.apache.sshd.common.session.UnknownChannelReferenceHandler;
import org.apache.sshd.common.session.helpers.AbstractSessionFactory;
import org.apache.sshd.common.session.helpers.SessionTimeoutListener;
import org.apache.sshd.common.util.EventListenerUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.threads.ThreadUtils;
import org.apache.sshd.core.CoreModuleProperties;
import org.apache.sshd.server.forward.ForwardingFilter;

public abstract class AbstractFactoryManager
extends AbstractKexFactoryManager
implements FactoryManager {
    protected IoServiceFactoryFactory ioServiceFactoryFactory;
    protected IoServiceFactory ioServiceFactory;
    protected Factory<? extends Random> randomFactory;
    protected List<? extends ChannelFactory> channelFactories;
    protected SshAgentFactory agentFactory;
    protected ScheduledExecutorService executor;
    protected boolean shutdownExecutor;
    protected ForwarderFactory forwarderFactory;
    protected ForwardingFilter forwardingFilter;
    protected FileSystemFactory fileSystemFactory;
    protected List<? extends ServiceFactory> serviceFactories;
    protected List<RequestHandler<ConnectionService>> globalRequestHandlers;
    protected final AtomicReference<SessionTimeoutListener> sessionTimeoutListener = new AtomicReference();
    protected final AtomicReference<ScheduledFuture<?>> timeoutListenerFuture = new AtomicReference();
    protected final Collection<SessionListener> sessionListeners = new CopyOnWriteArraySet<SessionListener>();
    protected final SessionListener sessionListenerProxy;
    protected final Collection<ChannelListener> channelListeners = new CopyOnWriteArraySet<ChannelListener>();
    protected final ChannelListener channelListenerProxy;
    protected final Collection<PortForwardingEventListener> tunnelListeners = new CopyOnWriteArraySet<PortForwardingEventListener>();
    protected final PortForwardingEventListener tunnelListenerProxy;
    private final Map<String, Object> properties = new ConcurrentHashMap<String, Object>();
    private final Map<AttributeRepository.AttributeKey<?>, Object> attributes = new ConcurrentHashMap();
    private PropertyResolver parentResolver = SyspropsMapWrapper.SYSPROPS_RESOLVER;
    private ReservedSessionMessagesHandler reservedSessionMessagesHandler;
    private SessionDisconnectHandler sessionDisconnectHandler;
    private ChannelStreamWriterResolver channelStreamWriterResolver;
    private UnknownChannelReferenceHandler unknownChannelReferenceHandler;
    private IoServiceEventListener eventListener;

    protected AbstractFactoryManager() {
        this.sessionListenerProxy = (SessionListener)EventListenerUtils.proxyWrapper(SessionListener.class, this.sessionListeners);
        this.channelListenerProxy = (ChannelListener)EventListenerUtils.proxyWrapper(ChannelListener.class, this.channelListeners);
        this.tunnelListenerProxy = (PortForwardingEventListener)EventListenerUtils.proxyWrapper(PortForwardingEventListener.class, this.tunnelListeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IoServiceFactory getIoServiceFactory() {
        IoServiceFactoryFactory ioServiceFactoryFactory = this.ioServiceFactoryFactory;
        synchronized (ioServiceFactoryFactory) {
            if (this.ioServiceFactory == null) {
                this.ioServiceFactory = this.ioServiceFactoryFactory.create(this);
            }
        }
        return this.ioServiceFactory;
    }

    public IoServiceFactoryFactory getIoServiceFactoryFactory() {
        return this.ioServiceFactoryFactory;
    }

    public void setIoServiceFactoryFactory(IoServiceFactoryFactory ioServiceFactory) {
        this.ioServiceFactoryFactory = ioServiceFactory;
    }

    public IoServiceEventListener getIoServiceEventListener() {
        return this.eventListener;
    }

    public void setIoServiceEventListener(IoServiceEventListener listener) {
        this.eventListener = listener;
    }

    @Override
    public Factory<? extends Random> getRandomFactory() {
        return this.randomFactory;
    }

    public void setRandomFactory(Factory<? extends Random> randomFactory) {
        this.randomFactory = randomFactory;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public int getAttributesCount() {
        return this.attributes.size();
    }

    public <T> T getAttribute(AttributeRepository.AttributeKey<T> key) {
        return (T)this.attributes.get(Objects.requireNonNull(key, "No key"));
    }

    public Collection<AttributeRepository.AttributeKey<?>> attributeKeys() {
        return this.attributes.isEmpty() ? Collections.emptySet() : new HashSet(this.attributes.keySet());
    }

    public <T> T computeAttributeIfAbsent(AttributeRepository.AttributeKey<T> key, Function<? super AttributeRepository.AttributeKey<T>, ? extends T> resolver) {
        return this.attributes.computeIfAbsent(Objects.requireNonNull(key, "No key"), resolver);
    }

    public <T> T setAttribute(AttributeRepository.AttributeKey<T> key, T value) {
        return (T)this.attributes.put(Objects.requireNonNull(key, "No key"), Objects.requireNonNull(value, "No value"));
    }

    public <T> T removeAttribute(AttributeRepository.AttributeKey<T> key) {
        return (T)this.attributes.remove(Objects.requireNonNull(key, "No key"));
    }

    public void clearAttributes() {
        this.attributes.clear();
    }

    public PropertyResolver getParentPropertyResolver() {
        return this.parentResolver;
    }

    public void setParentPropertyResolver(PropertyResolver parent) {
        this.parentResolver = parent;
    }

    @Override
    public String getVersion() {
        String version = PropertyResolverUtils.getStringProperty((Map)VersionProperties.getVersionProperties(), (String)"sshd-version", (String)"SSHD-UNKNOWN");
        return version.toUpperCase();
    }

    @Override
    public List<? extends ChannelFactory> getChannelFactories() {
        return this.channelFactories;
    }

    public void setChannelFactories(List<? extends ChannelFactory> channelFactories) {
        this.channelFactories = channelFactories;
    }

    public int getNioWorkers() {
        return (Integer)CoreModuleProperties.NIO_WORKERS.getRequired((PropertyResolver)this);
    }

    public void setNioWorkers(int nioWorkers) {
        CoreModuleProperties.NIO_WORKERS.set((PropertyResolver)this, (Object)nioWorkers);
    }

    @Override
    public SshAgentFactory getAgentFactory() {
        return this.agentFactory;
    }

    public void setAgentFactory(SshAgentFactory agentFactory) {
        this.agentFactory = agentFactory;
    }

    @Override
    public ScheduledExecutorService getScheduledExecutorService() {
        return this.executor;
    }

    public void setScheduledExecutorService(ScheduledExecutorService executor) {
        this.setScheduledExecutorService(executor, false);
    }

    public void setScheduledExecutorService(ScheduledExecutorService executor, boolean shutdownExecutor) {
        this.executor = executor;
        this.shutdownExecutor = shutdownExecutor;
    }

    @Override
    public ForwarderFactory getForwarderFactory() {
        return this.forwarderFactory;
    }

    public void setForwarderFactory(ForwarderFactory forwarderFactory) {
        this.forwarderFactory = forwarderFactory;
    }

    @Override
    public ForwardingFilter getForwardingFilter() {
        return this.forwardingFilter;
    }

    public void setForwardingFilter(ForwardingFilter forwardingFilter) {
        this.forwardingFilter = forwardingFilter;
    }

    @Override
    public FileSystemFactory getFileSystemFactory() {
        return this.fileSystemFactory;
    }

    public void setFileSystemFactory(FileSystemFactory fileSystemFactory) {
        this.fileSystemFactory = fileSystemFactory;
    }

    @Override
    public List<? extends ServiceFactory> getServiceFactories() {
        return this.serviceFactories;
    }

    public void setServiceFactories(List<? extends ServiceFactory> serviceFactories) {
        this.serviceFactories = serviceFactories;
    }

    @Override
    public List<RequestHandler<ConnectionService>> getGlobalRequestHandlers() {
        return this.globalRequestHandlers;
    }

    public void setGlobalRequestHandlers(List<RequestHandler<ConnectionService>> globalRequestHandlers) {
        this.globalRequestHandlers = globalRequestHandlers;
    }

    @Override
    public ReservedSessionMessagesHandler getReservedSessionMessagesHandler() {
        return this.reservedSessionMessagesHandler;
    }

    @Override
    public void setReservedSessionMessagesHandler(ReservedSessionMessagesHandler handler) {
        this.reservedSessionMessagesHandler = handler;
    }

    @Override
    public SessionDisconnectHandler getSessionDisconnectHandler() {
        return this.sessionDisconnectHandler;
    }

    @Override
    public void setSessionDisconnectHandler(SessionDisconnectHandler sessionDisconnectHandler) {
        this.sessionDisconnectHandler = sessionDisconnectHandler;
    }

    @Override
    public ChannelStreamWriterResolver getChannelStreamWriterResolver() {
        return this.channelStreamWriterResolver;
    }

    @Override
    public void setChannelStreamWriterResolver(ChannelStreamWriterResolver resolver) {
        this.channelStreamWriterResolver = resolver;
    }

    @Override
    public UnknownChannelReferenceHandler getUnknownChannelReferenceHandler() {
        return this.unknownChannelReferenceHandler;
    }

    @Override
    public void setUnknownChannelReferenceHandler(UnknownChannelReferenceHandler unknownChannelReferenceHandler) {
        this.unknownChannelReferenceHandler = unknownChannelReferenceHandler;
    }

    @Override
    public UnknownChannelReferenceHandler resolveUnknownChannelReferenceHandler() {
        return this.getUnknownChannelReferenceHandler();
    }

    @Override
    public void addSessionListener(SessionListener listener) {
        SessionListener.validateListener(listener);
        if (!this.isOpen()) {
            this.log.warn("addSessionListener({})[{}] ignore registration while manager is closing", (Object)this, (Object)listener);
            return;
        }
        if (this.sessionListeners.add(listener)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("addSessionListener({})[{}] registered", (Object)this, (Object)listener);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("addSessionListener({})[{}] ignored duplicate", (Object)this, (Object)listener);
        }
    }

    @Override
    public void removeSessionListener(SessionListener listener) {
        if (listener == null) {
            return;
        }
        SessionListener.validateListener(listener);
        if (this.sessionListeners.remove(listener)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("removeSessionListener({})[{}] removed", (Object)this, (Object)listener);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("removeSessionListener({})[{}] not registered", (Object)this, (Object)listener);
        }
    }

    @Override
    public SessionListener getSessionListenerProxy() {
        return this.sessionListenerProxy;
    }

    @Override
    public void addChannelListener(ChannelListener listener) {
        ChannelListener.validateListener(listener);
        if (!this.isOpen()) {
            this.log.warn("addChannelListener({})[{}] ignore registration while session is closing", (Object)this, (Object)listener);
            return;
        }
        if (this.channelListeners.add(listener)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("addChannelListener({})[{}] registered", (Object)this, (Object)listener);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("addChannelListener({})[{}] ignored duplicate", (Object)this, (Object)listener);
        }
    }

    @Override
    public void removeChannelListener(ChannelListener listener) {
        if (listener == null) {
            return;
        }
        ChannelListener.validateListener(listener);
        if (this.channelListeners.remove(listener)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("removeChannelListener({})[{}] removed", (Object)this, (Object)listener);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("removeChannelListener({})[{}] not registered", (Object)this, (Object)listener);
        }
    }

    @Override
    public ChannelListener getChannelListenerProxy() {
        return this.channelListenerProxy;
    }

    @Override
    public PortForwardingEventListener getPortForwardingEventListenerProxy() {
        return this.tunnelListenerProxy;
    }

    @Override
    public void addPortForwardingEventListener(PortForwardingEventListener listener) {
        PortForwardingEventListener.validateListener(listener);
        if (!this.isOpen()) {
            this.log.warn("addPortForwardingEventListener({})[{}] ignore registration while session is closing", (Object)this, (Object)listener);
            return;
        }
        if (this.tunnelListeners.add(listener)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("addPortForwardingEventListener({})[{}] registered", (Object)this, (Object)listener);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("addPortForwardingEventListener({})[{}] ignored duplicate", (Object)this, (Object)listener);
        }
    }

    @Override
    public void removePortForwardingEventListener(PortForwardingEventListener listener) {
        if (listener == null) {
            return;
        }
        PortForwardingEventListener.validateListener(listener);
        if (this.tunnelListeners.remove(listener)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("removePortForwardingEventListener({})[{}] removed", (Object)this, (Object)listener);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("removePortForwardingEventListener({})[{}] not registered", (Object)this, (Object)listener);
        }
    }

    protected void setupSessionTimeout(AbstractSessionFactory<?, ?> sessionFactory) {
        SessionTimeoutListener listener = this.createSessionTimeoutListener();
        this.sessionTimeoutListener.set(listener);
        this.addSessionListener(listener);
    }

    protected void removeSessionTimeout(AbstractSessionFactory<?, ?> sessionFactory) {
        this.stopSessionTimeoutListener(sessionFactory);
    }

    protected SessionTimeoutListener createSessionTimeoutListener() {
        return new SessionTimeoutListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sessionCreated(Session session) {
                1 var2_2 = this;
                synchronized (var2_2) {
                    super.sessionCreated(session);
                    if (!this.sessions.isEmpty()) {
                        AbstractFactoryManager.this.ensureTimeoutScheduled();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sessionClosed(Session s) {
                1 var2_2 = this;
                synchronized (var2_2) {
                    super.sessionClosed(s);
                    if (this.sessions.isEmpty()) {
                        AbstractFactoryManager.this.cancelSessionTimeout();
                    }
                }
            }
        };
    }

    private void ensureTimeoutScheduled() {
        if (this.isOpen() && this.timeoutListenerFuture.get() == null) {
            this.timeoutListenerFuture.set(this.getScheduledExecutorService().scheduleAtFixedRate(this.sessionTimeoutListener.get(), 1L, 1L, TimeUnit.SECONDS));
        }
    }

    private void cancelSessionTimeout() {
        ScheduledFuture future = this.timeoutListenerFuture.getAndSet(null);
        if (future != null) {
            future.cancel(true);
        }
    }

    protected void stopSessionTimeoutListener(AbstractSessionFactory<?, ?> sessionFactory) {
        this.cancelSessionTimeout();
        SessionTimeoutListener listener = this.sessionTimeoutListener.getAndSet(null);
        if (listener != null) {
            this.removeSessionListener(listener);
        }
    }

    protected void checkConfig() {
        ValidateUtils.checkNotNullAndNotEmpty(this.getKeyExchangeFactories(), (String)"KeyExchangeFactories not set", (Object[])new Object[0]);
        if (this.getScheduledExecutorService() == null) {
            this.setScheduledExecutorService(ThreadUtils.newSingleThreadScheduledExecutor((String)(this.toString() + "-timer")), true);
        }
        ValidateUtils.checkNotNullAndNotEmpty(this.getCipherFactories(), (String)"CipherFactories not set", (Object[])new Object[0]);
        ValidateUtils.checkNotNullAndNotEmpty(this.getCompressionFactories(), (String)"CompressionFactories not set", (Object[])new Object[0]);
        ValidateUtils.checkNotNullAndNotEmpty(this.getMacFactories(), (String)"MacFactories not set", (Object[])new Object[0]);
        Objects.requireNonNull(this.getRandomFactory(), "RandomFactory not set");
        if (this.getIoServiceFactoryFactory() == null) {
            DefaultIoServiceFactoryFactory defaultFactory = DefaultIoServiceFactoryFactory.getDefaultIoServiceFactoryFactoryInstance();
            this.setIoServiceFactoryFactory(defaultFactory);
        }
    }
}

