/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.finalize;

import java.util.ArrayList;
import java.util.Collections;
import jpt.sun.source.tree.BlockTree;
import jpt.sun.source.tree.ExpressionTree;
import jpt.sun.source.tree.IdentifierTree;
import jpt.sun.source.tree.MemberSelectTree;
import jpt.sun.source.tree.MethodInvocationTree;
import jpt.sun.source.tree.MethodTree;
import jpt.sun.source.tree.StatementTree;
import jpt.sun.source.tree.Tree;
import jpt.sun.source.tree.TryTree;
import jpt.sun.source.util.TreePath;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.support.ErrorAwareTreeScanner;
import org.netbeans.modules.java.hints.finalize.Util;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.openide.util.NbBundle;

public class FinalizeDoesNotCallSuper {
    private static final String SUPER = "super";
    private static final String FINALIZE = "finalize";

    public static ErrorDescription hint(HintContext ctx) {
        assert (ctx != null);
        TreePath tp = ctx.getPath();
        MethodTree method = (MethodTree)tp.getLeaf();
        if (method.getBody() == null) {
            return null;
        }
        if (!Util.isFinalize(method)) {
            return null;
        }
        FindSuper scanner = new FindSuper();
        scanner.scan((Tree)method, null);
        if (scanner.found) {
            return null;
        }
        return ErrorDescriptionFactory.forName(ctx, method, NbBundle.getMessage(FinalizeDoesNotCallSuper.class, "TXT_FinalizeDoesNotCallSuper"), new FixImpl(TreePathHandle.create(ctx.getPath(), ctx.getInfo())).toEditorFix());
    }

    static final class FindSuper
    extends ErrorAwareTreeScanner<Void, Void> {
        boolean found;

        FindSuper() {
        }

        @Override
        public Void scan(Tree node, Void p) {
            return this.found ? null : (Void)super.scan(node, p);
        }

        @Override
        public Void visitMethodInvocation(MethodInvocationTree node, Void p) {
            if (!node.getArguments().isEmpty()) {
                return null;
            }
            ExpressionTree et = node.getMethodSelect();
            if (et.getKind() != Tree.Kind.MEMBER_SELECT) {
                return null;
            }
            MemberSelectTree mst = (MemberSelectTree)et;
            if (!FinalizeDoesNotCallSuper.FINALIZE.contentEquals(mst.getIdentifier())) {
                return null;
            }
            if (mst.getExpression().getKind() != Tree.Kind.IDENTIFIER) {
                return null;
            }
            if (!FinalizeDoesNotCallSuper.SUPER.contentEquals(((IdentifierTree)mst.getExpression()).getName())) {
                return null;
            }
            this.found = true;
            return null;
        }
    }

    static class FixImpl
    extends JavaFix {
        public FixImpl(TreePathHandle handle) {
            super(handle);
            assert (handle != null);
        }

        @Override
        public String getText() {
            return NbBundle.getMessage(FinalizeDoesNotCallSuper.class, "FIX_FinalizeDoesNotCallSuper");
        }

        @Override
        protected void performRewrite(JavaFix.TransformationContext ctx) {
            WorkingCopy wc = ctx.getWorkingCopy();
            TreeMaker tm = wc.getTreeMaker();
            TreePath tp = ctx.getPath();
            BlockTree oldBody = ((MethodTree)tp.getLeaf()).getBody();
            if (oldBody == null) {
                return;
            }
            ArrayList newStatements = new ArrayList(2);
            BlockTree superFinalize = tm.Block(Collections.singletonList(tm.ExpressionStatement(tm.MethodInvocation(Collections.emptyList(), tm.MemberSelect((ExpressionTree)tm.Identifier(FinalizeDoesNotCallSuper.SUPER), FinalizeDoesNotCallSuper.FINALIZE), Collections.emptyList()))), false);
            if (oldBody.getStatements().isEmpty()) {
                wc.rewrite(oldBody, superFinalize);
            } else {
                TryTree soleTry = this.soleTryWithoutFinally(oldBody);
                if (soleTry != null) {
                    wc.rewrite(soleTry, tm.Try(soleTry.getBlock(), soleTry.getCatches(), superFinalize));
                } else {
                    wc.rewrite(oldBody, tm.Block(Collections.singletonList(tm.Try(oldBody, Collections.emptyList(), superFinalize)), false));
                }
            }
        }

        private TryTree soleTryWithoutFinally(BlockTree block) {
            if (block.getStatements().size() != 1) {
                return null;
            }
            StatementTree first = block.getStatements().get(0);
            if (first.getKind() != Tree.Kind.TRY) {
                return null;
            }
            TryTree tt = (TryTree)first;
            if (tt.getFinallyBlock() != null) {
                return null;
            }
            return tt;
        }
    }
}

