/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jpt30.tools.FileObject;
import jpt30.tools.JavaFileManager;
import jpt30.tools.JavaFileObject;
import jpt30.tools.StandardLocation;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.BinaryForSourceQuery;
import org.netbeans.modules.java.source.indexing.JavaIndex;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.parsing.InferableJavaFileObject;
import org.netbeans.modules.java.source.parsing.ModuleLocation;
import org.netbeans.modules.java.source.util.Iterators;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.BaseUtilities;
import org.openide.util.Pair;

final class PatchModuleFileManager
implements JavaFileManager {
    private static final Logger LOG = Logger.getLogger(PatchModuleFileManager.class.getName());
    private final JavaFileManager binDelegate;
    private final JavaFileManager srcDelegate;
    private final ClassPath src;
    private final Map<String, List<URL>> patches;
    private final Map<URL, String> roots;
    private Set<PatchLocation> moduleLocations;
    private String overrideModuleName;

    PatchModuleFileManager(@NonNull JavaFileManager binDelegate, @NonNull JavaFileManager srcDelegate, @NonNull ClassPath src) {
        this.binDelegate = binDelegate;
        this.srcDelegate = srcDelegate;
        this.src = src;
        this.patches = new HashMap<String, List<URL>>();
        this.roots = new HashMap<URL, String>();
    }

    @Override
    public JavaFileManager.Location getLocationForModule(JavaFileManager.Location location, String moduleName) throws IOException {
        if (location == StandardLocation.PATCH_MODULE_PATH) {
            return this.moduleLocations(location).stream().filter(ml -> moduleName != null && moduleName.equals(ml.getModuleName())).findFirst().orElse(null);
        }
        if (location == StandardLocation.CLASS_OUTPUT) {
            return this.moduleLocations(StandardLocation.PATCH_MODULE_PATH).stream().filter(pl -> moduleName != null && moduleName.equals(pl.getModuleName())).findFirst().map(pl -> {
                List cacheRoots = pl.getSrc() == null ? Collections.emptyList() : pl.getSrc().getModuleRoots().stream().map(url -> {
                    try {
                        return BaseUtilities.toURI(JavaIndex.getClassFolder(url, false, false)).toURL();
                    }
                    catch (IOException ioe) {
                        LOG.log(Level.WARNING, "Cannot determine the cache URL for: {0}", url);
                        return null;
                    }
                }).filter(url -> url != null).collect(Collectors.toList());
                return cacheRoots.isEmpty() ? null : new PatchLocation(StandardLocation.PATCH_MODULE_PATH, cacheRoots, Collections.emptyList(), pl.getModuleName());
            }).orElse(null);
        }
        return null;
    }

    @Override
    public JavaFileManager.Location getLocationForModule(JavaFileManager.Location location, JavaFileObject fo) throws IOException {
        if (location == StandardLocation.PATCH_MODULE_PATH) {
            URL url = fo.toUri().toURL();
            for (Map.Entry<URL, String> root : this.roots.entrySet()) {
                if (!FileObjects.isParentOf(root.getKey(), url)) continue;
                String modName = root.getValue();
                return this.moduleLocations(location).stream().filter(ml -> modName.equals(ml.getModuleName())).findFirst().orElse(null);
            }
        }
        return null;
    }

    @Override
    public Iterable<Set<JavaFileManager.Location>> listLocationsForModules(JavaFileManager.Location location) throws IOException {
        if (location == StandardLocation.PATCH_MODULE_PATH) {
            return this.moduleLocations(location).stream().map(ml -> Collections.singleton(ml)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public String inferModuleName(JavaFileManager.Location location) throws IOException {
        return ModuleLocation.cast(location).getModuleName();
    }

    @Override
    public int isSupportedOption(String option) {
        return -1;
    }

    @Override
    public boolean handleOption(String head, Iterator<String> tail) {
        if ("--patch-module".equals(head)) {
            Pair<String, List<URL>> modulePatches = FileObjects.parseModulePatches(tail);
            if (modulePatches != null) {
                this.addModulePatches(modulePatches.first(), modulePatches.second());
                return true;
            }
        } else if (head.startsWith("-Xnb-Xmodule:")) {
            this.overrideModuleName = head.substring("-Xnb-Xmodule:".length());
            this.addModulePatches(this.overrideModuleName, this.src.entries().stream().map(e -> e.getURL()).collect(Collectors.toList()));
            return true;
        }
        return false;
    }

    private void addModulePatches(String moduleName, List<URL> patchURLs) {
        if (this.patches.putIfAbsent(moduleName, patchURLs) == null) {
            for (URL url : patchURLs) {
                this.roots.put(url, moduleName);
            }
        } else {
            LOG.log(Level.WARNING, "Duplicate --patch-module option, ignoring: {0}", patchURLs);
        }
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        return (StandardLocation.PATCH_MODULE_PATH == location || StandardLocation.CLASS_OUTPUT == location) && !this.patches.isEmpty();
    }

    @Override
    public boolean isSameFile(FileObject a, FileObject b) {
        return this.binDelegate.isSameFile(a, b) || this.srcDelegate.isSameFile(a, b);
    }

    @Override
    public void flush() throws IOException {
        this.binDelegate.flush();
        this.srcDelegate.flush();
    }

    @Override
    public void close() throws IOException {
        this.binDelegate.close();
        this.srcDelegate.close();
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        return null;
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        if (PatchLocation.isInstance(location = this.fixLocation(location))) {
            PatchLocation pl = PatchLocation.cast(location);
            ModuleLocation bin = pl.getBin();
            ModuleLocation.WithExcludes src = pl.getSrc();
            EnumSet<JavaFileObject.Kind> binKinds = EnumSet.copyOf(kinds);
            binKinds.remove((Object)JavaFileObject.Kind.SOURCE);
            if (bin == null) {
                return src == null ? Collections.emptyList() : this.srcDelegate.list(src, packageName, kinds, recurse);
            }
            if (src == null) {
                return this.binDelegate.list(bin, packageName, binKinds, recurse);
            }
            ArrayList<Iterable<JavaFileObject>> res = new ArrayList<Iterable<JavaFileObject>>(2);
            res.add(this.binDelegate.list(bin, packageName, binKinds, recurse));
            res.add(this.srcDelegate.list(src, packageName, kinds, recurse));
            return Iterators.chained(res);
        }
        return Collections.emptyList();
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        if (file instanceof InferableJavaFileObject) {
            return ((InferableJavaFileObject)file).inferBinaryName();
        }
        return null;
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
        if (PatchLocation.isInstance(location = this.fixLocation(location))) {
            JavaFileObject jfo;
            PatchLocation pl = PatchLocation.cast(location);
            ModuleLocation bin = pl.getBin();
            ModuleLocation.WithExcludes src = pl.getSrc();
            if (bin != null && (jfo = this.binDelegate.getJavaFileForInput(bin, className, kind)) != null) {
                return jfo;
            }
            if (src != null && (jfo = this.srcDelegate.getJavaFileForInput(src, className, kind)) != null) {
                return jfo;
            }
        }
        return null;
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        throw new UnsupportedOperationException("Not supported by patch JavaFileManager.");
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
        throw new UnsupportedOperationException("Not supported by patch JavaFileManager.");
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) throws IOException {
        throw new UnsupportedOperationException("Not supported by patch JavaFileManager.");
    }

    private JavaFileManager.Location fixLocation(JavaFileManager.Location input) throws IOException {
        if (input == StandardLocation.CLASS_OUTPUT && this.overrideModuleName != null) {
            return this.moduleLocations(StandardLocation.PATCH_MODULE_PATH).stream().filter(pl -> this.overrideModuleName.equals(pl.getModuleName())).map(pl -> pl).findAny().orElse(input);
        }
        return input;
    }

    private Set<PatchLocation> moduleLocations(JavaFileManager.Location baseLocation) throws IOException {
        if (baseLocation != StandardLocation.PATCH_MODULE_PATH) {
            throw new IllegalStateException(baseLocation.toString());
        }
        if (this.moduleLocations == null) {
            HashSet<PatchLocation> res = new HashSet<PatchLocation>();
            for (Map.Entry<String, List<URL>> patch : this.patches.entrySet()) {
                res.add(PatchModuleFileManager.createPatchLocation(patch.getKey(), patch.getValue(), patch.getKey().equals(this.overrideModuleName)));
            }
            this.moduleLocations = Collections.unmodifiableSet(res);
        }
        return this.moduleLocations;
    }

    @NonNull
    private static PatchLocation createPatchLocation(@NonNull String modName, @NonNull List<? extends URL> roots, boolean sourceOverride) throws IOException {
        ArrayList<URL> bin = new ArrayList<URL>(roots.size());
        ArrayList<URL> src = new ArrayList<URL>(roots.size());
        for (URL uRL : roots) {
            if (JavaIndex.hasSourceCache(uRL, false)) {
                src.add(uRL);
                bin.add(FileUtil.urlForArchiveOrDir(JavaIndex.getClassFolder(uRL)));
                continue;
            }
            if (sourceOverride) {
                bin.addAll(Arrays.asList(BinaryForSourceQuery.findBinaryRoots(uRL).getRoots()));
                continue;
            }
            bin.add(uRL);
        }
        return new PatchLocation(StandardLocation.PATCH_MODULE_PATH, bin, src, modName);
    }

    private static final class PatchLocation
    extends ModuleLocation {
        private final ModuleLocation bin;
        private final ModuleLocation.WithExcludes src;

        PatchLocation(@NonNull JavaFileManager.Location base, @NonNull Collection<? extends URL> bin, @NonNull Collection<? extends URL> src, @NonNull String name) {
            super(base, name, Stream.of(bin, src).flatMap(c -> c.stream()).collect(Collectors.toList()));
            this.bin = PatchLocation.binaryLocation(name, bin);
            this.src = PatchLocation.sourceLocation(name, src);
        }

        @CheckForNull
        ModuleLocation getBin() {
            return this.bin;
        }

        @CheckForNull
        ModuleLocation.WithExcludes getSrc() {
            return this.src;
        }

        @CheckForNull
        private static ModuleLocation binaryLocation(@NonNull String name, @NonNull Collection<? extends URL> roots) {
            if (roots.isEmpty()) {
                return null;
            }
            return ModuleLocation.create(StandardLocation.MODULE_PATH, roots, name);
        }

        @CheckForNull
        private static ModuleLocation.WithExcludes sourceLocation(@NonNull String name, @NonNull Collection<? extends URL> roots) {
            if (roots.isEmpty()) {
                return null;
            }
            Collection moduleEntries = roots.stream().map(root -> {
                ClassPath cp;
                org.openide.filesystems.FileObject fo = URLMapper.findFileObject(root);
                if (fo != null && (cp = ClassPath.getClassPath(fo, "classpath/source")) != null) {
                    for (ClassPath.Entry e : cp.entries()) {
                        if (!root.equals(e.getURL())) continue;
                        return e;
                    }
                }
                return ClassPathSupport.createClassPath(root).entries().get(0);
            }).collect(Collectors.toList());
            return ModuleLocation.WithExcludes.createExcludes(StandardLocation.MODULE_SOURCE_PATH, moduleEntries, name);
        }

        static boolean isInstance(JavaFileManager.Location l) {
            return l.getClass() == PatchLocation.class;
        }

        @NonNull
        static PatchLocation cast(JavaFileManager.Location l) {
            if (PatchLocation.isInstance(l)) {
                return (PatchLocation)l;
            }
            throw new IllegalArgumentException(String.valueOf(l));
        }
    }
}

