/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.support.ant;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.project.spi.intern.ProjectIDEServices;
import org.netbeans.modules.project.spi.intern.ProjectIDEServicesImplementation;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.BaseUtilities;
import org.openide.util.ChangeSupport;
import org.openide.util.Mutex;
import org.openide.util.NbCollections;
import org.openide.util.RequestProcessor;

final class ProjectProperties {
    private final AntProjectHelper helper;
    private final Map<String, PP> properties = new HashMap<String, PP>();
    private PropertyProvider stockPropertyPreprovider = null;
    private PropertyEvaluator standardPropertyEvaluator = null;
    static File antJar;

    public ProjectProperties(AntProjectHelper helper) {
        this.helper = helper;
    }

    public EditableProperties getProperties(String path) {
        EditableProperties ep = this.getPP(path).getEditablePropertiesOrNull();
        if (ep != null) {
            return ep.cloneProperties();
        }
        return new EditableProperties(true);
    }

    public boolean putProperties(String path, EditableProperties props) {
        return this.getPP(path).put(props);
    }

    public FileLock write(String path) throws IOException {
        assert (this.properties.containsKey(path));
        return this.getPP(path).write();
    }

    public PropertyProvider getPropertyProvider(String path) {
        return this.getPP(path);
    }

    private PP getPP(String path) {
        PP pp = this.properties.get(path);
        if (pp == null) {
            pp = new PP(path, this.helper);
            this.properties.put(path, pp);
        }
        return pp;
    }

    private static synchronized File antJar() {
        if (antJar == null) {
            antJar = InstalledFileLocator.getDefault().locate("ant/lib/ant.jar", "org.apache.tools.ant.module", false);
        }
        return antJar;
    }

    public PropertyProvider getStockPropertyPreprovider() {
        if (this.stockPropertyPreprovider == null) {
            Map<String, String> m = null;
            while (m == null) {
                try {
                    m = NbCollections.checkedMapByCopy(System.getProperties(), String.class, String.class, false);
                }
                catch (ConcurrentModificationException x) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            m.put("basedir", FileUtil.toFile(this.helper.getProjectDirectory()).getAbsolutePath());
            File _antJar = ProjectProperties.antJar();
            if (_antJar != null) {
                File antHome = _antJar.getParentFile().getParentFile();
                m.put("ant.home", antHome.getAbsolutePath());
                m.put("ant.core.lib", _antJar.getAbsolutePath());
            }
            this.stockPropertyPreprovider = PropertyUtils.fixedPropertyProvider(m);
        }
        return this.stockPropertyPreprovider;
    }

    public PropertyEvaluator getStandardPropertyEvaluator() {
        if (this.standardPropertyEvaluator == null) {
            PropertyEvaluator findUserPropertiesFile = PropertyUtils.sequentialPropertyEvaluator(this.getStockPropertyPreprovider(), this.getPropertyProvider("nbproject/private/private.properties"));
            PropertyProvider globalProperties = PropertyUtils.userPropertiesProvider(findUserPropertiesFile, "user.properties.file", FileUtil.toFile(this.helper.getProjectDirectory()));
            this.standardPropertyEvaluator = PropertyUtils.sequentialPropertyEvaluator(this.getStockPropertyPreprovider(), this.getPropertyProvider("nbproject/private/private.properties"), this.helper.getProjectLibrariesPropertyProvider(), globalProperties, this.getPropertyProvider("nbproject/project.properties"));
        }
        return this.standardPropertyEvaluator;
    }

    private static final class PP
    implements PropertyProvider,
    FileChangeListener {
        private static final RequestProcessor RP = new RequestProcessor("ProjectProperties.PP.RP");
        private final String path;
        private final AntProjectHelper helper;
        private EditableProperties properties = null;
        private boolean loaded = false;
        private Throwable reloadedStackTrace;
        private final ChangeSupport cs = new ChangeSupport(this);
        private final Set<FileSystem.AtomicAction> saveActions = Collections.newSetFromMap(new WeakHashMap());
        private final AtomicBoolean fileListenerSet = new AtomicBoolean(false);
        private boolean filePropertiesChanged;
        private EditableProperties cachedPropertiesFromFile;

        public PP(String path, AntProjectHelper helper) {
            this.path = path;
            this.helper = helper;
        }

        private void lazyAttachListener() {
            if (this.fileListenerSet.compareAndSet(false, true)) {
                File fl = new File(FileUtil.toFile(this.dir()), this.path.replace('/', File.separatorChar));
                FileUtil.addFileChangeListener(this, FileUtil.normalizeFile(fl));
            }
        }

        private FileObject dir() {
            return this.helper.getProjectDirectory();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public EditableProperties getEditablePropertiesOrNull() {
            this.lazyAttachListener();
            if (!this.loaded) {
                this.properties = null;
                FileObject fo = this.dir().getFileObject(this.path);
                if (fo != null) {
                    try {
                        EditableProperties p;
                        try (InputStream is = fo.getInputStream();){
                            p = new EditableProperties(true);
                            p.load(is);
                        }
                        this.properties = p;
                        this.cachedPropertiesFromFile = p;
                    }
                    catch (IOException e) {
                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, null, e);
                    }
                }
                this.loaded = true;
                this.reloadedStackTrace = null;
            }
            return this.properties;
        }

        public boolean put(EditableProperties nue) {
            boolean modifying;
            this.loaded = true;
            this.reloadedStackTrace = null;
            this.filePropertiesChanged = this.filePropertiesChanged || !Objects.equals(nue, this.cachedPropertiesFromFile);
            boolean bl = modifying = !BaseUtilities.compareObjects(nue, this.properties);
            if (modifying) {
                this.properties = nue != null ? nue.cloneProperties() : null;
                this.fireChange();
            }
            return modifying;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runSaveAA(FileSystem.AtomicAction action) throws IOException {
            Set<FileSystem.AtomicAction> set = this.saveActions;
            synchronized (set) {
                this.saveActions.add(action);
            }
            this.dir().getFileSystem().runAtomicAction(action);
        }

        public FileLock write() throws IOException {
            this.lazyAttachListener();
            if (!this.loaded) {
                Logger.getLogger(ProjectProperties.class.getName()).log(Level.INFO, null, new IOException("#167784: changes on disk for " + this.path + " in " + this.dir() + " clobbered by in-memory data").initCause(this.reloadedStackTrace));
                this.loaded = true;
                this.reloadedStackTrace = null;
            }
            final FileObject f = this.dir().getFileObject(this.path);
            final FileLock[] _lock = new FileLock[1];
            try {
                if (this.properties != null && this.filePropertiesChanged) {
                    this.filePropertiesChanged = false;
                    this.runSaveAA(new FileSystem.AtomicAction(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() throws IOException {
                            FileObject _f;
                            if (f == null) {
                                _f = FileUtil.createData(this.dir(), path);
                                assert (_f != null) : "FU.cD must not return null; called on " + this.dir() + " + " + path;
                            } else {
                                _f = f;
                            }
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            properties.store(baos);
                            final byte[] data = baos.toByteArray();
                            try {
                                _lock[0] = _f.lock();
                                try (OutputStream os = _f.getOutputStream(_lock[0]);){
                                    os.write(data);
                                    cachedPropertiesFromFile = properties;
                                }
                            }
                            catch (IOException ioe) {
                                helper.needPendingHook();
                                if (!ProjectIDEServices.isUserQuestionException(ioe)) {
                                    throw ioe;
                                }
                                ProjectIDEServices.handleUserQuestionException(ioe, new ProjectIDEServicesImplementation.UserQuestionExceptionCallback(){

                                    @Override
                                    public void accepted() {
                                        try {
                                            this.runSaveAA(new FileSystem.AtomicAction(){

                                                @Override
                                                public void run() throws IOException {
                                                    try (OutputStream os = _f.getOutputStream();){
                                                        os.write(data);
                                                        cachedPropertiesFromFile = properties;
                                                    }
                                                    helper.maybeCallPendingHook();
                                                }
                                            });
                                        }
                                        catch (IOException e) {
                                            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, e);
                                            this.reload();
                                        }
                                    }

                                    @Override
                                    public void denied() {
                                        this.reload();
                                    }

                                    @Override
                                    public void error(IOException e) {
                                        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, e);
                                        this.reload();
                                    }

                                    private void reload() {
                                        helper.cancelPendingHook();
                                        this.diskChange(null);
                                    }
                                });
                            }
                        }
                    });
                } else if (this.properties == null && f != null) {
                    f.delete();
                }
            }
            catch (IOException e) {
                if (_lock[0] != null) {
                    _lock[0].releaseLock();
                }
                throw e;
            }
            return _lock[0];
        }

        @Override
        public Map<String, String> getProperties() {
            EditableProperties props = this.getEditablePropertiesOrNull();
            if (props != null) {
                return Collections.unmodifiableMap(props);
            }
            return Collections.emptyMap();
        }

        @Override
        public synchronized void addChangeListener(ChangeListener l) {
            this.cs.addChangeListener(l);
        }

        @Override
        public synchronized void removeChangeListener(ChangeListener l) {
            this.cs.removeChangeListener(l);
        }

        private void fireChange() {
            if (!this.cs.hasListeners()) {
                return;
            }
            final Mutex.Action<Void> action = new Mutex.Action<Void>(){

                @Override
                public Void run() {
                    cs.fireChange();
                    return null;
                }
            };
            if (ProjectManager.mutex().isWriteAccess()) {
                ProjectManager.mutex().readAccess(action);
            } else if (ProjectManager.mutex().isReadAccess()) {
                action.run();
            } else {
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        ProjectManager.mutex().readAccess(action);
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void diskChange(FileEvent fe) {
            boolean writing = false;
            if (fe != null) {
                Set<FileSystem.AtomicAction> set = this.saveActions;
                synchronized (set) {
                    for (FileSystem.AtomicAction a : this.saveActions) {
                        if (!fe.firedFrom(a)) continue;
                        writing = true;
                        break;
                    }
                }
            }
            if (!writing) {
                this.loaded = false;
                this.reloadedStackTrace = new Throwable("noticed disk change here");
            }
            this.fireChange();
            if (!writing) {
                this.helper.fireExternalChange(this.path);
            }
        }

        @Override
        public void fileFolderCreated(FileEvent fe) {
            this.diskChange(fe);
        }

        @Override
        public void fileDataCreated(FileEvent fe) {
            this.diskChange(fe);
        }

        @Override
        public void fileChanged(FileEvent fe) {
            this.diskChange(fe);
        }

        @Override
        public void fileRenamed(FileRenameEvent fe) {
            this.diskChange(fe);
        }

        @Override
        public void fileDeleted(FileEvent fe) {
            this.diskChange(fe);
        }

        @Override
        public void fileAttributeChanged(FileAttributeEvent fe) {
        }
    }
}

