/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.core.ui.options.filetypes;

import org.netbeans.core.ui.options.filetypes.FileAssociationsModel.MimeItem;
import org.openide.util.NbBundle;

/** Panel with list of available MIME types.
 *
 * @author Jiri Skrivanek
 */
public class OpenAsPanel extends javax.swing.JPanel {

    private FileAssociationsModel model;
    
    /** Creates new OpenAsPanel */
    public OpenAsPanel() {
        initComponents();
        lblDescription.setText("<html>" + lblDescription.getText() + "</html>");  //NOI18N
        getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(OpenAsPanel.class, "OpenAsPanel.AD")); // NOI18N
    }

    void setModel(FileAssociationsModel model) {
        this.model = model;
    }
    
    /** Returns selected MIME type. */
    String getMimeType() {
        if(lstMimeTypes.getSelectedValue() != null) {
            return ((MimeItem)lstMimeTypes.getSelectedValue()).getMimeType();
        }
        return null;
    }

    void setExtension(String extension) {
        lblExtension.setText(NbBundle.getMessage(OpenAsPanel.class, "OpenAsPanel.lblExtension.text", extension)); // NOI18N
        updateList();
    }
    
    void updateList() {
        lstMimeTypes.setListData(model.getMimeItems().toArray());
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new javax.swing.JPanel();
        lblExtension = new javax.swing.JLabel();
        jScrollPane2 = new javax.swing.JScrollPane();
        lstMimeTypes = new javax.swing.JList();
        jPanel2 = new javax.swing.JPanel();
        lblDescription = new javax.swing.JLabel();

        setPreferredSize(new java.awt.Dimension(250, 300));
        setLayout(new java.awt.BorderLayout());

        lblExtension.setLabelFor(lstMimeTypes);
        lblExtension.setText("Treat files as:"); // NOI18N

        lstMimeTypes.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        jScrollPane2.setViewportView(lstMimeTypes);

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jScrollPane2, javax.swing.GroupLayout.DEFAULT_SIZE, 283, Short.MAX_VALUE)
                    .addComponent(lblExtension))
                .addContainerGap())
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addComponent(lblExtension)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane2, javax.swing.GroupLayout.DEFAULT_SIZE, 240, Short.MAX_VALUE))
        );

        add(jPanel1, java.awt.BorderLayout.CENTER);

        lblDescription.setText(org.openide.util.NbBundle.getMessage(OpenAsPanel.class, "OpenAsPanel.lblDescription.text")); // NOI18N

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(lblDescription)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(lblDescription)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        add(jPanel2, java.awt.BorderLayout.NORTH);
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JLabel lblDescription;
    private javax.swing.JLabel lblExtension;
    private javax.swing.JList lstMimeTypes;
    // End of variables declaration//GEN-END:variables

}
