/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authentication.ott;

import java.util.Collection;
import org.jspecify.annotations.Nullable;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.Assert;

public class OneTimeTokenAuthentication
extends AbstractAuthenticationToken {
    private static final long serialVersionUID = 1195893764725073959L;
    private final Object principal;

    public OneTimeTokenAuthentication(Object principal, Collection<? extends GrantedAuthority> authorities) {
        super(authorities);
        this.principal = principal;
        this.setAuthenticated(true);
    }

    protected OneTimeTokenAuthentication(Builder<?> builder) {
        super(builder);
        this.principal = builder.principal;
    }

    @Override
    public Object getPrincipal() {
        return this.principal;
    }

    @Override
    public @Nullable Object getCredentials() {
        return null;
    }

    public Builder<?> toBuilder() {
        return new Builder(this);
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractAuthenticationToken.AbstractAuthenticationBuilder<B> {
        private Object principal;

        protected Builder(OneTimeTokenAuthentication token) {
            super(token);
            this.principal = token.principal;
        }

        @Override
        public B principal(@Nullable Object principal) {
            Assert.notNull((Object)principal, (String)"principal cannot be null");
            this.principal = principal;
            return (B)this;
        }

        @Override
        public OneTimeTokenAuthentication build() {
            return new OneTimeTokenAuthentication(this);
        }
    }
}

