/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.segment;

import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.MapFile;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileRecordReader;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.nutch.crawl.CrawlDatum;
import org.apache.nutch.crawl.Generator;
import org.apache.nutch.metadata.MetaWrapper;
import org.apache.nutch.net.URLFilters;
import org.apache.nutch.net.URLNormalizers;
import org.apache.nutch.parse.ParseData;
import org.apache.nutch.parse.ParseText;
import org.apache.nutch.protocol.Content;
import org.apache.nutch.segment.SegmentMergeFilters;
import org.apache.nutch.segment.SegmentPart;
import org.apache.nutch.util.HadoopFSUtil;
import org.apache.nutch.util.NutchConfiguration;
import org.apache.nutch.util.NutchJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentMerger
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String SEGMENT_PART_KEY = "part";
    private static final String SEGMENT_SLICE_KEY = "slice";

    public SegmentMerger() {
        super(null);
    }

    public SegmentMerger(Configuration conf) {
        super(conf);
    }

    public void setConf(Configuration conf) {
        super.setConf(conf);
    }

    public void merge(Path out, Path[] segs, boolean filter, boolean normalize, long slice) throws IOException, ClassNotFoundException, InterruptedException {
        int i;
        String segmentName = Generator.generateSegmentName();
        LOG.info("Merging {} segments to {}/{}", new Object[]{segs.length, out, segmentName});
        Job job = Job.getInstance((Configuration)this.getConf(), (String)("Nutch SegmentMerger: " + String.valueOf(out) + "/" + segmentName));
        Configuration conf = job.getConfiguration();
        conf.setBoolean("segment.merger.filter", filter);
        conf.setBoolean("segment.merger.normalizer", normalize);
        conf.setLong("segment.merger.slice", slice);
        conf.set("segment.merger.segmentName", segmentName);
        boolean g = true;
        boolean f = true;
        boolean p = true;
        boolean c = true;
        boolean pd = true;
        boolean pt = true;
        boolean pg = true;
        boolean pf = true;
        boolean pp = true;
        boolean pc = true;
        boolean ppd = true;
        boolean ppt = true;
        for (i = 0; i < segs.length; ++i) {
            FileSystem fs = segs[i].getFileSystem(conf);
            if (!fs.exists(segs[i])) {
                LOG.warn("Input dir {} doesn't exist, skipping.", (Object)segs[i]);
                segs[i] = null;
                continue;
            }
            LOG.info("SegmentMerger:   adding {}", (Object)segs[i]);
            Path cDir = new Path(segs[i], "content");
            Path gDir = new Path(segs[i], "crawl_generate");
            Path fDir = new Path(segs[i], "crawl_fetch");
            Path pDir = new Path(segs[i], "crawl_parse");
            Path pdDir = new Path(segs[i], "parse_data");
            Path ptDir = new Path(segs[i], "parse_text");
            c = c && fs.exists(cDir);
            g = g && fs.exists(gDir);
            f = f && fs.exists(fDir);
            p = p && fs.exists(pDir);
            pd = pd && fs.exists(pdDir);
            boolean bl = pt = pt && fs.exists(ptDir);
            if (g != pg || f != pf || p != pp || c != pc || pd != ppd || pt != ppt) {
                LOG.info("{} changed input dirs", (Object)segs[i]);
            }
            pg = g;
            pf = f;
            pp = p;
            pc = c;
            ppd = pd;
            ppt = pt;
        }
        if (LOG.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            if (c) {
                sb.append(" content");
            }
            if (g) {
                sb.append(" crawl_generate");
            }
            if (f) {
                sb.append(" crawl_fetch");
            }
            if (p) {
                sb.append(" crawl_parse");
            }
            if (pd) {
                sb.append(" parse_data");
            }
            if (pt) {
                sb.append(" parse_text");
            }
            LOG.info("SegmentMerger: using segment data from: {}", (Object)sb.toString());
        }
        for (i = 0; i < segs.length; ++i) {
            if (segs[i] == null) continue;
            if (g) {
                Path gDir = new Path(segs[i], "crawl_generate");
                FileInputFormat.addInputPath((Job)job, (Path)gDir);
            }
            if (c) {
                Path cDir = new Path(segs[i], "content");
                FileInputFormat.addInputPath((Job)job, (Path)cDir);
            }
            if (f) {
                Path fDir = new Path(segs[i], "crawl_fetch");
                FileInputFormat.addInputPath((Job)job, (Path)fDir);
            }
            if (p) {
                Path pDir = new Path(segs[i], "crawl_parse");
                FileInputFormat.addInputPath((Job)job, (Path)pDir);
            }
            if (pd) {
                Path pdDir = new Path(segs[i], "parse_data");
                FileInputFormat.addInputPath((Job)job, (Path)pdDir);
            }
            if (!pt) continue;
            Path ptDir = new Path(segs[i], "parse_text");
            FileInputFormat.addInputPath((Job)job, (Path)ptDir);
        }
        job.setInputFormatClass(ObjectInputFormat.class);
        job.setJarByClass(SegmentMerger.class);
        job.setMapperClass(SegmentMergerMapper.class);
        job.setReducerClass(SegmentMergerReducer.class);
        FileOutputFormat.setOutputPath((Job)job, (Path)out);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(MetaWrapper.class);
        job.setOutputFormatClass(SegmentOutputFormat.class);
        this.setConf(conf);
        try {
            boolean success = job.waitForCompletion(true);
            if (!success) {
                String message = NutchJob.getJobFailureLogMessage("SegmentMerger", job);
                LOG.error(message);
                throw new RuntimeException(message);
            }
        }
        catch (IOException | ClassNotFoundException | InterruptedException e) {
            LOG.error("SegmentMerger job failed: {}", (Object)e.getMessage());
            throw e;
        }
    }

    public int run(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("SegmentMerger output_dir (-dir segments | seg1 seg2 ...) [-filter] [-slice NNNN]");
            System.err.println("\toutput_dir\tname of the parent dir for output segment slice(s)");
            System.err.println("\t-dir segments\tparent dir containing several segments");
            System.err.println("\tseg1 seg2 ...\tlist of segment dirs");
            System.err.println("\t-filter\t\tfilter out URL-s prohibited by current URLFilters");
            System.err.println("\t-normalize\t\tnormalize URL via current URLNormalizers");
            System.err.println("\t-slice NNNN\tcreate many output segments, each containing NNNN URLs");
            return -1;
        }
        Configuration conf = NutchConfiguration.create();
        Path out = new Path(args[0]);
        ArrayList<Path> segs = new ArrayList<Path>();
        long sliceSize = 0L;
        boolean filter = false;
        boolean normalize = false;
        for (int i = 1; i < args.length; ++i) {
            if ("-dir".equals(args[i])) {
                Path dirPath = new Path(args[++i]);
                FileSystem fs = dirPath.getFileSystem(conf);
                FileStatus[] fstats = fs.listStatus(dirPath, HadoopFSUtil.getPassDirectoriesFilter(fs));
                Path[] files = HadoopFSUtil.getPaths(fstats);
                for (int j = 0; j < files.length; ++j) {
                    segs.add(files[j]);
                }
                continue;
            }
            if ("-filter".equals(args[i])) {
                filter = true;
                continue;
            }
            if ("-normalize".equals(args[i])) {
                normalize = true;
                continue;
            }
            if ("-slice".equals(args[i])) {
                sliceSize = Long.parseLong(args[++i]);
                continue;
            }
            segs.add(new Path(args[i]));
        }
        if (segs.isEmpty()) {
            System.err.println("ERROR: No input segments.");
            return -1;
        }
        this.merge(out, segs.toArray(new Path[segs.size()]), filter, normalize, sliceSize);
        return 0;
    }

    public static void main(String[] args) throws Exception {
        int result = ToolRunner.run((Configuration)NutchConfiguration.create(), (Tool)new SegmentMerger(), (String[])args);
        System.exit(result);
    }

    public static class SegmentMergerReducer
    extends Reducer<Text, MetaWrapper, Text, MetaWrapper> {
        private SegmentMergeFilters mergeFilters = null;
        private long sliceSize = -1L;
        private long curCount = 0L;

        public void setup(Reducer.Context context) {
            Configuration conf = context.getConfiguration();
            if (conf.getBoolean("segment.merger.filter", false)) {
                this.mergeFilters = new SegmentMergeFilters(conf);
            }
            this.sliceSize = conf.getLong("segment.merger.slice", -1L);
            if (this.sliceSize > 0L) {
                LOG.info("Slice size: {} URLs.", (Object)this.sliceSize);
            }
            if (this.sliceSize > 0L) {
                this.sliceSize /= (long)Integer.parseInt(conf.get("mapreduce.job.reduces"));
            }
        }

        public void reduce(Text key, Iterable<MetaWrapper> values, Reducer.Context context) throws IOException, InterruptedException {
            MetaWrapper wrapper2;
            CrawlDatum lastG = null;
            CrawlDatum lastF = null;
            CrawlDatum lastSig = null;
            Content lastC = null;
            ParseData lastPD = null;
            ParseText lastPT = null;
            String lastGname = null;
            String lastFname = null;
            String lastSigname = null;
            String lastCname = null;
            String lastPDname = null;
            String lastPTname = null;
            TreeMap<String, ArrayList<CrawlDatum>> linked = new TreeMap<String, ArrayList<CrawlDatum>>();
            for (MetaWrapper wrapper2 : values) {
                Writable o = wrapper2.get();
                String spString = wrapper2.getMeta(SegmentMerger.SEGMENT_PART_KEY);
                if (spString == null) {
                    throw new IOException("Null segment part, key=" + String.valueOf(key));
                }
                SegmentPart sp = SegmentPart.parse(spString);
                if (o instanceof CrawlDatum) {
                    CrawlDatum val = (CrawlDatum)o;
                    if (sp.partName.equals("crawl_generate")) {
                        if (lastG == null) {
                            lastG = val;
                            lastGname = sp.segmentName;
                            continue;
                        }
                        if (lastGname.compareTo(sp.segmentName) >= 0) continue;
                        lastG = val;
                        lastGname = sp.segmentName;
                        continue;
                    }
                    if (sp.partName.equals("crawl_fetch")) {
                        if (!CrawlDatum.hasFetchStatus(val) || val.getStatus() == 34 || val.getStatus() == 38) continue;
                        if (lastF == null) {
                            lastF = val;
                            lastFname = sp.segmentName;
                            continue;
                        }
                        if (lastFname.compareTo(sp.segmentName) >= 0) continue;
                        lastF = val;
                        lastFname = sp.segmentName;
                        continue;
                    }
                    if (sp.partName.equals("crawl_parse")) {
                        if (val.getStatus() == 65) {
                            if (lastSig == null) {
                                lastSig = val;
                                lastSigname = sp.segmentName;
                                continue;
                            }
                            if (lastSigname.compareTo(sp.segmentName) >= 0) continue;
                            lastSig = val;
                            lastSigname = sp.segmentName;
                            continue;
                        }
                        ArrayList<CrawlDatum> segLinked = (ArrayList<CrawlDatum>)linked.get(sp.segmentName);
                        if (segLinked == null) {
                            segLinked = new ArrayList<CrawlDatum>();
                            linked.put(sp.segmentName, segLinked);
                        }
                        segLinked.add(val);
                        continue;
                    }
                    throw new IOException("Cannot determine segment part: " + sp.partName);
                }
                if (o instanceof Content) {
                    if (lastC == null) {
                        lastC = (Content)o;
                        lastCname = sp.segmentName;
                        continue;
                    }
                    if (lastCname.compareTo(sp.segmentName) >= 0) continue;
                    lastC = (Content)o;
                    lastCname = sp.segmentName;
                    continue;
                }
                if (o instanceof ParseData) {
                    if (lastPD == null) {
                        lastPD = (ParseData)o;
                        lastPDname = sp.segmentName;
                        continue;
                    }
                    if (lastPDname.compareTo(sp.segmentName) >= 0) continue;
                    lastPD = (ParseData)o;
                    lastPDname = sp.segmentName;
                    continue;
                }
                if (!(o instanceof ParseText)) continue;
                if (lastPT == null) {
                    lastPT = (ParseText)o;
                    lastPTname = sp.segmentName;
                    continue;
                }
                if (lastPTname.compareTo(sp.segmentName) >= 0) continue;
                lastPT = (ParseText)o;
                lastPTname = sp.segmentName;
            }
            if (this.mergeFilters != null && !this.mergeFilters.filter(key, lastG, lastF, lastSig, lastC, lastPD, lastPT, linked.isEmpty() ? null : (Collection)linked.lastEntry().getValue())) {
                return;
            }
            ++this.curCount;
            wrapper2 = new MetaWrapper();
            if (this.sliceSize > 0L) {
                String sliceName = String.valueOf(this.curCount / this.sliceSize);
                wrapper2.setMeta(SegmentMerger.SEGMENT_SLICE_KEY, sliceName);
            }
            SegmentPart sp = new SegmentPart();
            if (lastG != null) {
                wrapper2.set((Writable)lastG);
                sp.partName = "crawl_generate";
                sp.segmentName = lastGname;
                wrapper2.setMeta(SegmentMerger.SEGMENT_PART_KEY, sp.toString());
                context.write((Object)key, (Object)wrapper2);
            }
            if (lastF != null) {
                wrapper2.set((Writable)lastF);
                sp.partName = "crawl_fetch";
                sp.segmentName = lastFname;
                wrapper2.setMeta(SegmentMerger.SEGMENT_PART_KEY, sp.toString());
                context.write((Object)key, (Object)wrapper2);
            }
            if (lastSig != null) {
                wrapper2.set((Writable)lastSig);
                sp.partName = "crawl_parse";
                sp.segmentName = lastSigname;
                wrapper2.setMeta(SegmentMerger.SEGMENT_PART_KEY, sp.toString());
                context.write((Object)key, (Object)wrapper2);
            }
            if (lastC != null) {
                wrapper2.set(lastC);
                sp.partName = "content";
                sp.segmentName = lastCname;
                wrapper2.setMeta(SegmentMerger.SEGMENT_PART_KEY, sp.toString());
                context.write((Object)key, (Object)wrapper2);
            }
            if (lastPD != null) {
                wrapper2.set((Writable)lastPD);
                sp.partName = "parse_data";
                sp.segmentName = lastPDname;
                wrapper2.setMeta(SegmentMerger.SEGMENT_PART_KEY, sp.toString());
                context.write((Object)key, (Object)wrapper2);
            }
            if (lastPT != null) {
                wrapper2.set(lastPT);
                sp.partName = "parse_text";
                sp.segmentName = lastPTname;
                wrapper2.setMeta(SegmentMerger.SEGMENT_PART_KEY, sp.toString());
                context.write((Object)key, (Object)wrapper2);
            }
            if (linked.size() > 0) {
                String name = (String)linked.lastKey();
                sp.partName = "crawl_parse";
                sp.segmentName = name;
                wrapper2.setMeta(SegmentMerger.SEGMENT_PART_KEY, sp.toString());
                ArrayList segLinked = (ArrayList)linked.get(name);
                for (int i = 0; i < segLinked.size(); ++i) {
                    CrawlDatum link = (CrawlDatum)segLinked.get(i);
                    wrapper2.set((Writable)link);
                    context.write((Object)key, (Object)wrapper2);
                }
            }
        }
    }

    public static class SegmentMergerMapper
    extends Mapper<Text, MetaWrapper, Text, MetaWrapper> {
        private URLFilters filters = null;
        private URLNormalizers normalizers = null;

        public void setup(Mapper.Context context) {
            Configuration conf = context.getConfiguration();
            if (conf.getBoolean("segment.merger.filter", false)) {
                this.filters = new URLFilters(conf);
            }
            if (conf.getBoolean("segment.merger.normalizer", false)) {
                this.normalizers = new URLNormalizers(conf, "default");
            }
        }

        public void map(Text key, MetaWrapper value, Mapper.Context context) throws IOException, InterruptedException {
            Text newKey = new Text();
            String url = key.toString();
            if (this.normalizers != null) {
                try {
                    url = this.normalizers.normalize(url, "default");
                }
                catch (Exception e) {
                    LOG.warn("Skipping {} : {}", (Object)url, (Object)e.getMessage());
                    url = null;
                }
            }
            if (url != null && this.filters != null) {
                try {
                    url = this.filters.filter(url);
                }
                catch (Exception e) {
                    LOG.warn("Skipping key {} : {}", (Object)url, (Object)e.getMessage());
                    url = null;
                }
            }
            if (url != null) {
                newKey.set(url);
                context.write((Object)newKey, (Object)value);
            }
        }
    }

    public static class SegmentOutputFormat
    extends FileOutputFormat<Text, MetaWrapper> {
        private static final String DEFAULT_SLICE = "default";

        public RecordWriter<Text, MetaWrapper> getRecordWriter(final TaskAttemptContext context) throws IOException {
            final Configuration conf = context.getConfiguration();
            final String name = SegmentOutputFormat.getUniqueFile((TaskAttemptContext)context, (String)SegmentMerger.SEGMENT_PART_KEY, (String)"");
            Path dir = FileOutputFormat.getOutputPath((JobContext)context);
            final FileSystem fs = dir.getFileSystem(context.getConfiguration());
            return new RecordWriter<Text, MetaWrapper>(){
                MapFile.Writer cOut = null;
                MapFile.Writer fOut = null;
                MapFile.Writer pdOut = null;
                MapFile.Writer ptOut = null;
                SequenceFile.Writer gOut = null;
                SequenceFile.Writer pOut = null;
                HashMap<String, Closeable> sliceWriters = new HashMap();
                String segmentName = conf.get("segment.merger.segmentName");

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public void write(Text key, MetaWrapper wrapper) throws IOException {
                    SegmentPart sp = SegmentPart.parse(wrapper.getMeta(SegmentMerger.SEGMENT_PART_KEY));
                    Writable o = wrapper.get();
                    String slice = wrapper.getMeta(SegmentMerger.SEGMENT_SLICE_KEY);
                    if (o instanceof CrawlDatum) {
                        if (sp.partName.equals("crawl_generate")) {
                            this.gOut = this.ensureSequenceFile(slice, "crawl_generate");
                            this.gOut.append((Writable)key, o);
                            return;
                        } else if (sp.partName.equals("crawl_fetch")) {
                            this.fOut = this.ensureMapFile(slice, "crawl_fetch", CrawlDatum.class);
                            this.fOut.append((WritableComparable)key, o);
                            return;
                        } else {
                            if (!sp.partName.equals("crawl_parse")) throw new IOException("Cannot determine segment part: " + sp.partName);
                            this.pOut = this.ensureSequenceFile(slice, "crawl_parse");
                            this.pOut.append((Writable)key, o);
                        }
                        return;
                    } else if (o instanceof Content) {
                        this.cOut = this.ensureMapFile(slice, "content", Content.class);
                        this.cOut.append((WritableComparable)key, o);
                        return;
                    } else if (o instanceof ParseData) {
                        if (slice == null) {
                            ((ParseData)o).getContentMeta().set("nutch.segment.name", this.segmentName);
                        } else {
                            ((ParseData)o).getContentMeta().set("nutch.segment.name", this.segmentName + "-" + slice);
                        }
                        this.pdOut = this.ensureMapFile(slice, "parse_data", ParseData.class);
                        this.pdOut.append((WritableComparable)key, o);
                        return;
                    } else {
                        if (!(o instanceof ParseText)) return;
                        this.ptOut = this.ensureMapFile(slice, "parse_text", ParseText.class);
                        this.ptOut.append((WritableComparable)key, o);
                    }
                }

                private SequenceFile.Writer ensureSequenceFile(String slice, String dirName) throws IOException {
                    SequenceFile.Writer res;
                    if (slice == null) {
                        slice = SegmentOutputFormat.DEFAULT_SLICE;
                    }
                    if ((res = (SequenceFile.Writer)this.sliceWriters.get(slice + dirName)) != null) {
                        return res;
                    }
                    Path out = FileOutputFormat.getOutputPath((JobContext)context);
                    Path wname = slice == SegmentOutputFormat.DEFAULT_SLICE ? new Path(new Path(new Path(out, this.segmentName), dirName), name) : new Path(new Path(new Path(out, this.segmentName + "-" + slice), dirName), name);
                    res = SequenceFile.createWriter((Configuration)conf, (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)wname), SequenceFile.Writer.keyClass(Text.class), SequenceFile.Writer.valueClass(CrawlDatum.class), SequenceFile.Writer.bufferSize((int)fs.getConf().getInt("io.file.buffer.size", 4096)), SequenceFile.Writer.replication((short)fs.getDefaultReplication(wname)), SequenceFile.Writer.blockSize((long)0x40000000L), SequenceFile.Writer.compression((SequenceFile.CompressionType)SequenceFileOutputFormat.getOutputCompressionType((JobContext)context), (CompressionCodec)new DefaultCodec()), SequenceFile.Writer.progressable((Progressable)context), SequenceFile.Writer.metadata((SequenceFile.Metadata)new SequenceFile.Metadata())});
                    this.sliceWriters.put(slice + dirName, (Closeable)res);
                    return res;
                }

                private MapFile.Writer ensureMapFile(String slice, String dirName, Class<? extends Writable> clazz) throws IOException {
                    MapFile.Writer res;
                    if (slice == null) {
                        slice = SegmentOutputFormat.DEFAULT_SLICE;
                    }
                    if ((res = (MapFile.Writer)this.sliceWriters.get(slice + dirName)) != null) {
                        return res;
                    }
                    Path out = FileOutputFormat.getOutputPath((JobContext)context);
                    Path wname = slice == SegmentOutputFormat.DEFAULT_SLICE ? new Path(new Path(new Path(out, this.segmentName), dirName), name) : new Path(new Path(new Path(out, this.segmentName + "-" + slice), dirName), name);
                    SequenceFile.CompressionType compType = SequenceFileOutputFormat.getOutputCompressionType((JobContext)context);
                    if (clazz.isAssignableFrom(ParseText.class)) {
                        compType = SequenceFile.CompressionType.RECORD;
                    }
                    MapFile.Writer.Option rKeyClassOpt = MapFile.Writer.keyClass(Text.class);
                    SequenceFile.Writer.Option rValClassOpt = SequenceFile.Writer.valueClass(clazz);
                    SequenceFile.Writer.Option rProgressOpt = SequenceFile.Writer.progressable((Progressable)context);
                    SequenceFile.Writer.Option rCompOpt = SequenceFile.Writer.compression((SequenceFile.CompressionType)compType);
                    res = new MapFile.Writer(conf, wname, new SequenceFile.Writer.Option[]{rKeyClassOpt, rValClassOpt, rCompOpt, rProgressOpt});
                    this.sliceWriters.put(slice + dirName, (Closeable)res);
                    return res;
                }

                public void close(TaskAttemptContext context2) throws IOException {
                    for (Closeable o : this.sliceWriters.values()) {
                        if (o instanceof SequenceFile.Writer) {
                            ((SequenceFile.Writer)o).close();
                            continue;
                        }
                        ((MapFile.Writer)o).close();
                    }
                }
            };
        }
    }

    public static class ObjectInputFormat
    extends SequenceFileInputFormat<Text, MetaWrapper> {
        public RecordReader<Text, MetaWrapper> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException {
            String spString;
            context.setStatus(split.toString());
            FileSplit fSplit = (FileSplit)split;
            try {
                SegmentPart segmentPart = SegmentPart.get(fSplit);
                spString = segmentPart.toString();
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot identify segment:", e);
            }
            final SequenceFileRecordReader splitReader = new SequenceFileRecordReader();
            return new SequenceFileRecordReader<Text, MetaWrapper>(){
                private Text key;
                private MetaWrapper wrapper;
                private Writable w;

                public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
                    splitReader.initialize(split, context);
                }

                public synchronized boolean nextKeyValue() throws IOException, InterruptedException {
                    try {
                        boolean res = splitReader.nextKeyValue();
                        if (!res) {
                            return res;
                        }
                        this.key = (Text)splitReader.getCurrentKey();
                        this.w = (Writable)splitReader.getCurrentValue();
                        this.wrapper = new MetaWrapper();
                        this.wrapper.set(this.w);
                        this.wrapper.setMeta(SegmentMerger.SEGMENT_PART_KEY, spString);
                        return res;
                    }
                    catch (InterruptedException e) {
                        LOG.error(StringUtils.stringifyException((Throwable)e));
                        throw e;
                    }
                }

                public Text getCurrentKey() {
                    return this.key;
                }

                public MetaWrapper getCurrentValue() {
                    return this.wrapper;
                }

                public synchronized void close() throws IOException {
                    splitReader.close();
                }
            };
        }
    }
}

