/*
 * Decompiled with CFR 0.152.
 */
package org.archive.streamcontext;

import java.io.IOException;
import org.archive.streamcontext.AbstractBufferingStream;

public class ByteArrayWrappedStream
extends AbstractBufferingStream {
    private byte[] buffer = null;
    int offset = 0;

    public ByteArrayWrappedStream(byte[] b) {
        this.buffer = b;
        this.offset = 0;
    }

    @Override
    public int doRead(byte[] b, int off, int len) throws IOException {
        if (this.offset == this.buffer.length) {
            return -1;
        }
        int amtToCopy = Math.min(this.buffer.length - this.offset, len);
        System.arraycopy(this.buffer, this.offset, b, off, amtToCopy);
        this.offset += amtToCopy;
        return amtToCopy;
    }

    @Override
    public void doSeek(long offset) throws IOException {
        if (offset > (long)this.offset) {
            throw new IOException("seek past end..");
        }
        this.offset = (int)offset;
    }

    @Override
    public void doClose() throws IOException {
    }
}

