/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.server;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.Date;
import java.util.UUID;
import org.apache.openmeetings.db.dto.room.RoomOptionsDTO;
import org.apache.openmeetings.db.entity.server.SOAPLogin;
import org.apache.openmeetings.db.util.DaoHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class SOAPLoginDao {
    private static final Logger log = LoggerFactory.getLogger(SOAPLoginDao.class);
    @PersistenceContext
    private EntityManager em;

    public String addSOAPLogin(String sessionHash, RoomOptionsDTO options) {
        SOAPLogin soapLogin = new SOAPLogin();
        soapLogin.setCreated(new Date());
        soapLogin.setUsed(false);
        soapLogin.setRoomId(options.getRoomId());
        soapLogin.setExternalRoomId(options.getExternalRoomId());
        soapLogin.setExternalType(options.getExternalType());
        soapLogin.setAllowSameURLMultipleTimes(options.isAllowSameURLMultipleTimes());
        soapLogin.setHash(UUID.randomUUID().toString());
        soapLogin.setRecordingId(options.getRecordingId());
        soapLogin.setSessionHash(sessionHash);
        soapLogin.setModerator(options.isModerator());
        soapLogin.setShowAudioVideoTest(options.isShowAudioVideoTest());
        soapLogin.setAllowRecording(options.isAllowRecording());
        this.em.persist((Object)soapLogin);
        this.em.flush();
        Long soapLoginId = soapLogin.getId();
        if (soapLoginId != null) {
            return soapLogin.getHash();
        }
        log.error("[addSOAPLogin]: Could not store SOAPLogin");
        return null;
    }

    public SOAPLogin get(String hash) {
        if (hash == null) {
            return null;
        }
        try {
            SOAPLogin sl = (SOAPLogin)DaoHelper.only(this.em.createNamedQuery("getSoapLoginByHash", SOAPLogin.class).setParameter("hash", (Object)("%" + hash + "%")).getResultList());
            if (sl != null) {
                if (hash.equals(sl.getHash())) {
                    return sl;
                }
                log.error("[get]: Wrong SOAPLogin was found by hash! {}", (Object)hash);
            }
        }
        catch (Exception ex2) {
            log.error("[get]: ", (Throwable)ex2);
        }
        return null;
    }

    public void update(SOAPLogin soapLogin) {
        try {
            if (soapLogin.getId() == null) {
                this.em.persist((Object)soapLogin);
            } else if (!this.em.contains((Object)soapLogin)) {
                this.em.merge((Object)soapLogin);
            }
        }
        catch (Exception ex2) {
            log.error("[update]: ", (Throwable)ex2);
        }
    }
}

