/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.user.profile;

import de.agilecoders.wicket.core.markup.html.bootstrap.button.BootstrapAjaxLink;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import de.agilecoders.wicket.core.markup.html.bootstrap.image.IconType;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.confirmation.ConfirmationBehavior;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.icon.FontAwesome6IconType;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.time.Duration;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.openmeetings.web.app.Application;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.openmeetings.web.common.CommunityUserForm;
import org.apache.openmeetings.web.common.FormActionsPanel;
import org.apache.openmeetings.web.common.GeneralUserForm;
import org.apache.openmeetings.web.common.UploadableProfileImagePanel;
import org.apache.openmeetings.web.common.confirmation.ConfirmationHelper;
import org.apache.openmeetings.web.pages.PrivacyPage;
import org.apache.openmeetings.web.pages.auth.SignInDialog;
import org.apache.openmeetings.web.user.profile.ChangePasswordDialog;
import org.apache.openmeetings.web.user.profile.EditProfilePanel;
import org.apache.openmeetings.web.user.profile.ToggleOtpDialog;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormValidatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.panel.IMarkupSourcingStrategy;
import org.apache.wicket.markup.html.panel.PanelMarkupSourcingStrategy;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.util.string.Strings;

public class EditProfileForm
extends Form<User> {
    private static final long serialVersionUID = 1L;
    private final PasswordTextField passwd = new PasswordTextField("passwd", (IModel)new Model());
    private final GeneralUserForm userForm;
    private boolean checkPassword;
    private FormActionsPanel<User> actions;
    private BootstrapAjaxLink<String> toggleOtp;
    @Inject
    private UserDao userDao;

    public EditProfileForm(String id) {
        super(id);
        this.setModel((IModel)new CompoundPropertyModel((Object)this.userDao.get(WebSession.getUserId())));
        this.userForm = new GeneralUserForm("general", (IModel<User>)this.getModel(), false);
        this.checkPassword = User.Type.OAUTH != ((User)this.getModelObject()).getType();
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{this.passwd.setLabel((IModel)new ResourceModel("current.password")).setRequired(true).setVisible(this.checkPassword)});
        Component[] componentArray = new Component[1];
        this.actions = new FormActionsPanel<User>("buttons", (Form)this){
            private static final long serialVersionUID = 1L;

            private void refreshUser() {
                User u = (User)EditProfileForm.this.getModelObject();
                u = u.getId() != null ? EditProfileForm.this.userDao.get(u.getId()) : new User();
                EditProfileForm.this.setModelObject(u);
            }

            @Override
            protected void onSaveSubmit(AjaxRequestTarget target, Form<?> form) {
                try {
                    EditProfileForm.this.userDao.update((User)EditProfileForm.this.getModelObject(), null, WebSession.getUserId());
                }
                catch (Exception e) {
                    this.error((Serializable)((Object)e.getMessage()));
                }
                this.refreshUser();
                target.add(new Component[]{EditProfileForm.this});
            }

            @Override
            protected void onRefreshSubmit(AjaxRequestTarget target, Form<?> form) {
                this.refreshUser();
                target.add(new Component[]{EditProfileForm.this});
            }

            @Override
            protected void onPurgeSubmit(AjaxRequestTarget target, Form<?> form) {
                EditProfileForm.this.userDao.purge((User)EditProfileForm.this.getModelObject(), WebSession.getUserId());
                WebSession.get().invalidateNow();
                this.setResponsePage(Application.get().getSignInPageClass());
            }
        };
        componentArray[0] = this.actions;
        this.add(componentArray);
        this.add(new Component[]{new BootstrapAjaxLink<String>("changePwd", (IModel)Model.of((Serializable)((Object)"")), Buttons.Type.Outline_Danger, (IModel)new ResourceModel("327")){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                ChangePasswordDialog dlg = (ChangePasswordDialog)((EditProfilePanel)((Object)this.findParent(EditProfilePanel.class))).get("changePasswdDlg");
                dlg.show((IPartialPageRequestHandler)target);
            }
        }.setVisible(this.checkPassword)});
        this.toggleOtp = new BootstrapAjaxLink<String>("toggleOtp", null, Buttons.Type.Outline_Danger, (IModel)Model.of((Serializable)((Object)""))){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                User u = (User)EditProfileForm.this.getModelObject();
                if (u.getOtpSecret() == null) {
                    ToggleOtpDialog dlg = (ToggleOtpDialog)((EditProfilePanel)((Object)this.findParent(EditProfilePanel.class))).get("toggleOtpDlg");
                    dlg.setModel(EditProfileForm.this.getModel());
                    dlg.show((IPartialPageRequestHandler)target);
                } else {
                    u.setOtpSecret(null);
                    u.setOtpRecoveryCodes(null);
                    EditProfileForm.this.updateOtpButton(false, (IPartialPageRequestHandler)target);
                }
            }
        };
        this.add(new Component[]{this.toggleOtp.setOutputMarkupId(true).setVisible(OpenmeetingsVariables.isOtpEnabled() && this.checkPassword)});
        this.updateOtpButton(((User)this.getModelObject()).getOtpSecret() != null, null);
        this.add(new Component[]{this.userForm});
        this.add(new Component[]{new UploadableProfileImagePanel("img", WebSession.getUserId())});
        this.add(new Component[]{new CommunityUserForm("comunity", (IModel<User>)this.getModel())});
        this.add(new Behavior[]{new AjaxFormValidatingBehavior("keydown", Duration.ofSeconds(1L))});
        this.add(new Component[]{new BookmarkablePageLink("link", PrivacyPage.class)});
    }

    protected void onConfigure() {
        super.onConfigure();
        this.actions.setPurgeVisible(true);
    }

    protected void onValidate() {
        String p;
        if (this.checkPassword && !Strings.isEmpty((String)(p = (String)this.passwd.getConvertedInput())) && !this.userDao.verifyPassword(((User)this.getModelObject()).getId(), p)) {
            this.error((Serializable)((Object)this.getString("231")));
            SignInDialog.penalty();
        }
        super.onValidate();
    }

    protected IMarkupSourcingStrategy newMarkupSourcingStrategy() {
        return new PanelMarkupSourcingStrategy(false);
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)("$('.profile-edit-form .my-info').off().click(function() {showUserInfo(" + WebSession.getUserId() + ");});")));
    }

    void updateOtpButton(boolean enabled, IPartialPageRequestHandler handler) {
        if (enabled) {
            this.toggleOtp.add(new Behavior[]{ConfirmationHelper.newOkCancelDangerConfirm((Component)this, this.getString("otp.disable.confirm"))});
        } else {
            this.toggleOtp.getBehaviors(ConfirmationBehavior.class).stream().forEach(b -> this.toggleOtp.remove(new Behavior[]{b}));
        }
        this.toggleOtp.setLabel((IModel)new ResourceModel(enabled ? "otp.disable" : "otp.enable"));
        this.toggleOtp.setIconType((IconType)(enabled ? FontAwesome6IconType.square_check_r : FontAwesome6IconType.square_r));
        this.toggleOtp.setType(enabled ? Buttons.Type.Outline_Danger : Buttons.Type.Primary);
        if (handler != null) {
            handler.add(new Component[]{this.toggleOtp});
        }
    }
}

