/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.examples.activities;

import java.io.IOException;
import org.asteriskjava.examples.activities.ExamplesAsteriskSettings;
import org.asteriskjava.manager.AuthenticationFailedException;
import org.asteriskjava.manager.TimeoutException;
import org.asteriskjava.pbx.ActivityCallback;
import org.asteriskjava.pbx.ActivityStatusEnum;
import org.asteriskjava.pbx.Call;
import org.asteriskjava.pbx.CallerID;
import org.asteriskjava.pbx.EndPoint;
import org.asteriskjava.pbx.PBX;
import org.asteriskjava.pbx.PBXFactory;
import org.asteriskjava.pbx.TechType;
import org.asteriskjava.pbx.Trunk;
import org.asteriskjava.pbx.activities.BlindTransferActivity;
import org.asteriskjava.pbx.activities.DialActivity;
import org.asteriskjava.pbx.internal.core.AsteriskPBX;

public class BlindTransfer {
    public static void main(String[] args) throws IOException, AuthenticationFailedException, TimeoutException {
        PBXFactory.init(new ExamplesAsteriskSettings());
        AsteriskPBX asteriskPbx = (AsteriskPBX)PBXFactory.getActivePBX();
        asteriskPbx.createAgiEntryPoint();
        BlindTransfer.blindTransfer();
    }

    private static void blindTransfer() {
        String dialOptions = "";
        PBX pbx = PBXFactory.getActivePBX();
        Trunk trunk = pbx.buildTrunk("default");
        EndPoint from = pbx.buildEndPoint(TechType.SIP, "100");
        CallerID fromCallerID = pbx.buildCallerID("100", "My Phone");
        CallerID toCallerID = pbx.buildCallerID("83208100", "Asterisk Java is calling");
        EndPoint to = pbx.buildEndPoint(TechType.SIP, trunk, "5551234");
        pbx.dial(from, fromCallerID, to, toCallerID, new ActivityCallback<DialActivity>(){

            @Override
            public void progress(DialActivity activity, ActivityStatusEnum status, String message) {
                if (status == ActivityStatusEnum.SUCCESS) {
                    System.out.println("Dial all good so lets do a blind transfer");
                    PBX pbx = PBXFactory.getActivePBX();
                    Call call = activity.getNewCall();
                    CallerID toCallerID = pbx.buildCallerID("101", "I'm calling you");
                    EndPoint transferTarget = pbx.buildEndPoint(TechType.SIP, "101");
                    pbx.blindTransfer(call, Call.OperandChannel.REMOTE_PARTY, transferTarget, toCallerID, false, 30L, new ActivityCallback<BlindTransferActivity>(){

                        @Override
                        public void progress(BlindTransferActivity activity, ActivityStatusEnum status, String message) {
                        }
                    }, "");
                }
                if (status == ActivityStatusEnum.FAILURE) {
                    System.out.println("Oops something bad happened when we dialed.");
                }
            }
        }, dialOptions);
    }
}

