/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.live.internal;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.asteriskjava.live.AsteriskChannel;
import org.asteriskjava.live.CallDetailRecord;
import org.asteriskjava.live.CallerId;
import org.asteriskjava.live.ChannelState;
import org.asteriskjava.live.ChannelStateHistoryEntry;
import org.asteriskjava.live.DialedChannelHistoryEntry;
import org.asteriskjava.live.Extension;
import org.asteriskjava.live.ExtensionHistoryEntry;
import org.asteriskjava.live.HangupCause;
import org.asteriskjava.live.LinkedChannelHistoryEntry;
import org.asteriskjava.live.ManagerCommunicationException;
import org.asteriskjava.live.NoSuchChannelException;
import org.asteriskjava.live.RecordingException;
import org.asteriskjava.live.internal.AbstractLiveObject;
import org.asteriskjava.live.internal.AsteriskQueueEntryImpl;
import org.asteriskjava.live.internal.AsteriskServerImpl;
import org.asteriskjava.live.internal.CallDetailRecordImpl;
import org.asteriskjava.live.internal.MeetMeUserImpl;
import org.asteriskjava.lock.LockableList;
import org.asteriskjava.lock.LockableMap;
import org.asteriskjava.lock.Locker;
import org.asteriskjava.manager.action.AbsoluteTimeoutAction;
import org.asteriskjava.manager.action.ChangeMonitorAction;
import org.asteriskjava.manager.action.GetVarAction;
import org.asteriskjava.manager.action.HangupAction;
import org.asteriskjava.manager.action.MonitorAction;
import org.asteriskjava.manager.action.PauseMixMonitorAction;
import org.asteriskjava.manager.action.PauseMonitorAction;
import org.asteriskjava.manager.action.PlayDtmfAction;
import org.asteriskjava.manager.action.RedirectAction;
import org.asteriskjava.manager.action.SetVarAction;
import org.asteriskjava.manager.action.StopMonitorAction;
import org.asteriskjava.manager.action.UnpauseMonitorAction;
import org.asteriskjava.manager.response.ManagerError;
import org.asteriskjava.manager.response.ManagerResponse;
import org.asteriskjava.util.MixMonitorDirection;

class AsteriskChannelImpl
extends AbstractLiveObject
implements AsteriskChannel {
    private static final String CAUSE_VARIABLE_NAME = "PRI_CAUSE";
    private final Date dateOfCreation;
    private final LockableList<ExtensionHistoryEntry> extensionHistory;
    private final LockableList<ChannelStateHistoryEntry> stateHistory;
    private final LockableList<LinkedChannelHistoryEntry> linkedChannelHistory;
    private final LockableList<DialedChannelHistoryEntry> dialedChannelHistory;
    private final LockableList<AsteriskChannel> dialedChannels;
    private final LockableList<AsteriskChannel> dialingChannels;
    private final LockableList<AsteriskChannel> linkedChannels;
    private final LockableMap<String, String> variables;
    private String id;
    private String traceId;
    private Date dateOfRemoval;
    private String name;
    private CallerId callerId;
    private ChannelState state;
    private String account;
    private boolean wasLinked;
    private HangupCause hangupCause;
    private String hangupCauseText;
    private CallDetailRecordImpl callDetailRecord;
    private MeetMeUserImpl meetMeUserImpl;
    private AsteriskQueueEntryImpl queueEntryImpl;
    private Extension parkedAt;
    private String parkingLot;
    private Character dtmfReceived;
    private Character dtmfSent;
    private boolean isMonitored;

    AsteriskChannelImpl(AsteriskServerImpl server, String name, String id, Date dateOfCreation) throws IllegalArgumentException {
        super(server);
        if (server == null) {
            throw new IllegalArgumentException("Parameter 'server' passed to AsteriskChannelImpl() must not be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter 'name' passed to AsteriskChannelImpl() must not be null.");
        }
        if (id == null) {
            throw new IllegalArgumentException("Parameter 'id' passed to AsteriskChannelImpl() must not be null.");
        }
        if (dateOfCreation == null) {
            throw new IllegalArgumentException("Parameter 'dateOfCreation' passed to AsteriskChannelImpl() must not be null.");
        }
        this.name = name;
        this.id = id;
        this.dateOfCreation = dateOfCreation;
        this.extensionHistory = new LockableList(new ArrayList());
        this.stateHistory = new LockableList(new ArrayList());
        this.linkedChannelHistory = new LockableList(new ArrayList());
        this.dialedChannelHistory = new LockableList(new ArrayList());
        this.variables = new LockableMap(new HashMap());
        this.dialedChannels = new LockableList(new ArrayList());
        this.dialingChannels = new LockableList(new ArrayList());
        this.linkedChannels = new LockableList(new ArrayList());
    }

    @Override
    public String getId() {
        return this.id;
    }

    void idChanged(Date date, String id) {
        String oldId = this.id;
        if (oldId != null && oldId.equals(id)) {
            return;
        }
        this.id = id;
        this.firePropertyChange("id", oldId, id);
    }

    String getTraceId() {
        return this.traceId;
    }

    void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    void nameChanged(Date date, String name) {
        String oldName = this.name;
        if (oldName != null && oldName.equals(name)) {
            return;
        }
        this.name = name;
        this.firePropertyChange("name", oldName, name);
    }

    @Override
    public CallerId getCallerId() {
        return this.callerId;
    }

    void setCallerId(CallerId callerId) {
        CallerId oldCallerId = this.callerId;
        this.callerId = callerId;
        this.firePropertyChange("callerId", oldCallerId, callerId);
    }

    @Override
    public ChannelState getState() {
        return this.state;
    }

    @Override
    public boolean wasInState(ChannelState state) {
        try (Locker.LockCloser closer = this.stateHistory.withLock();){
            for (ChannelStateHistoryEntry historyEntry : this.stateHistory) {
                if (historyEntry.getState() != state) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    @Override
    public boolean wasBusy() {
        return this.wasInState(ChannelState.BUSY) || this.hangupCause == HangupCause.AST_CAUSE_BUSY || this.hangupCause == HangupCause.AST_CAUSE_USER_BUSY;
    }

    void stateChanged(Date date, ChannelState state) {
        try (Locker.LockCloser closer = this.withLock();){
            ChannelState oldState = this.state;
            if (oldState == state) {
                return;
            }
            ChannelStateHistoryEntry historyEntry = new ChannelStateHistoryEntry(date, state);
            try (Locker.LockCloser closer2 = this.stateHistory.withLock();){
                this.stateHistory.add(historyEntry);
            }
            this.state = state;
            this.firePropertyChange("state", (Object)oldState, (Object)state);
        }
    }

    @Override
    public String getAccount() {
        return this.account;
    }

    void setAccount(String account) {
        String oldAccount = this.account;
        this.account = account;
        this.firePropertyChange("account", oldAccount, account);
    }

    @Override
    public Extension getCurrentExtension() {
        Extension extension;
        try (Locker.LockCloser closer = this.extensionHistory.withLock();){
            extension = this.extensionHistory.isEmpty() ? null : this.extensionHistory.get(this.extensionHistory.size() - 1).getExtension();
        }
        return extension;
    }

    @Override
    public Extension getFirstExtension() {
        Extension extension;
        try (Locker.LockCloser closer = this.extensionHistory.withLock();){
            extension = this.extensionHistory.isEmpty() ? null : this.extensionHistory.get(0).getExtension();
        }
        return extension;
    }

    @Override
    public List<ExtensionHistoryEntry> getExtensionHistory() {
        ArrayList<ExtensionHistoryEntry> copy;
        try (Locker.LockCloser closer = this.extensionHistory.withLock();){
            copy = new ArrayList<ExtensionHistoryEntry>(this.extensionHistory);
        }
        return copy;
    }

    void extensionVisited(Date date, Extension extension) {
        Extension oldCurrentExtension = this.getCurrentExtension();
        ExtensionHistoryEntry historyEntry = new ExtensionHistoryEntry(date, extension);
        try (Locker.LockCloser closer = this.extensionHistory.withLock();){
            this.extensionHistory.add(historyEntry);
        }
        this.firePropertyChange("currentExtension", oldCurrentExtension, extension);
    }

    @Override
    public Date getDateOfCreation() {
        return this.dateOfCreation;
    }

    @Override
    public Date getDateOfRemoval() {
        return this.dateOfRemoval;
    }

    @Override
    public HangupCause getHangupCause() {
        return this.hangupCause;
    }

    @Override
    public String getHangupCauseText() {
        return this.hangupCauseText;
    }

    @Override
    public CallDetailRecord getCallDetailRecord() {
        return this.callDetailRecord;
    }

    void callDetailRecordReceived(Date date, CallDetailRecordImpl callDetailRecord) {
        CallDetailRecordImpl oldCallDetailRecord = this.callDetailRecord;
        this.callDetailRecord = callDetailRecord;
        this.firePropertyChange("callDetailRecord", oldCallDetailRecord, callDetailRecord);
    }

    void hungup(Date dateOfRemoval, HangupCause hangupCause, String hangupCauseText) {
        try (Locker.LockCloser closer = this.withLock();){
            this.dateOfRemoval = dateOfRemoval;
            this.hangupCause = hangupCause;
            this.hangupCauseText = hangupCauseText;
            this.stateChanged(dateOfRemoval, ChannelState.HUNGUP);
        }
    }

    @Override
    public List<AsteriskChannel> getDialedChannels() {
        ArrayList<AsteriskChannel> copy;
        try (Locker.LockCloser closer = this.dialedChannels.withLock();){
            copy = new ArrayList<AsteriskChannel>(this.dialedChannels);
        }
        return copy;
    }

    @Override
    public AsteriskChannel getDialedChannel() {
        try (Locker.LockCloser closer = this.dialedChannels.withLock();){
            for (AsteriskChannel channel : this.dialedChannels) {
                if (channel == null) continue;
                AsteriskChannel asteriskChannel = channel;
                return asteriskChannel;
            }
        }
        return null;
    }

    @Override
    public List<DialedChannelHistoryEntry> getDialedChannelHistory() {
        ArrayList<DialedChannelHistoryEntry> copy;
        try (Locker.LockCloser closer = this.dialedChannelHistory.withLock();){
            copy = new ArrayList<DialedChannelHistoryEntry>(this.dialedChannelHistory);
        }
        return copy;
    }

    void channelDialed(Date date, AsteriskChannel dialedChannel) {
        try (Locker.LockCloser closer = this.withLock();){
            AsteriskChannel oldDialedChannel;
            try (Locker.LockCloser closer2 = this.dialedChannels.withLock();){
                oldDialedChannel = this.dialedChannels.isEmpty() ? null : this.dialedChannels.get(this.dialedChannels.size() - 1);
                this.dialedChannels.add(dialedChannel);
            }
            DialedChannelHistoryEntry historyEntry = new DialedChannelHistoryEntry(date, dialedChannel);
            try (Locker.LockCloser closer3 = this.dialedChannelHistory.withLock();){
                this.dialedChannelHistory.add(historyEntry);
            }
            this.firePropertyChange("dialedChannel", oldDialedChannel, dialedChannel);
        }
    }

    @Override
    public AsteriskChannel getDialingChannel() {
        try (Locker.LockCloser closer = this.dialingChannels.withLock();){
            if (this.dialingChannels.isEmpty()) {
                AsteriskChannel asteriskChannel = null;
                return asteriskChannel;
            }
            AsteriskChannel asteriskChannel = this.dialingChannels.get(0);
            return asteriskChannel;
        }
    }

    void channelDialing(Date date, AsteriskChannel dialingChannel) {
        try (Locker.LockCloser closer = this.withLock();){
            AsteriskChannel oldDialingChannel;
            try (Locker.LockCloser closer2 = this.dialingChannels.withLock();){
                if (this.dialingChannels.isEmpty()) {
                    oldDialingChannel = null;
                    this.dialingChannels.add(dialingChannel);
                } else {
                    oldDialingChannel = this.dialingChannels.get(0);
                    this.dialingChannels.set(0, dialingChannel);
                }
            }
            this.firePropertyChange("dialingChannel", oldDialingChannel, dialingChannel);
        }
    }

    @Override
    public AsteriskChannel getLinkedChannel() {
        try (Locker.LockCloser closer = this.linkedChannels.withLock();){
            if (this.linkedChannels.isEmpty()) {
                AsteriskChannel asteriskChannel = null;
                return asteriskChannel;
            }
            AsteriskChannel asteriskChannel = this.linkedChannels.get(0);
            return asteriskChannel;
        }
    }

    @Override
    public List<LinkedChannelHistoryEntry> getLinkedChannelHistory() {
        ArrayList<LinkedChannelHistoryEntry> copy;
        try (Locker.LockCloser closer = this.linkedChannelHistory.withLock();){
            copy = new ArrayList<LinkedChannelHistoryEntry>(this.linkedChannelHistory);
        }
        return copy;
    }

    @Override
    public boolean wasLinked() {
        return this.wasLinked;
    }

    void channelLinked(Date date, AsteriskChannel linkedChannel) {
        try (Locker.LockCloser closer = this.withLock();){
            AsteriskChannel oldLinkedChannel;
            try (Locker.LockCloser closer2 = this.linkedChannels.withLock();){
                if (this.linkedChannels.isEmpty()) {
                    oldLinkedChannel = null;
                    this.linkedChannels.add(linkedChannel);
                } else {
                    oldLinkedChannel = this.linkedChannels.get(0);
                    this.linkedChannels.set(0, linkedChannel);
                }
            }
            LinkedChannelHistoryEntry historyEntry = new LinkedChannelHistoryEntry(date, linkedChannel);
            try (Locker.LockCloser closer3 = this.linkedChannelHistory.withLock();){
                this.linkedChannelHistory.add(historyEntry);
            }
            this.wasLinked = true;
            this.firePropertyChange("linkedChannel", oldLinkedChannel, linkedChannel);
        }
    }

    void channelUnlinked(Date date) {
        try (Locker.LockCloser closer = this.withLock();){
            LinkedChannelHistoryEntry historyEntry;
            AsteriskChannel oldLinkedChannel;
            try (Locker.LockCloser closer2 = this.linkedChannels.withLock();){
                oldLinkedChannel = this.linkedChannels.isEmpty() ? null : this.linkedChannels.get(0);
                this.linkedChannels.clear();
            }
            try (Locker.LockCloser closer3 = this.linkedChannelHistory.withLock();){
                historyEntry = this.linkedChannelHistory.isEmpty() ? null : this.linkedChannelHistory.get(this.linkedChannelHistory.size() - 1);
            }
            if (historyEntry != null) {
                historyEntry.setDateUnlinked(date);
            }
            this.firePropertyChange("linkedChannel", oldLinkedChannel, null);
        }
    }

    @Override
    public MeetMeUserImpl getMeetMeUser() {
        return this.meetMeUserImpl;
    }

    void setMeetMeUserImpl(MeetMeUserImpl meetMeUserImpl) {
        MeetMeUserImpl oldMeetMeUserImpl = this.meetMeUserImpl;
        this.meetMeUserImpl = meetMeUserImpl;
        this.firePropertyChange("meetMeUser", oldMeetMeUserImpl, meetMeUserImpl);
    }

    @Override
    public void hangup() throws ManagerCommunicationException, NoSuchChannelException {
        this.hangup(null);
    }

    @Override
    public void hangup(HangupCause cause) throws ManagerCommunicationException, NoSuchChannelException {
        HangupAction action;
        if (cause != null) {
            this.setVariable(CAUSE_VARIABLE_NAME, Integer.toString(cause.getCode()));
            action = new HangupAction(this.name, cause.getCode());
        } else {
            action = new HangupAction(this.name);
        }
        ManagerResponse response = this.server.sendAction(action);
        if (response instanceof ManagerError) {
            throw new NoSuchChannelException("Channel '" + this.name + "' is not available: " + response.getMessage());
        }
    }

    @Override
    public void setAbsoluteTimeout(int seconds) throws ManagerCommunicationException, NoSuchChannelException {
        ManagerResponse response = this.server.sendAction(new AbsoluteTimeoutAction(this.name, seconds));
        if (response instanceof ManagerError) {
            throw new NoSuchChannelException("Channel '" + this.name + "' is not available: " + response.getMessage());
        }
    }

    @Override
    public void redirect(String context, String exten, int priority) throws ManagerCommunicationException, NoSuchChannelException {
        ManagerResponse response = this.server.sendAction(new RedirectAction(this.name, context, exten, priority));
        if (response instanceof ManagerError) {
            throw new NoSuchChannelException("Channel '" + this.name + "' is not available: " + response.getMessage());
        }
    }

    @Override
    public void redirectBothLegs(String context, String exten, int priority) throws ManagerCommunicationException, NoSuchChannelException {
        ManagerResponse response;
        try (Locker.LockCloser closer = this.linkedChannels.withLock();){
            response = this.linkedChannels.isEmpty() ? this.server.sendAction(new RedirectAction(this.name, context, exten, priority)) : this.server.sendAction(new RedirectAction(this.name, this.linkedChannels.get(0).getName(), context, exten, priority, context, exten, priority));
        }
        if (response instanceof ManagerError) {
            throw new NoSuchChannelException("Channel '" + this.name + "' is not available: " + response.getMessage());
        }
    }

    @Override
    public String getVariable(String variable) throws ManagerCommunicationException, NoSuchChannelException {
        String value;
        try (Locker.LockCloser closer = this.variables.withLock();){
            value = this.variables.get(variable);
            if (value != null) {
                String string = value;
                return string;
            }
            ManagerResponse response = this.server.sendAction(new GetVarAction(this.name, variable));
            if (response instanceof ManagerError) {
                throw new NoSuchChannelException("Channel '" + this.name + "' is not available: " + response.getMessage());
            }
            value = response.getAttribute("Value");
            if (value == null) {
                value = response.getAttribute(variable);
            }
            this.variables.put(variable, value);
        }
        return value;
    }

    @Override
    public void setVariable(String variable, String value) throws ManagerCommunicationException, NoSuchChannelException {
        ManagerResponse response = this.server.sendAction(new SetVarAction(this.name, variable, value));
        if (response instanceof ManagerError) {
            throw new NoSuchChannelException("Channel '" + this.name + "' is not available: " + response.getMessage());
        }
        try (Locker.LockCloser closer = this.variables.withLock();){
            this.variables.put(variable, value);
        }
    }

    @Override
    public void playDtmf(String digit) throws ManagerCommunicationException, NoSuchChannelException, IllegalArgumentException {
        if (digit == null) {
            throw new IllegalArgumentException("DTMF digit to send must not be null");
        }
        ManagerResponse response = this.server.sendAction(new PlayDtmfAction(this.name, digit));
        if (response instanceof ManagerError) {
            throw new NoSuchChannelException("Channel '" + this.name + "' is not available: " + response.getMessage());
        }
    }

    @Override
    public void startMonitoring(String filename) throws ManagerCommunicationException, NoSuchChannelException {
        this.startMonitoring(filename, null, false);
    }

    @Override
    public void startMonitoring(String filename, String format) throws ManagerCommunicationException, NoSuchChannelException {
        this.startMonitoring(filename, format, false);
    }

    @Override
    public void startMonitoring(String filename, String format, boolean mix) throws ManagerCommunicationException, NoSuchChannelException {
        ManagerResponse response = this.server.sendAction(new MonitorAction(this.name, filename, format, mix));
        if (response instanceof ManagerError) {
            throw new NoSuchChannelException("Channel '" + this.name + "' is not available: " + response.getMessage());
        }
    }

    @Override
    public void changeMonitoring(String filename) throws ManagerCommunicationException, NoSuchChannelException, IllegalArgumentException {
        if (filename == null) {
            throw new IllegalArgumentException("New filename must not be null");
        }
        ManagerResponse response = this.server.sendAction(new ChangeMonitorAction(this.name, filename));
        if (response instanceof ManagerError) {
            throw new NoSuchChannelException("Channel '" + this.name + "' is not available: " + response.getMessage());
        }
    }

    @Override
    public void stopMonitoring() throws ManagerCommunicationException, NoSuchChannelException {
        ManagerResponse response = this.server.sendAction(new StopMonitorAction(this.name));
        if (response instanceof ManagerError) {
            throw new NoSuchChannelException("Channel '" + this.name + "' is not available: " + response.getMessage());
        }
    }

    @Override
    public void pauseMonitoring() throws ManagerCommunicationException, NoSuchChannelException {
        ManagerResponse response = this.server.sendAction(new PauseMonitorAction(this.name));
        if (response instanceof ManagerError) {
            throw new NoSuchChannelException("Channel '" + this.name + "' is not available: " + response.getMessage());
        }
    }

    @Override
    public void unpauseMonitoring() throws ManagerCommunicationException, NoSuchChannelException {
        ManagerResponse response = this.server.sendAction(new UnpauseMonitorAction(this.name));
        if (response instanceof ManagerError) {
            throw new NoSuchChannelException("Channel '" + this.name + "' is not available: " + response.getMessage());
        }
    }

    @Override
    public void pauseMixMonitor(MixMonitorDirection direction) throws ManagerCommunicationException, NoSuchChannelException, RecordingException {
        ManagerResponse response = this.server.sendAction(new PauseMixMonitorAction(this.name, 1, direction.getStateName()));
        if (response instanceof ManagerError) {
            if (response.getMessage().equals("Cannot set mute flag")) {
                throw new RecordingException(response.getMessage() + " on channel: '" + this.name);
            }
            throw new NoSuchChannelException("Channel '" + this.name + "' is not available: " + response.getMessage());
        }
    }

    @Override
    public void unPauseMixMonitor(MixMonitorDirection direction) throws ManagerCommunicationException, NoSuchChannelException, RecordingException {
        ManagerResponse response = this.server.sendAction(new PauseMixMonitorAction(this.name, 0, direction.getStateName()));
        if (response instanceof ManagerError) {
            if (response.getMessage().equals("Cannot set mute flag")) {
                throw new RecordingException(response.getMessage() + " on channel: '" + this.name);
            }
            throw new NoSuchChannelException("Channel '" + this.name + "' is not available: " + response.getMessage());
        }
    }

    @Override
    public Extension getParkedAt() {
        return this.parkedAt;
    }

    @Override
    public String getParkingLot() {
        return this.parkingLot;
    }

    void setParkedAt(Extension parkedAt, String parkingLot) {
        Extension oldParkedAt = this.parkedAt;
        String oldParkingLot = this.parkingLot;
        this.parkedAt = parkedAt;
        this.parkingLot = parkingLot;
        this.firePropertyChange("parkedAt", oldParkedAt, parkedAt);
        this.firePropertyChange("parkingLot", oldParkingLot, parkingLot);
    }

    void updateVariable(String name, String value) {
        try (Locker.LockCloser closer = this.variables.withLock();){
            this.variables.put(name, value);
        }
    }

    @Override
    public Map<String, String> getVariables() {
        try (Locker.LockCloser closer = this.variables.withLock();){
            HashMap<String, String> hashMap = new HashMap<String, String>(this.variables);
            return hashMap;
        }
    }

    @Override
    public Character getDtmfReceived() {
        return this.dtmfReceived;
    }

    @Override
    public Character getDtmfSent() {
        return this.dtmfSent;
    }

    void dtmfReceived(Character digit) {
        Character oldDtmfReceived = this.dtmfReceived;
        this.dtmfReceived = digit;
        this.firePropertyChange("dtmfReceived", oldDtmfReceived, digit);
    }

    void dtmfSent(Character digit) {
        Character oldDtmfSent = this.dtmfSent;
        this.dtmfSent = digit;
        this.firePropertyChange("dtmfSent", oldDtmfSent, digit);
    }

    @Override
    public AsteriskQueueEntryImpl getQueueEntry() {
        return this.queueEntryImpl;
    }

    void setQueueEntry(AsteriskQueueEntryImpl queueEntry) {
        AsteriskQueueEntryImpl oldQueueEntry = this.queueEntryImpl;
        this.queueEntryImpl = queueEntry;
        this.firePropertyChange("queueEntry", oldQueueEntry, queueEntry);
    }

    @Override
    public boolean isMonitored() {
        return this.isMonitored;
    }

    void setMonitored(boolean monitored) {
        boolean oldMonitored = this.isMonitored;
        this.isMonitored = monitored;
        this.firePropertyChange("monitored", oldMonitored, monitored);
    }

    public String toString() {
        LockableList<AsteriskChannel> linkedChannel;
        LockableList<AsteriskChannel> dialingChannel;
        StringBuilder sb = new StringBuilder("AsteriskChannel[");
        try (Locker.LockCloser closer = this.withLock();){
            sb.append("id='").append(this.getId()).append("',");
            sb.append("name='").append(this.getName()).append("',");
            sb.append("callerId='").append(this.getCallerId()).append("',");
            sb.append("state='").append((Object)this.getState()).append("',");
            sb.append("account='").append(this.getAccount()).append("',");
            sb.append("dateOfCreation=").append(this.getDateOfCreation()).append(",");
            dialingChannel = this.dialingChannels;
            linkedChannel = this.linkedChannels;
        }
        if (this.dialedChannels.isEmpty()) {
            sb.append("dialedChannel=null,");
        } else {
            sb.append("dialedChannel=AsteriskChannel[");
            closer = this.dialedChannels.withLock();
            var5_3 = null;
            try {
                for (AsteriskChannel dialedChannel : this.dialedChannels) {
                    sb.append("[id='").append(dialedChannel.getId()).append("',");
                    sb.append("name='").append(dialedChannel.getName()).append("'],");
                }
                sb.append("],");
            }
            catch (Throwable throwable) {
                var5_3 = throwable;
                throw throwable;
            }
            finally {
                if (closer != null) {
                    if (var5_3 != null) {
                        try {
                            closer.close();
                        }
                        catch (Throwable throwable) {
                            var5_3.addSuppressed(throwable);
                        }
                    } else {
                        closer.close();
                    }
                }
            }
        }
        if (dialingChannel.isEmpty()) {
            sb.append("dialingChannel=null,");
        } else {
            sb.append("dialingChannel=AsteriskChannel[");
            sb.append("id='").append(dialingChannel.get(0).getId()).append("',");
            sb.append("name='").append(dialingChannel.get(0).getName()).append("'],");
        }
        closer = linkedChannel.withLock();
        var5_3 = null;
        try {
            if (linkedChannel.isEmpty()) {
                sb.append("linkedChannel=null");
            } else {
                sb.append("linkedChannel=AsteriskChannel[");
                sb.append("id='").append(linkedChannel.get(0).getId()).append("',");
                sb.append("name='").append(linkedChannel.get(0).getName()).append("']");
            }
        }
        catch (Throwable throwable) {
            var5_3 = throwable;
            throw throwable;
        }
        finally {
            if (closer != null) {
                if (var5_3 != null) {
                    try {
                        closer.close();
                    }
                    catch (Throwable throwable) {
                        var5_3.addSuppressed(throwable);
                    }
                } else {
                    closer.close();
                }
            }
        }
        sb.append("]");
        return sb.toString();
    }
}

