/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.CommonLogger;
import gov.nist.core.StackLogger;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.stack.NIOHandler;
import gov.nist.javax.sip.stack.NioTcpMessageChannel;
import gov.nist.javax.sip.stack.NioTcpMessageProcessor;
import gov.nist.javax.sip.stack.NioWebSocketMessageProcessor;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.WebSocketCodec;
import gov.nist.javax.sip.stack.WebSocketHttpHandshake;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.text.ParseException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sip.address.SipURI;
import javax.sip.header.ContactHeader;
import javax.sip.header.RecordRouteHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Request;

public class NioWebSocketMessageChannel
extends NioTcpMessageChannel {
    private static StackLogger logger = CommonLogger.getLogger(NioWebSocketMessageChannel.class);
    private WebSocketCodec codec = new WebSocketCodec(true, true);
    boolean readingHttp = true;
    String httpInput = "";
    boolean client;
    AtomicBoolean httpClientRequestSent = new AtomicBoolean(false);
    String httpHostHeader;
    String httpMethod;
    String httpLocation;
    private SIPTransactionStack stack;

    public static NioWebSocketMessageChannel create(SIPTransactionStack stack, NioWebSocketMessageProcessor nioTcpMessageProcessor, SocketChannel socketChannel) throws IOException {
        NioWebSocketMessageChannel retval = (NioWebSocketMessageChannel)channelMap.get(socketChannel);
        if (retval == null) {
            retval = new NioWebSocketMessageChannel(stack, nioTcpMessageProcessor, socketChannel);
            channelMap.put(socketChannel, retval);
        }
        return retval;
    }

    protected NioWebSocketMessageChannel(SIPTransactionStack stack, NioTcpMessageProcessor nioTcpMessageProcessor, SocketChannel socketChannel) throws IOException {
        super(nioTcpMessageProcessor, socketChannel);
        this.stack = stack;
        this.messageProcessor = nioTcpMessageProcessor;
        this.myClientInputStream = socketChannel.socket().getInputStream();
    }

    @Override
    protected void sendMessage(byte[] msg, boolean isClient) throws IOException {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("sendMessage isClient  = " + isClient + " this = " + this);
        }
        this.lastActivityTimeStamp = System.currentTimeMillis();
        NIOHandler nioHandler = ((NioTcpMessageProcessor)this.messageProcessor).nioHandler;
        if (this.socketChannel != null && this.socketChannel.isConnected() && this.socketChannel.isOpen()) {
            nioHandler.putSocket(NIOHandler.makeKey(this.peerAddress, this.peerPort), this.socketChannel);
        }
        this.sendWrapped(msg, this.peerAddress, this.peerPort, isClient);
    }

    protected void sendNonWebSocketMessage(byte[] msg, boolean isClient) throws IOException {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("sendMessage isClient  = " + isClient + " this = " + this);
        }
        this.lastActivityTimeStamp = System.currentTimeMillis();
        NIOHandler nioHandler = ((NioTcpMessageProcessor)this.messageProcessor).nioHandler;
        if (this.socketChannel != null && this.socketChannel.isConnected() && this.socketChannel.isOpen()) {
            nioHandler.putSocket(NIOHandler.makeKey(this.peerAddress, this.peerPort), this.socketChannel);
        }
        super.sendTCPMessage(msg, this.peerAddress, this.peerPort, isClient);
    }

    public static byte[] wrapBufferIntoWebSocketFrame(byte[] buffer, boolean client) {
        try {
            return WebSocketCodec.encode(buffer, 0, true, client);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void sendWrapped(byte[] message, InetAddress receiverAddress, int receiverPort, boolean retry) throws IOException {
        if (this.client && this.readingHttp && this.httpClientRequestSent.compareAndSet(false, true)) {
            String http = "null null HTTP/1.1\r\nHost: null \r\nUpgrade: websocket\r\nConnection: Upgrade\r\nSec-WebSocket-Key: dGhlIHNhbXBsZSBub25jZQ==\r\nSec-WebSocket-Protocol: sip\r\nSec-WebSocket-Version: 13\r\n\r\n";
            super.sendTCPMessage(http.getBytes(), receiverAddress, receiverPort, false);
            try {
                Thread.sleep(150L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        message = NioWebSocketMessageChannel.wrapBufferIntoWebSocketFrame(message, this.client);
        super.sendTCPMessage(message, receiverAddress, receiverPort, retry);
    }

    @Override
    public void sendMessage(byte[] message, InetAddress receiverAddress, int receiverPort, boolean retry) throws IOException {
        this.sendWrapped(message, receiverAddress, receiverPort, retry);
    }

    @Override
    public void sendMessage(SIPMessage sipMessage, InetAddress receiverAddress, int receiverPort) throws IOException {
        if (sipMessage instanceof SIPRequest && this.client && this.httpClientRequestSent.compareAndSet(false, true)) {
            SIPRequest request = (SIPRequest)sipMessage;
            SipURI requestUri = (SipURI)request.getRequestURI();
            this.httpHostHeader = requestUri.getHeader("Host");
            this.httpLocation = requestUri.getHeader("Location");
            this.httpMethod = requestUri.getMethodParam();
            String http = this.httpMethod + " " + this.httpLocation + " HTTP/1.1\r\n" + "Host: " + this.httpHostHeader + "\r\n" + "Upgrade: websocket\r\n" + "Connection: Upgrade\r\n" + "Sec-WebSocket-Key: dGhlIHNhbXBsZSBub25jZQ==\r\n" + "Sec-WebSocket-Protocol: sip\r\n" + "Sec-WebSocket-Version: 13\r\n\r\n";
            super.sendTCPMessage(http.getBytes(), receiverAddress, receiverPort, false);
            try {
                Thread.sleep(150L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        super.sendMessage(sipMessage, receiverAddress, receiverPort);
    }

    public NioWebSocketMessageChannel(InetAddress inetAddress, int port, SIPTransactionStack sipStack, NioTcpMessageProcessor nioTcpMessageProcessor) throws IOException {
        super(inetAddress, port, sipStack, nioTcpMessageProcessor);
        this.client = true;
        this.stack = sipStack;
        this.codec = new WebSocketCodec(false, true);
    }

    @Override
    protected void addBytes(byte[] bytes) throws Exception {
        String s = new String(bytes);
        if (this.readingHttp) {
            byte[] remaining = null;
            for (int q = 0; q < bytes.length - 3; ++q) {
                if (bytes[q] != 13 || bytes[q + 1] != 10 || bytes[q + 2] != 13 || bytes[q + 3] != 10) continue;
                s = s.substring(0, q + 4);
                remaining = new byte[bytes.length - q - 4];
                for (int w = 0; w < remaining.length; ++w) {
                    remaining[w] = bytes[q + 4 + w];
                }
            }
            this.httpInput = this.httpInput + s;
            if (s.endsWith("\r\n") || s.endsWith("\n")) {
                this.readingHttp = false;
                if (!this.httpInput.startsWith("HTTP")) {
                    byte[] response = new WebSocketHttpHandshake().createHttpResponse(s);
                    this.sendNonWebSocketMessage(response, false);
                } else {
                    logger.logDebug("HTTP Response. We are websocket client.\n" + this.httpInput);
                }
            }
            if (remaining != null) {
                this.addBytes(remaining);
            }
            return;
        }
        if (!this.readingHttp) {
            ByteArrayInputStream bios = new ByteArrayInputStream(bytes);
            byte[] decodedMsg = null;
            do {
                decodedMsg = this.codec.decode(bios);
                if (this.codec.isCloseOpcodeReceived()) {
                    logger.logDebug("Websocket close, sending polite close response");
                    ByteBuffer byteBuff = ByteBuffer.wrap(new byte[]{-120, 0});
                    this.socketChannel.write(byteBuff);
                    return;
                }
                if (decodedMsg == null) {
                    return;
                }
                this.nioParser.addBytes(decodedMsg);
                logger.logDebug("Nio websocket bytes were added " + decodedMsg.length);
            } while (decodedMsg != null);
        }
    }

    @Override
    public String getTransport() {
        return this.messageProcessor.transport;
    }

    @Override
    public void onNewSocket(byte[] message) {
        super.onNewSocket(message);
    }

    @Override
    public void processMessage(SIPMessage message) throws Exception {
        if (this.stack.isPatchWebSocketHeaders()) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Patching WebSocket headers");
            }
            if (message instanceof Request) {
                String viaHost;
                ContactHeader contact = (ContactHeader)message.getHeader("Contact");
                RecordRouteHeader rr = (RecordRouteHeader)message.getHeader("Record-Route");
                ViaHeader via = message.getTopmostViaHeader();
                if (rr == null) {
                    if (contact != null) {
                        this.rewriteUri((SipURI)contact.getAddress().getURI());
                    }
                } else {
                    this.rewriteUri((SipURI)rr.getAddress().getURI());
                }
                if ((viaHost = via.getHost()).endsWith(".invalid")) {
                    via.setHost(this.getPeerAddress());
                    via.setPort(this.getPeerPort());
                }
            } else {
                ContactHeader contact = (ContactHeader)message.getHeader("Contact");
                if (contact != null) {
                    this.rewriteUri((SipURI)contact.getAddress().getURI());
                }
            }
        }
        super.processMessage(message);
    }

    public void rewriteUri(SipURI uri) {
        try {
            String uriHost = uri.getHost();
            if (uriHost.endsWith(".invalid")) {
                uri.setHost(this.getPeerAddress());
            }
        }
        catch (ParseException e) {
            logger.logError("Cant parse address", e);
        }
        uri.setPort(this.getPeerPort());
    }
}

