/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.config;

import com.hazelcast.config.ItemListenerConfig;
import com.hazelcast.config.MergePolicyConfig;
import com.hazelcast.config.QueueConfig;
import com.hazelcast.config.QueueStoreConfig;
import com.hazelcast.internal.config.ItemListenerConfigReadOnly;
import com.hazelcast.internal.config.QueueStoreConfigReadOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class QueueConfigReadOnly
extends QueueConfig {
    public QueueConfigReadOnly(QueueConfig config) {
        super(config);
    }

    @Override
    @Nonnull
    public List<ItemListenerConfig> getItemListenerConfigs() {
        List<ItemListenerConfig> itemListenerConfigs = super.getItemListenerConfigs();
        ArrayList<ItemListenerConfigReadOnly> readOnlyItemListenerConfigs = new ArrayList<ItemListenerConfigReadOnly>(itemListenerConfigs.size());
        for (ItemListenerConfig itemListenerConfig : itemListenerConfigs) {
            readOnlyItemListenerConfigs.add(new ItemListenerConfigReadOnly(itemListenerConfig));
        }
        return Collections.unmodifiableList(readOnlyItemListenerConfigs);
    }

    @Override
    @Nullable
    public QueueStoreConfig getQueueStoreConfig() {
        QueueStoreConfig queueStoreConfig = super.getQueueStoreConfig();
        if (queueStoreConfig == null) {
            return null;
        }
        return new QueueStoreConfigReadOnly(queueStoreConfig);
    }

    @Override
    public QueueConfig setName(String name) {
        throw new UnsupportedOperationException("This config is read-only queue: " + this.getName());
    }

    @Override
    public QueueConfig setEmptyQueueTtl(int emptyQueueTtl) {
        throw new UnsupportedOperationException("This config is read-only queue: " + this.getName());
    }

    @Override
    public QueueConfig setMaxSize(int maxSize) {
        throw new UnsupportedOperationException("This config is read-only queue: " + this.getName());
    }

    @Override
    public QueueConfig setBackupCount(int backupCount) {
        throw new UnsupportedOperationException("This config is read-only queue: " + this.getName());
    }

    @Override
    public QueueConfig setAsyncBackupCount(int asyncBackupCount) {
        throw new UnsupportedOperationException("This config is read-only queue: " + this.getName());
    }

    @Override
    public QueueConfig setQueueStoreConfig(@Nullable QueueStoreConfig queueStoreConfig) {
        throw new UnsupportedOperationException("This config is read-only queue: " + this.getName());
    }

    @Override
    public QueueConfig setStatisticsEnabled(boolean statisticsEnabled) {
        throw new UnsupportedOperationException("This config is read-only queue: " + this.getName());
    }

    @Override
    public QueueConfig addItemListenerConfig(ItemListenerConfig listenerConfig) {
        throw new UnsupportedOperationException("This config is read-only queue: " + this.getName());
    }

    @Override
    public QueueConfig setItemListenerConfigs(@Nullable List<ItemListenerConfig> listenerConfigs) {
        throw new UnsupportedOperationException("This config is read-only queue: " + this.getName());
    }

    @Override
    public QueueConfig setSplitBrainProtectionName(@Nullable String splitBrainProtectionName) {
        throw new UnsupportedOperationException("This config is read-only queue: " + this.getName());
    }

    @Override
    public QueueConfig setMergePolicyConfig(@Nonnull MergePolicyConfig mergePolicyConfig) {
        throw new UnsupportedOperationException("This config is read-only queue: " + this.getName());
    }

    @Override
    public QueueConfig setPriorityComparatorClassName(@Nullable String priorityComparatorClassName) {
        return super.setPriorityComparatorClassName(priorityComparatorClassName);
    }

    @Override
    public QueueConfig setUserCodeNamespace(@Nullable String userCodeNamespace) {
        throw new UnsupportedOperationException("This config is read-only queue: " + this.getName());
    }
}

