/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.model;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import opennlp.tools.ml.model.Event;
import opennlp.tools.ml.model.Sequence;
import opennlp.tools.ml.model.SequenceStream;
import opennlp.tools.util.ObjectStream;

public class SequenceStreamEventStream
implements ObjectStream<Event> {
    private final SequenceStream<Event> sequenceStream;
    private Iterator<Event> eventIt = Collections.emptyListIterator();

    public SequenceStreamEventStream(SequenceStream<Event> sequenceStream) {
        this.sequenceStream = sequenceStream;
    }

    public Event read() throws IOException {
        while (!this.eventIt.hasNext()) {
            Sequence sequence = (Sequence)this.sequenceStream.read();
            if (sequence == null) {
                return null;
            }
            this.eventIt = Arrays.asList(sequence.getEvents()).iterator();
        }
        return this.eventIt.next();
    }

    public void reset() throws IOException, UnsupportedOperationException {
        this.eventIt = Collections.emptyListIterator();
        this.sequenceStream.reset();
    }

    public void close() throws IOException {
        this.eventIt = Collections.emptyListIterator();
        this.sequenceStream.close();
    }
}

