/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.common.conf;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.bookkeeper.common.conf.ConfigException;
import org.apache.bookkeeper.common.conf.ConfigKey;
import org.apache.bookkeeper.common.conf.ConfigKeyGroup;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigDef {
    private static final Logger log = LoggerFactory.getLogger(ConfigDef.class);
    private final Set<ConfigKeyGroup> groups;
    private final Map<String, Set<ConfigKey>> settings;
    private final Map<String, ConfigKey> keys;
    private static final int MAX_COLUMN_SIZE = 80;
    private static final String COMMENT_PREFIX = "# ";

    public static Builder builder() {
        return new Builder();
    }

    private ConfigDef(Set<ConfigKeyGroup> groups, Map<String, Set<ConfigKey>> settings) {
        this.groups = groups;
        this.settings = settings;
        this.keys = settings.values().stream().flatMap(keys -> keys.stream()).collect(Collectors.toSet()).stream().collect(Collectors.toMap(key -> key.name(), key -> key));
    }

    public void validate(Configuration conf) throws ConfigException {
        for (ConfigKey key : this.keys.values()) {
            key.validate(conf);
        }
    }

    public static ConfigDef of(Class configClass) {
        Field[] fields;
        Builder builder = ConfigDef.builder();
        for (Field field : fields = configClass.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !field.getType().equals(ConfigKey.class)) continue;
            field.setAccessible(true);
            try {
                builder.withConfigKey((ConfigKey)field.get(null));
            }
            catch (IllegalAccessException e) {
                log.error("Illegal to access {}#{}", new Object[]{configClass.getSimpleName(), field.getName(), e});
            }
        }
        return builder.build();
    }

    public void save(Path path) throws IOException {
        try (OutputStream stream = Files.newOutputStream(path, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
            this.save(stream);
        }
    }

    public void save(OutputStream os) throws IOException {
        try (PrintStream ps = new PrintStream(os, false, StandardCharsets.UTF_8.name());){
            this.save(ps);
            ps.flush();
        }
    }

    private void writeNSharps(PrintStream stream, int num) {
        IntStream.range(0, num).forEach(ignored -> stream.print("#"));
    }

    private void writeConfigKeyGroup(PrintStream stream, ConfigKeyGroup group) {
        int maxLength = Math.min(group.description().length() + COMMENT_PREFIX.length(), 80);
        this.writeNSharps(stream, maxLength);
        stream.println();
        this.writeSentence(stream, COMMENT_PREFIX, "Settings of `" + group.name() + "`");
        stream.println("#");
        this.writeSentence(stream, COMMENT_PREFIX, group.description());
        this.writeNSharps(stream, maxLength);
        stream.println();
    }

    private void writeConfigKey(PrintStream stream, ConfigKey key) {
        if (StringUtils.isNotBlank((String)key.description())) {
            this.writeSentence(stream, COMMENT_PREFIX, key.description());
            stream.println("#");
        }
        if (StringUtils.isNotBlank((String)key.documentation())) {
            this.writeSentence(stream, COMMENT_PREFIX, key.documentation());
            stream.println("#");
        }
        this.writeSentence(stream, COMMENT_PREFIX, "TYPE: " + (Object)((Object)key.type()) + ", " + (key.required() ? "required" : "optional"));
        if (null != key.validator() && StringUtils.isNotBlank((String)key.validator().documentation())) {
            this.writeSentence(stream, COMMENT_PREFIX, "@constraints : " + key.validator().documentation());
        }
        if (!key.optionValues().isEmpty()) {
            this.writeSentence(stream, COMMENT_PREFIX, "@options :");
            key.optionValues().forEach(value -> this.writeSentence(stream, COMMENT_PREFIX, "  " + value));
        }
        if (StringUtils.isNotBlank((String)key.since())) {
            stream.println("#");
            this.writeSentence(stream, COMMENT_PREFIX, "@since " + key.since() + "");
        }
        if (key.deprecated()) {
            stream.println("#");
            this.writeSentence(stream, COMMENT_PREFIX, this.getDeprecationDescription(key));
        }
        stream.print(key.name());
        stream.print("=");
        if (null != key.defaultValue()) {
            stream.print(key.defaultValue());
        }
        stream.println();
    }

    private String getDeprecationDescription(ConfigKey key) {
        StringBuilder sb = new StringBuilder();
        sb.append("@deprecated");
        if (StringUtils.isNotBlank((String)key.deprecatedSince())) {
            sb.append(" since `").append(key.deprecatedSince()).append("`");
        }
        if (StringUtils.isNotBlank((String)key.deprecatedByConfigKey())) {
            sb.append(" in favor of using `").append(key.deprecatedByConfigKey()).append("`");
        }
        return sb.toString();
    }

    private void writeSentence(PrintStream stream, String prefix, String sentence) {
        int max = 80;
        String[] words = sentence.split(" ");
        stream.print(prefix);
        int current = prefix.length();
        for (int i = 0; i < words.length; ++i) {
            String word = words[i];
            if (word.length() > max || current + word.length() <= max) {
                if (i != 0) {
                    stream.print(" ");
                }
                stream.print(word);
                current += word.length() + 1;
                continue;
            }
            stream.println();
            stream.print(prefix);
            stream.print(word);
            current = prefix.length() + word.length();
        }
        stream.println();
    }

    private void save(PrintStream stream) {
        for (ConfigKeyGroup group : this.groups) {
            this.writeConfigKeyGroup(stream, group);
            stream.println();
            Set<ConfigKey> groupKeys = this.settings.getOrDefault(group.name(), Collections.emptySet());
            groupKeys.forEach(key -> {
                this.writeConfigKey(stream, (ConfigKey)key);
                stream.println();
            });
        }
    }

    public Set<ConfigKeyGroup> getGroups() {
        return this.groups;
    }

    public Map<String, Set<ConfigKey>> getSettings() {
        return this.settings;
    }

    public Map<String, ConfigKey> getKeys() {
        return this.keys;
    }

    public static class Builder {
        private final Set<ConfigKeyGroup> groups = new TreeSet<ConfigKeyGroup>(ConfigKeyGroup.ORDERING);
        private final Map<String, Set<ConfigKey>> settings = new HashMap<String, Set<ConfigKey>>();

        private Builder() {
        }

        public Builder withConfigKeyGroup(ConfigKeyGroup group) {
            this.groups.add(group);
            return this;
        }

        public Builder withConfigKey(ConfigKey key) {
            String groupName;
            ConfigKeyGroup group = key.group();
            if (null == group) {
                groupName = "";
            } else {
                groupName = group.name();
                this.groups.add(group);
            }
            Set keys = this.settings.computeIfAbsent(groupName, name -> new TreeSet<ConfigKey>(ConfigKey.ORDERING));
            keys.add(key);
            return this;
        }

        public ConfigDef build() {
            Preconditions.checkArgument((boolean)Sets.difference(this.groups.stream().map(group -> group.name()).collect(Collectors.toSet()), this.settings.keySet()).isEmpty(), (Object)"Configuration Key Groups doesn't match with keys");
            return new ConfigDef(this.groups, this.settings);
        }
    }
}

