/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security.oauth2;

import io.trino.server.security.AbstractBearerAuthenticator;
import io.trino.server.security.AuthenticationException;
import io.trino.server.security.UserMapping;
import io.trino.server.security.oauth2.ChallengeFailedException;
import io.trino.server.security.oauth2.OAuth2Config;
import io.trino.server.security.oauth2.OAuth2Service;
import io.trino.server.security.oauth2.OAuth2TokenExchangeResource;
import io.trino.spi.security.BasicPrincipal;
import java.net.URI;
import java.security.Principal;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;

public class OAuth2Authenticator
extends AbstractBearerAuthenticator {
    private final OAuth2Service service;
    private final String principalField;

    @Inject
    public OAuth2Authenticator(OAuth2Service service, OAuth2Config config) {
        super(UserMapping.createUserMapping(config.getUserMappingPattern(), config.getUserMappingFile()));
        this.service = Objects.requireNonNull(service, "service is null");
        this.principalField = config.getPrincipalField();
    }

    @Override
    protected Optional<Principal> extractPrincipalFromToken(String token) {
        try {
            return this.service.convertTokenToClaims(token).map(claims -> claims.get(this.principalField)).map(String.class::cast).map(BasicPrincipal::new);
        }
        catch (ChallengeFailedException e) {
            return Optional.empty();
        }
    }

    @Override
    protected AuthenticationException needAuthentication(ContainerRequestContext request, String message) {
        UUID authId = UUID.randomUUID();
        URI initiateUri = request.getUriInfo().getBaseUri().resolve(OAuth2TokenExchangeResource.getInitiateUri(authId));
        URI tokenUri = request.getUriInfo().getBaseUri().resolve(OAuth2TokenExchangeResource.getTokenUri(authId));
        return new AuthenticationException(message, String.format("Bearer x_redirect_server=\"%s\", x_token_server=\"%s\"", initiateUri, tokenUri));
    }
}

