/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.Meter;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.common.stats.MetricsUtil;

public class OpenTelemetryReplicatedSubscriptionStats {
    public static final AttributeKey<String> SNAPSHOT_OPERATION_RESULT = AttributeKey.stringKey((String)"pulsar.replication.subscription.snapshot.operation.result");
    public static final String SNAPSHOT_OPERATION_COUNT_METRIC_NAME = "pulsar.broker.replication.subscription.snapshot.operation.count";
    private final LongCounter snapshotOperationCounter;
    public static final String SNAPSHOT_DURATION_METRIC_NAME = "pulsar.broker.replication.subscription.snapshot.operation.duration";
    private final DoubleHistogram snapshotDuration;

    public OpenTelemetryReplicatedSubscriptionStats(PulsarService pulsar) {
        Meter meter = pulsar.getOpenTelemetry().getMeter();
        this.snapshotOperationCounter = meter.counterBuilder(SNAPSHOT_OPERATION_COUNT_METRIC_NAME).setDescription("The number of snapshot operations attempted").setUnit("{operation}").build();
        this.snapshotDuration = meter.histogramBuilder(SNAPSHOT_DURATION_METRIC_NAME).setDescription("Time taken to complete a consistent snapshot operation across clusters").setUnit("s").build();
    }

    public void recordSnapshotStarted() {
        this.snapshotOperationCounter.add(1L);
    }

    public void recordSnapshotTimedOut(long durationMs) {
        this.snapshotDuration.record(MetricsUtil.convertToSeconds((long)durationMs, (TimeUnit)TimeUnit.MILLISECONDS), SnapshotOperationResult.TIMEOUT.attributes);
    }

    public void recordSnapshotCompleted(long durationMs) {
        this.snapshotDuration.record(MetricsUtil.convertToSeconds((long)durationMs, (TimeUnit)TimeUnit.MILLISECONDS), SnapshotOperationResult.SUCCESS.attributes);
    }

    public static enum SnapshotOperationResult {
        SUCCESS,
        TIMEOUT;

        private final Attributes attributes = Attributes.of(SNAPSHOT_OPERATION_RESULT, (Object)this.name().toLowerCase());
    }
}

