/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.utils;

import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimedSingleThreadRateLimiter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TimedSingleThreadRateLimiter.class);
    private final int rate;
    private final long periodAtMs;
    private long lastTimeReset;
    private int remaining;
    private long closeAfterAtMs;

    public TimedSingleThreadRateLimiter(int rate, long period, TimeUnit unit) {
        this.rate = rate;
        this.periodAtMs = unit.toMillis(period);
        this.lastTimeReset = System.currentTimeMillis();
        this.remaining = rate;
    }

    public int acquire(int permits) {
        long now = System.currentTimeMillis();
        if (permits < 0) {
            return 0;
        }
        if (now > this.closeAfterAtMs) {
            return permits;
        }
        this.mayRenew(now);
        if (this.remaining > permits) {
            this.remaining -= permits;
            if (log.isDebugEnabled()) {
                log.debug("acquired: {}, remaining:{}", (Object)permits, (Object)this.remaining);
            }
            return permits;
        }
        int acquired = this.remaining;
        this.remaining = 0;
        if (log.isDebugEnabled()) {
            log.debug("acquired: {}, remaining:{}", (Object)acquired, (Object)this.remaining);
        }
        return acquired;
    }

    public void timingOpen(long closeAfter, TimeUnit unit) {
        this.closeAfterAtMs = closeAfter <= 0L ? 0L : System.currentTimeMillis() + unit.toMillis(closeAfter);
    }

    private void mayRenew(long now) {
        if (now > this.lastTimeReset + this.periodAtMs) {
            this.remaining = this.rate;
            this.lastTimeReset = now;
        }
    }

    @Generated
    public int getRate() {
        return this.rate;
    }

    @Generated
    public long getPeriodAtMs() {
        return this.periodAtMs;
    }

    @Generated
    public int getRemaining() {
        return this.remaining;
    }
}

