/*
 * Decompiled with CFR 0.152.
 */
package io.oxia.client;

import io.oxia.client.api.options.GetOption;
import io.oxia.client.api.options.defs.OptionComparisonType;
import io.oxia.client.api.options.defs.OptionEphemeral;
import io.oxia.client.api.options.defs.OptionPartitionKey;
import io.oxia.client.api.options.defs.OptionSecondaryIndex;
import io.oxia.client.api.options.defs.OptionSecondaryIndexName;
import io.oxia.client.api.options.defs.OptionSequenceKeysDeltas;
import io.oxia.client.api.options.defs.OptionVersionId;
import io.oxia.proto.KeyComparisonType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import lombok.Generated;

public final class OptionsUtils {
    public static OptionalLong getVersionId(Set<?> options) {
        if (options == null || options.isEmpty()) {
            return OptionalLong.empty();
        }
        OptionalLong versionId = OptionalLong.empty();
        for (Object o : options) {
            if (!(o instanceof OptionVersionId)) continue;
            OptionVersionId e = (OptionVersionId)o;
            if (versionId.isPresent()) {
                throw new IllegalArgumentException("VersionId cannot be passed multiple times: " + String.valueOf(options));
            }
            versionId = OptionalLong.of(e.versionId());
        }
        return versionId;
    }

    public static boolean isEphemeral(Set<?> options) {
        if (options.isEmpty()) {
            return false;
        }
        for (Object option : options) {
            if (!(option instanceof OptionEphemeral)) continue;
            return true;
        }
        return false;
    }

    public static Optional<String> getPartitionKey(Set<?> options) {
        if (options == null || options.isEmpty()) {
            return Optional.empty();
        }
        Optional<String> partitionKey = Optional.empty();
        for (Object o : options) {
            if (!(o instanceof OptionPartitionKey)) continue;
            OptionPartitionKey pk = (OptionPartitionKey)o;
            if (partitionKey.isPresent()) {
                throw new IllegalArgumentException("PartitionKey can only specified once:  " + String.valueOf(options));
            }
            partitionKey = Optional.of(pk.partitionKey());
        }
        return partitionKey;
    }

    public static Optional<List<Long>> getSequenceKeysDeltas(Set<?> options) {
        if (options == null || options.isEmpty()) {
            return Optional.empty();
        }
        Optional<List<Long>> sequenceKeysDeltas = Optional.empty();
        for (Object o : options) {
            if (!(o instanceof OptionSequenceKeysDeltas)) continue;
            OptionSequenceKeysDeltas skd = (OptionSequenceKeysDeltas)o;
            if (sequenceKeysDeltas.isPresent()) {
                throw new IllegalArgumentException("SequencesKeysDeltas can only specified once:  " + String.valueOf(options));
            }
            sequenceKeysDeltas = Optional.of(skd.sequenceKeysDeltas());
        }
        return sequenceKeysDeltas;
    }

    public static KeyComparisonType getComparisonType(Set<GetOption> options) {
        if (options == null || options.isEmpty()) {
            return KeyComparisonType.EQUAL;
        }
        boolean alreadyHasComparisonType = false;
        KeyComparisonType comparisonType = KeyComparisonType.EQUAL;
        for (GetOption o : options) {
            if (!(o instanceof OptionComparisonType)) continue;
            OptionComparisonType e = (OptionComparisonType)o;
            if (alreadyHasComparisonType) {
                throw new IllegalArgumentException("Incompatible " + GetOption.class.getSimpleName() + "s: " + String.valueOf(options));
            }
            comparisonType = switch (e.comparisonType()) {
                default -> throw new IncompatibleClassChangeError();
                case OptionComparisonType.ComparisonType.Equal -> KeyComparisonType.EQUAL;
                case OptionComparisonType.ComparisonType.Floor -> KeyComparisonType.FLOOR;
                case OptionComparisonType.ComparisonType.Ceiling -> KeyComparisonType.CEILING;
                case OptionComparisonType.ComparisonType.Lower -> KeyComparisonType.LOWER;
                case OptionComparisonType.ComparisonType.Higher -> KeyComparisonType.HIGHER;
            };
            alreadyHasComparisonType = true;
        }
        return comparisonType;
    }

    public static List<OptionSecondaryIndex> getSecondaryIndexes(Set<?> options) {
        if (options == null || options.isEmpty()) {
            return Collections.emptyList();
        }
        List<OptionSecondaryIndex> res = null;
        for (Object o : options) {
            if (!(o instanceof OptionSecondaryIndex)) continue;
            OptionSecondaryIndex si = (OptionSecondaryIndex)o;
            if (res == null) {
                res = new ArrayList<OptionSecondaryIndex>();
            }
            res.add(si);
        }
        return res != null ? res : Collections.emptyList();
    }

    public static Optional<String> getSecondaryIndexName(Set<?> options) {
        if (options == null || options.isEmpty()) {
            return Optional.empty();
        }
        Optional<String> secondaryIndexName = Optional.empty();
        for (Object o : options) {
            if (!(o instanceof OptionSecondaryIndexName)) continue;
            OptionSecondaryIndexName sin = (OptionSecondaryIndexName)o;
            if (secondaryIndexName.isPresent()) {
                throw new IllegalArgumentException("Secondary index can only specified once:  " + String.valueOf(options));
            }
            secondaryIndexName = Optional.of(sin.secondaryIndexName());
        }
        return secondaryIndexName;
    }

    @Generated
    private OptionsUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

