/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.ws;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.ImmediateEventExecutor;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.asynchttpclient.netty.channel.Channels;
import org.asynchttpclient.netty.util.ByteBufUtils;
import org.asynchttpclient.netty.util.Utf8ByteBufCharsetDecoder;
import org.asynchttpclient.ws.WebSocket;
import org.asynchttpclient.ws.WebSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NettyWebSocket
implements WebSocket {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyWebSocket.class);
    protected final Channel channel;
    private final HttpHeaders upgradeHeaders;
    private final Collection<WebSocketListener> listeners;
    private FragmentedFrameType expectedFragmentedFrameType;
    private boolean ready;
    private List<WebSocketFrame> bufferedFrames;

    public NettyWebSocket(Channel channel, HttpHeaders upgradeHeaders) {
        this(channel, upgradeHeaders, new ConcurrentLinkedQueue<WebSocketListener>());
    }

    private NettyWebSocket(Channel channel, HttpHeaders upgradeHeaders, Collection<WebSocketListener> listeners) {
        this.channel = channel;
        this.upgradeHeaders = upgradeHeaders;
        this.listeners = listeners;
    }

    @Override
    public HttpHeaders getUpgradeHeaders() {
        return this.upgradeHeaders;
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.channel.remoteAddress();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.channel.localAddress();
    }

    @Override
    public Future<Void> sendTextFrame(String message) {
        return this.sendTextFrame(message, true, 0);
    }

    @Override
    public Future<Void> sendTextFrame(String payload, boolean finalFragment, int rsv) {
        return this.channel.writeAndFlush((Object)new TextWebSocketFrame(finalFragment, rsv, payload));
    }

    @Override
    public Future<Void> sendTextFrame(ByteBuf payload, boolean finalFragment, int rsv) {
        return this.channel.writeAndFlush((Object)new TextWebSocketFrame(finalFragment, rsv, payload));
    }

    @Override
    public Future<Void> sendBinaryFrame(byte[] payload) {
        return this.sendBinaryFrame(payload, true, 0);
    }

    @Override
    public Future<Void> sendBinaryFrame(byte[] payload, boolean finalFragment, int rsv) {
        return this.sendBinaryFrame(Unpooled.wrappedBuffer((byte[])payload), finalFragment, rsv);
    }

    @Override
    public Future<Void> sendBinaryFrame(ByteBuf payload, boolean finalFragment, int rsv) {
        return this.channel.writeAndFlush((Object)new BinaryWebSocketFrame(finalFragment, rsv, payload));
    }

    @Override
    public Future<Void> sendContinuationFrame(String payload, boolean finalFragment, int rsv) {
        return this.channel.writeAndFlush((Object)new ContinuationWebSocketFrame(finalFragment, rsv, payload));
    }

    @Override
    public Future<Void> sendContinuationFrame(byte[] payload, boolean finalFragment, int rsv) {
        return this.sendContinuationFrame(Unpooled.wrappedBuffer((byte[])payload), finalFragment, rsv);
    }

    @Override
    public Future<Void> sendContinuationFrame(ByteBuf payload, boolean finalFragment, int rsv) {
        return this.channel.writeAndFlush((Object)new ContinuationWebSocketFrame(finalFragment, rsv, payload));
    }

    @Override
    public Future<Void> sendPingFrame() {
        return this.channel.writeAndFlush((Object)new PingWebSocketFrame());
    }

    @Override
    public Future<Void> sendPingFrame(byte[] payload) {
        return this.sendPingFrame(Unpooled.wrappedBuffer((byte[])payload));
    }

    @Override
    public Future<Void> sendPingFrame(ByteBuf payload) {
        return this.channel.writeAndFlush((Object)new PingWebSocketFrame(payload));
    }

    @Override
    public Future<Void> sendPongFrame() {
        return this.channel.writeAndFlush((Object)new PongWebSocketFrame());
    }

    @Override
    public Future<Void> sendPongFrame(byte[] payload) {
        return this.sendPongFrame(Unpooled.wrappedBuffer((byte[])payload));
    }

    @Override
    public Future<Void> sendPongFrame(ByteBuf payload) {
        return this.channel.writeAndFlush((Object)new PongWebSocketFrame(Unpooled.wrappedBuffer((ByteBuf)payload)));
    }

    @Override
    public Future<Void> sendCloseFrame() {
        return this.sendCloseFrame(1000, "normal closure");
    }

    @Override
    public Future<Void> sendCloseFrame(int statusCode, String reasonText) {
        if (this.channel.isOpen()) {
            return this.channel.writeAndFlush((Object)new CloseWebSocketFrame(statusCode, reasonText));
        }
        return ImmediateEventExecutor.INSTANCE.newSucceededFuture(null);
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public WebSocket addWebSocketListener(WebSocketListener l) {
        this.listeners.add(l);
        return this;
    }

    @Override
    public WebSocket removeWebSocketListener(WebSocketListener l) {
        this.listeners.remove(l);
        return this;
    }

    public boolean isReady() {
        return this.ready;
    }

    public void bufferFrame(WebSocketFrame frame) {
        if (this.bufferedFrames == null) {
            this.bufferedFrames = new ArrayList<WebSocketFrame>(1);
        }
        frame.retain();
        this.bufferedFrames.add(frame);
    }

    private void releaseBufferedFrames() {
        if (this.bufferedFrames != null) {
            for (WebSocketFrame frame : this.bufferedFrames) {
                frame.release();
            }
            this.bufferedFrames = null;
        }
    }

    public void processBufferedFrames() {
        this.ready = true;
        if (this.bufferedFrames != null) {
            try {
                for (WebSocketFrame frame : this.bufferedFrames) {
                    this.handleFrame(frame);
                }
            }
            finally {
                this.releaseBufferedFrames();
            }
            this.bufferedFrames = null;
        }
    }

    public void handleFrame(WebSocketFrame frame) {
        if (frame instanceof TextWebSocketFrame) {
            this.onTextFrame((TextWebSocketFrame)frame);
        } else if (frame instanceof BinaryWebSocketFrame) {
            this.onBinaryFrame((BinaryWebSocketFrame)frame);
        } else if (frame instanceof CloseWebSocketFrame) {
            Channels.setDiscard(this.channel);
            CloseWebSocketFrame closeFrame = (CloseWebSocketFrame)frame;
            this.onClose(closeFrame.statusCode(), closeFrame.reasonText());
            Channels.silentlyCloseChannel(this.channel);
        } else if (frame instanceof PingWebSocketFrame) {
            this.onPingFrame((PingWebSocketFrame)frame);
        } else if (frame instanceof PongWebSocketFrame) {
            this.onPongFrame((PongWebSocketFrame)frame);
        } else if (frame instanceof ContinuationWebSocketFrame) {
            this.onContinuationFrame((ContinuationWebSocketFrame)frame);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onError(Throwable t) {
        try {
            for (WebSocketListener listener : this.listeners) {
                try {
                    listener.onError(t);
                }
                catch (Throwable t2) {
                    LOGGER.error("WebSocketListener.onError crash", t2);
                }
            }
        }
        finally {
            this.releaseBufferedFrames();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClose(int code, String reason) {
        try {
            for (WebSocketListener l : this.listeners) {
                try {
                    l.onClose(this, code, reason);
                }
                catch (Throwable t) {
                    l.onError(t);
                }
            }
            this.listeners.clear();
        }
        finally {
            this.releaseBufferedFrames();
        }
    }

    public String toString() {
        return "NettyWebSocket{channel=" + this.channel + '}';
    }

    private void onBinaryFrame(BinaryWebSocketFrame frame) {
        if (this.expectedFragmentedFrameType == null && !frame.isFinalFragment()) {
            this.expectedFragmentedFrameType = FragmentedFrameType.BINARY;
        }
        this.onBinaryFrame0((WebSocketFrame)frame);
    }

    private void onBinaryFrame0(WebSocketFrame frame) {
        byte[] bytes = ByteBufUtils.byteBuf2Bytes((ByteBuf)frame.content());
        for (WebSocketListener listener : this.listeners) {
            listener.onBinaryFrame(bytes, frame.isFinalFragment(), frame.rsv());
        }
    }

    private void onTextFrame(TextWebSocketFrame frame) {
        if (this.expectedFragmentedFrameType == null && !frame.isFinalFragment()) {
            this.expectedFragmentedFrameType = FragmentedFrameType.TEXT;
        }
        this.onTextFrame0((WebSocketFrame)frame);
    }

    private void onTextFrame0(WebSocketFrame frame) {
        String text = Utf8ByteBufCharsetDecoder.decodeUtf8((ByteBuf)frame.content());
        frame.isFinalFragment();
        frame.rsv();
        for (WebSocketListener listener : this.listeners) {
            listener.onTextFrame(text, frame.isFinalFragment(), frame.rsv());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void onContinuationFrame(ContinuationWebSocketFrame frame) {
        if (this.expectedFragmentedFrameType == null) {
            LOGGER.warn("Received continuation frame without an original text or binary frame, ignoring");
            return;
        }
        try {
            switch (this.expectedFragmentedFrameType) {
                case BINARY: {
                    this.onBinaryFrame0((WebSocketFrame)frame);
                    return;
                }
                case TEXT: {
                    this.onTextFrame0((WebSocketFrame)frame);
                    return;
                }
                default: {
                    throw new IllegalArgumentException("Unknown FragmentedFrameType " + (Object)((Object)this.expectedFragmentedFrameType));
                }
            }
        }
        finally {
            if (frame.isFinalFragment()) {
                this.expectedFragmentedFrameType = null;
            }
        }
    }

    private void onPingFrame(PingWebSocketFrame frame) {
        byte[] bytes = ByteBufUtils.byteBuf2Bytes((ByteBuf)frame.content());
        for (WebSocketListener listener : this.listeners) {
            listener.onPingFrame(bytes);
        }
    }

    private void onPongFrame(PongWebSocketFrame frame) {
        byte[] bytes = ByteBufUtils.byteBuf2Bytes((ByteBuf)frame.content());
        for (WebSocketListener listener : this.listeners) {
            listener.onPongFrame(bytes);
        }
    }

    private static enum FragmentedFrameType {
        TEXT,
        BINARY;

    }
}

