/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.persistent;

import com.google.common.annotations.VisibleForTesting;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import lombok.Generated;
import org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.bookkeeper.mledger.Position;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.service.BrokerServiceException;
import org.apache.pulsar.broker.service.ConsistentHashingStickyKeyConsumerSelector;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.service.DrainingHashesTracker;
import org.apache.pulsar.broker.service.EntryAndMetadata;
import org.apache.pulsar.broker.service.EntryBatchIndexesAcks;
import org.apache.pulsar.broker.service.EntryBatchSizes;
import org.apache.pulsar.broker.service.HashRangeAutoSplitStickyKeyConsumerSelector;
import org.apache.pulsar.broker.service.HashRangeExclusiveStickyKeyConsumerSelector;
import org.apache.pulsar.broker.service.ImpactedConsumersResult;
import org.apache.pulsar.broker.service.PendingAcksMap;
import org.apache.pulsar.broker.service.SendMessageInfo;
import org.apache.pulsar.broker.service.StickyKeyConsumerSelector;
import org.apache.pulsar.broker.service.StickyKeyDispatcher;
import org.apache.pulsar.broker.service.Subscription;
import org.apache.pulsar.broker.service.persistent.PersistentDispatcherMultipleConsumers;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.apache.pulsar.broker.service.persistent.RescheduleReadHandler;
import org.apache.pulsar.client.api.Range;
import org.apache.pulsar.common.api.proto.CommandSubscribe;
import org.apache.pulsar.common.api.proto.KeySharedMeta;
import org.apache.pulsar.common.api.proto.KeySharedMode;
import org.apache.pulsar.common.util.FutureUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentStickyKeyDispatcherMultipleConsumers
extends PersistentDispatcherMultipleConsumers
implements StickyKeyDispatcher {
    private final boolean allowOutOfOrderDelivery;
    private final StickyKeyConsumerSelector selector;
    private final boolean drainingHashesRequired;
    private boolean skipNextReplayToTriggerLookAhead = false;
    private final KeySharedMode keySharedMode;
    private final DrainingHashesTracker drainingHashesTracker;
    private final RescheduleReadHandler rescheduleReadHandler;
    private static final Logger log = LoggerFactory.getLogger(PersistentStickyKeyDispatcherMultipleConsumers.class);

    PersistentStickyKeyDispatcherMultipleConsumers(PersistentTopic topic, ManagedCursor cursor, Subscription subscription, ServiceConfiguration conf, KeySharedMeta ksm) {
        super(topic, cursor, subscription, ksm.isAllowOutOfOrderDelivery());
        this.allowOutOfOrderDelivery = ksm.isAllowOutOfOrderDelivery();
        this.keySharedMode = ksm.getKeySharedMode();
        this.drainingHashesRequired = this.keySharedMode == KeySharedMode.AUTO_SPLIT && !this.allowOutOfOrderDelivery;
        this.drainingHashesTracker = this.drainingHashesRequired ? new DrainingHashesTracker(this.getName(), this::stickyKeyHashUnblocked) : null;
        this.rescheduleReadHandler = new RescheduleReadHandler(() -> ((ServiceConfiguration)conf).getKeySharedUnblockingIntervalMs(), (ScheduledExecutorService)topic.getBrokerService().executor(), this::cancelPendingRead, () -> this.reScheduleReadInMs(0L), () -> this.havePendingRead, this::getReadMoreEntriesCallCount, () -> !this.redeliveryMessages.isEmpty());
        switch (this.keySharedMode) {
            case AUTO_SPLIT: {
                if (conf.isSubscriptionKeySharedUseConsistentHashing()) {
                    this.selector = new ConsistentHashingStickyKeyConsumerSelector(conf.getSubscriptionKeySharedConsistentHashingReplicaPoints(), this.drainingHashesRequired);
                    break;
                }
                this.selector = new HashRangeAutoSplitStickyKeyConsumerSelector(this.drainingHashesRequired);
                break;
            }
            case STICKY: {
                this.selector = new HashRangeExclusiveStickyKeyConsumerSelector();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid key-shared mode: " + String.valueOf(this.keySharedMode));
            }
        }
    }

    private void stickyKeyHashUnblocked(int stickyKeyHash) {
        if (log.isDebugEnabled()) {
            if (stickyKeyHash > -1) {
                log.debug("[{}] Sticky key hash {} is unblocked", (Object)this.getName(), (Object)stickyKeyHash);
            } else {
                log.debug("[{}] Some sticky key hashes are unblocked", (Object)this.getName());
            }
        }
        this.reScheduleReadWithKeySharedUnblockingInterval();
    }

    private void reScheduleReadWithKeySharedUnblockingInterval() {
        this.rescheduleReadHandler.rescheduleRead();
    }

    @Override
    @VisibleForTesting
    public StickyKeyConsumerSelector getSelector() {
        return this.selector;
    }

    @Override
    public synchronized CompletableFuture<Void> addConsumer(Consumer consumer) {
        if (IS_CLOSED_UPDATER.get(this) == 1) {
            log.warn("[{}] Dispatcher is already closed. Closing consumer {}", (Object)this.name, (Object)consumer);
            consumer.disconnect();
            return CompletableFuture.completedFuture(null);
        }
        return ((CompletableFuture)((CompletableFuture)super.addConsumer(consumer).thenCompose(__ -> this.selector.addConsumer(consumer))).thenAccept(impactedConsumers -> {
            if (this.drainingHashesRequired) {
                consumer.setPendingAcksAddHandler(this::handleAddingPendingAck);
                consumer.setPendingAcksRemoveHandler(new PendingAcksMap.PendingAcksRemoveHandler(){

                    @Override
                    public void handleRemoving(Consumer consumer, long ledgerId, long entryId, int stickyKeyHash, boolean closing) {
                        PersistentStickyKeyDispatcherMultipleConsumers.this.drainingHashesTracker.reduceRefCount(consumer, stickyKeyHash, closing);
                    }

                    @Override
                    public void startBatch() {
                        PersistentStickyKeyDispatcherMultipleConsumers.this.drainingHashesTracker.startBatch();
                    }

                    @Override
                    public void endBatch() {
                        PersistentStickyKeyDispatcherMultipleConsumers.this.drainingHashesTracker.endBatch();
                    }
                });
                consumer.setDrainingHashesConsumerStatsUpdater(this.drainingHashesTracker::updateConsumerStats);
                this.registerDrainingHashes(consumer, (ImpactedConsumersResult)impactedConsumers.orElseThrow());
            }
        })).exceptionally(ex -> {
            this.internalRemoveConsumer(consumer);
            throw FutureUtil.wrapToCompletionException((Throwable)ex);
        });
    }

    private synchronized void registerDrainingHashes(Consumer skipConsumer, ImpactedConsumersResult impactedConsumers) {
        impactedConsumers.processUpdatedHashRanges((c, updatedHashRanges, opType) -> {
            if (c != skipConsumer) {
                c.getPendingAcks().forEach((ledgerId, entryId, batchSize, stickyKeyHash) -> {
                    if (stickyKeyHash == 0) {
                        log.warn("[{}] Sticky key hash was missing for {}:{}", new Object[]{this.getName(), ledgerId, entryId});
                        return;
                    }
                    if (updatedHashRanges.containsStickyKey(stickyKeyHash)) {
                        switch (opType) {
                            case ADD: {
                                DrainingHashesTracker.DrainingHashEntry entry = this.drainingHashesTracker.getEntry(stickyKeyHash);
                                if (entry == null || entry.getConsumer() != c) break;
                                this.drainingHashesTracker.reduceRefCount(c, stickyKeyHash, false);
                                break;
                            }
                            case REMOVE: {
                                this.drainingHashesTracker.addEntry(c, stickyKeyHash);
                            }
                        }
                    }
                });
            }
        });
    }

    @Override
    public synchronized void removeConsumer(Consumer consumer) throws BrokerServiceException {
        Optional<ImpactedConsumersResult> impactedConsumers = this.selector.removeConsumer(consumer);
        super.removeConsumer(consumer);
        if (this.drainingHashesRequired) {
            this.registerDrainingHashes(consumer, impactedConsumers.orElseThrow());
            this.drainingHashesTracker.consumerRemoved(consumer);
        }
    }

    @Override
    protected synchronized void clearComponentsAfterRemovedAllConsumers() {
        super.clearComponentsAfterRemovedAllConsumers();
        if (this.drainingHashesRequired) {
            this.drainingHashesTracker.clear();
        }
    }

    @Override
    protected synchronized boolean trySendMessagesToConsumers(PersistentDispatcherMultipleConsumers.ReadType readType, List<Entry> entries) {
        Optional<Position> firstReplayPosition;
        this.lastNumberOfEntriesProcessed = 0;
        long totalMessagesSent = 0L;
        long totalBytesSent = 0L;
        long totalEntries = 0L;
        long totalEntriesProcessed = 0L;
        int entriesCount = entries.size();
        if (entriesCount == 0) {
            return true;
        }
        if (this.consumerSet.isEmpty()) {
            entries.forEach(Entry::release);
            this.cursor.rewind();
            return false;
        }
        if (!this.allowOutOfOrderDelivery && (firstReplayPosition = this.getFirstPositionInReplay()).isPresent()) {
            Position replayPosition = firstReplayPosition.get();
            if (this.minReplayedPosition != null && replayPosition.compareTo(this.minReplayedPosition) < 0) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Position {} (<{}) is inserted for relay during current {} read, discard this read and retry with readMoreEntries.", new Object[]{this.name, replayPosition, this.minReplayedPosition, readType});
                }
                if (readType == PersistentDispatcherMultipleConsumers.ReadType.Normal) {
                    entries.forEach(this::addEntryToReplay);
                } else if (readType == PersistentDispatcherMultipleConsumers.ReadType.Replay) {
                    entries.forEach(Entry::release);
                }
                this.skipNextBackoff = true;
                return true;
            }
        }
        MutableBoolean triggerLookAhead = new MutableBoolean();
        Map<Consumer, List<Entry>> entriesByConsumerForDispatching = this.filterAndGroupEntriesForDispatching(entries, readType, triggerLookAhead);
        AtomicInteger remainingConsumersToFinishSending = new AtomicInteger(entriesByConsumerForDispatching.size());
        for (Map.Entry<Consumer, List<Entry>> current : entriesByConsumerForDispatching.entrySet()) {
            Consumer consumer = current.getKey();
            List<Entry> entriesForConsumer = current.getValue();
            if (log.isDebugEnabled()) {
                log.debug("[{}] select consumer {} with messages num {}, read type is {}", new Object[]{this.name, consumer.consumerName(), entriesForConsumer.size(), readType});
            }
            if (readType == PersistentDispatcherMultipleConsumers.ReadType.Replay) {
                for (Entry entry : entriesForConsumer) {
                    this.redeliveryMessages.remove(entry.getLedgerId(), entry.getEntryId());
                }
            }
            SendMessageInfo sendMessageInfo = SendMessageInfo.getThreadLocal();
            EntryBatchSizes batchSizes = EntryBatchSizes.get(entriesForConsumer.size());
            EntryBatchIndexesAcks batchIndexesAcks = EntryBatchIndexesAcks.get(entriesForConsumer.size());
            totalEntries += (long)this.filterEntriesForConsumer(entriesForConsumer, batchSizes, sendMessageInfo, batchIndexesAcks, this.cursor, readType == PersistentDispatcherMultipleConsumers.ReadType.Replay, consumer);
            totalEntriesProcessed += (long)entriesForConsumer.size();
            consumer.sendMessages(entriesForConsumer, batchSizes, batchIndexesAcks, sendMessageInfo.getTotalMessages(), sendMessageInfo.getTotalBytes(), sendMessageInfo.getTotalChunkedMessages(), this.getRedeliveryTracker()).addListener(future -> {
                if (future.isDone() && remainingConsumersToFinishSending.decrementAndGet() == 0) {
                    this.readMoreEntriesAsync();
                }
            });
            TOTAL_AVAILABLE_PERMITS_UPDATER.getAndAdd(this, -(sendMessageInfo.getTotalMessages() - batchIndexesAcks.getTotalAckedIndexCount()));
            totalMessagesSent += (long)sendMessageInfo.getTotalMessages();
            totalBytesSent += sendMessageInfo.getTotalBytes();
        }
        this.lastNumberOfEntriesProcessed = (int)totalEntriesProcessed;
        this.acquirePermitsForDeliveredMessages(this.topic, this.cursor, totalEntries, totalMessagesSent, totalBytesSent);
        if (triggerLookAhead.booleanValue()) {
            this.skipNextReplayToTriggerLookAhead = true;
            this.skipNextBackoff = this.cursor.hasMoreEntries();
            return true;
        }
        return totalEntries == 0L;
    }

    private boolean handleAddingPendingAck(Consumer consumer, long ledgerId, long entryId, int stickyKeyHash) {
        if (stickyKeyHash == 0) {
            log.warn("[{}] Sticky key hash is missing for {}:{}", new Object[]{this.getName(), ledgerId, entryId});
            throw new IllegalArgumentException("Sticky key hash is missing for " + ledgerId + ":" + entryId);
        }
        DrainingHashesTracker.DrainingHashEntry drainingHashEntry = this.drainingHashesTracker.getEntry(stickyKeyHash);
        if (drainingHashEntry != null && drainingHashEntry.getConsumer() != consumer) {
            log.warn("[{}] Another consumer id {} is already draining hash {}. Skipping adding {}:{} to pending acks for consumer {}. Adding the message to replay.", new Object[]{this.getName(), drainingHashEntry.getConsumer(), stickyKeyHash, ledgerId, entryId, consumer});
            this.addMessageToReplay(ledgerId, entryId, stickyKeyHash);
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug("[{}] Adding {}:{} to pending acks for consumer id:{} name:{} with sticky key hash {}", new Object[]{this.getName(), ledgerId, entryId, consumer.consumerId(), consumer.consumerName(), stickyKeyHash});
        }
        return true;
    }

    private boolean isReplayQueueSizeBelowLimit() {
        return this.redeliveryMessages.size() < this.getEffectiveLookAheadLimit();
    }

    private int getEffectiveLookAheadLimit() {
        return PersistentStickyKeyDispatcherMultipleConsumers.getEffectiveLookAheadLimit(this.serviceConfig, this.consumerList.size());
    }

    static int getEffectiveLookAheadLimit(ServiceConfiguration serviceConfig, int consumerCount) {
        int effectiveLimit;
        int perConsumerLimit = serviceConfig.getKeySharedLookAheadMsgInReplayThresholdPerConsumer();
        int perSubscriptionLimit = serviceConfig.getKeySharedLookAheadMsgInReplayThresholdPerSubscription();
        if (perConsumerLimit <= 0) {
            effectiveLimit = perSubscriptionLimit;
        } else {
            effectiveLimit = perConsumerLimit * consumerCount;
            if (perSubscriptionLimit > 0 && perSubscriptionLimit < effectiveLimit) {
                effectiveLimit = perSubscriptionLimit;
            }
        }
        if (effectiveLimit <= 0) {
            int maxUnackedMessagesByConsumers;
            int maxUnackedMessagesPerSubscription = serviceConfig.getMaxUnackedMessagesPerSubscription();
            if (maxUnackedMessagesPerSubscription <= 0) {
                maxUnackedMessagesPerSubscription = Integer.MAX_VALUE;
            }
            if ((maxUnackedMessagesByConsumers = consumerCount * serviceConfig.getMaxUnackedMessagesPerConsumer()) <= 0) {
                maxUnackedMessagesByConsumers = Integer.MAX_VALUE;
            }
            effectiveLimit = Math.min(maxUnackedMessagesPerSubscription, maxUnackedMessagesByConsumers);
        }
        return effectiveLimit;
    }

    private Map<Consumer, List<Entry>> filterAndGroupEntriesForDispatching(List<Entry> entries, PersistentDispatcherMultipleConsumers.ReadType readType, MutableBoolean triggerLookAhead) {
        HashMap<Consumer, List<Entry>> entriesGroupedByConsumer = new HashMap<Consumer, List<Entry>>();
        HashMap<Consumer, MutableInt> permitsForConsumer = new HashMap<Consumer, MutableInt>();
        boolean lookAheadAllowed = this.isReplayQueueSizeBelowLimit();
        HashSet<Consumer> blockedByHashConsumers = lookAheadAllowed && readType == PersistentDispatcherMultipleConsumers.ReadType.Normal ? new HashSet<Consumer>() : null;
        HashSet<Consumer> consumersForEntriesForLookaheadCheck = lookAheadAllowed ? new HashSet<Consumer>() : null;
        IntOpenHashSet alreadyBlockedHashes = new IntOpenHashSet();
        for (Entry inputEntry : entries) {
            EntryAndMetadata entryAndMetadataInstance;
            EntryAndMetadata entry = inputEntry instanceof EntryAndMetadata ? (entryAndMetadataInstance = (EntryAndMetadata)inputEntry) : EntryAndMetadata.create(inputEntry);
            int stickyKeyHash = this.getStickyKeyHash(entry);
            Consumer consumer = null;
            boolean blockedByHash = false;
            boolean dispatchEntry = false;
            boolean hashIsAlreadyBlocked = alreadyBlockedHashes.contains(stickyKeyHash);
            if (!hashIsAlreadyBlocked && (consumer = this.selector.select(stickyKeyHash)) != null) {
                if (lookAheadAllowed) {
                    consumersForEntriesForLookaheadCheck.add(consumer);
                }
                boolean canUpdateBlockedByHash = lookAheadAllowed && readType == PersistentDispatcherMultipleConsumers.ReadType.Normal;
                MutableInt permits = permitsForConsumer.computeIfAbsent(consumer, k -> new MutableInt(this.getAvailablePermits((Consumer)k)));
                if (permits.intValue() > 0) {
                    boolean canDispatchEntry = this.canDispatchEntry(consumer, entry, readType, stickyKeyHash);
                    if (canDispatchEntry) {
                        permits.decrement();
                        dispatchEntry = true;
                    } else if (canUpdateBlockedByHash) {
                        blockedByHash = true;
                    }
                }
            }
            if (dispatchEntry) {
                List consumerEntries = entriesGroupedByConsumer.computeIfAbsent(consumer, k -> new ArrayList());
                consumerEntries.add(entry);
                continue;
            }
            if (!hashIsAlreadyBlocked) {
                alreadyBlockedHashes.add(stickyKeyHash);
            }
            if (blockedByHash) {
                blockedByHashConsumers.add(consumer);
            }
            if (entry.getReadCountHandler() != null) {
                entry.getReadCountHandler().incrementExpectedReadCount();
            }
            this.addMessageToReplay(entry.getLedgerId(), entry.getEntryId(), stickyKeyHash);
            entry.release();
        }
        if (lookAheadAllowed && entriesGroupedByConsumer.isEmpty()) {
            if (readType == PersistentDispatcherMultipleConsumers.ReadType.Normal) {
                for (Consumer consumer : blockedByHashConsumers) {
                    if (entriesGroupedByConsumer.containsKey(consumer) || ((MutableInt)permitsForConsumer.get(consumer)).intValue() <= 0) continue;
                    triggerLookAhead.setTrue();
                    break;
                }
            }
            if (!triggerLookAhead.booleanValue()) {
                for (Consumer consumer : this.getConsumers()) {
                    if (consumersForEntriesForLookaheadCheck.contains(consumer) || this.getAvailablePermits(consumer) <= 0) continue;
                    triggerLookAhead.setTrue();
                    break;
                }
            }
        }
        return entriesGroupedByConsumer;
    }

    private boolean canDispatchEntry(Consumer consumer, Entry entry, PersistentDispatcherMultipleConsumers.ReadType readType, int stickyKeyHash) {
        if (readType == PersistentDispatcherMultipleConsumers.ReadType.Normal && this.redeliveryMessages.containsStickyKeyHash(stickyKeyHash)) {
            return false;
        }
        return !this.drainingHashesRequired || !this.drainingHashesTracker.shouldBlockStickyKeyHash(consumer, stickyKeyHash);
    }

    @Override
    protected Predicate<Position> createFilterForReplay() {
        return new ReplayPositionFilter();
    }

    @Override
    protected int getStickyKeyHash(Entry entry) {
        if (entry instanceof EntryAndMetadata) {
            EntryAndMetadata entryAndMetadata = (EntryAndMetadata)entry;
            return entryAndMetadata.getOrUpdateCachedStickyKeyHash(this.selector::makeStickyKeyHash);
        }
        return this.selector.makeStickyKeyHash(this.peekStickyKey(entry));
    }

    @Override
    public void markDeletePositionMoveForward() {
        this.reScheduleReadWithKeySharedUnblockingInterval();
    }

    @Override
    protected synchronized boolean canReplayMessages() {
        if (this.skipNextReplayToTriggerLookAhead) {
            this.skipNextReplayToTriggerLookAhead = false;
            return false;
        }
        return true;
    }

    private int getAvailablePermits(Consumer c) {
        if (!c.cnx().isActive()) {
            return 0;
        }
        int availablePermits = Math.max(c.getAvailablePermits(), 0);
        if (availablePermits > 0 && c.getMaxUnackedMessages() > 0) {
            int maxAdditionalUnackedMessages = Math.max(c.getMaxUnackedMessages() - c.getUnackedMessages(), 0);
            if (maxAdditionalUnackedMessages == 0) {
                return 0;
            }
            int avgMessagesPerEntry = Math.max(c.getAvgMessagesPerEntry(), 1);
            int estimatedRemainingPermits = (maxAdditionalUnackedMessages + avgMessagesPerEntry - 1) / avgMessagesPerEntry;
            return Math.min(availablePermits, estimatedRemainingPermits);
        }
        return availablePermits;
    }

    @Override
    protected boolean doesntHavePendingRead() {
        return !this.havePendingRead && !this.havePendingReplayRead;
    }

    @Override
    protected boolean isNormalReadAllowed() {
        if (!this.isReplayQueueSizeBelowLimit()) {
            return false;
        }
        for (Consumer consumer : this.consumerList) {
            if (consumer == null || consumer.isBlocked() || this.getAvailablePermits(consumer) <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    protected int getMaxEntriesReadLimit() {
        return Math.max(this.getEffectiveLookAheadLimit() - this.redeliveryMessages.size(), 1);
    }

    @Override
    protected void handleNormalReadNotAllowed() {
        if (log.isDebugEnabled()) {
            log.debug("[{}] [{}] Skipping read for the topic since normal read isn't allowed. Rescheduling a read with a backoff.", (Object)this.topic.getName(), (Object)this.getSubscriptionName());
        }
        this.reScheduleReadWithBackoff();
    }

    @Override
    public CommandSubscribe.SubType getType() {
        return CommandSubscribe.SubType.Key_Shared;
    }

    @Override
    protected Set<? extends Position> asyncReplayEntries(Set<? extends Position> positions) {
        return this.cursor.asyncReplayEntries(positions, (AsyncCallbacks.ReadEntriesCallback)this, (Object)PersistentDispatcherMultipleConsumers.ReadType.Replay, true);
    }

    @Override
    public KeySharedMode getKeySharedMode() {
        return this.keySharedMode;
    }

    @Override
    public boolean isAllowOutOfOrderDelivery() {
        return this.allowOutOfOrderDelivery;
    }

    @Override
    public boolean hasSameKeySharedPolicy(KeySharedMeta ksm) {
        return ksm.getKeySharedMode() == this.keySharedMode && ksm.isAllowOutOfOrderDelivery() == this.allowOutOfOrderDelivery;
    }

    @Override
    public Map<Consumer, List<Range>> getConsumerKeyHashRanges() {
        return this.selector.getConsumerKeyHashRanges();
    }

    @Generated
    public DrainingHashesTracker getDrainingHashesTracker() {
        return this.drainingHashesTracker;
    }

    private class ReplayPositionFilter
    implements Predicate<Position> {
        private final Map<Consumer, MutableInt> availablePermitsMap = new HashMap<Consumer, MutableInt>();
        private final Set<Long> alreadyBlockedHashes = new HashSet<Long>();

        private ReplayPositionFilter() {
        }

        @Override
        public boolean test(Position position) {
            if (PersistentStickyKeyDispatcherMultipleConsumers.this.isAllowOutOfOrderDelivery()) {
                return true;
            }
            Long stickyKeyHash = PersistentStickyKeyDispatcherMultipleConsumers.this.redeliveryMessages.getHash(position.getLedgerId(), position.getEntryId());
            if (stickyKeyHash == null) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] replay of entry at position {} doesn't contain sticky key hash.", (Object)PersistentStickyKeyDispatcherMultipleConsumers.this.name, (Object)position);
                }
                return true;
            }
            if (this.alreadyBlockedHashes.contains(stickyKeyHash)) {
                return false;
            }
            Consumer consumer = PersistentStickyKeyDispatcherMultipleConsumers.this.selector.select(stickyKeyHash.intValue());
            if (consumer == null) {
                this.alreadyBlockedHashes.add(stickyKeyHash);
                return false;
            }
            MutableInt availablePermits = this.availablePermitsMap.computeIfAbsent(consumer, k -> new MutableInt(PersistentStickyKeyDispatcherMultipleConsumers.this.getAvailablePermits(consumer)));
            if (availablePermits.intValue() <= 0) {
                this.alreadyBlockedHashes.add(stickyKeyHash);
                return false;
            }
            if (PersistentStickyKeyDispatcherMultipleConsumers.this.drainingHashesRequired && PersistentStickyKeyDispatcherMultipleConsumers.this.drainingHashesTracker.shouldBlockStickyKeyHash(consumer, stickyKeyHash.intValue())) {
                this.alreadyBlockedHashes.add(stickyKeyHash);
                return false;
            }
            availablePermits.decrement();
            return true;
        }
    }
}

