/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.data;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableDoublePointData;
import java.util.List;

final class AutoValue_ImmutableDoublePointData
extends ImmutableDoublePointData {
    private final long startEpochNanos;
    private final long epochNanos;
    private final Attributes attributes;
    private final double value;
    private final List<DoubleExemplarData> exemplars;

    AutoValue_ImmutableDoublePointData(long startEpochNanos, long epochNanos, Attributes attributes, double value, List<DoubleExemplarData> exemplars) {
        this.startEpochNanos = startEpochNanos;
        this.epochNanos = epochNanos;
        if (attributes == null) {
            throw new NullPointerException("Null attributes");
        }
        this.attributes = attributes;
        this.value = value;
        if (exemplars == null) {
            throw new NullPointerException("Null exemplars");
        }
        this.exemplars = exemplars;
    }

    @Override
    public long getStartEpochNanos() {
        return this.startEpochNanos;
    }

    @Override
    public long getEpochNanos() {
        return this.epochNanos;
    }

    @Override
    public Attributes getAttributes() {
        return this.attributes;
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public List<DoubleExemplarData> getExemplars() {
        return this.exemplars;
    }

    public String toString() {
        return "ImmutableDoublePointData{startEpochNanos=" + this.startEpochNanos + ", epochNanos=" + this.epochNanos + ", attributes=" + this.attributes + ", value=" + this.value + ", exemplars=" + this.exemplars + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ImmutableDoublePointData) {
            ImmutableDoublePointData that = (ImmutableDoublePointData)o;
            return this.startEpochNanos == that.getStartEpochNanos() && this.epochNanos == that.getEpochNanos() && this.attributes.equals((Object)that.getAttributes()) && Double.doubleToLongBits(this.value) == Double.doubleToLongBits(that.getValue()) && this.exemplars.equals(that.getExemplars());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= (int)(this.startEpochNanos >>> 32 ^ this.startEpochNanos);
        h$ *= 1000003;
        h$ ^= (int)(this.epochNanos >>> 32 ^ this.epochNanos);
        h$ *= 1000003;
        h$ ^= this.attributes.hashCode();
        h$ *= 1000003;
        h$ ^= (int)(Double.doubleToLongBits(this.value) >>> 32 ^ Double.doubleToLongBits(this.value));
        h$ *= 1000003;
        return h$ ^= this.exemplars.hashCode();
    }
}

