/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.util.labels;

import io.kubernetes.client.util.labels.LabelMatcher;
import java.util.function.Function;
import java.util.function.Predicate;

public class EqualityMatcher
implements LabelMatcher {
    private Operator operator;
    private String key;
    private String value;

    EqualityMatcher(String key, Operator operator, String value) {
        this.key = key;
        this.operator = operator;
        this.value = value;
    }

    public static EqualityMatcher equal(String key, String value) {
        return new EqualityMatcher(key, Operator.EQUAL, value);
    }

    public static EqualityMatcher notEqual(String key, String value) {
        return new EqualityMatcher(key, Operator.NOT_EQUAL, value);
    }

    public String toString() {
        return this.key + " " + this.operator.name + " " + this.value;
    }

    @Override
    public boolean test(String s) {
        return this.operator.with(this.value).test(s);
    }

    @Override
    public String getKey() {
        return this.key;
    }

    private static enum Operator {
        EQUAL("=", arg -> v -> arg.equals(v)),
        DOUBLE_EQUAL("==", arg -> v -> arg.equals(v)),
        NOT_EQUAL("!=", arg -> v -> !arg.equals(v));

        private final String name;
        private final Function<String, Predicate<String>> matcherFunc;

        private Operator(String name, Function<String, Predicate<String>> matcherFunc) {
            this.name = name;
            this.matcherFunc = matcherFunc;
        }

        Predicate<String> with(String value) {
            return this.matcherFunc.apply(value);
        }
    }
}

